/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.cssgrid;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.dom.Style;
import java.util.Arrays;
import org.vaadin.firitin.components.cssgrid.Area;
import org.vaadin.firitin.components.cssgrid.Row;

@Deprecated(forRemoval=false)
public class CssGrid
extends Div {
    public CssGrid(int columns) {
        this();
        this.setTemplateColumns("repeat(%s, 1fr)".formatted(columns));
    }

    public CssGrid() {
        this.getStyle().setDisplay(Style.Display.GRID);
    }

    public void setTemplateColumns(String ... templateColumns) {
        this.getStyle().set("grid-template-columns", String.join((CharSequence)" ", templateColumns));
    }

    public void setTemplateRows(String ... templateRows) {
        this.getStyle().set("grid-template-rows", String.join((CharSequence)" ", templateRows));
    }

    public GridCell add(Component component) {
        super.add(new Component[]{component});
        return new GridCell(component);
    }

    public void add(Object ... texts) {
        for (Object o : texts) {
            if (o instanceof Component) {
                Component c = (Component)o;
                this.add(c);
                continue;
            }
            this.add(o.toString());
        }
    }

    public void add(String text) {
        super.add(new Component[]{new Div(text)});
    }

    public void setGap(String gap) {
        this.getStyle().set("gap", gap);
    }

    public void setAutoRows(String autoRows) {
        this.getStyle().set("grid-auto-rows", autoRows);
    }

    public void setColumnGap(String columnGap) {
        this.getStyle().set("grid-column-gap", columnGap);
    }

    public void setRowGap(String rowGap) {
        this.getStyle().set("grid-row-gap", rowGap);
    }

    @Deprecated(forRemoval=false)
    public void setTemplateAreas(String ... rows) {
        this.getStyle().set("grid-template-areas", "\"" + String.join((CharSequence)"\" \"", rows) + "\"");
    }

    public void setTemplateAreas(Row ... rows) {
        this.getStyle().set("grid-template-areas", String.join((CharSequence)" ", Arrays.stream(rows).map(Row::toCss).toList()));
    }

    public static class GridCell {
        private final Component component;

        private GridCell(Component component) {
            this.component = component;
        }

        public GridCell withColumn(int column) {
            return this;
        }

        public GridCell withColumns(int startColumn, int endColumn) {
            this.component.getStyle().set("grid-column", "%s / %s".formatted(startColumn, endColumn));
            return this;
        }

        public GridCell withRows(int startRow, int endRow) {
            this.component.getStyle().set("grid-row", "%s / %s".formatted(startRow, endRow));
            return this;
        }

        public GridCell withRow(int row) {
            this.component.getStyle().set("grid-row", "" + row);
            return this;
        }

        public GridCell withAlign(Style.AlignSelf align) {
            this.component.getStyle().setAlignSelf(align);
            return this;
        }

        public GridCell withJustifySelf(Style.JustifyContent align) {
            this.component.getStyle().set("justify-self", align.name());
            return this;
        }

        public GridCell withRowSpan(int numberRows) {
            this.component.getStyle().set("grid-row-start", "span " + numberRows);
            return this;
        }

        public GridCell withColumnSpan(int numberColumns) {
            this.component.getStyle().set("grid-column-start", "span " + numberColumns);
            return this;
        }

        public GridCell withArea(String areaName) {
            this.component.getStyle().set("grid-area", areaName);
            return this;
        }

        public GridCell withArea(Area area) {
            this.component.getStyle().set("grid-area", area.name());
            return this;
        }
    }
}

