/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.grid;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.grid.ColumnPathRenderer;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSelectionModel;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.vaadin.firitin.fluency.ui.FluentComponent;
import org.vaadin.firitin.fluency.ui.FluentFocusable;
import org.vaadin.firitin.fluency.ui.FluentHasSize;
import org.vaadin.firitin.fluency.ui.FluentHasStyle;
import org.vaadin.firitin.fluency.ui.FluentHasTheme;
import org.vaadin.firitin.util.VStyleUtil;

public class VGrid<T>
extends Grid<T>
implements FluentComponent<VGrid<T>>,
FluentHasStyle<VGrid<T>>,
FluentHasSize<VGrid<T>>,
FluentFocusable<Grid<T>, VGrid<T>>,
FluentHasTheme<VGrid<T>> {
    private static ObjectMapper dummyOm;
    private BasicBeanDescription bbd;
    private Set<String> columnCssKeys;
    private Set<String> rowCssKeys;
    private CellFormatter<T> cellFormatter;

    public VGrid() {
    }

    public VGrid(int pageSize) {
        super(pageSize);
    }

    public VGrid(Class<T> beanType) {
        super(beanType, false);
        if (dummyOm == null) {
            dummyOm = new ObjectMapper();
        }
        JavaType javaType = dummyOm.getTypeFactory().constructType(beanType);
        this.bbd = (BasicBeanDescription)dummyOm.getSerializationConfig().introspect(javaType);
        List<String> propertyNames = this.bbd.findProperties().stream().map(BeanPropertyDefinition::getName).toList();
        this.setColumns(propertyNames.toArray(new String[0]));
    }

    protected BiFunction<Renderer<T>, String, Grid.Column<T>> getDefaultColumnFactory() {
        return (tRenderer, s) -> new VColumn(this, (String)s, tRenderer);
    }

    public VGrid<T> withSelectionMode(Grid.SelectionMode selectionMode) {
        this.setSelectionMode(selectionMode);
        return this;
    }

    public VGrid<T> withSelectionModel(GridSelectionModel<T> selectionModel, Grid.SelectionMode selectionMode) {
        this.setSelectionModel(selectionModel, selectionMode);
        return this;
    }

    public VGrid<T> withProperties(String ... propertyNames) {
        this.setColumns(propertyNames);
        return this;
    }

    public VGrid<T> hideProperties(String ... propertyNamesToHide) {
        ArrayList<String> properties = new ArrayList<String>(this.getColumns().stream().map(col -> col.getKey()).toList());
        for (String pToHide : propertyNamesToHide) {
            properties.remove(pToHide);
        }
        this.setColumns(properties.toArray(new String[properties.size()]));
        ((Grid.Column)this.getColumns().get(1)).setVisible(false);
        return this;
    }

    public void setColumns(String ... propertyNames) {
        if (this.getBeanType().isRecord()) {
            this.removeAllColumns();
            RecordComponent[] recordComponents = this.getBeanType().getRecordComponents();
            for (String p : propertyNames) {
                for (RecordComponent r : recordComponents) {
                    String name = r.getName();
                    if (!name.equals(p)) continue;
                    this.addRecordColumn(r, name);
                }
            }
        } else {
            super.setColumns(propertyNames);
        }
    }

    public Grid.Column<T> addColumn(String propertyName) {
        try {
            return super.addColumn(propertyName);
        }
        catch (IllegalArgumentException exception) {
            if (this.bbd != null) {
                BeanPropertyDefinition d = this.bbd.findProperties().stream().filter(p -> p.getName().equals(propertyName)).findFirst().get();
                AnnotatedMethod getter = d.getGetter();
                Grid.Column col = this.addColumn((ValueProvider & Serializable)i -> {
                    try {
                        return getter.callOn(i);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                try {
                    col.setKey(propertyName);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Multiple columns for the same property: " + propertyName);
                }
                if (Comparable.class.isAssignableFrom(d.getPrimaryType().getRawClass())) {
                    col.setSortable(true);
                }
                col.setHeader(StringUtils.capitalize((String)propertyName));
                return col;
            }
            throw exception;
        }
    }

    private void addRecordColumn(RecordComponent r, String name) {
        this.addColumn((ValueProvider & Serializable)v -> {
            try {
                r.getAccessor().setAccessible(true);
                return r.getAccessor().invoke(v, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }).setKey(name).setHeader(StringUtils.capitalize((String)name));
    }

    public VGrid<T> withThemeVariants(GridVariant ... variants) {
        this.addThemeVariants(variants);
        return this;
    }

    public VGrid<T> setDataProvider(CallbackDataProvider.FetchCallback<T, Void> fetchCallback, CallbackDataProvider.CountCallback<T, Void> countCallback) {
        this.setDataProvider((DataProvider)DataProvider.fromCallbacks(fetchCallback, countCallback));
        return this;
    }

    public VGrid<T> withItems(Collection<T> items) {
        this.setItems(items);
        return this;
    }

    public VGrid<T> withItems(T ... items) {
        this.setItems(items);
        return this;
    }

    @Deprecated
    public void scrollToItem(T item) {
        Stream items;
        try {
            items = this.getListDataView().getItems();
        }
        catch (IllegalStateException exception) {
            items = this.getGenericDataView().getItems();
        }
        AtomicInteger i = new AtomicInteger();
        int index = items.peek(v -> i.incrementAndGet()).anyMatch(itm -> itm.equals(item)) ? i.get() - 1 : -1;
        this.scrollToIndex(index);
    }

    public VGrid<T> withColumnSelector() {
        ContextMenu columnSelector = new ContextMenu();
        this.getColumns().forEach(col -> {
            MenuItem item = (MenuItem)columnSelector.addItem(col.getHeaderText());
            item.setCheckable(true);
            item.setChecked(col.isVisible());
            item.addClickListener((ComponentEventListener & Serializable)e -> {
                col.setVisible(!col.isVisible());
                item.setChecked(col.isVisible());
            });
        });
        Grid.Column fakeColumn = this.addColumn((ValueProvider & Serializable)s -> "");
        fakeColumn.setKey("column-selector-fake-column");
        fakeColumn.setWidth("0px");
        fakeColumn.setFlexGrow(0);
        Button b = new Button((Component)VaadinIcon.CHEVRON_CIRCLE_DOWN_O.create());
        b.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
        b.getElement().executeJs("const el = this;\nsetTimeout(() => {\n    const w = el.offsetWidth;\n    el.parentElement.style.overflow = \"visible\";\n    el.parentElement.previousSibling.style.marginRight = (w - 16) + \"px\";\n    el.style.setProperty('margin-left', '-' + (w+16) + 'px');\n}, 0);\n", new Serializable[0]);
        columnSelector.setTarget((Component)b);
        columnSelector.setOpenOnClick(true);
        fakeColumn.setHeader((Component)b);
        return this;
    }

    private VColumn<T> colById(String columnId) {
        try {
            Field field = Grid.class.getDeclaredField("idToColumnMap");
            field.setAccessible(true);
            Map idToColumnMap = (Map)field.get(this);
            return (VColumn)((Object)idToColumnMap.get(columnId));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected <C extends Grid.Column<T>> C addColumn(ValueProvider<T, ?> valueProvider, BiFunction<Renderer<T>, String, C> columnFactory) {
        String columnId = this.createColumnId(false);
        Grid.Column column = this.addColumn((Renderer)new ColumnPathRenderer(columnId, (ValueProvider & Serializable)item -> this.formatColumnValue(this.colById(columnId), this.applyValueProvider(valueProvider, item))), columnFactory);
        try {
            Field field = Grid.Column.class.getDeclaredField("comparator");
            field.setAccessible(true);
            SerializableComparator & Serializable c = (SerializableComparator & Serializable)(a, b) -> VGrid.compareMaybeComparables((Object)this.applyValueProvider(valueProvider, a), (Object)this.applyValueProvider(valueProvider, b));
            field.set(column, c);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return (C)column;
    }

    private Object applyValueProvider(ValueProvider<T, ?> valueProvider, T item) {
        Object value;
        block2: {
            try {
                value = valueProvider.apply(item);
            }
            catch (NullPointerException npe) {
                value = null;
                if (Grid.NestedNullBehavior.THROW != this.getNestedNullBehavior()) break block2;
                throw npe;
            }
        }
        return value;
    }

    private String formatColumnValue(VColumn<T> col, Object value) {
        if (this.cellFormatter != null) {
            return this.cellFormatter.formatColumnValue(col, value);
        }
        return CellFormatter.defaultVaadinFormatting(value);
    }

    public VGrid<T> withCellFormatter(CellFormatter<T> formatter) {
        this.cellFormatter = formatter;
        return this;
    }

    public VGrid<T> withRowStyler(RowStyler<T> rowStyler) {
        SerializableFunction oldCNG = this.getPartNameGenerator();
        this.setPartNameGenerator((SerializableFunction)(ValueProvider & Serializable)t -> {
            String oldNames;
            boolean newRule;
            final TreeMap<String, String> styleRules = new TreeMap<String, String>();
            Style style = new Style(){

                public String get(String name) {
                    return (String)styleRules.get(name);
                }

                public Style set(String name, String value) {
                    styleRules.put(name, value);
                    return this;
                }

                public Style remove(String name) {
                    styleRules.remove(name);
                    return this;
                }

                public Style clear() {
                    styleRules.clear();
                    return this;
                }

                public boolean has(String name) {
                    return styleRules.containsKey(name);
                }

                public Stream<String> getNames() {
                    return styleRules.keySet().stream();
                }
            };
            rowStyler.styleRow(t, style);
            if (styleRules.isEmpty()) {
                return oldCNG != null ? (String)oldCNG.apply(t) : null;
            }
            StringBuilder cellCssBody = new StringBuilder();
            styleRules.forEach((k, v) -> cellCssBody.append("%s: %s;".formatted(k, v)));
            String cellCssBodyString = cellCssBody.toString();
            String key = "dynstyle" + cellCssBodyString.hashCode() + "-rc";
            if (this.rowCssKeys == null) {
                this.rowCssKeys = new HashSet<String>();
            }
            if (newRule = this.rowCssKeys.add(key)) {
                VStyleUtil.inject("vaadin-grid::part(%s) {\n    %s\n}\n".formatted(key, cellCssBodyString));
            }
            if (oldCNG != null && (oldNames = (String)oldCNG.apply(t)) != null) {
                return oldNames + " " + key;
            }
            return key;
        });
        return this;
    }

    public static class VColumn<T>
    extends Grid.Column<T> {
        private Style customStyle;

        public VColumn(Grid<T> grid, String columnId, Renderer<T> renderer) {
            super(grid, columnId, renderer);
        }

        public Style getStyle() {
            if (this.customStyle != null) {
                return this.customStyle;
            }
            final int indexOfColumn = this.getGrid().getColumns().indexOf((Object)this);
            this.customStyle = new Style(){
                private static final String[] harmfulAsDuplicate = new String[]{"border", "outline", "padding", "margin", "zoom"};
                private TreeMap<String, String> styles = new TreeMap();
                private boolean deferred;

                public String get(String s) {
                    return null;
                }

                public Style set(String s, String s1) {
                    this.styles.put(s, s1);
                    this.deferredApply();
                    return this;
                }

                private void deferredApply() {
                    if (!this.deferred) {
                        this.getGrid().getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> this.doApply());
                        this.deferred = true;
                    }
                }

                private void doApply() {
                    boolean newRule;
                    StringBuilder cellCssBody = new StringBuilder();
                    StringBuilder headerContentCssBody = new StringBuilder();
                    this.styles.forEach((k, v) -> {
                        cellCssBody.append("%s: %s;".formatted(k, v));
                        if (Arrays.stream(harmfulAsDuplicate).noneMatch(k::contains)) {
                            headerContentCssBody.append("%s: %s;".formatted(k, v));
                        }
                    });
                    String cellCssBodyString = cellCssBody.toString();
                    String key = "dynstyle" + cellCssBodyString.hashCode();
                    String headerText = this.getHeaderText();
                    if (headerText != null) {
                        this.setHeader((Component)new Span(headerText));
                    }
                    if (this.getHeaderComponent() != null) {
                        this.getHeaderComponent().addClassName(key + "-hc");
                    }
                    this.setPartNameGenerator((SerializableFunction & Serializable)p -> key);
                    this.getGrid().getElement().executeJs("const g = this; setTimeout(() => {g.shadowRoot.querySelector('th:nth-child(" + (indexOfColumn + 1) + ")').part.add('" + key + "');}, 1);", new Serializable[0]);
                    VGrid grid = (VGrid)this.findAncestor(VGrid.class);
                    if (grid.columnCssKeys == null) {
                        grid.columnCssKeys = new HashSet<String>();
                    }
                    if (newRule = grid.columnCssKeys.add(key)) {
                        VStyleUtil.inject("vaadin-grid::part(%s) {\n    %s\n}\n.%s-hc {\n    %s\n}\n".formatted(key, cellCssBodyString, key, headerContentCssBody.toString()));
                    }
                }

                public Style remove(String s) {
                    this.styles.remove(s);
                    return this;
                }

                public Style clear() {
                    customStyle.clear();
                    return this;
                }

                public boolean has(String s) {
                    return customStyle.has(s);
                }

                public Stream<String> getNames() {
                    return customStyle.getNames();
                }
            };
            return this.customStyle;
        }
    }

    public static interface CellFormatter<T> {
        public static String defaultVaadinFormatting(Object value) {
            if (value == null) {
                return "";
            }
            return String.valueOf(value);
        }

        public String formatColumnValue(VColumn<T> var1, Object var2);
    }

    public static interface RowStyler<T> {
        public void styleRow(T var1, Style var2);
    }
}

