/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.orderedlayout;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DebounceSettings;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.dom.DebouncePhase;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import org.vaadin.firitin.fluency.ui.FluentComponent;
import org.vaadin.firitin.fluency.ui.FluentHasSize;
import org.vaadin.firitin.fluency.ui.FluentHasStyle;

public class VScroller
extends Scroller
implements FluentComponent<VScroller>,
FluentHasStyle<VScroller>,
FluentHasSize<VScroller> {
    private DomListenerRegistration scrollreg;

    public VScroller() {
    }

    public VScroller(Component content) {
        super(content);
    }

    public VScroller(Component content, Scroller.ScrollDirection scrollDirection) {
        super(content, scrollDirection);
    }

    public VScroller(Scroller.ScrollDirection scrollDirection) {
        super(scrollDirection);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.getElement().executeJs("    var self = this;\n    this.addEventListener(\"scroll\", function(e) {\n        // if rather close the the end, fire it!\n        if(self.scrollTop + self.clientHeight > (self.scrollHeight - self.clientHeight/4)) {\n            var e = new Event(\"scroll-to-end\");\n            self.dispatchEvent(e);\n        }\n    });\n", new Serializable[0]);
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public Registration addScrollToEndListener(ComponentEventListener<ScrollToEndEvent> listener) {
        return this.addListener(ScrollToEndEvent.class, listener);
    }

    public Registration addScrollListener(ComponentEventListener<ScrollEvent> listener) {
        if (this.scrollreg == null) {
            this.scrollreg = this.getElement().addEventListener("scroll", (DomEventListener & Serializable)de -> this.getEventBus().fireEvent((ComponentEvent)new ScrollEvent(this, (int)de.getEventData().getNumber("event.target.scrollTop"), (int)de.getEventData().getNumber("event.target.scrollLeft"))));
            this.scrollreg.debounce(100);
            this.scrollreg.addEventData("event.target.scrollTop");
            this.scrollreg.addEventData("event.target.scrollLeft");
        }
        return this.addListener(ScrollEvent.class, listener);
    }

    public void scrollToTop() {
        this.setScrollTop(0);
    }

    public void scrollToBottom() {
        this.getElement().executeJs("this.scrollTop = this.scrollHeight", new Serializable[0]);
    }

    public void setScrollTop(int pixelsFromTop) {
        this.getElement().executeJs("this.scrollTop = $0", new Serializable[]{Integer.valueOf(pixelsFromTop)});
    }

    public void setScrollLeft(int pixelsFromLeft) {
        this.getElement().executeJs("this.scrollLeft = $0", new Serializable[]{Integer.valueOf(pixelsFromLeft)});
    }

    public void scrollIntoView(Component c) {
        c.scrollIntoView();
    }

    @DomEvent(value="scroll-to-end", debounce=@DebounceSettings(timeout=250, phases={DebouncePhase.TRAILING}))
    public static class ScrollToEndEvent
    extends ComponentEvent<VScroller> {
        public ScrollToEndEvent(VScroller source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    public static class ScrollEvent
    extends ComponentEvent<VScroller> {
        private final int scrollTop;
        private final int scrollLeft;

        ScrollEvent(VScroller source, int scrollTop, int scrollLeft) {
            super((Component)source, true);
            this.scrollTop = scrollTop;
            this.scrollLeft = scrollLeft;
        }

        public int getScrollLeft() {
            return this.scrollLeft;
        }

        public int getScrollTop() {
            return this.scrollTop;
        }
    }
}

