/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.fields.internalhtmltable;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HtmlComponent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.dom.Element;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.vaadin.firitin.fields.internalhtmltable.TableCell;
import org.vaadin.firitin.fields.internalhtmltable.TableDataCell;
import org.vaadin.firitin.fields.internalhtmltable.TableHeaderCell;

@Tag(value="tr")
public class TableRow
extends HtmlComponent {
    public TableRow() {
    }

    public TableRow(Component ... cells) {
        this.addCells(cells);
    }

    public TableDataCell addDataCell() {
        TableDataCell cell = new TableDataCell();
        this.addCells(cell);
        return cell;
    }

    public TableHeaderCell addHeaderCell() {
        TableHeaderCell cell = new TableHeaderCell();
        this.addCells(cell);
        return cell;
    }

    public void addHeaderCells(Component ... components) {
        for (int i = 0; i < components.length; ++i) {
            TableHeaderCell td = this.addHeaderCell();
            td.add(new Component[]{components[i]});
        }
    }

    public void addHeaderCells(String ... contents) {
        for (int i = 0; i < contents.length; ++i) {
            TableHeaderCell td = this.addHeaderCell();
            td.add(contents[i]);
        }
    }

    public TableDataCell[] addDataCells(int cells) {
        TableCell[] cellsObjects = (TableDataCell[])IntStream.range(0, cells).mapToObj(i -> new TableDataCell()).toArray(TableDataCell[]::new);
        this.addCells(cellsObjects);
        return cellsObjects;
    }

    public TableHeaderCell[] addHeaderCells(int cells) {
        TableCell[] cellsObjects = (TableHeaderCell[])IntStream.range(0, cells).mapToObj(i -> new TableHeaderCell()).toArray(TableHeaderCell[]::new);
        this.addCells(cellsObjects);
        return cellsObjects;
    }

    public void addCells(TableCell ... cells) {
        this.getElement().appendChild((Element[])Arrays.stream(cells).map(Component::getElement).toArray(Element[]::new));
    }

    public void addCells(Component ... components) {
        for (int i = 0; i < components.length; ++i) {
            TableDataCell td = this.addDataCell();
            td.add(new Component[]{components[i]});
        }
    }

    public void addCells(String ... contents) {
        for (int i = 0; i < contents.length; ++i) {
            TableDataCell td = this.addDataCell();
            td.add(contents[i]);
        }
    }

    public void removeCells(TableCell ... cells) {
        this.getElement().removeChild((Element[])Arrays.stream(cells).map(Component::getElement).toArray(Element[]::new));
    }

    public void removeCell(int index) {
        this.getCell(index).ifPresent(xva$0 -> this.removeCells((TableCell)xva$0));
    }

    public void removeAllCells() {
        this.removeCells((TableCell[])this.streamCells().toArray(TableCell[]::new));
    }

    public void removeDataCell(int dataCellIndex) {
        this.getDataCell(dataCellIndex).ifPresent(xva$0 -> this.removeCells((TableCell)xva$0));
    }

    public void removeAllDataCells() {
        this.removeCells((TableCell[])this.streamDataCells().toArray(TableCell[]::new));
    }

    public void removeHeaderCell(int headerCellIndex) {
        this.getHeaderCell(headerCellIndex).ifPresent(xva$0 -> this.removeCells((TableCell)xva$0));
    }

    public void removeAllHeaderCells() {
        this.removeCells((TableCell[])this.streamHeaderCells().toArray(TableCell[]::new));
    }

    public List<TableCell> getCells() {
        return this.streamCells().collect(Collectors.toList());
    }

    public List<TableDataCell> getDataCells() {
        return this.streamDataCells().collect(Collectors.toList());
    }

    public List<TableHeaderCell> getHeaderCells() {
        return this.streamHeaderCells().collect(Collectors.toList());
    }

    public Optional<TableCell> getCell(int index) {
        return this.streamCells().skip(index).findFirst();
    }

    public Optional<TableHeaderCell> getHeaderCell(int headerCellIndex) {
        return this.streamHeaderCells().skip(headerCellIndex).findFirst();
    }

    public Optional<TableDataCell> getDataCell(int dataCellIndex) {
        return this.streamDataCells().skip(dataCellIndex).findFirst();
    }

    public Stream<TableCell> streamCells() {
        return this.getChildren().filter(c -> c instanceof TableCell).map(c -> (TableCell)c);
    }

    public Stream<TableDataCell> streamDataCells() {
        return this.getChildren().filter(c -> c instanceof TableDataCell).map(c -> (TableDataCell)c);
    }

    public Stream<TableHeaderCell> streamHeaderCells() {
        return this.getChildren().filter(c -> c instanceof TableHeaderCell).map(c -> (TableHeaderCell)c);
    }
}

