/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.layouts;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.dom.Style;
import java.util.HashMap;
import java.util.Map;

@Tag(value="border-layout")
public class BorderLayout
extends Component
implements HasComponents {
    private final Map<Region, Component> children = new HashMap<Region, Component>(Region.values().length);

    public BorderLayout() {
        this.getElement().getStyle().setDisplay(Style.Display.GRID);
        this.getElement().getStyle().set("grid-template-columns", "repeat(3, 1fr)");
    }

    private static void applyStyle(Component component, Region region) {
        component.getElement().getStyle().set("grid-column", region.gridColumn);
        component.getElement().getStyle().set("grid-row", region.gridRow);
        BorderLayout.stripStyle(component);
        component.getElement().getClassList().add((Object)region.name().toLowerCase());
    }

    private static void stripStyle(Component component) {
        for (Region region : Region.values()) {
            component.getElement().getClassList().remove((Object)region.name().toLowerCase());
        }
    }

    public void setChildAt(Region region, Component component) {
        Component existingChild = this.children.get((Object)region);
        if (existingChild != null) {
            this.remove(new Component[]{existingChild});
        }
        BorderLayout.applyStyle(component, region);
        this.add(new Component[]{component});
        this.children.put(region, component);
    }

    public void removeChildAt(Region region) {
        Component existingChild = this.children.get((Object)region);
        if (existingChild == null) {
            return;
        }
        BorderLayout.stripStyle(existingChild);
        this.remove(new Component[]{existingChild});
        this.children.remove((Object)region);
    }

    public static enum Region {
        NORTH("1", "2"),
        SOUTH("3", "2"),
        EAST("2", "3"),
        WEST("2", "1"),
        CENTER("2", "2");

        private String gridRow;
        private String gridColumn;

        private Region(String r, String c) {
            this.gridRow = r;
            this.gridColumn = c;
        }
    }
}

