/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.rad;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H1;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.vaadin.firitin.components.details.VDetails;
import org.vaadin.firitin.fields.internalhtmltable.Table;
import org.vaadin.firitin.fields.internalhtmltable.TableHeaderCell;
import org.vaadin.firitin.fields.internalhtmltable.TableRow;
import org.vaadin.firitin.rad.PropertyPrinter;
import org.vaadin.firitin.rad.ValueContext;
import org.vaadin.firitin.util.VStyleUtil;

public class DtoDisplay
extends Composite<Div> {
    public static final int SHORT_STRING_THRESHOLD = 50;
    private final ValueContext context;
    private List<PropertyPrinter> propertyPrinters;
    private static List<PropertyPrinter> _propertyPrinters = new ArrayList<PropertyPrinter>();

    public static List<PropertyPrinter> getDefaultPropertyPrinters() {
        return Collections.unmodifiableList(_propertyPrinters);
    }

    public DtoDisplay(Object dto) {
        this(new ArrayList<PropertyPrinter>(DtoDisplay.getDefaultPropertyPrinters()), new ValueContext(dto));
    }

    private void buildTable() {
        this.injectStyles();
        Table table = new Table();
        this.context.getBeanDescription().findProperties().forEach(p -> {
            TableRow tableRow = table.addRow();
            this.context.setProperty((BeanPropertyDefinition)p);
            Component value = null;
            for (PropertyPrinter propertyPrinter : this.propertyPrinters) {
                value = propertyPrinter.printValue(this.context);
                if (value == null) continue;
                String propertyHeader = propertyPrinter.getPropertyHeader(this.context);
                TableHeaderCell tableHeaderCell = tableRow.addHeaderCell();
                tableHeaderCell.setText(propertyHeader);
                break;
            }
            if (value != null) {
                tableRow.addCells(value);
            } else {
                TableHeaderCell tableHeaderCell = tableRow.addHeaderCell();
                tableHeaderCell.setText(p.getName());
                Object value1 = p.getGetter().getValue(this.context.getValue());
                tableRow.addCells((value1 == null ? "null" : value1.toString()) + " (no printer found)");
            }
        });
        ((Div)this.getContent()).add(new Component[]{table});
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        ((Div)this.getContent()).removeAll();
        this.buildTable();
    }

    private void injectStyles() {
        ((Div)this.getContent()).setClassName("dto-display");
        VStyleUtil.injectAsFirst("    .dto-display table {\n        border-collapse: collapse;\n    }\n    .dto-display td, .dto-display th {\n        padding: var(--lumo-space-xs);\n    }\n    .dto-display tr:first-child td, .dto-display tr:first-child th {\n        padding-top: 0;\n    }\n    .dto-display td>div>p:first-child {\n        margin-top: 0;\n    }\n    .dto-display th {\n        text-align: left;\n        color: var(--lumo-secondary-text-color);\n        font-weight: 500;\n    }\n\n    .dto-display>table>tr>th {\n        text-align: right;\n        white-space: nowrap;\n        align-items: start;\n        vertical-align: top;\n        padding-right: var(--lumo-space-s);\n    }\n    .dto-display td>vaadin-details>vaadin-details-summary {\n        padding: 0;\n    }\n\n");
    }

    public DtoDisplay(List<PropertyPrinter> propertyPrinters, ValueContext context) {
        _propertyPrinters.add(new PrimitivePrinter());
        _propertyPrinters.add(new RecordTypePrinter());
        _propertyPrinters.add(new CollectionPropertyPrinter());
        _propertyPrinters.add(new ObjectPrinter());
        this.propertyPrinters = propertyPrinters;
        this.context = context;
    }

    private static boolean isLongString(Object object) {
        return object != null && object.toString().length() > 50;
    }

    private static String toShortString(Object object) {
        String toString = object == null ? "" : object.toString();
        return DtoDisplay.toShortString(toString);
    }

    private static String toShortString(String toString) {
        if (toString == null) {
            return "";
        }
        if (((String)toString).length() > 50) {
            toString = ((String)toString).substring(0, 50) + "...";
        }
        return toString;
    }

    static String deCamelCased(String propertyName) {
        String deCamelCased = propertyName.replaceAll("([a-z])([A-Z]+)", "$1 $2");
        deCamelCased = StringUtils.capitalize((String)deCamelCased);
        return deCamelCased;
    }

    public DtoDisplay withDefaultHeader() {
        ((Div)this.getContent()).addComponentAsFirst((Component)new H1(DtoDisplay.deCamelCased(this.context.getValue().getClass().getSimpleName()) + ":"));
        return this;
    }

    public DtoDisplay withPropertyPrinter(PropertyPrinter printer) {
        this.propertyPrinters.add(0, printer);
        return this;
    }

    private static class PrimitivePrinter
    implements PropertyPrinter {
        private PrimitivePrinter() {
        }

        @Override
        public Component printValue(ValueContext ctx) {
            if (ctx.getProperty().getPrimaryType().isPrimitive() || String.class == ctx.getProperty().getPrimaryType().getRawClass() || ClassUtils.isPrimitiveOrWrapper((Class)ctx.getProperty().getRawPrimaryType())) {
                return new Span("" + ctx.getPropertyValue());
            }
            return null;
        }
    }

    private static class RecordTypePrinter
    implements PropertyPrinter {
        private RecordTypePrinter() {
        }

        @Override
        public Component printValue(ValueContext ctx) {
            if (ctx.getProperty().getPrimaryType().isRecordType()) {
                Object value = ctx.getProperty().getGetter().getValue(ctx.getValue());
                String header = DtoDisplay.toShortString(value);
                return new VDetails(header, (SerializableSupplier<Component>)(SerializableSupplier & Serializable)() -> new DtoDisplay(value));
            }
            return null;
        }
    }

    private static class CollectionPropertyPrinter
    implements PropertyPrinter {
        private CollectionPropertyPrinter() {
        }

        @Override
        public Component printValue(ValueContext ctx) {
            JavaType primaryType = ctx.getProperty().getPrimaryType();
            if (primaryType instanceof CollectionLikeType || primaryType instanceof ArrayType) {
                Table subTable = new Table();
                TableRow header = subTable.addRow();
                JavaType contentType = primaryType.getContentType();
                BasicBeanDescription contentTypeBbd = (BasicBeanDescription)ValueContext.jack.getSerializationConfig().introspect(contentType);
                contentTypeBbd.findProperties().forEach(subP -> header.addHeaderCell().setText(DtoDisplay.deCamelCased(subP.getName())));
                Object collection = ctx.getPropertyValue();
                Class<?> collectionClass = collection.getClass();
                if (collectionClass.isArray()) {
                    Object[] array;
                    for (Object e2 : array = (Object[])collection) {
                        TableRow subTableRow = subTable.addRow();
                        contentTypeBbd.findProperties().forEach(subP -> {
                            Object value = subP.getGetter().getValue(e2);
                            subTableRow.addCells(value.toString());
                        });
                    }
                } else if (collection instanceof Iterable) {
                    Iterable iterable = (Iterable)collection;
                    iterable.forEach(e -> {
                        TableRow subTableRow = subTable.addRow();
                        contentTypeBbd.findProperties().forEach(subP -> {
                            Object value = subP.getGetter().getValue(e);
                            subTableRow.addCells(value.toString());
                        });
                    });
                }
                return subTable;
            }
            return null;
        }
    }

    private static class ObjectPrinter
    implements PropertyPrinter {
        private ObjectPrinter() {
        }

        @Override
        public Component printValue(ValueContext ctx) {
            Object value = ctx.getProperty().getGetter().getValue(ctx.getValue());
            String header = DtoDisplay.toShortString(value);
            return new VDetails(header, (SerializableSupplier<Component>)(SerializableSupplier & Serializable)() -> new DtoDisplay(value));
        }
    }
}

