/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class ResizeObserver {
    private static ObjectMapper om = new ObjectMapper();
    private final Element el;
    private final Map<Component, List<SizeHandler>> listeners = new HashMap<Component, List<SizeHandler>>();
    private final List<Component> components = new ArrayList<Component>();
    private final DomListenerRegistration reg;
    private static Map<Component, ResizeObserver> uiToObserver = Collections.synchronizedMap(new WeakHashMap());

    public static ResizeObserver of(UI ui) {
        return uiToObserver.computeIfAbsent((Component)ui, c -> new ResizeObserver(ui));
    }

    public static ResizeObserver get() {
        return ResizeObserver.of(UI.getCurrent());
    }

    private ResizeObserver(UI ui) {
        this.components.add((Component)ui);
        this.el = ui.getElement();
        this.el.executeJs("var el = this;\nel._resizeObserverElements = [];\nconst resizeObserver = new ResizeObserver((entries) => {\n  const sizes = {};\n  for (const entry of entries) {\n    if (entry.contentBoxSize) {\n      const idx = el._resizeObserverElements.indexOf(entry.target);\n      const contentBoxSize = entry.contentBoxSize[0];\n      sizes[idx] = JSON.stringify(entry.contentRect);\n    }\n  }\n  const event = new Event(\"element-resize\");\n  event.dimensions = sizes;\n  el.dispatchEvent(event);\n});\nel._resizeObserver = resizeObserver;\n// Always observe UI element !?!\nel._resizeObserverElements.push(el);\nresizeObserver.observe(el);\n", new Serializable[0]);
        this.reg = this.el.addEventListener("element-resize", (DomEventListener & Serializable)event -> {
            JsonObject object = event.getEventData().getObject("event.dimensions");
            for (String idx : object.keys()) {
                String json = object.getString(idx);
                try {
                    Dimensions dimensions = (Dimensions)om.readValue(json, Dimensions.class);
                    Component component = this.components.get(Integer.valueOf(idx));
                    new ArrayList<SizeHandler>(this.listeners.getOrDefault(component, Collections.emptyList())).forEach(l -> l.onSizeObservation(dimensions));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        }).addEventData("event.dimensions").debounce(100);
    }

    public ResizeObserver observe(Component component, SizeHandler listener) {
        this.observeComponentChanges(component);
        this.listeners.computeIfAbsent(component, c -> new ArrayList()).add(listener);
        return this;
    }

    private ResizeObserver observeComponentChanges(Component ... additionalComponentsToObserve) {
        for (Component c : additionalComponentsToObserve) {
            if (this.components.contains(c)) continue;
            this.components.add(c);
            this.el.executeJs("    this._resizeObserverElements.push($0);\n    this._resizeObserver.observe($0);\n", new Serializable[]{c.getElement()}).then((SerializableConsumer & Serializable)jsonvalue -> {}, (SerializableConsumer & Serializable)s -> {
                throw new RuntimeException("Error adding size observer, component not attached!?");
            });
        }
        return this;
    }

    public ResizeObserver withDebounceTimeout(int timeout) {
        this.reg.debounce(timeout);
        return this;
    }

    public record Dimensions(int x, int y, int width, int height, int top, int right, int bottom, int left) {
    }

    public static interface SizeHandler {
        public void onSizeObservation(Dimensions var1);
    }
}

