/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

public class TreeItem
extends Component
implements ClickNotifier<TreeItem> {
    private static final long serialVersionUID = -5047062207386723618L;
    private Element expander;
    private boolean open = false;
    private Div children;
    private Component nodeContent;
    private Element contentTD;
    private Div contentDiv;
    private PopulateSubtreeHandler populateSubtreeHandler;

    public TreeItem(Component nodeContent) {
        super(new Element("table"));
        Element tr = new Element("tr");
        this.expander = new Element("td");
        this.expander.getClassList().add((Object)"expander");
        this.expander.addEventListener("click", (DomEventListener & Serializable)e -> this.toggleNode());
        this.children = new Div();
        this.children.setVisible(false);
        this.contentTD = new Element("td");
        this.contentDiv = new Div();
        this.contentDiv.addClassName("node-content");
        this.contentDiv.getElement().appendChild(new Element[]{nodeContent.getElement()});
        this.contentTD.appendChild(new Element[]{this.contentDiv.getElement(), this.children.getElement()});
        tr.appendChild(new Element[]{this.expander, this.contentTD});
        this.getElement().appendChild(new Element[]{tr});
        this.nodeContent = nodeContent;
    }

    public TreeItem(String stringContent) {
        this((Component)new Div(new Component[]{new Text(stringContent)}));
    }

    public TreeItem addChild(Component childComponent) {
        TreeItem i = new TreeItem(childComponent);
        this.addChild(i);
        return i;
    }

    public Component getNodeContent() {
        return this.nodeContent;
    }

    public void addChild(TreeItem treeItem) {
        this.expander.setVisible(true);
        this.children.add(new Component[]{treeItem});
        if (this.children.getChildren().count() == 1L) {
            this.updateExpanderToggle();
        }
    }

    private void updateExpanderToggle() {
        this.expander.removeAllChildren();
        this.expander.appendChild(new Element[]{this.open ? VaadinIcon.CARET_DOWN.create().getElement() : VaadinIcon.CARET_RIGHT.create().getElement()});
    }

    public TreeItem addChild(String stringContent) {
        return this.addChild((Component)new Span(stringContent));
    }

    public void removeChild(TreeItem c) {
        this.children.remove(new Component[]{c});
        if (this.children.getChildren().count() == 0L) {
            this.expander.removeAllChildren();
        }
    }

    public void toggleNode() {
        if (this.hasChildren()) {
            this.open = !this.open;
            this.updateExpanderToggle();
            this.children.setVisible(this.open);
            if (this.open && this.populateSubtreeHandler != null) {
                this.populateSubtreeHandler.onExpand();
                this.populateSubtreeHandler = null;
            }
        }
    }

    public void showChildren() {
        if (!this.open) {
            this.toggleNode();
        }
    }

    public void closeChildren() {
        if (this.open) {
            this.toggleNode();
        }
    }

    public void showChildrenRecursively() {
        this.showChildren();
        this.children.getChildren().forEach(c -> {
            TreeItem treeItem = (TreeItem)((Object)c);
            treeItem.showChildrenRecursively();
        });
    }

    public void setPopulateSubreeHandler(PopulateSubtreeHandler handler) {
        this.populateSubtreeHandler = handler;
        this.updateExpanderToggle();
    }

    public boolean isOpen() {
        return this.open;
    }

    private boolean hasChildren() {
        if (this.populateSubtreeHandler != null) {
            return true;
        }
        return this.children.getChildren().findFirst().isPresent();
    }

    public void setSelected(boolean selected) {
        this.nodeContent.getElement().getClassList().set("selected", selected);
    }

    public Registration addClickListener(ComponentEventListener<ClickEvent<TreeItem>> listener) {
        return ComponentUtil.addListener((Component)this.nodeContent, ClickEvent.class, listener);
    }

    public static interface PopulateSubtreeHandler
    extends Serializable {
        public void onExpand();
    }
}

