/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.button;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.vaadin.firitin.components.button.UIFuture;
import org.vaadin.firitin.components.button.VButton;
import org.vaadin.firitin.components.progressbar.VProgressBar;

public class ActionButton<T>
extends Composite<Div> {
    private Integer estimatedDuration;
    private Supplier<T> action;
    private Consumer<? super T> postUiUpdate;
    private Runnable preUiUpdate;
    private UI ui;
    private CompletableFuture<T> completableFuture;
    private Boolean showProgressBar;
    private VProgressBar progressBar;
    private Supplier<CompletableFuture<T>> completableFutureSupplier;
    private Executor executor;
    private UIFuture uiFuture;
    private boolean enableAfterAction = true;
    private VButton button = new VButton();
    private String busyText;
    private String buttonText;

    public ActionButton() {
        ((Div)this.getContent()).getStyle().setDisplay(Style.Display.INLINE_BLOCK);
        ((Div)this.getContent()).getStyle().setPosition(Style.Position.RELATIVE);
        ((Div)this.getContent()).add(new Component[]{this.button});
        this.getButton().setDisableOnClick(true);
        this.getButton().addClickListener(this::handleClick);
    }

    public ActionButton(String buttonText, Supplier<CompletableFuture<T>> action) {
        this();
        this.setText(buttonText);
        this.setCompletableFutureAction(action);
    }

    public ActionButton(String buttonText, Runnable action) {
        this();
        this.setText(buttonText);
        this.setAction(() -> {
            action.run();
            return null;
        });
    }

    public ActionButton(String buttonText) {
        this();
        this.setText(buttonText);
    }

    public ActionButton<T> setAction(Supplier<T> action) {
        this.action = action;
        return this;
    }

    public ActionButton<Void> setAction(Runnable action) {
        this.action = () -> {
            action.run();
            return null;
        };
        return this;
    }

    public ActionButton<T> setCompletableFutureAction(Supplier<CompletableFuture<T>> task) {
        this.completableFutureSupplier = task;
        return this;
    }

    public ActionButton<T> setPostUiAction(Consumer<? super T> postUiAction) {
        this.postUiUpdate = this.postUiUpdate;
        return this;
    }

    @Deprecated
    public ActionButton<T> setPostUiUpdate(Consumer<? super T> postUiUpdate) {
        this.postUiUpdate = postUiUpdate;
        return this;
    }

    public ActionButton<T> setPreUiAction(Runnable preUiAction) {
        this.preUiUpdate = preUiAction;
        return this;
    }

    @Deprecated(forRemoval=true)
    public ActionButton<T> setPreUiUpdate(Runnable preUiUpdate) {
        return this.setPreUiAction(preUiUpdate);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.ui = attachEvent.getUI();
        this.uiFuture = new UIFuture(this.ui);
        if (this.executor != null) {
            this.uiFuture.setExecutor(this.executor);
        }
    }

    private void handleClick() {
        if (this.preUiUpdate != null) {
            this.preUiUpdate.run();
        }
        if (this.isShowProgressBar()) {
            if (this.progressBar == null) {
                this.progressBar = this.prepareProgressBar();
            }
            if (this.estimatedDuration != null) {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setValue(0.0);
                this.progressBar.setMax(this.estimatedDuration.intValue());
                this.progressBar.animateToEstimate();
            } else {
                this.progressBar.setIndeterminate(true);
            }
            this.progressBar.setVisible(true);
        }
        if (this.busyText != null) {
            this.buttonText = this.getButton().getText();
            this.getButton().setText(this.busyText);
        }
        this.completableFuture = this.completableFutureSupplier != null ? this.completableFutureSupplier.get() : (this.executor != null ? CompletableFuture.supplyAsync(() -> this.action.get(), this.executor) : CompletableFuture.supplyAsync(() -> this.action.get()));
        this.uiFuture.of(this.completableFuture).whenComplete((result, e) -> {
            this.reEnableAfterAction();
            if (this.postUiUpdate != null && e == null) {
                this.postUiUpdate.accept(result);
            }
        });
    }

    public CompletableFuture<T> getCompletableFuture() {
        return this.completableFuture;
    }

    public void setText(String s) {
        this.getButton().setText(s);
    }

    public ActionButton setBusyText(String text) {
        this.busyText = text;
        return this;
    }

    protected void reEnableAfterAction() {
        if (this.isEnableAfterAction()) {
            this.getButton().setEnabled(true);
            if (this.busyText != null) {
                this.getButton().setText(this.buttonText);
            }
        }
        if (this.progressBar != null) {
            this.progressBar.setVisible(false);
        }
    }

    public boolean isShowProgressBar() {
        return this.showProgressBar == null ? true : this.showProgressBar;
    }

    public void setShowProgressBar(boolean showProgressBar) {
        this.showProgressBar = showProgressBar;
    }

    protected VProgressBar prepareProgressBar() {
        VProgressBar progressBar = new VProgressBar();
        progressBar.getStyle().setPosition(Style.Position.ABSOLUTE);
        progressBar.getStyle().setRight("0");
        progressBar.getStyle().setLeft("0");
        progressBar.getStyle().setBottom("0");
        progressBar.getStyle().setMargin("0");
        progressBar.getStyle().setDisplay(Style.Display.BLOCK);
        progressBar.setVisible(false);
        ((Div)this.getContent()).add(new Component[]{progressBar});
        return progressBar;
    }

    public void updateProgressAsync(double progress, double min, double max) {
        if (this.progressBar != null) {
            Command & Serializable command = (Command & Serializable)() -> {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setMin(min);
                this.progressBar.setMax(max);
                if (progress > min) {
                    if (progress > max) {
                        this.progressBar.setIndeterminate(true);
                    } else {
                        this.progressBar.setValue(progress);
                    }
                }
            };
            CompletableFuture.runAsync(() -> {
                if (this.ui != null) {
                    this.ui.access(command);
                } else {
                    command.execute();
                }
            });
        }
    }

    public void updateProgressAsync(double progress) {
        if (this.progressBar != null) {
            Command & Serializable command = (Command & Serializable)() -> {
                this.progressBar.setIndeterminate(false);
                if (progress > this.progressBar.getMax()) {
                    this.progressBar.setIndeterminate(true);
                } else {
                    this.progressBar.setValue(progress);
                }
            };
            CompletableFuture.runAsync(() -> {
                if (this.ui != null) {
                    this.ui.access(command);
                } else {
                    command.execute();
                }
            });
        }
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
        if (this.uiFuture != null) {
            this.uiFuture.setExecutor(executor);
        }
    }

    public Integer getEstimatedDuration() {
        return this.estimatedDuration;
    }

    public void setEstimatedDuration(Integer estimatedDuration) {
        this.estimatedDuration = estimatedDuration;
        if (estimatedDuration != null) {
            this.setShowProgressBar(true);
        }
    }

    public VButton getButton() {
        return this.button;
    }

    public boolean isEnableAfterAction() {
        return this.enableAfterAction;
    }

    public ActionButton setEnableAfterAction(boolean enableAfterAction) {
        this.enableAfterAction = enableAfterAction;
        return this;
    }
}

