/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.upload;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.component.upload.UploadI18N;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.StreamReceiver;
import com.vaadin.flow.server.StreamVariable;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.vaadin.firitin.fluency.ui.FluentComponent;
import org.vaadin.firitin.fluency.ui.FluentHasEnabled;
import org.vaadin.firitin.fluency.ui.FluentHasSize;
import org.vaadin.firitin.fluency.ui.FluentHasStyle;

@Uses(value=Upload.class)
@Tag(value="vaadin-upload")
public class UploadFileHandler
extends Component
implements FluentComponent<UploadFileHandler>,
FluentHasStyle<UploadFileHandler>,
FluentHasSize<UploadFileHandler>,
FluentHasEnabled<UploadFileHandler> {
    private UploadI18N i18n;
    private int maxFiles = 1;
    protected final CallbackFileHandler fileHandler;
    private FileRequestHandler frh;
    private boolean clearAutomatically = true;
    private UI ui;
    private int maxConcurrentUploads = 1;

    public UploadFileHandler(FileHandler fileHandler) {
        this((InputStream content, FileDetails fmd) -> {
            fileHandler.handleFile(content, fmd.fileName(), fmd.mimeType());
            return (Command & Serializable)() -> {};
        });
    }

    public UploadFileHandler(CallbackFileHandler fileHandler) {
        this.fileHandler = fileHandler;
        this.withAllowMultiple(false);
        this.addUploadSucceededListener((ComponentEventListener<UploadSucceededEvent>)(ComponentEventListener & Serializable)e -> {});
    }

    public void clearFiles() {
        this.getElement().executeJs("this.files = [];", new Serializable[0]);
    }

    public UploadFileHandler allowMultiple() {
        return this.withAllowMultiple(true);
    }

    public UploadFileHandler withAllowMultiple(boolean allowMultiple) {
        if (allowMultiple) {
            this.withMaxFiles(Integer.MAX_VALUE);
        } else {
            this.withMaxFiles(1);
        }
        return this;
    }

    public UploadFileHandler withDragAndDrop(boolean enableDragAndDrop) {
        if (enableDragAndDrop) {
            this.getElement().removeAttribute("nodrop");
        } else {
            this.getElement().setAttribute("nodrop", true);
        }
        return this;
    }

    public UploadFileHandler withClearAutomatically(boolean clear) {
        this.clearAutomatically = clear;
        return this;
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.frh = new FileRequestHandler();
        StreamReceiver fakeSR = new StreamReceiver(this.getElement().getNode(), "s", this.dummySV());
        this.frh.id = fakeSR.getId();
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> this.getElement().setAttribute("fakesr", (AbstractStreamResource)fakeSR));
        attachEvent.getSession().addRequestHandler((RequestHandler)this.frh);
        this.getElement().executeJs("    const ufhid = $2;\n    this.setAttribute(\"target\",\n    this.getAttribute(\"fakesr\").substring(0, this.getAttribute(\"fakesr\").indexOf(\"VAADIN\"))\n    + \"?v-r=ufh\");\n    // override default dragover so that it works\n    this.addEventListener(\"dragover\", event => {\n        event.stopPropagation();\n        event.preventDefault();\n        if (!this.nodrop && !this._dragover) {\n            let containsInvalid = false;\n            let numberOfFiles = 0;\n            const re = this.__acceptRegexp;\n            for (const item of event.dataTransfer.items) {\n                const acceptedType = (re == null) || re.test(item.type);\n                if(acceptedType && item.kind == \"file\") {\n                    numberOfFiles++;\n                } else {\n                    containsInvalid = true;\n                }\n            }\n            if(!containsInvalid && (this.files.length + numberOfFiles) <= this.maxFiles) {\n                this._dragoverValid = !this.maxFilesReached;\n                this._dragover = true;\n            }\n        }\n        event.dataTransfer.dropEffect = !this._dragoverValid || this.nodrop ? 'none' : 'copy';\n    }, true); // bubling phase as no idea how to override default handler by default\n\n    // avoid the default auto upload behaviour\n    // that immediately opens xhr for each file\n    this.noAuto = true;\n    const CLEAR = $0;\n    const MAX_CONNECTIONS = $1;\n    this.queueNext = () => {\n        const numConnections = this.files.filter(file => file.uploading).length;\n        if(numConnections < MAX_CONNECTIONS) {\n        // reverse to pick next in selection order\n            const nextFileToUpload = this.files.slice().reverse().find(file => file.held)\n            if (nextFileToUpload) {\n                this.uploadFiles(nextFileToUpload)\n            }\n        }\n    }\n\n    // start uploading next file in queue when a file is successfully uploaded\n    this.addEventListener('upload-success', e => {\n        if(CLEAR) {\n            const index = this.files.indexOf(e.detail.file);\n            if (index > -1) {\n                this._removeFile(e.detail.file);\n            }\n        }\n        this.queueNext();\n    });\n\n    // start uploading next file in queue also when there is an error when uploading the file\n    this.addEventListener('upload-error', () => {\n        this.queueNext();\n    });\n\n    this.addEventListener('files-changed', (event) => {\n        this.queueNext();\n    });\n\n    // This sends the request without obsolete and somewhat problematic multipart request\n    this.addEventListener(\"upload-request\", e => {\n        e.preventDefault(true); // I'll send this instead!!\n        const xhr = event.detail.xhr;\n        const file = event.detail.file;\n        const name = encodeURIComponent(file.name);\n        xhr.setRequestHeader('Content-Type', file.type);\n        xhr.setRequestHeader('Content-Disposition', 'attachment;name=\"'+ufhid+'\"; filename=\"' + name + '\"');\n        xhr.send(file);\n    });\n", new Serializable[]{Boolean.valueOf(this.clearAutomatically), Integer.valueOf(this.maxConcurrentUploads), this.frh.id});
        this.ui = attachEvent.getUI();
        super.onAttach(attachEvent);
        if (this.i18n != null) {
            this.setI18nWithJS();
        }
    }

    private StreamVariable dummySV() {
        return new StreamVariable(){

            public OutputStream getOutputStream() {
                return null;
            }

            public boolean listenProgress() {
                return false;
            }

            public void onProgress(StreamVariable.StreamingProgressEvent event) {
            }

            public void streamingStarted(StreamVariable.StreamingStartEvent event) {
            }

            public void streamingFinished(StreamVariable.StreamingEndEvent event) {
            }

            public void streamingFailed(StreamVariable.StreamingErrorEvent event) {
            }

            public boolean isInterrupted() {
                return false;
            }
        };
    }

    protected void onDetach(DetachEvent detachEvent) {
        detachEvent.getSession().removeRequestHandler((RequestHandler)this.frh);
        this.ui = null;
        super.onDetach(detachEvent);
    }

    public UploadFileHandler withMaxFiles(int maxFiles) {
        this.maxFiles = maxFiles;
        this.getElement().setProperty("maxFiles", (double)maxFiles);
        return this;
    }

    public Registration addUploadSucceededListener(ComponentEventListener<UploadSucceededEvent> listener) {
        return this.addListener(UploadSucceededEvent.class, listener);
    }

    public void setMaxConcurrentUploads(int maxConcurrentUploads) {
        this.maxConcurrentUploads = maxConcurrentUploads;
    }

    public void setUploadButton(Component button) {
        SlotUtils.setSlot((HasElement)this, (String)"add-button", (Component[])new Component[]{button});
    }

    public UploadFileHandler withUploadButton(Component button) {
        this.setUploadButton(button);
        return this;
    }

    public void setAcceptedFileTypes(String ... acceptedFileTypes) {
        String accepted = "";
        if (acceptedFileTypes != null) {
            accepted = String.join((CharSequence)",", acceptedFileTypes);
        }
        this.getElement().setProperty("accept", accepted);
    }

    public UploadFileHandler withAcceptedFileTypes(String ... acceptedFileTypes) {
        this.setAcceptedFileTypes(acceptedFileTypes);
        return this;
    }

    public void setDropLabel(Component label) {
        SlotUtils.setSlot((HasElement)this, (String)"drop-label", (Component[])new Component[]{label});
    }

    public UploadFileHandler withDropLabel(Component label) {
        this.setDropLabel(label);
        return this;
    }

    public void setDropLabelIcon(Component icon) {
        SlotUtils.setSlot((HasElement)this, (String)"drop-label-icon", (Component[])new Component[]{icon});
    }

    public UploadFileHandler withDropLabelIcon(Component icon) {
        this.setDropLabelIcon(icon);
        return this;
    }

    public void setI18n(UploadI18N i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.i18n = i18n;
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            if (i18n == this.i18n) {
                this.setI18nWithJS();
            }
        });
    }

    private void setI18nWithJS() {
        JsonObject i18nJson = (JsonObject)JsonSerializer.toJson((Object)this.i18n);
        this.deeplyRemoveNullValuesFromJsonObject(i18nJson);
        this.getElement().executeJs("const dropFiles = Object.assign({}, this.i18n.dropFiles, $0.dropFiles);const addFiles = Object.assign({}, this.i18n.addFiles, $0.addFiles);const error = Object.assign({}, this.i18n.error, $0.error);const uploadingStatus = Object.assign({}, this.i18n.uploading.status, $0.uploading && $0.uploading.status);const uploadingRemainingTime = Object.assign({}, this.i18n.uploading.remainingTime, $0.uploading && $0.uploading.remainingTime);const uploadingError = Object.assign({}, this.i18n.uploading.error, $0.uploading && $0.uploading.error);const uploading = {status: uploadingStatus,  remainingTime: uploadingRemainingTime,  error: uploadingError};const units = $0.units || this.i18n.units;this.i18n = Object.assign({}, this.i18n, $0, {  addFiles: addFiles,  dropFiles: dropFiles,  uploading: uploading, units: units});", new Serializable[]{i18nJson});
    }

    private void deeplyRemoveNullValuesFromJsonObject(JsonObject jsonObject) {
        for (String key : jsonObject.keys()) {
            if (jsonObject.get(key).getType() == JsonType.OBJECT) {
                this.deeplyRemoveNullValuesFromJsonObject((JsonObject)jsonObject.get(key));
                continue;
            }
            if (jsonObject.get(key).getType() != JsonType.NULL) continue;
            jsonObject.remove(key);
        }
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public void onEnabledStateChanged(boolean enabled) {
        super.onEnabledStateChanged(enabled);
        if (!enabled) {
            int origMax = this.maxFiles;
            this.withMaxFiles(0);
            this.maxFiles = origMax;
        } else {
            this.withMaxFiles(this.maxFiles);
        }
    }

    @FunctionalInterface
    public static interface FileHandler
    extends Serializable {
        public void handleFile(InputStream var1, String var2, String var3);
    }

    @FunctionalInterface
    public static interface CallbackFileHandler
    extends Serializable {
        public Command handleFile(InputStream var1, FileDetails var2) throws IOException;
    }

    private class FileRequestHandler
    implements RequestHandler {
        private String id;
        private List<String> files = new LinkedList<String>();

        private FileRequestHandler() {
        }

        public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
            String contextPath = request.getContextPath();
            String cd = request.getHeader("Content-Disposition");
            if (cd != null && cd.contains(this.id)) {
                String contentType = request.getHeader("Content-Type");
                String name = cd.split(";")[2].split("=")[1].substring(1);
                name = name.substring(0, name.indexOf("\""));
                name = URLDecoder.decode(name, "UTF-8");
                Command cb = UploadFileHandler.this.fileHandler.handleFile(request.getInputStream(), new FileDetails(name, contentType));
                if (cb != null) {
                    UploadFileHandler.this.ui.access(cb);
                }
                response.setStatus(200);
                response.getWriter().println("OK");
                return true;
            }
            return false;
        }
    }

    @DomEvent(value="upload-success")
    public static class UploadSucceededEvent
    extends ComponentEvent<UploadFileHandler> {
        private final String fileName;

        public UploadSucceededEvent(UploadFileHandler source, boolean fromClient, @EventData(value="event.detail.file.name") String fileName) {
            super((Component)source, fromClient);
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }

    public record FileDetails(String fileName, String mimeType) {
    }
}

