/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.form;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import jakarta.validation.Configuration;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.vaadin.firitin.components.button.DefaultButton;
import org.vaadin.firitin.components.button.DeleteButton;
import org.vaadin.firitin.components.button.VButton;
import org.vaadin.firitin.components.dialog.VDialog;
import org.vaadin.firitin.components.orderedlayout.VVerticalLayout;
import org.vaadin.firitin.form.FormBinder;
import org.vaadin.firitin.util.VStyles;

@Deprecated(forRemoval=false)
public abstract class BeanValidationForm<T>
extends Composite<Div> {
    private final Class<T> entityType;
    private T entity;
    private SavedHandler<T> savedHandler;
    private ResetHandler<T> resetHandler;
    private DeleteHandler<T> deleteHandler;
    private String modalWindowTitle = "Edit entry";
    private String saveCaption = "Save";
    private String deleteCaption = "Delete";
    private String cancelCaption = "Cancel";
    private VDialog popup;
    private FormBinder<T> binder;
    private boolean hasChanges = false;
    private Button saveButton;
    private Button resetButton;
    private Button deleteButton;
    private Class<?>[] validationGroups;
    private Validator validator;
    private Div classLevelViolationsDisplay = new Div();

    public BeanValidationForm(Class<T> entityType) {
        this.entityType = entityType;
        this.addAttachListener((ComponentEventListener & Serializable)e -> this.lazyInit());
    }

    public void setEntityWithEnabledSave(T entity) {
        this.setEntity(entity);
        this.setHasChanges(true);
        this.adjustSaveButtonState();
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    protected void setHasChanges(boolean hasChanges) {
        this.hasChanges = hasChanges;
    }

    @Deprecated
    public boolean isValid() {
        return this.binder.isValid();
    }

    public ResetHandler<T> getResetHandler() {
        return this.resetHandler;
    }

    public void setResetHandler(ResetHandler<T> resetHandler) {
        this.resetHandler = resetHandler;
        this.getResetButton().setVisible(this.resetHandler != null);
    }

    public SavedHandler<T> getSavedHandler() {
        return this.savedHandler;
    }

    public void setSavedHandler(SavedHandler<T> savedHandler) {
        this.savedHandler = savedHandler;
        this.getSaveButton().setVisible(this.savedHandler != null);
    }

    public DeleteHandler<T> getDeleteHandler() {
        return this.deleteHandler;
    }

    public void setDeleteHandler(DeleteHandler<T> deleteHandler) {
        this.deleteHandler = deleteHandler;
        this.getDeleteButton().setVisible(this.deleteHandler != null);
    }

    public String getSaveCaption() {
        return this.saveCaption;
    }

    public void setSaveCaption(String saveCaption) {
        this.saveCaption = saveCaption;
        if (this.saveButton != null) {
            this.getSaveButton().setText(this.getSaveCaption());
        }
    }

    public String getModalWindowTitle() {
        return this.modalWindowTitle;
    }

    public void setModalWindowTitle(String modalWindowTitle) {
        this.modalWindowTitle = modalWindowTitle;
    }

    public String getDeleteCaption() {
        return this.deleteCaption;
    }

    public void setDeleteCaption(String deleteCaption) {
        this.deleteCaption = deleteCaption;
        if (this.deleteButton != null) {
            this.getDeleteButton().setText(this.getDeleteCaption());
        }
    }

    public String getCancelCaption() {
        return this.cancelCaption;
    }

    public void setCancelCaption(String cancelCaption) {
        this.cancelCaption = cancelCaption;
        if (this.resetButton != null) {
            this.getResetButton().setText(this.getCancelCaption());
        }
    }

    public FormBinder<T> getBinder() {
        if (this.binder == null) {
            this.lazyInit();
        }
        return this.binder;
    }

    protected void lazyInit() {
        if (!((Div)this.getContent()).getChildren().findAny().isPresent()) {
            ((Div)this.getContent()).add(new Component[]{this.createContent()});
            this.bind();
        }
    }

    protected void bind() {
        this.binder = new FormBinder<T>(this.entityType, (Object)this);
        this.binder.setClassLevelViolationDisplay((HasComponents)this.classLevelViolationsDisplay);
        this.binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (e.isFromClient()) {
                this.hasChanges = true;
                Set constraintViolations = this.doBeanValidation(e.getValue());
                this.binder.setConstraintViolations(constraintViolations);
                this.adjustResetButtonState();
                this.adjustSaveButtonState();
            }
        });
    }

    public Class<?>[] getValidationGroups() {
        return this.validationGroups;
    }

    public void setValidationGroups(Class<?> ... groups) {
        this.validationGroups = groups;
    }

    protected <T> Set<ConstraintViolation<T>> doBeanValidation(T object) {
        Class[] groups = this.getValidationGroups();
        if (groups != null) {
            return this.getValidator().validate(object, groups);
        }
        return this.getValidator().validate(object, new Class[0]);
    }

    protected Validator getValidator() {
        if (this.validator == null) {
            Configuration configuration = Validation.byDefaultProvider().configure();
            final MessageInterpolator defaultMessageInterpolator = configuration.getDefaultMessageInterpolator();
            ValidatorFactory factory = configuration.messageInterpolator(new MessageInterpolator(){
                final /* synthetic */ BeanValidationForm this$0;
                {
                    this.this$0 = this$0;
                }

                public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
                    return defaultMessageInterpolator.interpolate(messageTemplate, context, this.this$0.getLocale());
                }

                public String interpolate(String messageTemplate, MessageInterpolator.Context context, Locale locale) {
                    return defaultMessageInterpolator.interpolate(messageTemplate, context, locale);
                }
            }).buildValidatorFactory();
            this.validator = factory.getValidator();
        }
        return this.validator;
    }

    protected Component createContent() {
        VVerticalLayout layout = new VVerticalLayout();
        this.getFormComponents().forEach(f -> layout.add(new Component[]{f}));
        layout.add(new Component[]{this.classLevelViolationsDisplay});
        layout.add(new Component[]{this.getToolbar()});
        return layout;
    }

    protected abstract List<Component> getFormComponents();

    protected void adjustSaveButtonState() {
        if (this.isBound()) {
            boolean valid = this.isValid();
            this.getSaveButton().setEnabled(this.hasChanges() && valid);
        }
    }

    public Button getSaveButton() {
        if (this.saveButton == null) {
            this.setSaveButton(this.createSaveButton());
        }
        return this.saveButton;
    }

    public void setSaveButton(Button button) {
        this.saveButton = button;
        this.saveButton.addClickListener(this::save);
    }

    protected Button createSaveButton() {
        return (Button)new DefaultButton(this.getSaveCaption()).withVisible(false);
    }

    protected boolean isBound() {
        return this.binder != null && this.binder.getValue() != null;
    }

    protected Button createResetButton() {
        return (Button)new VButton(this.getCancelCaption()).withVisible(false);
    }

    public Button getResetButton() {
        if (this.resetButton == null) {
            this.setResetButton(this.createResetButton());
        }
        return this.resetButton;
    }

    public void setResetButton(Button resetButton) {
        this.resetButton = resetButton;
        this.resetButton.addClickListener(this::reset);
    }

    protected Button createDeleteButton() {
        return new DeleteButton();
    }

    public Button getDeleteButton() {
        if (this.deleteButton == null) {
            this.setDeleteButton(this.createDeleteButton());
            this.deleteButton.setVisible(this.deleteHandler != null);
        }
        return this.deleteButton;
    }

    public void setDeleteButton(Button deleteButton) {
        this.deleteButton = deleteButton;
        deleteButton.addClickListener(this::delete);
    }

    protected void adjustResetButtonState() {
        this.getResetButton().setEnabled(true);
    }

    public T getEntity() {
        if (this.binder.isImmutable()) {
            return this.binder.getValue();
        }
        return this.entity;
    }

    public void setEntity(T entity) {
        this.entity = entity;
        this.lazyInit();
        if (entity != null) {
            this.binder.setValue(entity);
            this.hasChanges = false;
            this.setVisible(true);
        } else {
            this.binder.setValue(null);
            this.hasChanges = false;
            this.setVisible(false);
        }
        this.adjustSaveButtonState();
    }

    protected void save(ClickEvent<Button> e) {
        this.savedHandler.onSave(this.getEntity());
        this.hasChanges = false;
        this.adjustSaveButtonState();
        this.adjustResetButtonState();
    }

    protected void reset(ClickEvent<Button> e) {
        this.resetHandler.onReset(this.getEntity());
        this.hasChanges = false;
        this.adjustSaveButtonState();
        this.adjustResetButtonState();
    }

    protected void delete(ClickEvent<Button> e) {
        this.deleteHandler.onDelete(this.getEntity());
        this.hasChanges = false;
    }

    public HorizontalLayout getToolbar() {
        return new HorizontalLayout(new Component[]{this.getSaveButton(), this.getResetButton(), this.getDeleteButton()});
    }

    public VDialog openInModalPopup() {
        this.popup = new VDialog(new Component[0]);
        VStyles.applyDialogNoPaddingStyle(this.popup);
        this.popup.add(new Component[]{this});
        this.focusFirst();
        this.popup.open();
        return this.popup;
    }

    public void focusFirst() {
        this.findFieldAndFocus(this.getContent());
    }

    private boolean findFieldAndFocus(Component compositionRoot) {
        Iterator iter = compositionRoot.getChildren().iterator();
        while (iter.hasNext()) {
            Component component = (Component)iter.next();
            if (component instanceof Focusable && !this.isReadOnly(component)) {
                ((Focusable)component).focus();
                return true;
            }
            if (component.getChildren().count() <= 0L || !this.findFieldAndFocus(component)) continue;
            return true;
        }
        return false;
    }

    private boolean isReadOnly(Component component) {
        if (component instanceof HasValue) {
            return ((HasValue)component).isReadOnly();
        }
        return false;
    }

    public Dialog getPopup() {
        return this.popup;
    }

    public void closePopup() {
        if (this.getPopup() != null) {
            this.getPopup().close();
        }
    }

    public static interface ResetHandler<T>
    extends Serializable {
        public void onReset(T var1);
    }

    public static interface SavedHandler<T>
    extends Serializable {
        public void onSave(T var1);
    }

    public static interface DeleteHandler<T>
    extends Serializable {
        public void onDelete(T var1);
    }
}

