/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.rad;

import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H1;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.vaadin.firitin.fields.internalhtmltable.Table;
import org.vaadin.firitin.fields.internalhtmltable.TableHeaderCell;
import org.vaadin.firitin.fields.internalhtmltable.TableRow;
import org.vaadin.firitin.rad.PrettyPrinter;
import org.vaadin.firitin.rad.PropertyContext;
import org.vaadin.firitin.rad.PropertyHeaderPrinter;
import org.vaadin.firitin.rad.PropertyPrinter;
import org.vaadin.firitin.rad.ValueContext;
import org.vaadin.firitin.rad.ValueContextImpl;
import org.vaadin.firitin.util.VStyleUtil;

public class DtoDisplay
extends Composite<Div> {
    public static final int SHORT_STRING_THRESHOLD = 50;
    private final ValueContext context;
    private List<PropertyPrinter> propertyPrinters;
    private List<PropertyHeaderPrinter> headerPrinters = new ArrayList<PropertyHeaderPrinter>();

    public DtoDisplay(Object dto) {
        this(new ArrayList<PropertyPrinter>(DtoDisplay.getDefaultPropertyPrinters()), new ValueContextImpl(PrettyPrinter.getDefault(), dto));
    }

    public DtoDisplay(List<PropertyPrinter> propertyPrinters, ValueContext context) {
        this.propertyPrinters = propertyPrinters;
        this.context = context;
    }

    public static List<PropertyPrinter> getDefaultPropertyPrinters() {
        return Collections.unmodifiableList(PrettyPrinter._defaultPropertyPrinters);
    }

    private static boolean isLongString(Object object) {
        return object != null && object.toString().length() > 50;
    }

    static String toShortString(Object object) {
        String toString = object == null ? "" : object.toString();
        return DtoDisplay.toShortString(toString);
    }

    static String toShortString(String toString) {
        if (toString == null) {
            return "";
        }
        if (((String)toString).length() > 50) {
            toString = ((String)toString).substring(0, 50) + "...";
        }
        return toString;
    }

    static String deCamelCased(String propertyName) {
        String deCamelCased = propertyName.replaceAll("([a-z])([A-Z]+)", "$1 $2");
        deCamelCased = StringUtils.capitalize((String)deCamelCased);
        return deCamelCased;
    }

    private void buildTable() {
        this.injectStyles();
        Table table = new Table();
        this.context.beanDescription().findProperties().forEach(p -> {
            TableRow tableRow = table.addRow();
            PropertyContext propertyContext = this.context.getPropertyContext((BeanPropertyDefinition)p);
            Object value = null;
            for (PropertyPrinter propertyPrinter : this.propertyPrinters) {
                value = propertyPrinter.printValue(propertyContext);
                if (value == null) continue;
                Object propertyHeader = propertyPrinter.getPropertyHeader(propertyContext);
                if (propertyHeader == null) {
                    propertyHeader = this.headerPrinters.stream().map(headerPrinter -> headerPrinter.printHeader(propertyContext)).filter(h -> h != null).findFirst().orElse(PropertyHeaderPrinter.defaultHeader(propertyContext));
                }
                TableHeaderCell tableHeaderCell = tableRow.addHeaderCell();
                if (propertyHeader instanceof Component) {
                    Component c = (Component)propertyHeader;
                    tableHeaderCell.add(new Component[]{c});
                    break;
                }
                tableHeaderCell.setText(propertyHeader.toString());
                break;
            }
            if (value != null) {
                if (value instanceof Component) {
                    Component c = (Component)value;
                    tableRow.addCells(c);
                } else {
                    tableRow.addCells(value.toString());
                }
            } else {
                TableHeaderCell tableHeaderCell = tableRow.addHeaderCell();
                tableHeaderCell.setText(p.getName());
                Object value1 = p.getGetter().getValue(this.context.value());
                tableRow.addCells((value1 == null ? "null" : value1.toString()) + " (no printer found)");
            }
        });
        ((Div)this.getContent()).add(new Component[]{table});
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        ((Div)this.getContent()).removeAll();
        this.buildTable();
    }

    private void injectStyles() {
        ((Div)this.getContent()).setClassName("dto-display");
        VStyleUtil.injectAsFirst("    .dto-display table {\n        border-collapse: collapse;\n    }\n    .dto-display td, .dto-display th {\n        padding: var(--lumo-space-xs);\n    }\n    .dto-display tr:first-child td, .dto-display tr:first-child th {\n        padding-top: 0;\n    }\n    .dto-display td>div>p:first-child,\n    .dto-display td>p:first-child {\n        margin: 0;\n    }\n    .dto-display th {\n        text-align: left;\n        color: var(--lumo-secondary-text-color);\n        font-weight: 500;\n    }\n    .dto-display th,\n    .dto-display td {\n        vertical-align: top;\n    }\n    .dto-display>table>tr>th {\n        text-align: right;\n        white-space: nowrap;\n        align-items: start;\n        padding-right: var(--lumo-space-s);\n    }\n    .dto-display td>vaadin-details>vaadin-details-summary {\n        padding: 0;\n    }\n\n");
    }

    public DtoDisplay withDefaultHeader() {
        ((Div)this.getContent()).addComponentAsFirst((Component)new H1(DtoDisplay.deCamelCased(this.context.value().getClass().getSimpleName()) + ":"));
        return this;
    }

    public DtoDisplay withPropertyPrinter(PropertyPrinter printer) {
        this.propertyPrinters.add(0, printer);
        return this;
    }

    public DtoDisplay withPropertyHeaderPrinter(PropertyHeaderPrinter printer) {
        this.headerPrinters.add(0, printer);
        return this;
    }
}

