/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.rad;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.vaadin.firitin.components.details.VDetails;
import org.vaadin.firitin.components.html.VCode;
import org.vaadin.firitin.fields.internalhtmltable.Table;
import org.vaadin.firitin.fields.internalhtmltable.TableRow;
import org.vaadin.firitin.rad.DtoDisplay;
import org.vaadin.firitin.rad.PropertyContext;
import org.vaadin.firitin.rad.PropertyHeaderPrinter;
import org.vaadin.firitin.rad.PropertyPrinter;
import org.vaadin.firitin.rad.ValueContext;
import org.vaadin.firitin.rad.ValueContextImpl;

public class PrettyPrinter {
    static final ObjectMapper jack = new ObjectMapper();
    static List<PropertyPrinter> _defaultPropertyPrinters = new ArrayList<PropertyPrinter>();
    private static final PrettyPrinter INSTANCE = new PrettyPrinter(PrettyPrinter.getDefaultPropertyPrinters());
    private final List<PropertyPrinter> propertyPrinters;
    private final List<PropertyHeaderPrinter> propertyHeaderPrinters;
    private Locale locale;

    public PrettyPrinter() {
        this(new ArrayList<PropertyPrinter>(PrettyPrinter.getDefaultPropertyPrinters()));
    }

    public PrettyPrinter(List<PropertyPrinter> propertyPrinters) {
        this.propertyPrinters = propertyPrinters;
        this.propertyHeaderPrinters = new ArrayList<PropertyHeaderPrinter>();
    }

    public static List<PropertyPrinter> getDefaultPropertyPrinters() {
        return Collections.unmodifiableList(_defaultPropertyPrinters);
    }

    static PrettyPrinter getDefault() {
        return INSTANCE;
    }

    public static Component toVaadin(Object value) {
        return INSTANCE.printToVaadin(value);
    }

    static BasicBeanDescription inrospect(Object dto) {
        if (dto == null) {
            return null;
        }
        JavaType javaType = jack.getTypeFactory().constructType(dto.getClass());
        return (BasicBeanDescription)jack.getSerializationConfig().introspect(javaType);
    }

    public List<PropertyPrinter> getPropertyPrinters() {
        return this.propertyPrinters;
    }

    public Component printToVaadin(Object value) {
        ValueContextImpl valueContext = new ValueContextImpl(this, value);
        return this.printToVaadin(valueContext);
    }

    Component printToVaadin(ValueContext ctx) {
        DtoDisplay dtoDisplay = new DtoDisplay(this.propertyPrinters, ctx);
        this.propertyHeaderPrinters.forEach(dtoDisplay::withPropertyHeaderPrinter);
        return dtoDisplay;
    }

    public PrettyPrinter withPropertyPrinter(PropertyPrinter printer) {
        this.propertyPrinters.add(0, printer);
        return this;
    }

    public PrettyPrinter withPropertyHeaderPrinter(PropertyHeaderPrinter printer) {
        this.propertyHeaderPrinters.add(0, printer);
        return this;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            UI ui = UI.getCurrent();
            this.locale = ui != null ? ui.getLocale() : Locale.getDefault();
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    static {
        _defaultPropertyPrinters.add(new PrimitivePrinter());
        _defaultPropertyPrinters.add(new EnumPrinter());
        _defaultPropertyPrinters.add(new RecordTypePrinter());
        _defaultPropertyPrinters.add(new CollectionPropertyPrinter());
        _defaultPropertyPrinters.add(new ObjectPrinter());
    }

    private static class PrimitivePrinter
    implements PropertyPrinter {
        private PrimitivePrinter() {
        }

        public Component printValue(PropertyContext ctx) {
            if (ctx.beanPropertyDefinition().getPrimaryType().isPrimitive() || String.class == ctx.beanPropertyDefinition().getPrimaryType().getRawClass() || ClassUtils.isPrimitiveOrWrapper((Class)ctx.beanPropertyDefinition().getRawPrimaryType())) {
                Object propertyValue = ctx.getPropertyValue();
                if (propertyValue instanceof Number) {
                    Number number = (Number)propertyValue;
                    Locale locale = ctx.getLocale();
                    propertyValue = NumberFormat.getInstance(locale).format(propertyValue);
                }
                return new Span(String.valueOf(propertyValue));
            }
            return null;
        }
    }

    private static class EnumPrinter
    implements PropertyPrinter {
        private EnumPrinter() {
        }

        public Component printValue(PropertyContext ctx) {
            if (ctx.beanPropertyDefinition().getPrimaryType().isEnumType() || ctx.beanPropertyDefinition().getPrimaryType().isEnumImplType()) {
                return new VCode(String.valueOf(ctx.getPropertyValue()));
            }
            return null;
        }
    }

    private static class RecordTypePrinter
    implements PropertyPrinter {
        private RecordTypePrinter() {
        }

        public Component printValue(PropertyContext ctx) {
            if (ctx.beanPropertyDefinition().getPrimaryType().isRecordType()) {
                ValueContext propertyContext = ctx.asValueContext();
                String header = propertyContext.toShortString();
                return new VDetails(header, (SerializableSupplier<Component>)(SerializableSupplier & Serializable)() -> propertyContext.getPrettyPrinter().printToVaadin(propertyContext));
            }
            return null;
        }
    }

    private static class CollectionPropertyPrinter
    implements PropertyPrinter {
        private CollectionPropertyPrinter() {
        }

        public Component printValue(PropertyContext ctx) {
            JavaType primaryType = ctx.beanPropertyDefinition().getPrimaryType();
            if (primaryType instanceof CollectionLikeType || primaryType instanceof ArrayType) {
                JavaType contentType = primaryType.getContentType();
                BasicBeanDescription contentTypeBbd = (BasicBeanDescription)jack.getSerializationConfig().introspect(contentType);
                List properties = contentTypeBbd.findProperties();
                Object collection = ctx.getPropertyValue();
                Class<?> collectionClass = collection.getClass();
                if (properties.isEmpty()) {
                    String str;
                    if (collectionClass.isArray()) {
                        Object[] array = (Object[])collection;
                        str = Arrays.stream(array).map(Object::toString).collect(Collectors.joining(", "));
                    } else if (collection instanceof Iterable) {
                        Iterable iterable = (Iterable)collection;
                        StringBuilder sb = new StringBuilder();
                        Iterator iterator = iterable.iterator();
                        while (iterator.hasNext()) {
                            sb.append(iterator.next().toString());
                            if (!iterator.hasNext()) continue;
                            sb.append(", ");
                        }
                        str = sb.toString();
                    } else {
                        str = collection.toString();
                    }
                    return new Paragraph(str);
                }
                Table subTable = new Table();
                TableRow header = subTable.addRow();
                contentTypeBbd.findProperties().forEach(subP -> header.addHeaderCell().setText(DtoDisplay.deCamelCased(subP.getName())));
                if (collectionClass.isArray()) {
                    Object[] array;
                    for (Object e2 : array = (Object[])collection) {
                        TableRow subTableRow = subTable.addRow();
                        properties.forEach(subP -> {
                            Object value = subP.getGetter().getValue(e2);
                            subTableRow.addCells(value.toString());
                        });
                    }
                } else if (collection instanceof Iterable) {
                    Iterable iterable = (Iterable)collection;
                    iterable.forEach(e -> {
                        TableRow subTableRow = subTable.addRow();
                        contentTypeBbd.findProperties().forEach(subP -> {
                            Object value = subP.getGetter().getValue(e);
                            subTableRow.addCells(value.toString());
                        });
                    });
                }
                return subTable;
            }
            return null;
        }
    }

    private static class ObjectPrinter
    implements PropertyPrinter {
        private ObjectPrinter() {
        }

        public Component printValue(PropertyContext ctx) {
            ValueContext propCtx = ctx.asValueContext();
            String header = propCtx.toShortString();
            return new VDetails(header, (SerializableSupplier<Component>)(SerializableSupplier & Serializable)() -> propCtx.getPrettyPrinter().printToVaadin(propCtx));
        }
    }
}

