/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.rad;

import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.util.Locale;
import org.vaadin.firitin.rad.DtoDisplay;
import org.vaadin.firitin.rad.PrettyPrinter;
import org.vaadin.firitin.rad.ValueContext;
import org.vaadin.firitin.rad.ValueContextImpl;

public interface PropertyContext {
    public ValueContext owner();

    public BeanPropertyDefinition beanPropertyDefinition();

    default public Object getPropertyValue() {
        Object value;
        Object ownerValue = this.owner().value();
        if (this.beanPropertyDefinition().hasGetter()) {
            AnnotatedMethod getter = this.beanPropertyDefinition().getGetter();
            value = getter.getValue(ownerValue);
        } else {
            value = this.beanPropertyDefinition().getAccessor().getValue(ownerValue);
        }
        return value;
    }

    default public String getName() {
        return this.beanPropertyDefinition().getName();
    }

    default public String shortToString() {
        return DtoDisplay.toShortString(this.getPropertyValue());
    }

    default public Locale getLocale() {
        return this.owner().getLocale();
    }

    default public ValueContext asValueContext() {
        return new ValueContextImpl(this.getPrettyPrinter(), this.getPropertyValue());
    }

    default public int getLevel() {
        return this.owner().getLevel() + 1;
    }

    default public PrettyPrinter getPrettyPrinter() {
        return this.owner().getPrettyPrinter();
    }
}

