/*
 * Decompiled with CFR 0.152.
 */
package in.yajnesh.util.java;

import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JUtil {
    public static final String EMPTY_STRING = "";

    public static <T> T get(T[] array, int index) {
        return JUtil.get(array, index, null);
    }

    public static <T> T get(T[] array, int index, T defaultValue) {
        if (array == null) {
            return defaultValue;
        }
        if (index < 0 || index >= JUtil.size(array)) {
            return defaultValue;
        }
        return array[index];
    }

    public static <T> T get(List<T> list, int index) {
        return JUtil.get(list, index, null);
    }

    public static <T> T get(List<T> list, int index, T defaultValue) {
        if (list == null) {
            return defaultValue;
        }
        if (index < 0 || index >= JUtil.size(list)) {
            return defaultValue;
        }
        return list.get(index);
    }

    public static Character get(String s, int index) {
        return JUtil.get(s, index, null);
    }

    public static Character get(String s, int index, Character defaultValue) {
        if (JUtil.isEmpty(s)) {
            return defaultValue;
        }
        if (index < 0 || index >= JUtil.size(s)) {
            return defaultValue;
        }
        return Character.valueOf(s.charAt(index));
    }

    public static Character get(CharSequence cs, int index) {
        return JUtil.get(cs, index, null);
    }

    public static Character get(CharSequence cs, int index, Character defaultValue) {
        if (JUtil.isEmpty(cs)) {
            return defaultValue;
        }
        if (index < 0 || index >= JUtil.size(cs)) {
            return defaultValue;
        }
        return Character.valueOf(cs.charAt(index));
    }

    public static <T> T getLastItem(T[] array) {
        return JUtil.getLastItem(array, null);
    }

    public static <T> T getLastItem(T[] array, T defaultValue) {
        return JUtil.get(array, JUtil.size(array) - 1, defaultValue);
    }

    public static <T> T getLastItem(List<T> list) {
        return JUtil.getLastItem(list, null);
    }

    public static <T> T getLastItem(List<T> list, T defaultValue) {
        return JUtil.get(list, JUtil.size(list) - 1, defaultValue);
    }

    public static Character getLastItem(String s) {
        return JUtil.getLastItem(s, null);
    }

    public static Character getLastItem(String s, Character defaultValue) {
        return JUtil.get(s, JUtil.size(s) - 1, defaultValue);
    }

    public static Character getLastItem(CharSequence cs) {
        return JUtil.getLastItem(cs, null);
    }

    public static Character getLastItem(CharSequence cs, Character defaultValue) {
        return JUtil.get(cs, JUtil.size(cs) - 1, defaultValue);
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length < 1;
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isEmpty(CharSequence cs) {
        return JUtil.isEmpty(cs.toString());
    }

    public static <K, V> boolean isEmpty(Map<K, V> m) {
        return m == null || m.isEmpty();
    }

    public static <T> int size(Collection<T> collection) {
        return collection == null ? 0 : collection.size();
    }

    public static <T> int size(T[] array) {
        return array == null ? 0 : array.length;
    }

    public static int size(String s) {
        return s == null ? 0 : JUtil.getString(s).length();
    }

    public static int size(CharSequence cs) {
        return cs == null ? 0 : JUtil.getString(cs).length();
    }

    public static boolean equals(Object a, Object b) {
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean equalsRelaxed(Object a, Object b) {
        String as = JUtil.getString(a);
        if (as == null) {
            return false;
        }
        return as.equalsIgnoreCase(JUtil.getString(b));
    }

    public static boolean contains(String source, String searchTerm) {
        if (JUtil.isAnyEmpty(source, searchTerm)) {
            return false;
        }
        return source.contains(searchTerm);
    }

    public static boolean containsIgnoreCase(String source, String searchTerm) {
        if (JUtil.isAnyEmpty(source, searchTerm)) {
            return false;
        }
        int length = JUtil.size(searchTerm);
        char firstLo = Character.toLowerCase(JUtil.get(searchTerm, 0).charValue());
        char firstUp = Character.toUpperCase(JUtil.get(searchTerm, 0).charValue());
        for (int i = JUtil.size(source) - length; i >= 0; --i) {
            char ch = JUtil.get(source, i).charValue();
            if (ch != firstLo && ch != firstUp || !source.regionMatches(true, i, searchTerm, 0, length)) continue;
            return true;
        }
        return false;
    }

    public static <T> T typeCast(Object o, Class<T> clazz) {
        if (clazz != null && o != null && clazz.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        return null;
    }

    public static String stringify(String message, Collection collection) {
        StringBuilder sb = new StringBuilder();
        try {
            if (!JUtil.isEmpty(message)) {
                sb.append(message).append(":\n");
            }
            if (collection != null) {
                for (Object o : collection) {
                    sb.append("e= ").append(o);
                }
            }
            return sb.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String stringify(Collection collection) {
        return JUtil.stringify(null, collection);
    }

    public static String stringify(String message, Map map) {
        StringBuilder sb = new StringBuilder();
        try {
            if (!JUtil.isEmpty(message)) {
                sb.append(message).append(":\n");
            }
            if (map != null) {
                for (Object o : map.keySet()) {
                    sb.append("key = ").append(o).append(" , value = ").append(map.get(o));
                }
            }
            return sb.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String stringify(Map map) {
        return JUtil.stringify(null, map);
    }

    public static boolean isAnyEmpty(Object ... objects) {
        if (objects == null || JUtil.size(objects) == 0) {
            return true;
        }
        for (Object o : objects) {
            if (o == null) {
                return true;
            }
            if (!(o instanceof Collection ? JUtil.isEmpty((Collection)o) : (o instanceof Map ? JUtil.isEmpty((Map)o) : (o instanceof String ? JUtil.isEmpty((String)o) : o instanceof CharSequence && JUtil.isEmpty((CharSequence)o))))) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(Object ... objects) {
        if (objects == null || JUtil.size(objects) == 0) {
            return true;
        }
        for (Object o : objects) {
            if (o == null) continue;
            if (o instanceof Collection) {
                if (JUtil.isEmpty((Collection)o)) continue;
                return false;
            }
            if (o instanceof Map) {
                if (JUtil.isEmpty((Map)o)) continue;
                return false;
            }
            if (o instanceof String) {
                if (JUtil.isEmpty((String)o)) continue;
                return false;
            }
            if (o instanceof CharSequence) {
                if (JUtil.isEmpty((CharSequence)o)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static String getString(Object o) {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    public static String getStringSafe(Object o) {
        String s = JUtil.getString(o);
        return s == null ? EMPTY_STRING : s;
    }

    public static Map<String, String> emptyMapMutable() {
        return new HashMap<String, String>();
    }

    public static Set<String> emptySetMutable() {
        return new HashSet<String>();
    }

    public static String safeUrlEncode(String s, String enc) {
        try {
            return URLEncoder.encode(s, enc);
        }
        catch (Throwable t) {
            try {
                return URLEncoder.encode(s);
            }
            catch (Throwable tFailSafe) {
                return s;
            }
        }
    }
}

