/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.aggregator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Preconditions;
import in.zapr.druid.druidry.aggregator.DruidAggregator;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DoubleSumAggregator
extends DruidAggregator {
    private static final String DOUBLE_SUM_TYPE_AGGREGATOR = "doubleSum";
    private String fieldName;
    private String expression;

    @Deprecated
    public DoubleSumAggregator(@NonNull String name, @NonNull String fieldName) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        this.type = DOUBLE_SUM_TYPE_AGGREGATOR;
        this.name = name;
        this.fieldName = fieldName;
    }

    private DoubleSumAggregator(@NonNull String name, String fieldName, String expression) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.type = DOUBLE_SUM_TYPE_AGGREGATOR;
        this.name = name;
        this.fieldName = fieldName;
        this.expression = expression;
        Preconditions.checkArgument((boolean)(fieldName == null ^ expression == null), (Object)"Must have a valid, non-null fieldName or expression");
    }

    public static DoubleSumAggregatorBuilder builder() {
        return new DoubleSumAggregatorBuilder();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getExpression() {
        return this.expression;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleSumAggregator)) {
            return false;
        }
        DoubleSumAggregator other = (DoubleSumAggregator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DoubleSumAggregator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        return result;
    }

    public static class DoubleSumAggregatorBuilder {
        private String name;
        private String fieldName;
        private String expression;

        DoubleSumAggregatorBuilder() {
        }

        public DoubleSumAggregatorBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public DoubleSumAggregatorBuilder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public DoubleSumAggregatorBuilder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public DoubleSumAggregator build() {
            return new DoubleSumAggregator(this.name, this.fieldName, this.expression);
        }

        public String toString() {
            return "DoubleSumAggregator.DoubleSumAggregatorBuilder(name=" + this.name + ", fieldName=" + this.fieldName + ", expression=" + this.expression + ")";
        }
    }
}

