/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.dataSource;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.dataSource.DataSource;
import in.zapr.druid.druidry.dataSource.DataSourceType;
import in.zapr.druid.druidry.query.DruidQuery;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class QueryDataSource
extends DataSource {
    @NonNull
    private DruidQuery query;

    public QueryDataSource(@NonNull DruidQuery query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        this.type = DataSourceType.QUERY;
        this.query = query;
    }

    public static QueryDataSourceBuilder builder() {
        return new QueryDataSourceBuilder();
    }

    @NonNull
    public DruidQuery getQuery() {
        return this.query;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryDataSource)) {
            return false;
        }
        QueryDataSource other = (QueryDataSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DruidQuery this$query = this.getQuery();
        DruidQuery other$query = other.getQuery();
        return !(this$query == null ? other$query != null : !((Object)this$query).equals(other$query));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof QueryDataSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DruidQuery $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : ((Object)$query).hashCode());
        return result;
    }

    public static class QueryDataSourceBuilder {
        private DruidQuery query;

        QueryDataSourceBuilder() {
        }

        public QueryDataSourceBuilder query(@NonNull DruidQuery query) {
            if (query == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            this.query = query;
            return this;
        }

        public QueryDataSource build() {
            return new QueryDataSource(this.query);
        }

        public String toString() {
            return "QueryDataSource.QueryDataSourceBuilder(query=" + this.query + ")";
        }
    }
}

