/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.dataSource;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.dataSource.DataSource;
import in.zapr.druid.druidry.dataSource.DataSourceType;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TableDataSource
extends DataSource {
    @NonNull
    private String name;

    public TableDataSource(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.type = DataSourceType.TABLE;
        this.name = name;
    }

    public static TableDataSourceBuilder builder() {
        return new TableDataSourceBuilder();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableDataSource)) {
            return false;
        }
        TableDataSource other = (TableDataSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TableDataSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public static class TableDataSourceBuilder {
        private String name;

        TableDataSourceBuilder() {
        }

        public TableDataSourceBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public TableDataSource build() {
            return new TableDataSource(this.name);
        }

        public String toString() {
            return "TableDataSource.TableDataSourceBuilder(name=" + this.name + ")";
        }
    }
}

