/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.dimension;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import in.zapr.druid.druidry.dimension.DimensionSpec;
import in.zapr.druid.druidry.dimension.enums.OutputType;
import in.zapr.druid.druidry.extractionFunctions.ExtractionFunction;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ExtractionDimension
extends DimensionSpec {
    private static final String EXTRACTION_TYPE = "extraction";
    @JsonProperty(value="extractionFn")
    private ExtractionFunction extractionFunction;

    public ExtractionDimension(@NonNull String dimension, @NonNull String outputName, OutputType outputType, @NonNull ExtractionFunction extractionFunction) {
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        if (outputName == null) {
            throw new NullPointerException("outputName is marked non-null but is null");
        }
        if (extractionFunction == null) {
            throw new NullPointerException("extractionFunction is marked non-null but is null");
        }
        this.type = EXTRACTION_TYPE;
        this.dimension = dimension;
        this.outputName = outputName;
        this.outputType = outputType;
        this.extractionFunction = extractionFunction;
    }

    public static ExtractionDimensionBuilder builder() {
        return new ExtractionDimensionBuilder();
    }

    public ExtractionFunction getExtractionFunction() {
        return this.extractionFunction;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtractionDimension)) {
            return false;
        }
        ExtractionDimension other = (ExtractionDimension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExtractionFunction this$extractionFunction = this.getExtractionFunction();
        ExtractionFunction other$extractionFunction = other.getExtractionFunction();
        return !(this$extractionFunction == null ? other$extractionFunction != null : !((Object)this$extractionFunction).equals(other$extractionFunction));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExtractionDimension;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ExtractionFunction $extractionFunction = this.getExtractionFunction();
        result = result * 59 + ($extractionFunction == null ? 43 : ((Object)$extractionFunction).hashCode());
        return result;
    }

    public static class ExtractionDimensionBuilder {
        private String dimension;
        private String outputName;
        private OutputType outputType;
        private ExtractionFunction extractionFunction;

        ExtractionDimensionBuilder() {
        }

        public ExtractionDimensionBuilder dimension(@NonNull String dimension) {
            if (dimension == null) {
                throw new NullPointerException("dimension is marked non-null but is null");
            }
            this.dimension = dimension;
            return this;
        }

        public ExtractionDimensionBuilder outputName(@NonNull String outputName) {
            if (outputName == null) {
                throw new NullPointerException("outputName is marked non-null but is null");
            }
            this.outputName = outputName;
            return this;
        }

        public ExtractionDimensionBuilder outputType(OutputType outputType) {
            this.outputType = outputType;
            return this;
        }

        public ExtractionDimensionBuilder extractionFunction(@NonNull ExtractionFunction extractionFunction) {
            if (extractionFunction == null) {
                throw new NullPointerException("extractionFunction is marked non-null but is null");
            }
            this.extractionFunction = extractionFunction;
            return this;
        }

        public ExtractionDimension build() {
            return new ExtractionDimension(this.dimension, this.outputName, this.outputType, this.extractionFunction);
        }

        public String toString() {
            return "ExtractionDimension.ExtractionDimensionBuilder(dimension=" + this.dimension + ", outputName=" + this.outputName + ", outputType=" + (Object)((Object)this.outputType) + ", extractionFunction=" + this.extractionFunction + ")";
        }
    }
}

