/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.dimension;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import in.zapr.druid.druidry.dimension.DimensionSpec;
import in.zapr.druid.druidry.dimension.FilteredDimension;
import in.zapr.druid.druidry.dimension.enums.FilteredDimensionType;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ListFilteredDimension
extends FilteredDimension {
    private List<String> values;
    @JsonProperty(value="isWhitelist")
    private Boolean whitelist;

    public ListFilteredDimension(@NonNull DimensionSpec dimensionSpec, @NonNull List<String> values, Boolean whitelist) {
        if (dimensionSpec == null) {
            throw new NullPointerException("dimensionSpec is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        this.delegate = dimensionSpec;
        this.type = FilteredDimensionType.LIST_FILTERED;
        this.values = values;
        this.whitelist = whitelist;
    }

    public static ListFilteredDimensionBuilder builder() {
        return new ListFilteredDimensionBuilder();
    }

    public List<String> getValues() {
        return this.values;
    }

    public Boolean getWhitelist() {
        return this.whitelist;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListFilteredDimension)) {
            return false;
        }
        ListFilteredDimension other = (ListFilteredDimension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$values = this.getValues();
        List<String> other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        Boolean this$whitelist = this.getWhitelist();
        Boolean other$whitelist = other.getWhitelist();
        return !(this$whitelist == null ? other$whitelist != null : !((Object)this$whitelist).equals(other$whitelist));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListFilteredDimension;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        Boolean $whitelist = this.getWhitelist();
        result = result * 59 + ($whitelist == null ? 43 : ((Object)$whitelist).hashCode());
        return result;
    }

    public static class ListFilteredDimensionBuilder {
        private DimensionSpec dimensionSpec;
        private List<String> values;
        private Boolean whitelist;

        ListFilteredDimensionBuilder() {
        }

        public ListFilteredDimensionBuilder dimensionSpec(@NonNull DimensionSpec dimensionSpec) {
            if (dimensionSpec == null) {
                throw new NullPointerException("dimensionSpec is marked non-null but is null");
            }
            this.dimensionSpec = dimensionSpec;
            return this;
        }

        public ListFilteredDimensionBuilder values(@NonNull List<String> values) {
            if (values == null) {
                throw new NullPointerException("values is marked non-null but is null");
            }
            this.values = values;
            return this;
        }

        public ListFilteredDimensionBuilder whitelist(Boolean whitelist) {
            this.whitelist = whitelist;
            return this;
        }

        public ListFilteredDimension build() {
            return new ListFilteredDimension(this.dimensionSpec, this.values, this.whitelist);
        }

        public String toString() {
            return "ListFilteredDimension.ListFilteredDimensionBuilder(dimensionSpec=" + this.dimensionSpec + ", values=" + this.values + ", whitelist=" + this.whitelist + ")";
        }
    }
}

