/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.extensions.datasketches.aggregator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import in.zapr.druid.druidry.aggregator.DruidAggregator;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class QuantilesSketchAggregator
extends DruidAggregator {
    private static final String QUANTILES_SKETCH_TYPE_AGGREGATOR = "quantilesDoublesSketch";
    private String fieldName;
    private Integer k;

    private QuantilesSketchAggregator(@NonNull String name, @NonNull String fieldName, Integer k) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        this.type = QUANTILES_SKETCH_TYPE_AGGREGATOR;
        this.name = name;
        this.fieldName = fieldName;
        this.k = k;
        if (k != null) {
            Preconditions.checkArgument((boolean)LongMath.isPowerOfTwo((long)k.intValue()), (Object)"k must be a power of 2");
        }
    }

    public static QuantilesSketchAggregatorBuilder builder() {
        return new QuantilesSketchAggregatorBuilder();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Integer getK() {
        return this.k;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuantilesSketchAggregator)) {
            return false;
        }
        QuantilesSketchAggregator other = (QuantilesSketchAggregator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        Integer this$k = this.getK();
        Integer other$k = other.getK();
        return !(this$k == null ? other$k != null : !((Object)this$k).equals(other$k));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof QuantilesSketchAggregator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        Integer $k = this.getK();
        result = result * 59 + ($k == null ? 43 : ((Object)$k).hashCode());
        return result;
    }

    public static class QuantilesSketchAggregatorBuilder {
        private String name;
        private String fieldName;
        private Integer k;

        QuantilesSketchAggregatorBuilder() {
        }

        public QuantilesSketchAggregatorBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public QuantilesSketchAggregatorBuilder fieldName(@NonNull String fieldName) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName is marked non-null but is null");
            }
            this.fieldName = fieldName;
            return this;
        }

        public QuantilesSketchAggregatorBuilder k(Integer k) {
            this.k = k;
            return this;
        }

        public QuantilesSketchAggregator build() {
            return new QuantilesSketchAggregator(this.name, this.fieldName, this.k);
        }

        public String toString() {
            return "QuantilesSketchAggregator.QuantilesSketchAggregatorBuilder(name=" + this.name + ", fieldName=" + this.fieldName + ", k=" + this.k + ")";
        }
    }
}

