/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.extensions.datasketches.aggregator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import in.zapr.druid.druidry.aggregator.DruidAggregator;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TupleSketchAggregator
extends DruidAggregator {
    private static final String TUPLE_SKETCH_TYPE_AGGREGATOR = "arrayOfDoublesSketch";
    private String fieldName;
    private Integer nominalEntries;
    private Integer numberOfValues;
    private List<String> metricColumns;

    private TupleSketchAggregator(@NonNull String name, @NonNull String fieldName, Integer nominalEntries, Integer numberOfValues, List<String> metricColumns) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        this.type = TUPLE_SKETCH_TYPE_AGGREGATOR;
        this.name = name;
        this.fieldName = fieldName;
        this.nominalEntries = nominalEntries;
        this.numberOfValues = numberOfValues;
        this.metricColumns = metricColumns;
        if (nominalEntries != null) {
            Preconditions.checkArgument((boolean)LongMath.isPowerOfTwo((long)nominalEntries.intValue()), (Object)"nominalEntries must be a power of 2");
        }
    }

    public static TupleSketchAggregatorBuilder builder() {
        return new TupleSketchAggregatorBuilder();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Integer getNominalEntries() {
        return this.nominalEntries;
    }

    public Integer getNumberOfValues() {
        return this.numberOfValues;
    }

    public List<String> getMetricColumns() {
        return this.metricColumns;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TupleSketchAggregator)) {
            return false;
        }
        TupleSketchAggregator other = (TupleSketchAggregator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        Integer this$nominalEntries = this.getNominalEntries();
        Integer other$nominalEntries = other.getNominalEntries();
        if (this$nominalEntries == null ? other$nominalEntries != null : !((Object)this$nominalEntries).equals(other$nominalEntries)) {
            return false;
        }
        Integer this$numberOfValues = this.getNumberOfValues();
        Integer other$numberOfValues = other.getNumberOfValues();
        if (this$numberOfValues == null ? other$numberOfValues != null : !((Object)this$numberOfValues).equals(other$numberOfValues)) {
            return false;
        }
        List<String> this$metricColumns = this.getMetricColumns();
        List<String> other$metricColumns = other.getMetricColumns();
        return !(this$metricColumns == null ? other$metricColumns != null : !((Object)this$metricColumns).equals(other$metricColumns));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TupleSketchAggregator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        Integer $nominalEntries = this.getNominalEntries();
        result = result * 59 + ($nominalEntries == null ? 43 : ((Object)$nominalEntries).hashCode());
        Integer $numberOfValues = this.getNumberOfValues();
        result = result * 59 + ($numberOfValues == null ? 43 : ((Object)$numberOfValues).hashCode());
        List<String> $metricColumns = this.getMetricColumns();
        result = result * 59 + ($metricColumns == null ? 43 : ((Object)$metricColumns).hashCode());
        return result;
    }

    public static class TupleSketchAggregatorBuilder {
        private String name;
        private String fieldName;
        private Integer nominalEntries;
        private Integer numberOfValues;
        private List<String> metricColumns;

        TupleSketchAggregatorBuilder() {
        }

        public TupleSketchAggregatorBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public TupleSketchAggregatorBuilder fieldName(@NonNull String fieldName) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName is marked non-null but is null");
            }
            this.fieldName = fieldName;
            return this;
        }

        public TupleSketchAggregatorBuilder nominalEntries(Integer nominalEntries) {
            this.nominalEntries = nominalEntries;
            return this;
        }

        public TupleSketchAggregatorBuilder numberOfValues(Integer numberOfValues) {
            this.numberOfValues = numberOfValues;
            return this;
        }

        public TupleSketchAggregatorBuilder metricColumns(List<String> metricColumns) {
            this.metricColumns = metricColumns;
            return this;
        }

        public TupleSketchAggregator build() {
            return new TupleSketchAggregator(this.name, this.fieldName, this.nominalEntries, this.numberOfValues, this.metricColumns);
        }

        public String toString() {
            return "TupleSketchAggregator.TupleSketchAggregatorBuilder(name=" + this.name + ", fieldName=" + this.fieldName + ", nominalEntries=" + this.nominalEntries + ", numberOfValues=" + this.numberOfValues + ", metricColumns=" + this.metricColumns + ")";
        }
    }
}

