/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.extensions.datasketches.postAggregator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import in.zapr.druid.druidry.extensions.datasketches.postAggregator.TupleSketchOperation;
import in.zapr.druid.druidry.postAggregator.DruidPostAggregator;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TupleSketchSetOpPostAggregator
extends DruidPostAggregator {
    private static final String TUPLE_SKETCH_SET_OP_POST_AGGREGATOR_TYPE = "arrayOfDoublesSketchSetOp";
    private TupleSketchOperation operation;
    private List<DruidPostAggregator> fields;
    private Integer nominalEntries;
    private Integer numberOfValues;

    private TupleSketchSetOpPostAggregator(@NonNull String name, @NonNull TupleSketchOperation operation, @NonNull List<DruidPostAggregator> fields, Integer nominalEntries, Integer numberOfValues) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        this.type = TUPLE_SKETCH_SET_OP_POST_AGGREGATOR_TYPE;
        this.name = name;
        this.operation = operation;
        this.fields = fields;
        this.nominalEntries = nominalEntries;
        this.numberOfValues = numberOfValues;
        if (nominalEntries != null) {
            Preconditions.checkArgument((boolean)LongMath.isPowerOfTwo((long)nominalEntries.intValue()), (Object)"nominalEntries must be a power of 2");
        }
    }

    public static TupleSketchSetOpPostAggregatorBuilder builder() {
        return new TupleSketchSetOpPostAggregatorBuilder();
    }

    public TupleSketchOperation getOperation() {
        return this.operation;
    }

    public List<DruidPostAggregator> getFields() {
        return this.fields;
    }

    public Integer getNominalEntries() {
        return this.nominalEntries;
    }

    public Integer getNumberOfValues() {
        return this.numberOfValues;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TupleSketchSetOpPostAggregator)) {
            return false;
        }
        TupleSketchSetOpPostAggregator other = (TupleSketchSetOpPostAggregator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TupleSketchOperation this$operation = this.getOperation();
        TupleSketchOperation other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation)) {
            return false;
        }
        List<DruidPostAggregator> this$fields = this.getFields();
        List<DruidPostAggregator> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Integer this$nominalEntries = this.getNominalEntries();
        Integer other$nominalEntries = other.getNominalEntries();
        if (this$nominalEntries == null ? other$nominalEntries != null : !((Object)this$nominalEntries).equals(other$nominalEntries)) {
            return false;
        }
        Integer this$numberOfValues = this.getNumberOfValues();
        Integer other$numberOfValues = other.getNumberOfValues();
        return !(this$numberOfValues == null ? other$numberOfValues != null : !((Object)this$numberOfValues).equals(other$numberOfValues));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TupleSketchSetOpPostAggregator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TupleSketchOperation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        List<DruidPostAggregator> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        Integer $nominalEntries = this.getNominalEntries();
        result = result * 59 + ($nominalEntries == null ? 43 : ((Object)$nominalEntries).hashCode());
        Integer $numberOfValues = this.getNumberOfValues();
        result = result * 59 + ($numberOfValues == null ? 43 : ((Object)$numberOfValues).hashCode());
        return result;
    }

    public static class TupleSketchSetOpPostAggregatorBuilder {
        private String name;
        private TupleSketchOperation operation;
        private List<DruidPostAggregator> fields;
        private Integer nominalEntries;
        private Integer numberOfValues;

        TupleSketchSetOpPostAggregatorBuilder() {
        }

        public TupleSketchSetOpPostAggregatorBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public TupleSketchSetOpPostAggregatorBuilder operation(@NonNull TupleSketchOperation operation) {
            if (operation == null) {
                throw new NullPointerException("operation is marked non-null but is null");
            }
            this.operation = operation;
            return this;
        }

        public TupleSketchSetOpPostAggregatorBuilder fields(@NonNull List<DruidPostAggregator> fields) {
            if (fields == null) {
                throw new NullPointerException("fields is marked non-null but is null");
            }
            this.fields = fields;
            return this;
        }

        public TupleSketchSetOpPostAggregatorBuilder nominalEntries(Integer nominalEntries) {
            this.nominalEntries = nominalEntries;
            return this;
        }

        public TupleSketchSetOpPostAggregatorBuilder numberOfValues(Integer numberOfValues) {
            this.numberOfValues = numberOfValues;
            return this;
        }

        public TupleSketchSetOpPostAggregator build() {
            return new TupleSketchSetOpPostAggregator(this.name, this.operation, this.fields, this.nominalEntries, this.numberOfValues);
        }

        public String toString() {
            return "TupleSketchSetOpPostAggregator.TupleSketchSetOpPostAggregatorBuilder(name=" + this.name + ", operation=" + (Object)((Object)this.operation) + ", fields=" + this.fields + ", nominalEntries=" + this.nominalEntries + ", numberOfValues=" + this.numberOfValues + ")";
        }
    }
}

