/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.extractionFunctions;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.extractionFunctions.ExtractionFunction;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JavascriptExtractionFunction
extends ExtractionFunction {
    private String function;
    private Boolean injective;

    private JavascriptExtractionFunction(@NonNull String function, Boolean injective) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        this.type = "javascript";
        this.function = function;
        this.injective = injective;
    }

    public static JavascriptExtractionFunctionBuilder builder() {
        return new JavascriptExtractionFunctionBuilder();
    }

    public String getFunction() {
        return this.function;
    }

    public Boolean getInjective() {
        return this.injective;
    }

    public static class JavascriptExtractionFunctionBuilder {
        private String function;
        private Boolean injective;

        JavascriptExtractionFunctionBuilder() {
        }

        public JavascriptExtractionFunctionBuilder function(@NonNull String function) {
            if (function == null) {
                throw new NullPointerException("function is marked non-null but is null");
            }
            this.function = function;
            return this;
        }

        public JavascriptExtractionFunctionBuilder injective(Boolean injective) {
            this.injective = injective;
            return this;
        }

        public JavascriptExtractionFunction build() {
            return new JavascriptExtractionFunction(this.function, this.injective);
        }

        public String toString() {
            return "JavascriptExtractionFunction.JavascriptExtractionFunctionBuilder(function=" + this.function + ", injective=" + this.injective + ")";
        }
    }
}

