/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.extractionFunctions;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.extractionFunctions.ExtractionFunction;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SubStringExtractionFunction
extends ExtractionFunction {
    private Integer index;
    private Integer length;

    private SubStringExtractionFunction(@NonNull Integer index, Integer length) {
        if (index == null) {
            throw new NullPointerException("index is marked non-null but is null");
        }
        this.type = "substring";
        this.index = index;
        this.length = length;
    }

    public static SubStringExtractionFunctionBuilder builder() {
        return new SubStringExtractionFunctionBuilder();
    }

    public Integer getIndex() {
        return this.index;
    }

    public Integer getLength() {
        return this.length;
    }

    public static class SubStringExtractionFunctionBuilder {
        private Integer index;
        private Integer length;

        SubStringExtractionFunctionBuilder() {
        }

        public SubStringExtractionFunctionBuilder index(@NonNull Integer index) {
            if (index == null) {
                throw new NullPointerException("index is marked non-null but is null");
            }
            this.index = index;
            return this;
        }

        public SubStringExtractionFunctionBuilder length(Integer length) {
            this.length = length;
            return this;
        }

        public SubStringExtractionFunction build() {
            return new SubStringExtractionFunction(this.index, this.length);
        }

        public String toString() {
            return "SubStringExtractionFunction.SubStringExtractionFunctionBuilder(index=" + this.index + ", length=" + this.length + ")";
        }
    }
}

