/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.filter;

import in.zapr.druid.druidry.filter.DruidFilter;
import in.zapr.druid.druidry.query.config.SortingOrder;
import lombok.NonNull;

public class BoundFilter
extends DruidFilter {
    private static String BOUND_DRUID_FILTER_TYPE = "bound";
    @NonNull
    private String dimension;
    private String lower;
    private String upper;
    private Boolean lowerStrict;
    private Boolean upperStrict;
    private SortingOrder ordering;

    private BoundFilter(@NonNull String dimension, String lower, String upper, Boolean lowerStrict, Boolean upperStrict, SortingOrder ordering) {
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        this.type = BOUND_DRUID_FILTER_TYPE;
        this.dimension = dimension;
        this.lower = lower;
        this.upper = upper;
        this.lowerStrict = lowerStrict;
        this.upperStrict = upperStrict;
        this.ordering = ordering;
    }

    public static BoundFilterBuilder builder() {
        return new BoundFilterBuilder();
    }

    @NonNull
    public String getDimension() {
        return this.dimension;
    }

    public String getLower() {
        return this.lower;
    }

    public String getUpper() {
        return this.upper;
    }

    public Boolean getLowerStrict() {
        return this.lowerStrict;
    }

    public Boolean getUpperStrict() {
        return this.upperStrict;
    }

    public SortingOrder getOrdering() {
        return this.ordering;
    }

    public void setDimension(@NonNull String dimension) {
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        this.dimension = dimension;
    }

    public void setLower(String lower) {
        this.lower = lower;
    }

    public void setUpper(String upper) {
        this.upper = upper;
    }

    public void setLowerStrict(Boolean lowerStrict) {
        this.lowerStrict = lowerStrict;
    }

    public void setUpperStrict(Boolean upperStrict) {
        this.upperStrict = upperStrict;
    }

    public void setOrdering(SortingOrder ordering) {
        this.ordering = ordering;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoundFilter)) {
            return false;
        }
        BoundFilter other = (BoundFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$dimension = this.getDimension();
        String other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        String this$lower = this.getLower();
        String other$lower = other.getLower();
        if (this$lower == null ? other$lower != null : !this$lower.equals(other$lower)) {
            return false;
        }
        String this$upper = this.getUpper();
        String other$upper = other.getUpper();
        if (this$upper == null ? other$upper != null : !this$upper.equals(other$upper)) {
            return false;
        }
        Boolean this$lowerStrict = this.getLowerStrict();
        Boolean other$lowerStrict = other.getLowerStrict();
        if (this$lowerStrict == null ? other$lowerStrict != null : !((Object)this$lowerStrict).equals(other$lowerStrict)) {
            return false;
        }
        Boolean this$upperStrict = this.getUpperStrict();
        Boolean other$upperStrict = other.getUpperStrict();
        if (this$upperStrict == null ? other$upperStrict != null : !((Object)this$upperStrict).equals(other$upperStrict)) {
            return false;
        }
        SortingOrder this$ordering = this.getOrdering();
        SortingOrder other$ordering = other.getOrdering();
        return !(this$ordering == null ? other$ordering != null : !((Object)((Object)this$ordering)).equals((Object)other$ordering));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BoundFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        String $lower = this.getLower();
        result = result * 59 + ($lower == null ? 43 : $lower.hashCode());
        String $upper = this.getUpper();
        result = result * 59 + ($upper == null ? 43 : $upper.hashCode());
        Boolean $lowerStrict = this.getLowerStrict();
        result = result * 59 + ($lowerStrict == null ? 43 : ((Object)$lowerStrict).hashCode());
        Boolean $upperStrict = this.getUpperStrict();
        result = result * 59 + ($upperStrict == null ? 43 : ((Object)$upperStrict).hashCode());
        SortingOrder $ordering = this.getOrdering();
        result = result * 59 + ($ordering == null ? 43 : ((Object)((Object)$ordering)).hashCode());
        return result;
    }

    public static class BoundFilterBuilder {
        private String dimension;
        private String lower;
        private String upper;
        private Boolean lowerStrict;
        private Boolean upperStrict;
        private SortingOrder ordering;

        BoundFilterBuilder() {
        }

        public BoundFilterBuilder dimension(@NonNull String dimension) {
            if (dimension == null) {
                throw new NullPointerException("dimension is marked non-null but is null");
            }
            this.dimension = dimension;
            return this;
        }

        public BoundFilterBuilder lower(String lower) {
            this.lower = lower;
            return this;
        }

        public BoundFilterBuilder upper(String upper) {
            this.upper = upper;
            return this;
        }

        public BoundFilterBuilder lowerStrict(Boolean lowerStrict) {
            this.lowerStrict = lowerStrict;
            return this;
        }

        public BoundFilterBuilder upperStrict(Boolean upperStrict) {
            this.upperStrict = upperStrict;
            return this;
        }

        public BoundFilterBuilder ordering(SortingOrder ordering) {
            this.ordering = ordering;
            return this;
        }

        public BoundFilter build() {
            return new BoundFilter(this.dimension, this.lower, this.upper, this.lowerStrict, this.upperStrict, this.ordering);
        }

        public String toString() {
            return "BoundFilter.BoundFilterBuilder(dimension=" + this.dimension + ", lower=" + this.lower + ", upper=" + this.upper + ", lowerStrict=" + this.lowerStrict + ", upperStrict=" + this.upperStrict + ", ordering=" + (Object)((Object)this.ordering) + ")";
        }
    }
}

