/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.granularity;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import in.zapr.druid.druidry.granularity.Granularity;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DurationGranularity
extends Granularity {
    private static final String DURATION_GRANULARITY_TYPE = "duration";
    private final String type;
    @JsonProperty(value="duration")
    private long durationInMilliSeconds;
    private DateTime origin;

    public DurationGranularity(long durationInMilliSeconds) {
        this(durationInMilliSeconds, null);
    }

    public DurationGranularity(long durationInMilliSeconds, DateTime origin) {
        this.type = DURATION_GRANULARITY_TYPE;
        this.durationInMilliSeconds = durationInMilliSeconds;
        this.origin = origin;
    }

    public String getOrigin() {
        return this.origin == null ? null : this.origin.toDateTimeISO().toString();
    }

    public String getType() {
        return this.type;
    }

    public long getDurationInMilliSeconds() {
        return this.durationInMilliSeconds;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DurationGranularity)) {
            return false;
        }
        DurationGranularity other = (DurationGranularity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        if (this.getDurationInMilliSeconds() != other.getDurationInMilliSeconds()) {
            return false;
        }
        String this$origin = this.getOrigin();
        String other$origin = other.getOrigin();
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DurationGranularity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        long $durationInMilliSeconds = this.getDurationInMilliSeconds();
        result = result * 59 + (int)($durationInMilliSeconds >>> 32 ^ $durationInMilliSeconds);
        String $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

