/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.granularity;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.granularity.Granularity;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PeriodGranularity
extends Granularity {
    private static final String PERIOD_GRANULARITY_TYPE = "period";
    private static final String DEFAULT_TIMEZONE = "UTC";
    private final String type = "period";
    private String period;
    private DateTimeZone timeZone;
    private DateTime origin;

    public String getOrigin() {
        return this.origin == null ? null : this.origin.toDateTimeISO().toString();
    }

    public String getTimeZone() {
        return this.timeZone == null ? DEFAULT_TIMEZONE : this.timeZone.getID();
    }

    PeriodGranularity(String period, DateTimeZone timeZone, DateTime origin) {
        this.period = period;
        this.timeZone = timeZone;
        this.origin = origin;
    }

    public static PeriodGranularityBuilder builder() {
        return new PeriodGranularityBuilder();
    }

    public String getType() {
        return this.type;
    }

    public String getPeriod() {
        return this.period;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PeriodGranularity)) {
            return false;
        }
        PeriodGranularity other = (PeriodGranularity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$period = this.getPeriod();
        String other$period = other.getPeriod();
        if (this$period == null ? other$period != null : !this$period.equals(other$period)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        String this$origin = this.getOrigin();
        String other$origin = other.getOrigin();
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PeriodGranularity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : $period.hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        String $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }

    public static class PeriodGranularityBuilder {
        private String period;
        private DateTimeZone timeZone;
        private DateTime origin;

        PeriodGranularityBuilder() {
        }

        public PeriodGranularityBuilder period(String period) {
            this.period = period;
            return this;
        }

        public PeriodGranularityBuilder timeZone(DateTimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public PeriodGranularityBuilder origin(DateTime origin) {
            this.origin = origin;
            return this;
        }

        public PeriodGranularity build() {
            return new PeriodGranularity(this.period, this.timeZone, this.origin);
        }

        public String toString() {
            return "PeriodGranularity.PeriodGranularityBuilder(period=" + this.period + ", timeZone=" + this.timeZone + ", origin=" + this.origin + ")";
        }
    }
}

