/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.query.aggregation;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.aggregator.DruidAggregator;
import in.zapr.druid.druidry.averager.DruidAverager;
import in.zapr.druid.druidry.dataSource.DataSource;
import in.zapr.druid.druidry.dimension.DruidDimension;
import in.zapr.druid.druidry.filter.DruidFilter;
import in.zapr.druid.druidry.filter.havingSpec.HavingSpec;
import in.zapr.druid.druidry.granularity.Granularity;
import in.zapr.druid.druidry.limitSpec.DefaultLimitSpec;
import in.zapr.druid.druidry.postAggregator.DruidPostAggregator;
import in.zapr.druid.druidry.query.QueryType;
import in.zapr.druid.druidry.query.aggregation.DruidAggregationQuery;
import in.zapr.druid.druidry.query.config.Context;
import in.zapr.druid.druidry.query.config.Interval;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DruidMovingAverageQuery
extends DruidAggregationQuery {
    private List<DruidDimension> dimensions;
    private DefaultLimitSpec limitSpec;
    private HavingSpec having;
    private List<DruidAverager> averagers;
    private List<DruidPostAggregator> postAveragers;

    private DruidMovingAverageQuery(@NonNull DataSource dataSource, List<DruidDimension> dimensions, DefaultLimitSpec limitSpec, @NonNull Granularity granularity, DruidFilter filter, @NonNull List<DruidAggregator> aggregations, List<DruidPostAggregator> postAggregations, HavingSpec having, @NonNull List<Interval> intervals, Context context, @NonNull List<DruidAverager> averagers, List<DruidPostAggregator> postAveragers) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        if (granularity == null) {
            throw new NullPointerException("granularity is marked non-null but is null");
        }
        if (aggregations == null) {
            throw new NullPointerException("aggregations is marked non-null but is null");
        }
        if (intervals == null) {
            throw new NullPointerException("intervals is marked non-null but is null");
        }
        if (averagers == null) {
            throw new NullPointerException("averagers is marked non-null but is null");
        }
        this.queryType = QueryType.MOVING_AVERAGE;
        this.dataSource = dataSource;
        this.dimensions = dimensions;
        this.limitSpec = limitSpec;
        this.having = having;
        this.granularity = granularity;
        this.filter = filter;
        this.aggregations = aggregations;
        this.postAggregations = postAggregations;
        this.intervals = intervals;
        this.context = context;
        this.averagers = averagers;
        this.postAveragers = postAveragers;
    }

    public static DruidMovingAverageQueryBuilder builder() {
        return new DruidMovingAverageQueryBuilder();
    }

    public List<DruidDimension> getDimensions() {
        return this.dimensions;
    }

    public DefaultLimitSpec getLimitSpec() {
        return this.limitSpec;
    }

    public HavingSpec getHaving() {
        return this.having;
    }

    public List<DruidAverager> getAveragers() {
        return this.averagers;
    }

    public List<DruidPostAggregator> getPostAveragers() {
        return this.postAveragers;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DruidMovingAverageQuery)) {
            return false;
        }
        DruidMovingAverageQuery other = (DruidMovingAverageQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<DruidDimension> this$dimensions = this.getDimensions();
        List<DruidDimension> other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions)) {
            return false;
        }
        DefaultLimitSpec this$limitSpec = this.getLimitSpec();
        DefaultLimitSpec other$limitSpec = other.getLimitSpec();
        if (this$limitSpec == null ? other$limitSpec != null : !((Object)this$limitSpec).equals(other$limitSpec)) {
            return false;
        }
        HavingSpec this$having = this.getHaving();
        HavingSpec other$having = other.getHaving();
        if (this$having == null ? other$having != null : !((Object)this$having).equals(other$having)) {
            return false;
        }
        List<DruidAverager> this$averagers = this.getAveragers();
        List<DruidAverager> other$averagers = other.getAveragers();
        if (this$averagers == null ? other$averagers != null : !((Object)this$averagers).equals(other$averagers)) {
            return false;
        }
        List<DruidPostAggregator> this$postAveragers = this.getPostAveragers();
        List<DruidPostAggregator> other$postAveragers = other.getPostAveragers();
        return !(this$postAveragers == null ? other$postAveragers != null : !((Object)this$postAveragers).equals(other$postAveragers));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DruidMovingAverageQuery;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<DruidDimension> $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
        DefaultLimitSpec $limitSpec = this.getLimitSpec();
        result = result * 59 + ($limitSpec == null ? 43 : ((Object)$limitSpec).hashCode());
        HavingSpec $having = this.getHaving();
        result = result * 59 + ($having == null ? 43 : ((Object)$having).hashCode());
        List<DruidAverager> $averagers = this.getAveragers();
        result = result * 59 + ($averagers == null ? 43 : ((Object)$averagers).hashCode());
        List<DruidPostAggregator> $postAveragers = this.getPostAveragers();
        result = result * 59 + ($postAveragers == null ? 43 : ((Object)$postAveragers).hashCode());
        return result;
    }

    public static class DruidMovingAverageQueryBuilder {
        private DataSource dataSource;
        private List<DruidDimension> dimensions;
        private DefaultLimitSpec limitSpec;
        private Granularity granularity;
        private DruidFilter filter;
        private List<DruidAggregator> aggregations;
        private List<DruidPostAggregator> postAggregations;
        private HavingSpec having;
        private List<Interval> intervals;
        private Context context;
        private List<DruidAverager> averagers;
        private List<DruidPostAggregator> postAveragers;

        DruidMovingAverageQueryBuilder() {
        }

        public DruidMovingAverageQueryBuilder dataSource(@NonNull DataSource dataSource) {
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            this.dataSource = dataSource;
            return this;
        }

        public DruidMovingAverageQueryBuilder dimensions(List<DruidDimension> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public DruidMovingAverageQueryBuilder limitSpec(DefaultLimitSpec limitSpec) {
            this.limitSpec = limitSpec;
            return this;
        }

        public DruidMovingAverageQueryBuilder granularity(@NonNull Granularity granularity) {
            if (granularity == null) {
                throw new NullPointerException("granularity is marked non-null but is null");
            }
            this.granularity = granularity;
            return this;
        }

        public DruidMovingAverageQueryBuilder filter(DruidFilter filter) {
            this.filter = filter;
            return this;
        }

        public DruidMovingAverageQueryBuilder aggregations(@NonNull List<DruidAggregator> aggregations) {
            if (aggregations == null) {
                throw new NullPointerException("aggregations is marked non-null but is null");
            }
            this.aggregations = aggregations;
            return this;
        }

        public DruidMovingAverageQueryBuilder postAggregations(List<DruidPostAggregator> postAggregations) {
            this.postAggregations = postAggregations;
            return this;
        }

        public DruidMovingAverageQueryBuilder having(HavingSpec having) {
            this.having = having;
            return this;
        }

        public DruidMovingAverageQueryBuilder intervals(@NonNull List<Interval> intervals) {
            if (intervals == null) {
                throw new NullPointerException("intervals is marked non-null but is null");
            }
            this.intervals = intervals;
            return this;
        }

        public DruidMovingAverageQueryBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public DruidMovingAverageQueryBuilder averagers(@NonNull List<DruidAverager> averagers) {
            if (averagers == null) {
                throw new NullPointerException("averagers is marked non-null but is null");
            }
            this.averagers = averagers;
            return this;
        }

        public DruidMovingAverageQueryBuilder postAveragers(List<DruidPostAggregator> postAveragers) {
            this.postAveragers = postAveragers;
            return this;
        }

        public DruidMovingAverageQuery build() {
            return new DruidMovingAverageQuery(this.dataSource, this.dimensions, this.limitSpec, this.granularity, this.filter, this.aggregations, this.postAggregations, this.having, this.intervals, this.context, this.averagers, this.postAveragers);
        }

        public String toString() {
            return "DruidMovingAverageQuery.DruidMovingAverageQueryBuilder(dataSource=" + this.dataSource + ", dimensions=" + this.dimensions + ", limitSpec=" + this.limitSpec + ", granularity=" + this.granularity + ", filter=" + this.filter + ", aggregations=" + this.aggregations + ", postAggregations=" + this.postAggregations + ", having=" + this.having + ", intervals=" + this.intervals + ", context=" + this.context + ", averagers=" + this.averagers + ", postAveragers=" + this.postAveragers + ")";
        }
    }
}

