/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.query.aggregation;

import com.fasterxml.jackson.annotation.JsonInclude;
import in.zapr.druid.druidry.aggregator.DruidAggregator;
import in.zapr.druid.druidry.dataSource.DataSource;
import in.zapr.druid.druidry.filter.DruidFilter;
import in.zapr.druid.druidry.granularity.Granularity;
import in.zapr.druid.druidry.postAggregator.DruidPostAggregator;
import in.zapr.druid.druidry.query.QueryType;
import in.zapr.druid.druidry.query.aggregation.DruidAggregationQuery;
import in.zapr.druid.druidry.query.config.Context;
import in.zapr.druid.druidry.query.config.Interval;
import in.zapr.druid.druidry.virtualColumn.DruidVirtualColumn;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DruidTimeSeriesQuery
extends DruidAggregationQuery {
    private Boolean descending;
    private Integer limit;

    private DruidTimeSeriesQuery(@NonNull DataSource dataSource, Boolean descending, @NonNull List<Interval> intervals, @NonNull Granularity granularity, List<DruidVirtualColumn> virtualColumns, DruidFilter filter, List<DruidAggregator> aggregators, List<DruidPostAggregator> postAggregators, Integer limit, Context context) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        if (intervals == null) {
            throw new NullPointerException("intervals is marked non-null but is null");
        }
        if (granularity == null) {
            throw new NullPointerException("granularity is marked non-null but is null");
        }
        this.queryType = QueryType.TIMESERIES;
        this.dataSource = dataSource;
        this.descending = descending;
        this.intervals = intervals;
        this.granularity = granularity;
        this.virtualColumns = virtualColumns;
        this.filter = filter;
        this.aggregations = aggregators;
        this.postAggregations = postAggregators;
        this.limit = limit;
        this.context = context;
    }

    public static DruidTimeSeriesQueryBuilder builder() {
        return new DruidTimeSeriesQueryBuilder();
    }

    public Boolean getDescending() {
        return this.descending;
    }

    public Integer getLimit() {
        return this.limit;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DruidTimeSeriesQuery)) {
            return false;
        }
        DruidTimeSeriesQuery other = (DruidTimeSeriesQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$descending = this.getDescending();
        Boolean other$descending = other.getDescending();
        if (this$descending == null ? other$descending != null : !((Object)this$descending).equals(other$descending)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        return !(this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DruidTimeSeriesQuery;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $descending = this.getDescending();
        result = result * 59 + ($descending == null ? 43 : ((Object)$descending).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        return result;
    }

    public static class DruidTimeSeriesQueryBuilder {
        private DataSource dataSource;
        private Boolean descending;
        private List<Interval> intervals;
        private Granularity granularity;
        private List<DruidVirtualColumn> virtualColumns;
        private DruidFilter filter;
        private List<DruidAggregator> aggregators;
        private List<DruidPostAggregator> postAggregators;
        private Integer limit;
        private Context context;

        DruidTimeSeriesQueryBuilder() {
        }

        public DruidTimeSeriesQueryBuilder dataSource(@NonNull DataSource dataSource) {
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            this.dataSource = dataSource;
            return this;
        }

        public DruidTimeSeriesQueryBuilder descending(Boolean descending) {
            this.descending = descending;
            return this;
        }

        public DruidTimeSeriesQueryBuilder intervals(@NonNull List<Interval> intervals) {
            if (intervals == null) {
                throw new NullPointerException("intervals is marked non-null but is null");
            }
            this.intervals = intervals;
            return this;
        }

        public DruidTimeSeriesQueryBuilder granularity(@NonNull Granularity granularity) {
            if (granularity == null) {
                throw new NullPointerException("granularity is marked non-null but is null");
            }
            this.granularity = granularity;
            return this;
        }

        public DruidTimeSeriesQueryBuilder virtualColumns(List<DruidVirtualColumn> virtualColumns) {
            this.virtualColumns = virtualColumns;
            return this;
        }

        public DruidTimeSeriesQueryBuilder filter(DruidFilter filter) {
            this.filter = filter;
            return this;
        }

        public DruidTimeSeriesQueryBuilder aggregators(List<DruidAggregator> aggregators) {
            this.aggregators = aggregators;
            return this;
        }

        public DruidTimeSeriesQueryBuilder postAggregators(List<DruidPostAggregator> postAggregators) {
            this.postAggregators = postAggregators;
            return this;
        }

        public DruidTimeSeriesQueryBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public DruidTimeSeriesQueryBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public DruidTimeSeriesQuery build() {
            return new DruidTimeSeriesQuery(this.dataSource, this.descending, this.intervals, this.granularity, this.virtualColumns, this.filter, this.aggregators, this.postAggregators, this.limit, this.context);
        }

        public String toString() {
            return "DruidTimeSeriesQuery.DruidTimeSeriesQueryBuilder(dataSource=" + this.dataSource + ", descending=" + this.descending + ", intervals=" + this.intervals + ", granularity=" + this.granularity + ", virtualColumns=" + this.virtualColumns + ", filter=" + this.filter + ", aggregators=" + this.aggregators + ", postAggregators=" + this.postAggregators + ", limit=" + this.limit + ", context=" + this.context + ")";
        }
    }
}

