/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.query.aggregation;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Preconditions;
import in.zapr.druid.druidry.aggregator.DruidAggregator;
import in.zapr.druid.druidry.dataSource.DataSource;
import in.zapr.druid.druidry.dimension.DruidDimension;
import in.zapr.druid.druidry.filter.DruidFilter;
import in.zapr.druid.druidry.granularity.Granularity;
import in.zapr.druid.druidry.postAggregator.DruidPostAggregator;
import in.zapr.druid.druidry.query.QueryType;
import in.zapr.druid.druidry.query.aggregation.DruidAggregationQuery;
import in.zapr.druid.druidry.query.config.Context;
import in.zapr.druid.druidry.query.config.Interval;
import in.zapr.druid.druidry.topNMetric.TopNMetric;
import in.zapr.druid.druidry.virtualColumn.DruidVirtualColumn;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DruidTopNQuery
extends DruidAggregationQuery {
    private DruidDimension dimension;
    private Integer threshold;
    private TopNMetric metric;

    private DruidTopNQuery(@NonNull DataSource dataSource, @NonNull List<Interval> intervals, @NonNull Granularity granularity, List<DruidVirtualColumn> virtualColumns, DruidFilter filter, List<DruidAggregator> aggregators, List<DruidPostAggregator> postAggregators, @NonNull DruidDimension dimension, @NonNull Integer threshold, @NonNull TopNMetric topNMetric, Context context) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        if (intervals == null) {
            throw new NullPointerException("intervals is marked non-null but is null");
        }
        if (granularity == null) {
            throw new NullPointerException("granularity is marked non-null but is null");
        }
        if (dimension == null) {
            throw new NullPointerException("dimension is marked non-null but is null");
        }
        if (threshold == null) {
            throw new NullPointerException("threshold is marked non-null but is null");
        }
        if (topNMetric == null) {
            throw new NullPointerException("topNMetric is marked non-null but is null");
        }
        this.queryType = QueryType.TOPN;
        this.dataSource = dataSource;
        this.intervals = intervals;
        this.granularity = granularity;
        this.virtualColumns = virtualColumns;
        this.filter = filter;
        this.aggregations = aggregators;
        this.postAggregations = postAggregators;
        this.dimension = dimension;
        this.threshold = threshold;
        this.metric = topNMetric;
        this.context = context;
        Preconditions.checkArgument((threshold > 0 ? 1 : 0) != 0, (Object)"threshold must be greater than 0");
    }

    public static DruidTopNQueryBuilder builder() {
        return new DruidTopNQueryBuilder();
    }

    public DruidDimension getDimension() {
        return this.dimension;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    public TopNMetric getMetric() {
        return this.metric;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DruidTopNQuery)) {
            return false;
        }
        DruidTopNQuery other = (DruidTopNQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DruidDimension this$dimension = this.getDimension();
        DruidDimension other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !((Object)this$dimension).equals(other$dimension)) {
            return false;
        }
        Integer this$threshold = this.getThreshold();
        Integer other$threshold = other.getThreshold();
        if (this$threshold == null ? other$threshold != null : !((Object)this$threshold).equals(other$threshold)) {
            return false;
        }
        TopNMetric this$metric = this.getMetric();
        TopNMetric other$metric = other.getMetric();
        return !(this$metric == null ? other$metric != null : !((Object)this$metric).equals(other$metric));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DruidTopNQuery;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DruidDimension $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : ((Object)$dimension).hashCode());
        Integer $threshold = this.getThreshold();
        result = result * 59 + ($threshold == null ? 43 : ((Object)$threshold).hashCode());
        TopNMetric $metric = this.getMetric();
        result = result * 59 + ($metric == null ? 43 : ((Object)$metric).hashCode());
        return result;
    }

    public static class DruidTopNQueryBuilder {
        private DataSource dataSource;
        private List<Interval> intervals;
        private Granularity granularity;
        private List<DruidVirtualColumn> virtualColumns;
        private DruidFilter filter;
        private List<DruidAggregator> aggregators;
        private List<DruidPostAggregator> postAggregators;
        private DruidDimension dimension;
        private Integer threshold;
        private TopNMetric topNMetric;
        private Context context;

        DruidTopNQueryBuilder() {
        }

        public DruidTopNQueryBuilder dataSource(@NonNull DataSource dataSource) {
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            this.dataSource = dataSource;
            return this;
        }

        public DruidTopNQueryBuilder intervals(@NonNull List<Interval> intervals) {
            if (intervals == null) {
                throw new NullPointerException("intervals is marked non-null but is null");
            }
            this.intervals = intervals;
            return this;
        }

        public DruidTopNQueryBuilder granularity(@NonNull Granularity granularity) {
            if (granularity == null) {
                throw new NullPointerException("granularity is marked non-null but is null");
            }
            this.granularity = granularity;
            return this;
        }

        public DruidTopNQueryBuilder virtualColumns(List<DruidVirtualColumn> virtualColumns) {
            this.virtualColumns = virtualColumns;
            return this;
        }

        public DruidTopNQueryBuilder filter(DruidFilter filter) {
            this.filter = filter;
            return this;
        }

        public DruidTopNQueryBuilder aggregators(List<DruidAggregator> aggregators) {
            this.aggregators = aggregators;
            return this;
        }

        public DruidTopNQueryBuilder postAggregators(List<DruidPostAggregator> postAggregators) {
            this.postAggregators = postAggregators;
            return this;
        }

        public DruidTopNQueryBuilder dimension(@NonNull DruidDimension dimension) {
            if (dimension == null) {
                throw new NullPointerException("dimension is marked non-null but is null");
            }
            this.dimension = dimension;
            return this;
        }

        public DruidTopNQueryBuilder threshold(@NonNull Integer threshold) {
            if (threshold == null) {
                throw new NullPointerException("threshold is marked non-null but is null");
            }
            this.threshold = threshold;
            return this;
        }

        public DruidTopNQueryBuilder topNMetric(@NonNull TopNMetric topNMetric) {
            if (topNMetric == null) {
                throw new NullPointerException("topNMetric is marked non-null but is null");
            }
            this.topNMetric = topNMetric;
            return this;
        }

        public DruidTopNQueryBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public DruidTopNQuery build() {
            return new DruidTopNQuery(this.dataSource, this.intervals, this.granularity, this.virtualColumns, this.filter, this.aggregators, this.postAggregators, this.dimension, this.threshold, this.topNMetric, this.context);
        }

        public String toString() {
            return "DruidTopNQuery.DruidTopNQueryBuilder(dataSource=" + this.dataSource + ", intervals=" + this.intervals + ", granularity=" + this.granularity + ", virtualColumns=" + this.virtualColumns + ", filter=" + this.filter + ", aggregators=" + this.aggregators + ", postAggregators=" + this.postAggregators + ", dimension=" + this.dimension + ", threshold=" + this.threshold + ", topNMetric=" + this.topNMetric + ", context=" + this.context + ")";
        }
    }
}

