/*
 * Decompiled with CFR 0.152.
 */
package in.zapr.druid.druidry.query.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import in.zapr.druid.druidry.query.config.GroupByStrategy;
import in.zapr.druid.druidry.query.config.Vectorize;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Context {
    @JsonProperty(value="timeout")
    private Long timeoutInMilliSeconds;
    private Integer priority;
    private String queryId;
    private Boolean useCache;
    private Boolean populateCache;
    private Boolean useResultLevelCache;
    private Boolean populateResultLevelCache;
    private Boolean bySegment;
    private Boolean finalize;
    private String chunkPeriod;
    private Long maxScatterGatherBytes;
    private Long maxQueuedBytes;
    private Boolean serializeDateTimeAsLong;
    private Boolean serializeDateTimeAsLongInner;
    private Integer minTopNThreshold;
    private Boolean skipEmptyBuckets;
    private Long maxMergingDictionarySize;
    private Long maxOnDiskStorage;
    private GroupByStrategy groupByStrategy;
    private Boolean groupByIsSingleThreaded;
    private Integer bufferGrouperInitialBuckets;
    private Float bufferGrouperMaxLoadFactor;
    private Boolean forceHashAggregation;
    private Integer intermediateCombineDegree;
    private Integer numParallelCombineThreads;
    private Boolean sortByDimsFirst;
    private Boolean forceLimitPushDown;
    private Boolean applyLimitPushDown;
    private Integer maxIntermediateRows;
    private Integer maxResults;
    private Boolean useOffheap;
    private Vectorize vectorize;
    private Integer vectorSize;

    private Context(Long timeoutInMilliSeconds, Integer priority, String queryId, Boolean useCache, Boolean populateCache, Boolean useResultLevelCache, Boolean populateResultLevelCache, Boolean bySegment, Boolean finalize, String chunkPeriod, Long maxScatterGatherBytes, Long maxQueuedBytes, Boolean serializeDateTimeAsLong, Boolean serializeDateTimeAsLongInner, Integer minTopNThreshold, Boolean skipEmptyBuckets, Long maxMergingDictionarySize, Long maxOnDiskStorage, GroupByStrategy groupByStrategy, Boolean groupByIsSingleThreaded, Integer bufferGrouperInitialBuckets, Float bufferGrouperMaxLoadFactor, Boolean forceHashAggregation, Integer intermediateCombineDegree, Integer numParallelCombineThreads, Boolean sortByDimsFirst, Boolean forceLimitPushDown, Boolean applyLimitPushDown, Integer maxIntermediateRows, Integer maxResults, Boolean useOffheap, Vectorize vectorize, Integer vectorSize) {
        this.timeoutInMilliSeconds = timeoutInMilliSeconds;
        this.priority = priority;
        this.queryId = queryId;
        this.useCache = useCache;
        this.populateCache = populateCache;
        this.useResultLevelCache = useResultLevelCache;
        this.populateResultLevelCache = populateResultLevelCache;
        this.bySegment = bySegment;
        this.finalize = finalize;
        this.chunkPeriod = chunkPeriod;
        this.maxScatterGatherBytes = maxScatterGatherBytes;
        this.maxQueuedBytes = maxQueuedBytes;
        this.serializeDateTimeAsLong = serializeDateTimeAsLong;
        this.serializeDateTimeAsLongInner = serializeDateTimeAsLongInner;
        this.minTopNThreshold = minTopNThreshold;
        this.skipEmptyBuckets = skipEmptyBuckets;
        this.maxMergingDictionarySize = maxMergingDictionarySize;
        this.maxOnDiskStorage = maxOnDiskStorage;
        this.groupByStrategy = groupByStrategy;
        this.groupByIsSingleThreaded = groupByIsSingleThreaded;
        this.bufferGrouperInitialBuckets = bufferGrouperInitialBuckets;
        this.bufferGrouperMaxLoadFactor = bufferGrouperMaxLoadFactor;
        this.forceHashAggregation = forceHashAggregation;
        this.intermediateCombineDegree = intermediateCombineDegree;
        this.numParallelCombineThreads = numParallelCombineThreads;
        this.sortByDimsFirst = sortByDimsFirst;
        this.forceLimitPushDown = forceLimitPushDown;
        this.applyLimitPushDown = applyLimitPushDown;
        this.maxIntermediateRows = maxIntermediateRows;
        this.maxResults = maxResults;
        this.useOffheap = useOffheap;
        this.vectorize = vectorize;
        this.vectorSize = vectorSize;
        if (timeoutInMilliSeconds != null) {
            Preconditions.checkArgument((timeoutInMilliSeconds >= 0L ? 1 : 0) != 0, (String)"Timeout must be a non negative value, but was [%s]", (Object)timeoutInMilliSeconds);
        }
    }

    public static ContextBuilder builder() {
        return new ContextBuilder();
    }

    public Long getTimeoutInMilliSeconds() {
        return this.timeoutInMilliSeconds;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public Boolean getUseCache() {
        return this.useCache;
    }

    public Boolean getPopulateCache() {
        return this.populateCache;
    }

    public Boolean getUseResultLevelCache() {
        return this.useResultLevelCache;
    }

    public Boolean getPopulateResultLevelCache() {
        return this.populateResultLevelCache;
    }

    public Boolean getBySegment() {
        return this.bySegment;
    }

    public Boolean getFinalize() {
        return this.finalize;
    }

    public String getChunkPeriod() {
        return this.chunkPeriod;
    }

    public Long getMaxScatterGatherBytes() {
        return this.maxScatterGatherBytes;
    }

    public Long getMaxQueuedBytes() {
        return this.maxQueuedBytes;
    }

    public Boolean getSerializeDateTimeAsLong() {
        return this.serializeDateTimeAsLong;
    }

    public Boolean getSerializeDateTimeAsLongInner() {
        return this.serializeDateTimeAsLongInner;
    }

    public Integer getMinTopNThreshold() {
        return this.minTopNThreshold;
    }

    public Boolean getSkipEmptyBuckets() {
        return this.skipEmptyBuckets;
    }

    public Long getMaxMergingDictionarySize() {
        return this.maxMergingDictionarySize;
    }

    public Long getMaxOnDiskStorage() {
        return this.maxOnDiskStorage;
    }

    public GroupByStrategy getGroupByStrategy() {
        return this.groupByStrategy;
    }

    public Boolean getGroupByIsSingleThreaded() {
        return this.groupByIsSingleThreaded;
    }

    public Integer getBufferGrouperInitialBuckets() {
        return this.bufferGrouperInitialBuckets;
    }

    public Float getBufferGrouperMaxLoadFactor() {
        return this.bufferGrouperMaxLoadFactor;
    }

    public Boolean getForceHashAggregation() {
        return this.forceHashAggregation;
    }

    public Integer getIntermediateCombineDegree() {
        return this.intermediateCombineDegree;
    }

    public Integer getNumParallelCombineThreads() {
        return this.numParallelCombineThreads;
    }

    public Boolean getSortByDimsFirst() {
        return this.sortByDimsFirst;
    }

    public Boolean getForceLimitPushDown() {
        return this.forceLimitPushDown;
    }

    public Boolean getApplyLimitPushDown() {
        return this.applyLimitPushDown;
    }

    public Integer getMaxIntermediateRows() {
        return this.maxIntermediateRows;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public Boolean getUseOffheap() {
        return this.useOffheap;
    }

    public Vectorize getVectorize() {
        return this.vectorize;
    }

    public Integer getVectorSize() {
        return this.vectorSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Context)) {
            return false;
        }
        Context other = (Context)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$timeoutInMilliSeconds = this.getTimeoutInMilliSeconds();
        Long other$timeoutInMilliSeconds = other.getTimeoutInMilliSeconds();
        if (this$timeoutInMilliSeconds == null ? other$timeoutInMilliSeconds != null : !((Object)this$timeoutInMilliSeconds).equals(other$timeoutInMilliSeconds)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        String this$queryId = this.getQueryId();
        String other$queryId = other.getQueryId();
        if (this$queryId == null ? other$queryId != null : !this$queryId.equals(other$queryId)) {
            return false;
        }
        Boolean this$useCache = this.getUseCache();
        Boolean other$useCache = other.getUseCache();
        if (this$useCache == null ? other$useCache != null : !((Object)this$useCache).equals(other$useCache)) {
            return false;
        }
        Boolean this$populateCache = this.getPopulateCache();
        Boolean other$populateCache = other.getPopulateCache();
        if (this$populateCache == null ? other$populateCache != null : !((Object)this$populateCache).equals(other$populateCache)) {
            return false;
        }
        Boolean this$useResultLevelCache = this.getUseResultLevelCache();
        Boolean other$useResultLevelCache = other.getUseResultLevelCache();
        if (this$useResultLevelCache == null ? other$useResultLevelCache != null : !((Object)this$useResultLevelCache).equals(other$useResultLevelCache)) {
            return false;
        }
        Boolean this$populateResultLevelCache = this.getPopulateResultLevelCache();
        Boolean other$populateResultLevelCache = other.getPopulateResultLevelCache();
        if (this$populateResultLevelCache == null ? other$populateResultLevelCache != null : !((Object)this$populateResultLevelCache).equals(other$populateResultLevelCache)) {
            return false;
        }
        Boolean this$bySegment = this.getBySegment();
        Boolean other$bySegment = other.getBySegment();
        if (this$bySegment == null ? other$bySegment != null : !((Object)this$bySegment).equals(other$bySegment)) {
            return false;
        }
        Boolean this$finalize = this.getFinalize();
        Boolean other$finalize = other.getFinalize();
        if (this$finalize == null ? other$finalize != null : !((Object)this$finalize).equals(other$finalize)) {
            return false;
        }
        String this$chunkPeriod = this.getChunkPeriod();
        String other$chunkPeriod = other.getChunkPeriod();
        if (this$chunkPeriod == null ? other$chunkPeriod != null : !this$chunkPeriod.equals(other$chunkPeriod)) {
            return false;
        }
        Long this$maxScatterGatherBytes = this.getMaxScatterGatherBytes();
        Long other$maxScatterGatherBytes = other.getMaxScatterGatherBytes();
        if (this$maxScatterGatherBytes == null ? other$maxScatterGatherBytes != null : !((Object)this$maxScatterGatherBytes).equals(other$maxScatterGatherBytes)) {
            return false;
        }
        Long this$maxQueuedBytes = this.getMaxQueuedBytes();
        Long other$maxQueuedBytes = other.getMaxQueuedBytes();
        if (this$maxQueuedBytes == null ? other$maxQueuedBytes != null : !((Object)this$maxQueuedBytes).equals(other$maxQueuedBytes)) {
            return false;
        }
        Boolean this$serializeDateTimeAsLong = this.getSerializeDateTimeAsLong();
        Boolean other$serializeDateTimeAsLong = other.getSerializeDateTimeAsLong();
        if (this$serializeDateTimeAsLong == null ? other$serializeDateTimeAsLong != null : !((Object)this$serializeDateTimeAsLong).equals(other$serializeDateTimeAsLong)) {
            return false;
        }
        Boolean this$serializeDateTimeAsLongInner = this.getSerializeDateTimeAsLongInner();
        Boolean other$serializeDateTimeAsLongInner = other.getSerializeDateTimeAsLongInner();
        if (this$serializeDateTimeAsLongInner == null ? other$serializeDateTimeAsLongInner != null : !((Object)this$serializeDateTimeAsLongInner).equals(other$serializeDateTimeAsLongInner)) {
            return false;
        }
        Integer this$minTopNThreshold = this.getMinTopNThreshold();
        Integer other$minTopNThreshold = other.getMinTopNThreshold();
        if (this$minTopNThreshold == null ? other$minTopNThreshold != null : !((Object)this$minTopNThreshold).equals(other$minTopNThreshold)) {
            return false;
        }
        Boolean this$skipEmptyBuckets = this.getSkipEmptyBuckets();
        Boolean other$skipEmptyBuckets = other.getSkipEmptyBuckets();
        if (this$skipEmptyBuckets == null ? other$skipEmptyBuckets != null : !((Object)this$skipEmptyBuckets).equals(other$skipEmptyBuckets)) {
            return false;
        }
        Long this$maxMergingDictionarySize = this.getMaxMergingDictionarySize();
        Long other$maxMergingDictionarySize = other.getMaxMergingDictionarySize();
        if (this$maxMergingDictionarySize == null ? other$maxMergingDictionarySize != null : !((Object)this$maxMergingDictionarySize).equals(other$maxMergingDictionarySize)) {
            return false;
        }
        Long this$maxOnDiskStorage = this.getMaxOnDiskStorage();
        Long other$maxOnDiskStorage = other.getMaxOnDiskStorage();
        if (this$maxOnDiskStorage == null ? other$maxOnDiskStorage != null : !((Object)this$maxOnDiskStorage).equals(other$maxOnDiskStorage)) {
            return false;
        }
        GroupByStrategy this$groupByStrategy = this.getGroupByStrategy();
        GroupByStrategy other$groupByStrategy = other.getGroupByStrategy();
        if (this$groupByStrategy == null ? other$groupByStrategy != null : !((Object)((Object)this$groupByStrategy)).equals((Object)other$groupByStrategy)) {
            return false;
        }
        Boolean this$groupByIsSingleThreaded = this.getGroupByIsSingleThreaded();
        Boolean other$groupByIsSingleThreaded = other.getGroupByIsSingleThreaded();
        if (this$groupByIsSingleThreaded == null ? other$groupByIsSingleThreaded != null : !((Object)this$groupByIsSingleThreaded).equals(other$groupByIsSingleThreaded)) {
            return false;
        }
        Integer this$bufferGrouperInitialBuckets = this.getBufferGrouperInitialBuckets();
        Integer other$bufferGrouperInitialBuckets = other.getBufferGrouperInitialBuckets();
        if (this$bufferGrouperInitialBuckets == null ? other$bufferGrouperInitialBuckets != null : !((Object)this$bufferGrouperInitialBuckets).equals(other$bufferGrouperInitialBuckets)) {
            return false;
        }
        Float this$bufferGrouperMaxLoadFactor = this.getBufferGrouperMaxLoadFactor();
        Float other$bufferGrouperMaxLoadFactor = other.getBufferGrouperMaxLoadFactor();
        if (this$bufferGrouperMaxLoadFactor == null ? other$bufferGrouperMaxLoadFactor != null : !((Object)this$bufferGrouperMaxLoadFactor).equals(other$bufferGrouperMaxLoadFactor)) {
            return false;
        }
        Boolean this$forceHashAggregation = this.getForceHashAggregation();
        Boolean other$forceHashAggregation = other.getForceHashAggregation();
        if (this$forceHashAggregation == null ? other$forceHashAggregation != null : !((Object)this$forceHashAggregation).equals(other$forceHashAggregation)) {
            return false;
        }
        Integer this$intermediateCombineDegree = this.getIntermediateCombineDegree();
        Integer other$intermediateCombineDegree = other.getIntermediateCombineDegree();
        if (this$intermediateCombineDegree == null ? other$intermediateCombineDegree != null : !((Object)this$intermediateCombineDegree).equals(other$intermediateCombineDegree)) {
            return false;
        }
        Integer this$numParallelCombineThreads = this.getNumParallelCombineThreads();
        Integer other$numParallelCombineThreads = other.getNumParallelCombineThreads();
        if (this$numParallelCombineThreads == null ? other$numParallelCombineThreads != null : !((Object)this$numParallelCombineThreads).equals(other$numParallelCombineThreads)) {
            return false;
        }
        Boolean this$sortByDimsFirst = this.getSortByDimsFirst();
        Boolean other$sortByDimsFirst = other.getSortByDimsFirst();
        if (this$sortByDimsFirst == null ? other$sortByDimsFirst != null : !((Object)this$sortByDimsFirst).equals(other$sortByDimsFirst)) {
            return false;
        }
        Boolean this$forceLimitPushDown = this.getForceLimitPushDown();
        Boolean other$forceLimitPushDown = other.getForceLimitPushDown();
        if (this$forceLimitPushDown == null ? other$forceLimitPushDown != null : !((Object)this$forceLimitPushDown).equals(other$forceLimitPushDown)) {
            return false;
        }
        Boolean this$applyLimitPushDown = this.getApplyLimitPushDown();
        Boolean other$applyLimitPushDown = other.getApplyLimitPushDown();
        if (this$applyLimitPushDown == null ? other$applyLimitPushDown != null : !((Object)this$applyLimitPushDown).equals(other$applyLimitPushDown)) {
            return false;
        }
        Integer this$maxIntermediateRows = this.getMaxIntermediateRows();
        Integer other$maxIntermediateRows = other.getMaxIntermediateRows();
        if (this$maxIntermediateRows == null ? other$maxIntermediateRows != null : !((Object)this$maxIntermediateRows).equals(other$maxIntermediateRows)) {
            return false;
        }
        Integer this$maxResults = this.getMaxResults();
        Integer other$maxResults = other.getMaxResults();
        if (this$maxResults == null ? other$maxResults != null : !((Object)this$maxResults).equals(other$maxResults)) {
            return false;
        }
        Boolean this$useOffheap = this.getUseOffheap();
        Boolean other$useOffheap = other.getUseOffheap();
        if (this$useOffheap == null ? other$useOffheap != null : !((Object)this$useOffheap).equals(other$useOffheap)) {
            return false;
        }
        Vectorize this$vectorize = this.getVectorize();
        Vectorize other$vectorize = other.getVectorize();
        if (this$vectorize == null ? other$vectorize != null : !((Object)((Object)this$vectorize)).equals((Object)other$vectorize)) {
            return false;
        }
        Integer this$vectorSize = this.getVectorSize();
        Integer other$vectorSize = other.getVectorSize();
        return !(this$vectorSize == null ? other$vectorSize != null : !((Object)this$vectorSize).equals(other$vectorSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Context;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $timeoutInMilliSeconds = this.getTimeoutInMilliSeconds();
        result = result * 59 + ($timeoutInMilliSeconds == null ? 43 : ((Object)$timeoutInMilliSeconds).hashCode());
        Integer $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        String $queryId = this.getQueryId();
        result = result * 59 + ($queryId == null ? 43 : $queryId.hashCode());
        Boolean $useCache = this.getUseCache();
        result = result * 59 + ($useCache == null ? 43 : ((Object)$useCache).hashCode());
        Boolean $populateCache = this.getPopulateCache();
        result = result * 59 + ($populateCache == null ? 43 : ((Object)$populateCache).hashCode());
        Boolean $useResultLevelCache = this.getUseResultLevelCache();
        result = result * 59 + ($useResultLevelCache == null ? 43 : ((Object)$useResultLevelCache).hashCode());
        Boolean $populateResultLevelCache = this.getPopulateResultLevelCache();
        result = result * 59 + ($populateResultLevelCache == null ? 43 : ((Object)$populateResultLevelCache).hashCode());
        Boolean $bySegment = this.getBySegment();
        result = result * 59 + ($bySegment == null ? 43 : ((Object)$bySegment).hashCode());
        Boolean $finalize = this.getFinalize();
        result = result * 59 + ($finalize == null ? 43 : ((Object)$finalize).hashCode());
        String $chunkPeriod = this.getChunkPeriod();
        result = result * 59 + ($chunkPeriod == null ? 43 : $chunkPeriod.hashCode());
        Long $maxScatterGatherBytes = this.getMaxScatterGatherBytes();
        result = result * 59 + ($maxScatterGatherBytes == null ? 43 : ((Object)$maxScatterGatherBytes).hashCode());
        Long $maxQueuedBytes = this.getMaxQueuedBytes();
        result = result * 59 + ($maxQueuedBytes == null ? 43 : ((Object)$maxQueuedBytes).hashCode());
        Boolean $serializeDateTimeAsLong = this.getSerializeDateTimeAsLong();
        result = result * 59 + ($serializeDateTimeAsLong == null ? 43 : ((Object)$serializeDateTimeAsLong).hashCode());
        Boolean $serializeDateTimeAsLongInner = this.getSerializeDateTimeAsLongInner();
        result = result * 59 + ($serializeDateTimeAsLongInner == null ? 43 : ((Object)$serializeDateTimeAsLongInner).hashCode());
        Integer $minTopNThreshold = this.getMinTopNThreshold();
        result = result * 59 + ($minTopNThreshold == null ? 43 : ((Object)$minTopNThreshold).hashCode());
        Boolean $skipEmptyBuckets = this.getSkipEmptyBuckets();
        result = result * 59 + ($skipEmptyBuckets == null ? 43 : ((Object)$skipEmptyBuckets).hashCode());
        Long $maxMergingDictionarySize = this.getMaxMergingDictionarySize();
        result = result * 59 + ($maxMergingDictionarySize == null ? 43 : ((Object)$maxMergingDictionarySize).hashCode());
        Long $maxOnDiskStorage = this.getMaxOnDiskStorage();
        result = result * 59 + ($maxOnDiskStorage == null ? 43 : ((Object)$maxOnDiskStorage).hashCode());
        GroupByStrategy $groupByStrategy = this.getGroupByStrategy();
        result = result * 59 + ($groupByStrategy == null ? 43 : ((Object)((Object)$groupByStrategy)).hashCode());
        Boolean $groupByIsSingleThreaded = this.getGroupByIsSingleThreaded();
        result = result * 59 + ($groupByIsSingleThreaded == null ? 43 : ((Object)$groupByIsSingleThreaded).hashCode());
        Integer $bufferGrouperInitialBuckets = this.getBufferGrouperInitialBuckets();
        result = result * 59 + ($bufferGrouperInitialBuckets == null ? 43 : ((Object)$bufferGrouperInitialBuckets).hashCode());
        Float $bufferGrouperMaxLoadFactor = this.getBufferGrouperMaxLoadFactor();
        result = result * 59 + ($bufferGrouperMaxLoadFactor == null ? 43 : ((Object)$bufferGrouperMaxLoadFactor).hashCode());
        Boolean $forceHashAggregation = this.getForceHashAggregation();
        result = result * 59 + ($forceHashAggregation == null ? 43 : ((Object)$forceHashAggregation).hashCode());
        Integer $intermediateCombineDegree = this.getIntermediateCombineDegree();
        result = result * 59 + ($intermediateCombineDegree == null ? 43 : ((Object)$intermediateCombineDegree).hashCode());
        Integer $numParallelCombineThreads = this.getNumParallelCombineThreads();
        result = result * 59 + ($numParallelCombineThreads == null ? 43 : ((Object)$numParallelCombineThreads).hashCode());
        Boolean $sortByDimsFirst = this.getSortByDimsFirst();
        result = result * 59 + ($sortByDimsFirst == null ? 43 : ((Object)$sortByDimsFirst).hashCode());
        Boolean $forceLimitPushDown = this.getForceLimitPushDown();
        result = result * 59 + ($forceLimitPushDown == null ? 43 : ((Object)$forceLimitPushDown).hashCode());
        Boolean $applyLimitPushDown = this.getApplyLimitPushDown();
        result = result * 59 + ($applyLimitPushDown == null ? 43 : ((Object)$applyLimitPushDown).hashCode());
        Integer $maxIntermediateRows = this.getMaxIntermediateRows();
        result = result * 59 + ($maxIntermediateRows == null ? 43 : ((Object)$maxIntermediateRows).hashCode());
        Integer $maxResults = this.getMaxResults();
        result = result * 59 + ($maxResults == null ? 43 : ((Object)$maxResults).hashCode());
        Boolean $useOffheap = this.getUseOffheap();
        result = result * 59 + ($useOffheap == null ? 43 : ((Object)$useOffheap).hashCode());
        Vectorize $vectorize = this.getVectorize();
        result = result * 59 + ($vectorize == null ? 43 : ((Object)((Object)$vectorize)).hashCode());
        Integer $vectorSize = this.getVectorSize();
        result = result * 59 + ($vectorSize == null ? 43 : ((Object)$vectorSize).hashCode());
        return result;
    }

    public static class ContextBuilder {
        private Long timeoutInMilliSeconds;
        private Integer priority;
        private String queryId;
        private Boolean useCache;
        private Boolean populateCache;
        private Boolean useResultLevelCache;
        private Boolean populateResultLevelCache;
        private Boolean bySegment;
        private Boolean finalize;
        private String chunkPeriod;
        private Long maxScatterGatherBytes;
        private Long maxQueuedBytes;
        private Boolean serializeDateTimeAsLong;
        private Boolean serializeDateTimeAsLongInner;
        private Integer minTopNThreshold;
        private Boolean skipEmptyBuckets;
        private Long maxMergingDictionarySize;
        private Long maxOnDiskStorage;
        private GroupByStrategy groupByStrategy;
        private Boolean groupByIsSingleThreaded;
        private Integer bufferGrouperInitialBuckets;
        private Float bufferGrouperMaxLoadFactor;
        private Boolean forceHashAggregation;
        private Integer intermediateCombineDegree;
        private Integer numParallelCombineThreads;
        private Boolean sortByDimsFirst;
        private Boolean forceLimitPushDown;
        private Boolean applyLimitPushDown;
        private Integer maxIntermediateRows;
        private Integer maxResults;
        private Boolean useOffheap;
        private Vectorize vectorize;
        private Integer vectorSize;

        ContextBuilder() {
        }

        @JsonProperty(value="timeout")
        public ContextBuilder timeoutInMilliSeconds(Long timeoutInMilliSeconds) {
            this.timeoutInMilliSeconds = timeoutInMilliSeconds;
            return this;
        }

        public ContextBuilder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public ContextBuilder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public ContextBuilder useCache(Boolean useCache) {
            this.useCache = useCache;
            return this;
        }

        public ContextBuilder populateCache(Boolean populateCache) {
            this.populateCache = populateCache;
            return this;
        }

        public ContextBuilder useResultLevelCache(Boolean useResultLevelCache) {
            this.useResultLevelCache = useResultLevelCache;
            return this;
        }

        public ContextBuilder populateResultLevelCache(Boolean populateResultLevelCache) {
            this.populateResultLevelCache = populateResultLevelCache;
            return this;
        }

        public ContextBuilder bySegment(Boolean bySegment) {
            this.bySegment = bySegment;
            return this;
        }

        public ContextBuilder finalize(Boolean finalize) {
            this.finalize = finalize;
            return this;
        }

        public ContextBuilder chunkPeriod(String chunkPeriod) {
            this.chunkPeriod = chunkPeriod;
            return this;
        }

        public ContextBuilder maxScatterGatherBytes(Long maxScatterGatherBytes) {
            this.maxScatterGatherBytes = maxScatterGatherBytes;
            return this;
        }

        public ContextBuilder maxQueuedBytes(Long maxQueuedBytes) {
            this.maxQueuedBytes = maxQueuedBytes;
            return this;
        }

        public ContextBuilder serializeDateTimeAsLong(Boolean serializeDateTimeAsLong) {
            this.serializeDateTimeAsLong = serializeDateTimeAsLong;
            return this;
        }

        public ContextBuilder serializeDateTimeAsLongInner(Boolean serializeDateTimeAsLongInner) {
            this.serializeDateTimeAsLongInner = serializeDateTimeAsLongInner;
            return this;
        }

        public ContextBuilder minTopNThreshold(Integer minTopNThreshold) {
            this.minTopNThreshold = minTopNThreshold;
            return this;
        }

        public ContextBuilder skipEmptyBuckets(Boolean skipEmptyBuckets) {
            this.skipEmptyBuckets = skipEmptyBuckets;
            return this;
        }

        public ContextBuilder maxMergingDictionarySize(Long maxMergingDictionarySize) {
            this.maxMergingDictionarySize = maxMergingDictionarySize;
            return this;
        }

        public ContextBuilder maxOnDiskStorage(Long maxOnDiskStorage) {
            this.maxOnDiskStorage = maxOnDiskStorage;
            return this;
        }

        public ContextBuilder groupByStrategy(GroupByStrategy groupByStrategy) {
            this.groupByStrategy = groupByStrategy;
            return this;
        }

        public ContextBuilder groupByIsSingleThreaded(Boolean groupByIsSingleThreaded) {
            this.groupByIsSingleThreaded = groupByIsSingleThreaded;
            return this;
        }

        public ContextBuilder bufferGrouperInitialBuckets(Integer bufferGrouperInitialBuckets) {
            this.bufferGrouperInitialBuckets = bufferGrouperInitialBuckets;
            return this;
        }

        public ContextBuilder bufferGrouperMaxLoadFactor(Float bufferGrouperMaxLoadFactor) {
            this.bufferGrouperMaxLoadFactor = bufferGrouperMaxLoadFactor;
            return this;
        }

        public ContextBuilder forceHashAggregation(Boolean forceHashAggregation) {
            this.forceHashAggregation = forceHashAggregation;
            return this;
        }

        public ContextBuilder intermediateCombineDegree(Integer intermediateCombineDegree) {
            this.intermediateCombineDegree = intermediateCombineDegree;
            return this;
        }

        public ContextBuilder numParallelCombineThreads(Integer numParallelCombineThreads) {
            this.numParallelCombineThreads = numParallelCombineThreads;
            return this;
        }

        public ContextBuilder sortByDimsFirst(Boolean sortByDimsFirst) {
            this.sortByDimsFirst = sortByDimsFirst;
            return this;
        }

        public ContextBuilder forceLimitPushDown(Boolean forceLimitPushDown) {
            this.forceLimitPushDown = forceLimitPushDown;
            return this;
        }

        public ContextBuilder applyLimitPushDown(Boolean applyLimitPushDown) {
            this.applyLimitPushDown = applyLimitPushDown;
            return this;
        }

        public ContextBuilder maxIntermediateRows(Integer maxIntermediateRows) {
            this.maxIntermediateRows = maxIntermediateRows;
            return this;
        }

        public ContextBuilder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public ContextBuilder useOffheap(Boolean useOffheap) {
            this.useOffheap = useOffheap;
            return this;
        }

        public ContextBuilder vectorize(Vectorize vectorize) {
            this.vectorize = vectorize;
            return this;
        }

        public ContextBuilder vectorSize(Integer vectorSize) {
            this.vectorSize = vectorSize;
            return this;
        }

        public Context build() {
            return new Context(this.timeoutInMilliSeconds, this.priority, this.queryId, this.useCache, this.populateCache, this.useResultLevelCache, this.populateResultLevelCache, this.bySegment, this.finalize, this.chunkPeriod, this.maxScatterGatherBytes, this.maxQueuedBytes, this.serializeDateTimeAsLong, this.serializeDateTimeAsLongInner, this.minTopNThreshold, this.skipEmptyBuckets, this.maxMergingDictionarySize, this.maxOnDiskStorage, this.groupByStrategy, this.groupByIsSingleThreaded, this.bufferGrouperInitialBuckets, this.bufferGrouperMaxLoadFactor, this.forceHashAggregation, this.intermediateCombineDegree, this.numParallelCombineThreads, this.sortByDimsFirst, this.forceLimitPushDown, this.applyLimitPushDown, this.maxIntermediateRows, this.maxResults, this.useOffheap, this.vectorize, this.vectorSize);
        }

        public String toString() {
            return "Context.ContextBuilder(timeoutInMilliSeconds=" + this.timeoutInMilliSeconds + ", priority=" + this.priority + ", queryId=" + this.queryId + ", useCache=" + this.useCache + ", populateCache=" + this.populateCache + ", useResultLevelCache=" + this.useResultLevelCache + ", populateResultLevelCache=" + this.populateResultLevelCache + ", bySegment=" + this.bySegment + ", finalize=" + this.finalize + ", chunkPeriod=" + this.chunkPeriod + ", maxScatterGatherBytes=" + this.maxScatterGatherBytes + ", maxQueuedBytes=" + this.maxQueuedBytes + ", serializeDateTimeAsLong=" + this.serializeDateTimeAsLong + ", serializeDateTimeAsLongInner=" + this.serializeDateTimeAsLongInner + ", minTopNThreshold=" + this.minTopNThreshold + ", skipEmptyBuckets=" + this.skipEmptyBuckets + ", maxMergingDictionarySize=" + this.maxMergingDictionarySize + ", maxOnDiskStorage=" + this.maxOnDiskStorage + ", groupByStrategy=" + (Object)((Object)this.groupByStrategy) + ", groupByIsSingleThreaded=" + this.groupByIsSingleThreaded + ", bufferGrouperInitialBuckets=" + this.bufferGrouperInitialBuckets + ", bufferGrouperMaxLoadFactor=" + this.bufferGrouperMaxLoadFactor + ", forceHashAggregation=" + this.forceHashAggregation + ", intermediateCombineDegree=" + this.intermediateCombineDegree + ", numParallelCombineThreads=" + this.numParallelCombineThreads + ", sortByDimsFirst=" + this.sortByDimsFirst + ", forceLimitPushDown=" + this.forceLimitPushDown + ", applyLimitPushDown=" + this.applyLimitPushDown + ", maxIntermediateRows=" + this.maxIntermediateRows + ", maxResults=" + this.maxResults + ", useOffheap=" + this.useOffheap + ", vectorize=" + (Object)((Object)this.vectorize) + ", vectorSize=" + this.vectorSize + ")";
        }
    }
}

