/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.script;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.MoreExecutors;
import info.archinnov.achilles.internals.futures.FutureUtils;
import info.archinnov.achilles.internals.statement.StatementHelper;
import info.archinnov.achilles.validation.Validator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptExecutor {
    private static final Logger DML_LOGGER = LoggerFactory.getLogger((String)"ACHILLES_DML_STATEMENT");
    private static final Logger DDL_LOGGER = LoggerFactory.getLogger((String)"ACHILLES_DDL_SCRIPT");
    private static final String COMMA = ";";
    private static final String BATCH_BEGIN = "BEGIN";
    private static final String BATCH_APPLY = "APPLY";
    private static final String CODE_DELIMITER_START = "^\\s*(?:AS)?\\s*\\$\\$\\s*$";
    private static final String CODE_DELIMITER_END = "^\\s*\\$\\$\\s*;\\s*$";
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{([a-z][a-zA-Z0-9_]*)\\}");
    private static final Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[\\{\\}\\(\\)\\[\\]\\.\\+\\*\\?\\^\\$\\\\\\|]");
    private static final Map<String, Object> EMPTY_MAP = new HashMap<String, Object>();
    private final ExecutorService sameThreadExecutor = MoreExecutors.newDirectExecutorService();
    private final Session session;

    public ScriptExecutor(Session session) {
        this.session = session;
    }

    public void executeScript(String scriptLocation) {
        this.executeScriptTemplate(scriptLocation, EMPTY_MAP);
    }

    public void executeScriptTemplate(String scriptTemplateLocation, Map<String, Object> values) {
        List<SimpleStatement> statements = this.buildStatements(this.loadScriptAsLines(scriptTemplateLocation, values));
        for (SimpleStatement statement : statements) {
            if (StatementHelper.isDMLStatement((Statement)statement)) {
                DML_LOGGER.debug("\tSCRIPT : {}\n", (Object)statement.getQueryString());
            } else {
                DDL_LOGGER.debug("\tSCRIPT : {}\n", (Object)statement.getQueryString());
            }
            this.session.execute((Statement)statement);
        }
    }

    public ResultSet execute(String statement) {
        return this.session.execute(statement);
    }

    public ResultSet execute(Statement statement) {
        return this.session.execute(statement);
    }

    public CompletableFuture<ResultSet> executeAsync(String statement) {
        return FutureUtils.toCompletableFuture(this.session.executeAsync(statement), this.sameThreadExecutor);
    }

    public CompletableFuture<ResultSet> executeAsync(Statement statement) {
        return FutureUtils.toCompletableFuture(this.session.executeAsync(statement), this.sameThreadExecutor);
    }

    protected List<String> loadScriptAsLines(String scriptLocation) {
        return this.loadScriptAsLines(scriptLocation, EMPTY_MAP);
    }

    protected List<String> loadScriptAsLines(String scriptLocation, Map<String, Object> variables) {
        InputStream inputStream = this.getClass().getResourceAsStream("/" + scriptLocation);
        Validator.validateNotNull((Object)inputStream, (String)"Cannot find CQL script file at location '%s'", (Object[])new Object[]{scriptLocation});
        Scanner scanner = new Scanner(inputStream);
        ArrayList<String> lines = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            String nextLine = this.maybeReplaceVariables(scanner, variables);
            if (!StringUtils.isNotBlank((CharSequence)nextLine)) continue;
            lines.add(nextLine);
        }
        return lines;
    }

    private String maybeReplaceVariables(Scanner scanner, Map<String, Object> variables) {
        String nextLine = scanner.nextLine().trim();
        if (StringUtils.isNotBlank((CharSequence)nextLine) && !variables.isEmpty()) {
            Matcher matcher = VARIABLE_PATTERN.matcher(nextLine);
            while (matcher.find()) {
                String group = matcher.group(1);
                Validator.validateTrue((boolean)variables.containsKey(group), (String)"Cannot find value for variable ${%s} in the variable map provided to ScriptExecutor", (Object[])new Object[]{group});
                String replacement = SPECIAL_REGEX_CHARS.matcher(variables.get(group).toString()).replaceAll("\\\\$0");
                nextLine = nextLine.replaceFirst("\\$\\{" + group + "\\}", replacement);
            }
        }
        return nextLine;
    }

    protected List<SimpleStatement> buildStatements(List<String> lines) {
        ArrayList<SimpleStatement> statements = new ArrayList<SimpleStatement>();
        StringBuilder statement = new StringBuilder();
        boolean batch = false;
        boolean codeBlock = false;
        StringBuilder batchStatement = new StringBuilder();
        for (String line : lines) {
            if (line.trim().startsWith(BATCH_BEGIN)) {
                batch = true;
            }
            if (line.trim().matches(CODE_DELIMITER_START)) {
                codeBlock = !codeBlock;
            }
            if (batch) {
                batchStatement.append(" ").append(line);
                if (!line.trim().startsWith(BATCH_APPLY)) continue;
                batch = false;
                statements.add(new SimpleStatement(batchStatement.toString()));
                batchStatement = new StringBuilder();
                continue;
            }
            if (codeBlock) {
                statement.append(line);
                if (!line.trim().matches(CODE_DELIMITER_END)) continue;
                codeBlock = false;
                statements.add(new SimpleStatement(statement.toString()));
                statement = new StringBuilder();
                continue;
            }
            statement.append(line);
            if (line.trim().endsWith(COMMA)) {
                statements.add(new SimpleStatement(statement.toString()));
                statement = new StringBuilder();
                continue;
            }
            statement.append(" ");
        }
        return statements;
    }

    public Session getSession() {
        return this.session;
    }
}

