/*
 * Decompiled with CFR 0.152.
 */
package info.batey.kafka.unit;

import info.batey.kafka.unit.KafkaUnit;
import java.io.IOException;
import org.junit.rules.ExternalResource;

public class KafkaUnitRule
extends ExternalResource {
    private final KafkaUnit kafkaUnit;

    public KafkaUnitRule() {
        try {
            this.kafkaUnit = new KafkaUnit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public KafkaUnitRule(int zkPort, int kafkaPort) {
        this.kafkaUnit = new KafkaUnit(zkPort, kafkaPort);
    }

    public KafkaUnitRule(String zkConnectionString, String kafkaConnectionString) {
        this.kafkaUnit = new KafkaUnit(zkConnectionString, kafkaConnectionString);
    }

    public KafkaUnitRule(int zkPort, int kafkaPort, int zkMaxConnections) {
        this.kafkaUnit = new KafkaUnit(zkPort, kafkaPort, zkMaxConnections);
    }

    public KafkaUnitRule(String zkConnectionString, String kafkaConnectionString, int zkMaxConnections) {
        this.kafkaUnit = new KafkaUnit(zkConnectionString, kafkaConnectionString, zkMaxConnections);
    }

    protected void before() throws Throwable {
        this.kafkaUnit.startup();
    }

    protected void after() {
        this.kafkaUnit.shutdown();
    }

    public int getZkPort() {
        return this.kafkaUnit.getZkPort();
    }

    public int getKafkaPort() {
        return this.kafkaUnit.getBrokerPort();
    }

    public KafkaUnit getKafkaUnit() {
        return this.kafkaUnit;
    }
}

