/*
 * Decompiled with CFR 0.152.
 */
package info.batey.kafka.unit;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;

public class Zookeeper {
    private int port;
    private int maxConnections;
    private ServerCnxnFactory factory;

    public Zookeeper(int port) {
        this.port = port;
        this.maxConnections = 16;
    }

    public Zookeeper(int port, int maxConnections) {
        this.port = port;
        this.maxConnections = maxConnections;
    }

    public void startup() {
        File logDir;
        File snapshotDir;
        try {
            snapshotDir = Files.createTempDirectory("zookeeper-snapshot", new FileAttribute[0]).toFile();
            logDir = Files.createTempDirectory("zookeeper-logs", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to start Kafka", e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    FileUtils.deleteDirectory((File)snapshotDir);
                    FileUtils.deleteDirectory((File)logDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        try {
            int tickTime = 500;
            ZooKeeperServer zkServer = new ZooKeeperServer(snapshotDir, logDir, tickTime);
            this.factory = NIOServerCnxnFactory.createFactory();
            this.factory.configure(new InetSocketAddress("localhost", this.port), this.maxConnections);
            this.factory.startup(zkServer);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to start ZooKeeper", e);
        }
    }

    public void shutdown() {
        this.factory.shutdown();
    }
}

