/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.fhir.npm;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.cqframework.fhir.npm.NpmPackageManagerException;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_40_50;
import org.hl7.fhir.convertors.conv40_50.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.formats.FormatUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.JsonTrackingParser;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class NpmPackageManager
implements IWorkerContext.ILoggingService {
    private FilesystemPackageCacheManager pcm;
    private List<NpmPackage> npmList = new ArrayList<NpmPackage>();
    private String version;
    private ImplementationGuide sourceIg;

    public List<NpmPackage> getNpmList() {
        return this.npmList;
    }

    public String getVersion() {
        return this.version;
    }

    public ImplementationGuide getSourceIg() {
        return this.sourceIg;
    }

    public static NpmPackageManager fromPath(String igPath, String version) throws IOException {
        if (igPath == null || igPath.equals("")) {
            throw new IllegalArgumentException("igPath is required");
        }
        VersionConvertor_40_50 versionConvertor_40_50 = new VersionConvertor_40_50(new BaseAdvisor_40_50());
        return new NpmPackageManager((ImplementationGuide)versionConvertor_40_50.convertResource(FormatUtilities.loadFile((String)igPath)), version);
    }

    public static NpmPackageManager fromStream(InputStream is, String version) throws IOException {
        VersionConvertor_40_50 versionConvertor_40_50 = new VersionConvertor_40_50(new BaseAdvisor_40_50());
        return new NpmPackageManager((ImplementationGuide)versionConvertor_40_50.convertResource(FormatUtilities.loadFile((InputStream)is)), version);
    }

    public NpmPackageManager(ImplementationGuide sourceIg, String version) throws IOException {
        if (version == null || version.equals("")) {
            throw new IllegalArgumentException("version is required");
        }
        this.version = version;
        if (sourceIg == null) {
            throw new IllegalArgumentException("sourceIg is required");
        }
        this.sourceIg = sourceIg;
        try {
            this.pcm = new FilesystemPackageCacheManager(true, 3);
        }
        catch (IOException e) {
            String message = "error creating the FilesystemPackageCacheManager";
            this.logMessage(message);
            throw new NpmPackageManagerException(message, e);
        }
        this.loadCorePackage();
        int i = 0;
        for (ImplementationGuide.ImplementationGuideDependsOnComponent dep : sourceIg.getDependsOn()) {
            this.loadIg(dep, i);
            ++i;
        }
    }

    private void loadCorePackage() {
        NpmPackage pi = null;
        String v = this.version.equals("5.0.0-snapshot1") ? "current" : this.version;
        this.logMessage("Core Package " + VersionUtilities.packageForVersion((String)v) + "#" + v);
        try {
            pi = this.pcm.loadPackage(VersionUtilities.packageForVersion((String)v), v);
        }
        catch (Exception e) {
            try {
                pi = this.pcm.loadPackage(VersionUtilities.packageForVersion((String)v), v);
            }
            catch (Exception ex) {
                throw new NpmPackageManagerException("Error loading core package", e);
            }
        }
        if (pi == null) {
            throw new NpmPackageManagerException("Could not load core package");
        }
        if (v.equals("current")) {
            throw new IllegalArgumentException("Current core package not supported");
        }
        this.npmList.add(pi);
    }

    private void loadIg(ImplementationGuide.ImplementationGuideDependsOnComponent dep, int index) throws IOException {
        String cu;
        NpmPackage pi;
        Object name = dep.getId();
        if (!dep.hasId()) {
            this.logMessage("Dependency '" + this.idForDep(dep) + "' has no id, so can't be referred to in markdown in the IG");
            name = "u" + Utilities.makeUuidLC().replace("-", "");
        }
        if (!this.isValidIGToken((String)name)) {
            throw new IllegalArgumentException("IG Name must be a valid token (" + (String)name + ")");
        }
        String canonical = this.determineCanonical(dep.getUri(), "ImplementationGuide.dependency[" + index + "].url");
        String packageId = dep.getPackageId();
        if (Utilities.noString((String)packageId)) {
            packageId = this.pcm.getPackageId(canonical);
        }
        if (Utilities.noString((String)canonical) && !Utilities.noString((String)packageId)) {
            canonical = this.pcm.getPackageUrl(packageId);
        }
        if (Utilities.noString((String)canonical)) {
            throw new IllegalArgumentException("You must specify a canonical URL for the IG " + (String)name);
        }
        String igver = dep.getVersion();
        if (Utilities.noString((String)igver)) {
            throw new IllegalArgumentException("You must specify a version for the IG " + packageId + " (" + canonical + ")");
        }
        NpmPackage npmPackage = pi = packageId == null ? null : this.pcm.loadPackageFromCacheOnly(packageId, igver);
        if (pi != null) {
            this.npmList.add(pi);
        }
        if (pi == null) {
            pi = this.resolveDependency(canonical, packageId, igver);
            if (pi == null) {
                if (Utilities.noString((String)packageId)) {
                    throw new IllegalArgumentException("Package Id for guide at " + canonical + " is unknown (contact FHIR Product Director");
                }
                throw new IllegalArgumentException("Unknown Package " + packageId + "#" + igver);
            }
            this.npmList.add(pi);
        }
        this.logDebugMessage(IWorkerContext.ILoggingService.LogCategory.INIT, "Load " + (String)name + " (" + canonical + ") from " + packageId + "#" + igver);
        if (dep.hasUri() && !dep.getUri().contains("/ImplementationGuide/") && (cu = this.getIgUri(pi)) != null) {
            this.logMessage("The correct canonical URL for this dependency is " + cu);
        }
    }

    private String determineCanonical(String url, String path) throws FHIRException {
        if (url == null) {
            return url;
        }
        if (url.contains("/ImplementationGuide/")) {
            return url.substring(0, url.indexOf("/ImplementationGuide/"));
        }
        if (path != null) {
            this.logMessage("The canonical URL for an Implementation Guide must point directly to the implementation guide resource, not to the Implementation Guide as a whole");
        }
        return url;
    }

    private boolean isValidIGToken(String tail) {
        if (tail == null || tail.length() == 0) {
            return false;
        }
        boolean result = Utilities.isAlphabetic((char)tail.charAt(0));
        for (int i = 1; i < tail.length(); ++i) {
            result = result && (Utilities.isAlphabetic((char)tail.charAt(i)) || Utilities.isDigit((char)tail.charAt(i)) || tail.charAt(i) == '_');
        }
        return result;
    }

    private String idForDep(ImplementationGuide.ImplementationGuideDependsOnComponent dep) {
        if (dep.hasPackageId()) {
            return dep.getPackageId();
        }
        if (dep.hasUri()) {
            return dep.getUri();
        }
        return "{no id}";
    }

    private String getIgUri(NpmPackage pi) throws IOException {
        for (String rs : pi.listResources(new String[]{"ImplementationGuide"})) {
            JsonObject json = JsonTrackingParser.parseJson((InputStream)pi.loadResource(rs));
            if (!json.has("packageId") || !json.get("packageId").getAsString().equals(pi.name()) || !json.has("url")) continue;
            return json.get("url").getAsString();
        }
        return null;
    }

    private NpmPackage resolveDependency(String canonical, String packageId, String igver) throws IOException {
        JsonObject pl;
        if (packageId != null) {
            return this.pcm.loadPackage(packageId, igver);
        }
        this.logDebugMessage(IWorkerContext.ILoggingService.LogCategory.INIT, "Fetch Package history from " + Utilities.pathURL((String[])new String[]{canonical, "package-list.json"}));
        try {
            pl = this.fetchJson(Utilities.pathURL((String[])new String[]{canonical, "package-list.json"}));
        }
        catch (Exception e) {
            return null;
        }
        if (!canonical.equals(pl.get("canonical").getAsString())) {
            throw new IllegalArgumentException("Canonical mismatch fetching package list for " + canonical + "#" + igver + ", package-list.json says " + pl.get("canonical"));
        }
        for (JsonElement e : pl.getAsJsonArray("list")) {
            JsonObject o = (JsonObject)e;
            if (!igver.equals(o.get("version").getAsString())) continue;
            InputStream src = this.fetchFromSource(pl.get("package-id").getAsString() + "-" + igver, Utilities.pathURL((String[])new String[]{o.get("path").getAsString(), "package.tgz"}));
            return this.pcm.addPackageToCache(pl.get("package-id").getAsString(), igver, src, Utilities.pathURL((String[])new String[]{o.get("path").getAsString(), "package.tgz"}));
        }
        return null;
    }

    private JsonObject fetchJson(String source) throws IOException {
        URL url = new URL(source + "?nocache=" + System.currentTimeMillis());
        HttpURLConnection c = (HttpURLConnection)url.openConnection();
        c.setInstanceFollowRedirects(true);
        return JsonTrackingParser.parseJson((InputStream)c.getInputStream());
    }

    private InputStream fetchFromSource(String id, String source) throws IOException {
        this.logDebugMessage(IWorkerContext.ILoggingService.LogCategory.INIT, "Fetch " + id + " package from " + source);
        URL url = new URL(source + "?nocache=" + System.currentTimeMillis());
        URLConnection c = url.openConnection();
        return c.getInputStream();
    }

    public void logMessage(String msg) {
    }

    public void logDebugMessage(IWorkerContext.ILoggingService.LogCategory category, String msg) {
        this.logMessage(msg);
    }
}

