/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.fhir.npm;

import ca.uhn.fhir.model.primitive.IdDt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cqframework.fhir.npm.NpmPackageManagerException;
import org.hl7.fhir.r5.context.ILoggingService;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpmPackageManager
implements ILoggingService {
    private static final Logger logger = LoggerFactory.getLogger(NpmPackageManager.class);
    private final ImplementationGuide sourceIg;
    private final FilesystemPackageCacheManager fspcm;
    private final List<NpmPackage> npmList;

    public NpmPackageManager(ImplementationGuide sourceIg) {
        this(sourceIg, null, null);
    }

    public NpmPackageManager(ImplementationGuide sourceIg, FilesystemPackageCacheManager fspcm) {
        this(sourceIg, fspcm, null);
    }

    public NpmPackageManager(ImplementationGuide sourceIg, FilesystemPackageCacheManager fspcm, List<NpmPackage> npmList) {
        this.sourceIg = sourceIg;
        this.npmList = npmList == null ? new ArrayList() : npmList;
        try {
            this.fspcm = fspcm != null ? fspcm : new FilesystemPackageCacheManager.Builder().build();
            this.loadDependencies();
        }
        catch (Exception e) {
            this.logErrorMessage(e.getMessage());
            throw new NpmPackageManagerException(e.getMessage());
        }
    }

    public void loadDependencies() throws IOException {
        for (Enumeration fhirVersion : this.sourceIg.getFhirVersion()) {
            String coreFhirVersion = VersionUtilities.packageForVersion((String)fhirVersion.getCode());
            this.logMessage("Loading core FHIR version " + coreFhirVersion);
            this.npmList.add(this.fspcm.loadPackage(coreFhirVersion, fhirVersion.getCode()));
        }
        for (ImplementationGuide.ImplementationGuideDependsOnComponent dependency : this.sourceIg.getDependsOn()) {
            NpmPackage dependencyPackage = null;
            if (dependency.hasPackageId() && !this.hasPackage(dependency.getPackageId(), false)) {
                this.logMessage("Loading package: " + dependency.getPackageId());
                dependencyPackage = this.fspcm.loadPackage(dependency.getPackageId(), dependency.hasVersion() ? dependency.getVersion() : "current");
                this.npmList.add(dependencyPackage);
            } else if (dependency.hasUri() && !this.hasPackage(dependency.getUri(), true)) {
                IdDt id = new IdDt(dependency.getUri());
                this.logMessage("Loading package: " + id.getIdPart());
                dependencyPackage = this.fspcm.loadPackage(id.getIdPart(), dependency.hasVersion() ? dependency.getVersion() : "current");
                this.npmList.add(dependencyPackage);
            } else {
                String dependencyIdentifier = dependency.hasId() ? dependency.getId() : "";
                this.logWarningMessage("Dependency " + dependencyIdentifier + "missing packageId and uri, so can't be referred to in markdown in the IG");
            }
            if (dependencyPackage == null) continue;
            this.loadDependencies(dependencyPackage);
        }
    }

    public void loadDependencies(NpmPackage parentPackage) throws IOException {
        for (String dependency : parentPackage.dependencies()) {
            if (this.hasPackage(dependency, false)) continue;
            this.logMessage("Loading package: " + dependency);
            NpmPackage childPackage = this.fspcm.loadPackage(dependency);
            this.npmList.add(childPackage);
            if (childPackage.dependencies().isEmpty()) continue;
            this.loadDependencies(childPackage);
        }
    }

    public boolean hasPackage(String packageId, boolean isUrl) {
        Iterator<NpmPackage> iterator = this.npmList.iterator();
        if (iterator.hasNext()) {
            NpmPackage npmPackage = iterator.next();
            if (!isUrl) {
                return npmPackage.getNpm().has("name") && packageId.startsWith(npmPackage.getNpm().get("name").asString());
            }
            return npmPackage.getNpm().has("canonical") && packageId.equals(npmPackage.getNpm().get("canonical").asString());
        }
        return false;
    }

    public List<NpmPackage> getNpmList() {
        return this.npmList;
    }

    public ImplementationGuide getSourceIg() {
        return this.sourceIg;
    }

    public void logMessage(String message) {
        logger.info(message);
    }

    public void logDebugMessage(ILoggingService.LogCategory category, String message) {
        logger.debug(message);
    }

    public void logWarningMessage(String message) {
        logger.warn(message);
    }

    public void logErrorMessage(String message) {
        logger.error(message);
    }

    public boolean isDebugLogging() {
        return logger.isDebugEnabled();
    }
}

