/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.fhir.npm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.cqframework.fhir.npm.ILibraryReader;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.r5.context.ILoggingService;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class NpmLibrarySourceProvider
implements LibrarySourceProvider {
    private List<NpmPackage> packages;
    private ILibraryReader reader;
    private ILoggingService logger;

    public NpmLibrarySourceProvider(List<NpmPackage> packages, ILibraryReader reader, ILoggingService logger) {
        this.packages = packages;
        this.reader = reader;
        this.logger = logger;
    }

    public InputStream getLibrarySource(VersionedIdentifier identifier) {
        for (NpmPackage p : this.packages) {
            try {
                InputStream s;
                VersionedIdentifier libraryIdentifier = new VersionedIdentifier().withId(identifier.getId()).withVersion(identifier.getVersion()).withSystem(identifier.getSystem());
                if (libraryIdentifier.getSystem() == null) {
                    libraryIdentifier.setSystem(p.canonical());
                }
                if ((s = p.loadByCanonicalVersion(libraryIdentifier.getSystem() + "/Library/" + libraryIdentifier.getId(), libraryIdentifier.getVersion())) == null) continue;
                Library l = this.reader.readLibrary(s);
                for (Attachment a : l.getContent()) {
                    if (a.getContentType() == null || !a.getContentType().equals("text/cql")) continue;
                    if (identifier.getSystem() == null) {
                        identifier.setSystem(libraryIdentifier.getSystem());
                    }
                    return new ByteArrayInputStream(a.getData());
                }
            }
            catch (IOException e) {
                this.logger.logDebugMessage(ILoggingService.LogCategory.PROGRESS, String.format("Exceptions occurred attempting to load npm library source for %s", identifier.toString()));
            }
        }
        return null;
    }
}

