/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.fhir.utilities;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.cqframework.fhir.utilities.IGUtils;
import org.cqframework.fhir.utilities.exception.IGInitializationException;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_30_50;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_40_50;
import org.hl7.fhir.convertors.conv30_50.VersionConvertor_30_50;
import org.hl7.fhir.convertors.conv40_50.VersionConvertor_40_50;
import org.hl7.fhir.dstu3.formats.ParserBase;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r5.context.ILoggingService;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.formats.FormatUtilities;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;

public class IGContext {
    private ILoggingService logger;
    protected String rootDir;
    protected ImplementationGuide sourceIg;
    protected String fhirVersion;
    protected String packageId;
    protected String canonicalBase;
    private List<String> binaryPaths;

    public ILoggingService getLogger() {
        return this.logger;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public ImplementationGuide getSourceIg() {
        return this.sourceIg;
    }

    public String getFhirVersion() {
        return this.fhirVersion;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public String getCanonicalBase() {
        return this.canonicalBase;
    }

    public List<String> getBinaryPaths() {
        return this.binaryPaths;
    }

    protected void setBinaryPaths(List<String> binaryPaths) {
        this.binaryPaths = binaryPaths;
    }

    public IGContext(ILoggingService logger) {
        this.logger = logger;
    }

    public void initializeFromIg(String rootDir, String igPath, String fhirVersion) {
        this.rootDir = rootDir;
        try {
            igPath = Utilities.path((String[])new String[]{rootDir, igPath});
        }
        catch (IOException e) {
            String message = String.format("Exceptions occurred creating igPath from source rootDir: %s, and igPath: %s", rootDir, igPath);
            this.logMessage(message);
            throw new IGInitializationException(message, e);
        }
        if (fhirVersion != null) {
            this.loadSourceIG(igPath, fhirVersion);
        } else {
            this.loadSourceIG(igPath);
        }
        this.fhirVersion = ((Enumeration)this.sourceIg.getFhirVersion().get(0)).getCode();
        this.packageId = this.sourceIg.getPackageId();
        this.canonicalBase = IGUtils.getImplementationGuideCanonicalBase(this.sourceIg.getUrl());
        this.binaryPaths = IGUtils.extractBinaryPaths(rootDir, this.sourceIg);
    }

    public void initializeFromIni(String iniFile) {
        try {
            IniFile ini = new IniFile(new File(iniFile).getAbsolutePath());
            String iniDir = Utilities.getDirectoryForFile((String)ini.getFileName());
            String igPath = ini.getStringProperty("IG", "ig");
            String specifiedFhirVersion = ini.getStringProperty("IG", "fhir-version");
            if (specifiedFhirVersion == null || specifiedFhirVersion == "") {
                this.logMessage("fhir-version was not specified in the ini file. Trying FHIR version 4.0.1");
                specifiedFhirVersion = "4.0.1";
            }
            this.initializeFromIg(iniDir, igPath, specifiedFhirVersion);
        }
        catch (Exception e) {
            String message = String.format("Exceptions occurred initializing refresh from ini file '%s':%s", iniFile, e.getMessage());
            this.logMessage(message);
            throw new IGInitializationException(message, e);
        }
    }

    private ImplementationGuide loadSourceIG(String igPath) {
        try {
            try {
                this.sourceIg = (ImplementationGuide)FormatUtilities.loadFile((String)igPath);
            }
            catch (IOException | FHIRException e) {
                try {
                    VersionConvertor_40_50 versionConvertor_40_50 = new VersionConvertor_40_50(new BaseAdvisor_40_50());
                    this.sourceIg = (ImplementationGuide)versionConvertor_40_50.convertResource(org.hl7.fhir.r4.formats.FormatUtilities.loadFile((String)igPath));
                }
                catch (IOException | FHIRException ex) {
                    byte[] src = TextFile.fileToBytes((String)igPath);
                    Manager.FhirFormat fmt = FormatUtilities.determineFormat((byte[])src);
                    ParserBase parser = org.hl7.fhir.dstu3.formats.FormatUtilities.makeParser((String)fmt.toString());
                    VersionConvertor_30_50 versionConvertor_30_50 = new VersionConvertor_30_50(new BaseAdvisor_30_50());
                    this.sourceIg = (ImplementationGuide)versionConvertor_30_50.convertResource(parser.parse(src));
                }
            }
        }
        catch (IOException | FHIRException e) {
            throw new IGInitializationException(String.format("error initializing IG from igPath: %s", igPath), e);
        }
        return this.sourceIg;
    }

    private ImplementationGuide loadSourceIG(String igPath, String specifiedFhirVersion) {
        block5: {
            try {
                if (VersionUtilities.isR3Ver((String)specifiedFhirVersion)) {
                    byte[] src = TextFile.fileToBytes((String)igPath);
                    Manager.FhirFormat fmt = FormatUtilities.determineFormat((byte[])src);
                    ParserBase parser = org.hl7.fhir.dstu3.formats.FormatUtilities.makeParser((String)fmt.toString());
                    VersionConvertor_30_50 versionConvertor_30_50 = new VersionConvertor_30_50(new BaseAdvisor_30_50());
                    this.sourceIg = (ImplementationGuide)versionConvertor_30_50.convertResource(parser.parse(src));
                    break block5;
                }
                if (VersionUtilities.isR4Ver((String)specifiedFhirVersion)) {
                    Resource res = org.hl7.fhir.r4.formats.FormatUtilities.loadFile((String)igPath);
                    VersionConvertor_40_50 versionConvertor_40_50 = new VersionConvertor_40_50(new BaseAdvisor_40_50());
                    this.sourceIg = (ImplementationGuide)versionConvertor_40_50.convertResource(res);
                    break block5;
                }
                if (VersionUtilities.isR5Ver((String)specifiedFhirVersion)) {
                    this.sourceIg = (ImplementationGuide)FormatUtilities.loadFile((String)igPath);
                    break block5;
                }
                throw new FHIRException("Unknown Version '" + specifiedFhirVersion + "'");
            }
            catch (IOException e) {
                String message = String.format("Exceptions occurred loading IG path: %s", igPath);
                this.logMessage(message);
                throw new IGInitializationException(message, e);
            }
        }
        return this.sourceIg;
    }

    public void logMessage(String msg) {
        if (this.logger != null) {
            this.logger.logMessage(msg);
        }
    }
}

