/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.fhir.utilities;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.utilities.Utilities;

public class IGUtils {
    public static String getImplementationGuideCanonicalBase(String url) {
        String canonicalBase = null;
        if (url != null && !url.isEmpty()) {
            canonicalBase = url.substring(0, url.indexOf("/ImplementationGuide/"));
        }
        return canonicalBase;
    }

    public static ArrayList<String> extractResourcePaths(String rootDir, ImplementationGuide sourceIg) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        for (ImplementationGuide.ImplementationGuideDefinitionParameterComponent p : sourceIg.getDefinition().getParameter()) {
            if (!p.getCode().equals("path-resource")) continue;
            result.add(Utilities.path((String[])new String[]{rootDir, p.getValue()}));
        }
        File resources = new File(Utilities.path((String[])new String[]{rootDir, "input/resources"}));
        if (resources.exists() && resources.isDirectory()) {
            result.add(resources.getAbsolutePath());
        }
        return result;
    }

    public static List<String> extractBinaryPaths(String rootDir, ImplementationGuide sourceIg) {
        ArrayList<String> result = new ArrayList<String>();
        File input = IGUtils.tryDirectory(rootDir, "input/cql");
        if (input != null && input.exists() && input.isDirectory()) {
            result.add(input.getAbsolutePath());
        }
        if ((input = IGUtils.tryDirectory(rootDir, "input/pagecontent/cql")) != null && input.exists() && input.isDirectory()) {
            result.add(input.getAbsolutePath());
        }
        return result;
    }

    protected static File tryDirectory(String rootDir, String path) {
        String combinedPath = null;
        try {
            combinedPath = Utilities.path((String[])new String[]{rootDir, path});
        }
        catch (IOException e) {
            return null;
        }
        return new File(combinedPath);
    }
}

