/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.tools.formatter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.cqframework.cql.gen.cqlBaseVisitor;
import org.cqframework.cql.gen.cqlLexer;
import org.cqframework.cql.gen.cqlParser;

public class CqlFormatterVisitor
extends cqlBaseVisitor<Object> {
    private static List<CommentToken> comments = new ArrayList<CommentToken>();
    private boolean useSpaces = true;
    private int indentSize = 2;
    private StringBuilder output;
    private final char space = (char)32;
    private final char tab = (char)9;
    private final String newLine = "\r\n";
    private int currentLine = 0;
    private boolean onNewLine;
    private boolean needsWhitespace;
    private int indentLevel = 0;
    private int previousIndentLevel = 0;
    private boolean isFirstTupleElement = false;
    private String currentSection;
    private int sectionCount = 0;
    private int typeSpecifierLevel = 0;
    private int functionDefinitionLevel = 0;
    private int functionInvocationLevel = 0;
    private int retrieveLevel = 0;
    private Stack<Integer> groups;

    public static FormatResult getFormattedOutput(InputStream is) throws IOException {
        CharStream in = CharStreams.fromStream((InputStream)is);
        cqlLexer lexer = new cqlLexer(in);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        tokens.fill();
        CqlFormatterVisitor.populateComments(tokens);
        cqlParser parser = new cqlParser((TokenStream)tokens);
        parser.addErrorListener((ANTLRErrorListener)new SyntaxErrorListener());
        parser.setBuildParseTree(true);
        cqlParser.LibraryContext tree = parser.library();
        if (((SyntaxErrorListener)((Object)parser.getErrorListeners().get(1))).errors.size() > 0) {
            return new FormatResult(((SyntaxErrorListener)((Object)parser.getErrorListeners().get(1))).errors, in.toString());
        }
        CqlFormatterVisitor formatter = new CqlFormatterVisitor();
        String output = (String)formatter.visit((ParseTree)tree);
        if (comments.size() > 0) {
            StringBuilder eofComments = new StringBuilder();
            for (CommentToken comment : comments) {
                eofComments.append(comment.whitespaceBefore).append(comment.token.getText());
            }
            comments.clear();
            output = output + eofComments.toString();
        }
        return new FormatResult(new ArrayList<Exception>(), output);
    }

    public static String getInputStreamAsString(InputStream is) {
        return new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining("\n"));
    }

    public static void populateComments(CommonTokenStream tokens) {
        for (Token token : tokens.getTokens()) {
            if (!token.getText().startsWith("//") && !token.getText().startsWith("/*")) continue;
            String whitespace = token.getTokenIndex() < 1 ? "" : tokens.get(token.getTokenIndex() - 1).getText();
            comments.add(new CommentToken(token, whitespace.matches("\\s+") ? whitespace : ""));
        }
    }

    public boolean getUseSpaces() {
        return this.useSpaces;
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    private void newSection(String section) {
        if (this.hasSectionContent()) {
            this.resetIndentLevel();
            this.newLine();
        }
        this.sectionCount = 0;
        this.currentSection = section;
    }

    private boolean needsSectionSeparator(String section) {
        switch (section) {
            case "statement": {
                return true;
            }
        }
        return false;
    }

    private void ensureSectionSeparator() {
        if (this.needsSectionSeparator(this.currentSection) && this.hasSectionContent()) {
            this.resetIndentLevel();
            this.newLine();
        }
    }

    private void addToSection(String section) {
        if (!section.equals(this.currentSection)) {
            this.newSection(section);
        }
        this.ensureSectionSeparator();
        ++this.sectionCount;
    }

    private boolean hasSectionContent() {
        return this.sectionCount > 0;
    }

    private void enterTypeSpecifier() {
        ++this.typeSpecifierLevel;
    }

    private void exitTypeSpecifier() {
        --this.typeSpecifierLevel;
    }

    private boolean inTypeSpecifier() {
        return this.typeSpecifierLevel > 0;
    }

    private void enterFunctionDefinition() {
        ++this.functionDefinitionLevel;
    }

    private void exitFunctionDefinition() {
        --this.functionDefinitionLevel;
    }

    private boolean inFunctionDefinition() {
        return this.functionDefinitionLevel > 0;
    }

    private void enterFunctionInvocation() {
        ++this.functionInvocationLevel;
    }

    private void exitFunctionInvocation() {
        --this.functionInvocationLevel;
    }

    private boolean inFunctionInvocation() {
        return this.functionInvocationLevel > 0;
    }

    private void enterRetrieve() {
        ++this.retrieveLevel;
    }

    private void exitRetrieve() {
        --this.retrieveLevel;
    }

    private boolean inRetrieve() {
        return this.retrieveLevel > 0;
    }

    private void enterClause() {
        this.increaseIndentLevel();
        this.newLine();
    }

    private void exitClause() {
        this.decreaseIndentLevel();
    }

    private void enterGroup() {
        this.increaseIndentLevel();
        this.groups.push(this.currentLine);
    }

    private void exitGroup() {
        Integer groupStartLine = this.groups.pop();
        this.decreaseIndentLevel();
        if (this.currentLine != groupStartLine) {
            this.newLine();
        }
    }

    private boolean needsWhitespaceBefore(String terminal) {
        if (terminal.trim().isEmpty() || terminal.startsWith("//") || terminal.startsWith("/*")) {
            return false;
        }
        switch (terminal) {
            case ":": {
                return false;
            }
            case ".": {
                return false;
            }
            case ",": {
                return false;
            }
            case "<": {
                return !this.inTypeSpecifier();
            }
            case ">": {
                return !this.inTypeSpecifier();
            }
            case "(": {
                return !this.inFunctionDefinition() && !this.inFunctionInvocation();
            }
            case ")": {
                return !this.inFunctionDefinition() && !this.inFunctionInvocation();
            }
            case "[": {
                return this.inRetrieve();
            }
            case "]": {
                return false;
            }
        }
        return true;
    }

    private boolean needsWhitespaceAfter(String terminal) {
        switch (terminal) {
            case ".": {
                return false;
            }
            case "<": {
                return !this.inTypeSpecifier();
            }
            case ">": {
                return !this.inTypeSpecifier();
            }
            case "(": {
                return !this.inFunctionDefinition() && !this.inFunctionInvocation();
            }
            case ")": {
                return !this.inFunctionDefinition() && !this.inFunctionInvocation();
            }
            case "[": {
                return false;
            }
            case "]": {
                return this.inRetrieve();
            }
        }
        return true;
    }

    private void appendComment(CommentToken token) {
        String out = this.output.toString();
        String whitespace = out.substring(out.replaceAll("\\s+$", "").length());
        if (!whitespace.equals(token.whitespaceBefore)) {
            String whitespaceBefore = token.whitespaceBefore;
            this.output = new StringBuilder().append(out.substring(0, out.length() - whitespace.length())).append(whitespaceBefore);
        }
        this.output.append(token.token.getText()).append(whitespace);
    }

    private void appendTerminal(String terminal) {
        if (this.needsWhitespaceBefore(terminal)) {
            this.ensureWhitespace();
        }
        if (terminal.equals("else")) {
            this.increaseIndentLevel();
            this.newLine();
            this.decreaseIndentLevel();
        }
        if (terminal.equals("end")) {
            this.newLine();
        }
        this.output.append(terminal);
        this.onNewLine = false;
        this.needsWhitespace = this.needsWhitespaceAfter(terminal);
    }

    private void increaseIndentLevel() {
        this.previousIndentLevel = this.indentLevel;
        this.indentLevel = this.previousIndentLevel + 1;
    }

    private void decreaseIndentLevel() {
        this.previousIndentLevel = this.indentLevel;
        this.indentLevel = this.previousIndentLevel - 1;
    }

    private void resetIndentLevel() {
        this.indentLevel = 0;
        this.previousIndentLevel = 0;
    }

    private void indent() {
        int indent = this.indentLevel * (this.useSpaces ? this.indentSize : 1);
        for (int i = 0; i < indent; ++i) {
            this.output.append(this.useSpaces ? (char)' ' : '\t');
        }
    }

    private void newLine() {
        this.output.append("\r\n");
        ++this.currentLine;
        this.indent();
        this.onNewLine = true;
    }

    private void newConstruct(String section) {
        this.resetIndentLevel();
        this.newLine();
        this.addToSection(section);
    }

    private void ensureWhitespace() {
        if (!this.onNewLine && this.needsWhitespace) {
            this.output.append(' ');
        }
    }

    private void reset() {
        this.resetIndentLevel();
        this.currentLine = 1;
        this.onNewLine = true;
        this.output = new StringBuilder();
        this.groups = new Stack();
    }

    public Object visitLibrary(cqlParser.LibraryContext ctx) {
        this.reset();
        super.visitLibrary(ctx);
        this.resetIndentLevel();
        return this.output.toString();
    }

    public Object visitChildren(RuleNode node) {
        Object result = this.defaultResult();
        int n = node.getChildCount();
        for (int i = 0; i < n && this.shouldVisitNextChild(node, result); ++i) {
            ParseTree c = node.getChild(i);
            if ((node instanceof cqlParser.TupleSelectorContext || node instanceof cqlParser.TupleTypeSpecifierContext) && c instanceof TerminalNodeImpl && ((TerminalNodeImpl)c).getSymbol().getText().equals("}")) {
                this.decreaseIndentLevel();
                this.newLine();
            }
            Object childResult = c.accept((ParseTreeVisitor)this);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    public Object visitLibraryDefinition(cqlParser.LibraryDefinitionContext ctx) {
        this.addToSection("library");
        return super.visitLibraryDefinition(ctx);
    }

    public Object visitUsingDefinition(cqlParser.UsingDefinitionContext ctx) {
        this.newConstruct("using");
        return super.visitUsingDefinition(ctx);
    }

    public Object visitIncludeDefinition(cqlParser.IncludeDefinitionContext ctx) {
        this.newConstruct("include");
        return super.visitIncludeDefinition(ctx);
    }

    public Object visitLocalIdentifier(cqlParser.LocalIdentifierContext ctx) {
        return super.visitLocalIdentifier(ctx);
    }

    public Object visitAccessModifier(cqlParser.AccessModifierContext ctx) {
        return super.visitAccessModifier(ctx);
    }

    public Object visitParameterDefinition(cqlParser.ParameterDefinitionContext ctx) {
        this.newConstruct("parameter");
        return super.visitParameterDefinition(ctx);
    }

    public Object visitCodesystemDefinition(cqlParser.CodesystemDefinitionContext ctx) {
        this.newConstruct("codesystem");
        return super.visitCodesystemDefinition(ctx);
    }

    public Object visitValuesetDefinition(cqlParser.ValuesetDefinitionContext ctx) {
        this.newConstruct("valueset");
        return super.visitValuesetDefinition(ctx);
    }

    public Object visitCodesystems(cqlParser.CodesystemsContext ctx) {
        return super.visitCodesystems(ctx);
    }

    public Object visitCodesystemIdentifier(cqlParser.CodesystemIdentifierContext ctx) {
        return super.visitCodesystemIdentifier(ctx);
    }

    public Object visitLibraryIdentifier(cqlParser.LibraryIdentifierContext ctx) {
        return super.visitLibraryIdentifier(ctx);
    }

    public Object visitCodeDefinition(cqlParser.CodeDefinitionContext ctx) {
        this.newConstruct("code");
        return super.visitCodeDefinition(ctx);
    }

    public Object visitConceptDefinition(cqlParser.ConceptDefinitionContext ctx) {
        this.newConstruct("concept");
        return super.visitConceptDefinition(ctx);
    }

    public Object visitCodeIdentifier(cqlParser.CodeIdentifierContext ctx) {
        return super.visitCodeIdentifier(ctx);
    }

    public Object visitCodesystemId(cqlParser.CodesystemIdContext ctx) {
        return super.visitCodesystemId(ctx);
    }

    public Object visitValuesetId(cqlParser.ValuesetIdContext ctx) {
        return super.visitValuesetId(ctx);
    }

    public Object visitVersionSpecifier(cqlParser.VersionSpecifierContext ctx) {
        return super.visitVersionSpecifier(ctx);
    }

    public Object visitCodeId(cqlParser.CodeIdContext ctx) {
        return super.visitCodeId(ctx);
    }

    public Object visitTypeSpecifier(cqlParser.TypeSpecifierContext ctx) {
        this.enterTypeSpecifier();
        try {
            Object object = super.visitTypeSpecifier(ctx);
            return object;
        }
        finally {
            this.exitTypeSpecifier();
        }
    }

    public Object visitNamedTypeSpecifier(cqlParser.NamedTypeSpecifierContext ctx) {
        return super.visitNamedTypeSpecifier(ctx);
    }

    public Object visitModelIdentifier(cqlParser.ModelIdentifierContext ctx) {
        return super.visitModelIdentifier(ctx);
    }

    public Object visitListTypeSpecifier(cqlParser.ListTypeSpecifierContext ctx) {
        return super.visitListTypeSpecifier(ctx);
    }

    public Object visitIntervalTypeSpecifier(cqlParser.IntervalTypeSpecifierContext ctx) {
        return super.visitIntervalTypeSpecifier(ctx);
    }

    public Object visitTupleTypeSpecifier(cqlParser.TupleTypeSpecifierContext ctx) {
        this.isFirstTupleElement = true;
        return super.visitTupleTypeSpecifier(ctx);
    }

    public Object visitTupleElementDefinition(cqlParser.TupleElementDefinitionContext ctx) {
        if (this.isFirstTupleElement) {
            this.increaseIndentLevel();
            this.isFirstTupleElement = false;
        }
        this.newLine();
        return super.visitTupleElementDefinition(ctx);
    }

    public Object visitChoiceTypeSpecifier(cqlParser.ChoiceTypeSpecifierContext ctx) {
        return super.visitChoiceTypeSpecifier(ctx);
    }

    public Object visitStatement(cqlParser.StatementContext ctx) {
        return super.visitStatement(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitExpressionDefinition(cqlParser.ExpressionDefinitionContext ctx) {
        this.newConstruct("statement");
        Object result = this.defaultResult();
        int n = ctx.getChildCount();
        for (int i = 0; i < n && this.shouldVisitNextChild((RuleNode)ctx, result); ++i) {
            ParseTree c = ctx.getChild(i);
            if (c == ctx.expression()) {
                this.enterClause();
            }
            try {
                Object childResult = c.accept((ParseTreeVisitor)this);
                result = this.aggregateResult(result, childResult);
                continue;
            }
            finally {
                if (c == ctx.expression()) {
                    this.exitClause();
                }
            }
        }
        return result;
    }

    public Object visitContextDefinition(cqlParser.ContextDefinitionContext ctx) {
        this.newConstruct("statement");
        return super.visitContextDefinition(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitFunctionDefinition(cqlParser.FunctionDefinitionContext ctx) {
        this.newConstruct("statement");
        Object result = this.defaultResult();
        int n = ctx.getChildCount();
        boolean clauseEntered = false;
        try {
            for (int i = 0; i < n; ++i) {
                if (!this.shouldVisitNextChild((RuleNode)ctx, result)) {
                    break;
                }
                ParseTree c = ctx.getChild(i);
                if (c.getText().equals("(")) {
                    this.enterFunctionDefinition();
                }
                Object childResult = c.accept((ParseTreeVisitor)this);
                result = this.aggregateResult(result, childResult);
                if (c.getText().equals(")")) {
                    this.exitFunctionDefinition();
                }
                if (!c.getText().equals(":")) continue;
                this.enterClause();
                clauseEntered = true;
            }
        }
        finally {
            if (clauseEntered) {
                this.exitClause();
            }
        }
        return result;
    }

    public Object visitOperandDefinition(cqlParser.OperandDefinitionContext ctx) {
        return super.visitOperandDefinition(ctx);
    }

    public Object visitFunctionBody(cqlParser.FunctionBodyContext ctx) {
        return super.visitFunctionBody(ctx);
    }

    public Object visitQuerySource(cqlParser.QuerySourceContext ctx) {
        return super.visitQuerySource(ctx);
    }

    public Object visitAliasedQuerySource(cqlParser.AliasedQuerySourceContext ctx) {
        return super.visitAliasedQuerySource(ctx);
    }

    public Object visitAlias(cqlParser.AliasContext ctx) {
        return super.visitAlias(ctx);
    }

    public Object visitQueryInclusionClause(cqlParser.QueryInclusionClauseContext ctx) {
        this.enterClause();
        try {
            Object object = super.visitQueryInclusionClause(ctx);
            return object;
        }
        finally {
            this.exitClause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object visitWithOrWithoutClause(ParserRuleContext ctx) {
        Object result = this.defaultResult();
        int n = ctx.getChildCount();
        boolean clauseEntered = false;
        try {
            for (int i = 0; i < n; ++i) {
                if (!this.shouldVisitNextChild((RuleNode)ctx, result)) {
                    break;
                }
                ParseTree c = ctx.getChild(i);
                if (c.getText().equals("such that")) {
                    this.enterClause();
                    clauseEntered = true;
                }
                Object childResult = c.accept((ParseTreeVisitor)this);
                result = this.aggregateResult(result, childResult);
            }
        }
        finally {
            if (clauseEntered) {
                this.exitClause();
            }
        }
        return result;
    }

    public Object visitWithClause(cqlParser.WithClauseContext ctx) {
        return this.visitWithOrWithoutClause((ParserRuleContext)ctx);
    }

    public Object visitWithoutClause(cqlParser.WithoutClauseContext ctx) {
        return this.visitWithOrWithoutClause((ParserRuleContext)ctx);
    }

    public Object visitRetrieve(cqlParser.RetrieveContext ctx) {
        this.enterRetrieve();
        try {
            Object object = super.visitRetrieve(ctx);
            return object;
        }
        finally {
            this.exitRetrieve();
        }
    }

    public Object visitCodePath(cqlParser.CodePathContext ctx) {
        return super.visitCodePath(ctx);
    }

    public Object visitTerminology(cqlParser.TerminologyContext ctx) {
        return super.visitTerminology(ctx);
    }

    public Object visitQualifier(cqlParser.QualifierContext ctx) {
        return super.visitQualifier(ctx);
    }

    public Object visitQuery(cqlParser.QueryContext ctx) {
        return super.visitQuery(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitSourceClause(cqlParser.SourceClauseContext ctx) {
        Object result = this.defaultResult();
        int n = ctx.getChildCount();
        boolean clauseEntered = false;
        try {
            for (int i = 0; i < n && this.shouldVisitNextChild((RuleNode)ctx, result); ++i) {
                ParseTree c = ctx.getChild(i);
                if (i == 1) {
                    this.enterClause();
                    clauseEntered = true;
                }
                if (i > 1 && !c.getText().equals(",")) {
                    this.newLine();
                }
                Object childResult = c.accept((ParseTreeVisitor)this);
                result = this.aggregateResult(result, childResult);
            }
            Object object = result;
            return object;
        }
        finally {
            if (clauseEntered) {
                this.exitClause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitLetClause(cqlParser.LetClauseContext ctx) {
        this.enterClause();
        try {
            Object result = this.defaultResult();
            int n = ctx.getChildCount();
            for (int i = 0; i < n && this.shouldVisitNextChild((RuleNode)ctx, result); ++i) {
                ParseTree c = ctx.getChild(i);
                if (i > 1 && !c.getText().equals(",")) {
                    this.newLine();
                }
                Object childResult = c.accept((ParseTreeVisitor)this);
                result = this.aggregateResult(result, childResult);
            }
            Object object = result;
            return object;
        }
        finally {
            this.exitClause();
        }
    }

    public Object visitLetClauseItem(cqlParser.LetClauseItemContext ctx) {
        return super.visitLetClauseItem(ctx);
    }

    public Object visitWhereClause(cqlParser.WhereClauseContext ctx) {
        this.enterClause();
        try {
            Object object = super.visitWhereClause(ctx);
            return object;
        }
        finally {
            this.exitClause();
        }
    }

    public Object visitReturnClause(cqlParser.ReturnClauseContext ctx) {
        this.enterClause();
        try {
            Object object = super.visitReturnClause(ctx);
            return object;
        }
        finally {
            this.exitClause();
        }
    }

    public Object visitSortClause(cqlParser.SortClauseContext ctx) {
        this.enterClause();
        try {
            Object object = super.visitSortClause(ctx);
            return object;
        }
        finally {
            this.exitClause();
        }
    }

    public Object visitSortDirection(cqlParser.SortDirectionContext ctx) {
        return super.visitSortDirection(ctx);
    }

    public Object visitSortByItem(cqlParser.SortByItemContext ctx) {
        return super.visitSortByItem(ctx);
    }

    public Object visitQualifiedIdentifier(cqlParser.QualifiedIdentifierContext ctx) {
        return super.visitQualifiedIdentifier(ctx);
    }

    public Object visitDurationBetweenExpression(cqlParser.DurationBetweenExpressionContext ctx) {
        return super.visitDurationBetweenExpression(ctx);
    }

    public Object visitInFixSetExpression(cqlParser.InFixSetExpressionContext ctx) {
        return this.visitBinaryClausedExpression((ParserRuleContext)ctx);
    }

    public Object visitRetrieveExpression(cqlParser.RetrieveExpressionContext ctx) {
        return super.visitRetrieveExpression(ctx);
    }

    public Object visitTimingExpression(cqlParser.TimingExpressionContext ctx) {
        return super.visitTimingExpression(ctx);
    }

    public Object visitNotExpression(cqlParser.NotExpressionContext ctx) {
        return super.visitNotExpression(ctx);
    }

    public Object visitQueryExpression(cqlParser.QueryExpressionContext ctx) {
        return super.visitQueryExpression(ctx);
    }

    public Object visitBooleanExpression(cqlParser.BooleanExpressionContext ctx) {
        return super.visitBooleanExpression(ctx);
    }

    public Object visitOrExpression(cqlParser.OrExpressionContext ctx) {
        return this.visitBinaryClausedExpression((ParserRuleContext)ctx);
    }

    public Object visitCastExpression(cqlParser.CastExpressionContext ctx) {
        return super.visitCastExpression(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object visitBinaryClausedExpression(ParserRuleContext ctx) {
        Object result = this.defaultResult();
        int n = ctx.getChildCount();
        boolean clauseEntered = false;
        try {
            for (int i = 0; i < n && this.shouldVisitNextChild((RuleNode)ctx, result); ++i) {
                ParseTree c = ctx.getChild(i);
                if (i == 1) {
                    this.enterClause();
                    clauseEntered = true;
                }
                Object childResult = c.accept((ParseTreeVisitor)this);
                result = this.aggregateResult(result, childResult);
            }
            Object object = result;
            return object;
        }
        finally {
            if (clauseEntered) {
                this.exitClause();
            }
        }
    }

    public Object visitAndExpression(cqlParser.AndExpressionContext ctx) {
        return this.visitBinaryClausedExpression((ParserRuleContext)ctx);
    }

    public Object visitBetweenExpression(cqlParser.BetweenExpressionContext ctx) {
        return super.visitBetweenExpression(ctx);
    }

    public Object visitMembershipExpression(cqlParser.MembershipExpressionContext ctx) {
        return super.visitMembershipExpression(ctx);
    }

    public Object visitDifferenceBetweenExpression(cqlParser.DifferenceBetweenExpressionContext ctx) {
        return super.visitDifferenceBetweenExpression(ctx);
    }

    public Object visitInequalityExpression(cqlParser.InequalityExpressionContext ctx) {
        return super.visitInequalityExpression(ctx);
    }

    public Object visitEqualityExpression(cqlParser.EqualityExpressionContext ctx) {
        return super.visitEqualityExpression(ctx);
    }

    public Object visitExistenceExpression(cqlParser.ExistenceExpressionContext ctx) {
        return super.visitExistenceExpression(ctx);
    }

    public Object visitImpliesExpression(cqlParser.ImpliesExpressionContext ctx) {
        return super.visitImpliesExpression(ctx);
    }

    public Object visitTermExpression(cqlParser.TermExpressionContext ctx) {
        return super.visitTermExpression(ctx);
    }

    public Object visitTypeExpression(cqlParser.TypeExpressionContext ctx) {
        return super.visitTypeExpression(ctx);
    }

    public Object visitDateTimePrecision(cqlParser.DateTimePrecisionContext ctx) {
        return super.visitDateTimePrecision(ctx);
    }

    public Object visitDateTimeComponent(cqlParser.DateTimeComponentContext ctx) {
        return super.visitDateTimeComponent(ctx);
    }

    public Object visitPluralDateTimePrecision(cqlParser.PluralDateTimePrecisionContext ctx) {
        return super.visitPluralDateTimePrecision(ctx);
    }

    public Object visitAdditionExpressionTerm(cqlParser.AdditionExpressionTermContext ctx) {
        return super.visitAdditionExpressionTerm(ctx);
    }

    public Object visitIndexedExpressionTerm(cqlParser.IndexedExpressionTermContext ctx) {
        return super.visitIndexedExpressionTerm(ctx);
    }

    public Object visitWidthExpressionTerm(cqlParser.WidthExpressionTermContext ctx) {
        return super.visitWidthExpressionTerm(ctx);
    }

    public Object visitTimeUnitExpressionTerm(cqlParser.TimeUnitExpressionTermContext ctx) {
        return super.visitTimeUnitExpressionTerm(ctx);
    }

    public Object visitIfThenElseExpressionTerm(cqlParser.IfThenElseExpressionTermContext ctx) {
        return super.visitIfThenElseExpressionTerm(ctx);
    }

    public Object visitTimeBoundaryExpressionTerm(cqlParser.TimeBoundaryExpressionTermContext ctx) {
        return super.visitTimeBoundaryExpressionTerm(ctx);
    }

    public Object visitElementExtractorExpressionTerm(cqlParser.ElementExtractorExpressionTermContext ctx) {
        return super.visitElementExtractorExpressionTerm(ctx);
    }

    public Object visitConversionExpressionTerm(cqlParser.ConversionExpressionTermContext ctx) {
        return super.visitConversionExpressionTerm(ctx);
    }

    public Object visitTypeExtentExpressionTerm(cqlParser.TypeExtentExpressionTermContext ctx) {
        return super.visitTypeExtentExpressionTerm(ctx);
    }

    public Object visitPredecessorExpressionTerm(cqlParser.PredecessorExpressionTermContext ctx) {
        return super.visitPredecessorExpressionTerm(ctx);
    }

    public Object visitPointExtractorExpressionTerm(cqlParser.PointExtractorExpressionTermContext ctx) {
        return super.visitPointExtractorExpressionTerm(ctx);
    }

    public Object visitMultiplicationExpressionTerm(cqlParser.MultiplicationExpressionTermContext ctx) {
        return super.visitMultiplicationExpressionTerm(ctx);
    }

    public Object visitAggregateExpressionTerm(cqlParser.AggregateExpressionTermContext ctx) {
        return super.visitAggregateExpressionTerm(ctx);
    }

    public Object visitDurationExpressionTerm(cqlParser.DurationExpressionTermContext ctx) {
        return super.visitDurationExpressionTerm(ctx);
    }

    private boolean hasNeighborOnLine(ParserRuleContext ctx) {
        for (ParserRuleContext context = ctx.getParent(); context != null; context = context.getParent()) {
            if (context.getStart().getStartIndex() >= ctx.getStart().getStartIndex()) continue;
            return context.getStart().getLine() == ctx.getStart().getLine();
        }
        return false;
    }

    public Object visitCaseExpressionTerm(cqlParser.CaseExpressionTermContext ctx) {
        if (this.hasNeighborOnLine((ParserRuleContext)ctx)) {
            this.newLine();
            if (this.previousIndentLevel == this.indentLevel) {
                this.increaseIndentLevel();
            }
        }
        return super.visitCaseExpressionTerm(ctx);
    }

    public Object visitPowerExpressionTerm(cqlParser.PowerExpressionTermContext ctx) {
        return super.visitPowerExpressionTerm(ctx);
    }

    public Object visitSuccessorExpressionTerm(cqlParser.SuccessorExpressionTermContext ctx) {
        return super.visitSuccessorExpressionTerm(ctx);
    }

    public Object visitPolarityExpressionTerm(cqlParser.PolarityExpressionTermContext ctx) {
        return super.visitPolarityExpressionTerm(ctx);
    }

    public Object visitTermExpressionTerm(cqlParser.TermExpressionTermContext ctx) {
        return super.visitTermExpressionTerm(ctx);
    }

    public Object visitInvocationExpressionTerm(cqlParser.InvocationExpressionTermContext ctx) {
        return super.visitInvocationExpressionTerm(ctx);
    }

    public Object visitCaseExpressionItem(cqlParser.CaseExpressionItemContext ctx) {
        try {
            this.enterClause();
            Object object = super.visitCaseExpressionItem(ctx);
            return object;
        }
        finally {
            this.exitClause();
        }
    }

    public Object visitDateTimePrecisionSpecifier(cqlParser.DateTimePrecisionSpecifierContext ctx) {
        return super.visitDateTimePrecisionSpecifier(ctx);
    }

    public Object visitRelativeQualifier(cqlParser.RelativeQualifierContext ctx) {
        return super.visitRelativeQualifier(ctx);
    }

    public Object visitOffsetRelativeQualifier(cqlParser.OffsetRelativeQualifierContext ctx) {
        return super.visitOffsetRelativeQualifier(ctx);
    }

    public Object visitExclusiveRelativeQualifier(cqlParser.ExclusiveRelativeQualifierContext ctx) {
        return super.visitExclusiveRelativeQualifier(ctx);
    }

    public Object visitQuantityOffset(cqlParser.QuantityOffsetContext ctx) {
        return super.visitQuantityOffset(ctx);
    }

    public Object visitTemporalRelationship(cqlParser.TemporalRelationshipContext ctx) {
        return super.visitTemporalRelationship(ctx);
    }

    public Object visitConcurrentWithIntervalOperatorPhrase(cqlParser.ConcurrentWithIntervalOperatorPhraseContext ctx) {
        return super.visitConcurrentWithIntervalOperatorPhrase(ctx);
    }

    public Object visitIncludesIntervalOperatorPhrase(cqlParser.IncludesIntervalOperatorPhraseContext ctx) {
        return super.visitIncludesIntervalOperatorPhrase(ctx);
    }

    public Object visitIncludedInIntervalOperatorPhrase(cqlParser.IncludedInIntervalOperatorPhraseContext ctx) {
        return super.visitIncludedInIntervalOperatorPhrase(ctx);
    }

    public Object visitBeforeOrAfterIntervalOperatorPhrase(cqlParser.BeforeOrAfterIntervalOperatorPhraseContext ctx) {
        return super.visitBeforeOrAfterIntervalOperatorPhrase(ctx);
    }

    public Object visitWithinIntervalOperatorPhrase(cqlParser.WithinIntervalOperatorPhraseContext ctx) {
        return super.visitWithinIntervalOperatorPhrase(ctx);
    }

    public Object visitMeetsIntervalOperatorPhrase(cqlParser.MeetsIntervalOperatorPhraseContext ctx) {
        return super.visitMeetsIntervalOperatorPhrase(ctx);
    }

    public Object visitOverlapsIntervalOperatorPhrase(cqlParser.OverlapsIntervalOperatorPhraseContext ctx) {
        return super.visitOverlapsIntervalOperatorPhrase(ctx);
    }

    public Object visitStartsIntervalOperatorPhrase(cqlParser.StartsIntervalOperatorPhraseContext ctx) {
        return super.visitStartsIntervalOperatorPhrase(ctx);
    }

    public Object visitEndsIntervalOperatorPhrase(cqlParser.EndsIntervalOperatorPhraseContext ctx) {
        return super.visitEndsIntervalOperatorPhrase(ctx);
    }

    public Object visitInvocationTerm(cqlParser.InvocationTermContext ctx) {
        return super.visitInvocationTerm(ctx);
    }

    public Object visitLiteralTerm(cqlParser.LiteralTermContext ctx) {
        return super.visitLiteralTerm(ctx);
    }

    public Object visitExternalConstantTerm(cqlParser.ExternalConstantTermContext ctx) {
        return super.visitExternalConstantTerm(ctx);
    }

    public Object visitIntervalSelectorTerm(cqlParser.IntervalSelectorTermContext ctx) {
        return super.visitIntervalSelectorTerm(ctx);
    }

    public Object visitTupleSelectorTerm(cqlParser.TupleSelectorTermContext ctx) {
        return super.visitTupleSelectorTerm(ctx);
    }

    public Object visitInstanceSelectorTerm(cqlParser.InstanceSelectorTermContext ctx) {
        return super.visitInstanceSelectorTerm(ctx);
    }

    public Object visitListSelectorTerm(cqlParser.ListSelectorTermContext ctx) {
        return super.visitListSelectorTerm(ctx);
    }

    public Object visitCodeSelectorTerm(cqlParser.CodeSelectorTermContext ctx) {
        return super.visitCodeSelectorTerm(ctx);
    }

    public Object visitConceptSelectorTerm(cqlParser.ConceptSelectorTermContext ctx) {
        return super.visitConceptSelectorTerm(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitParenthesizedTerm(cqlParser.ParenthesizedTermContext ctx) {
        Object result = this.defaultResult();
        int n = ctx.getChildCount();
        for (int i = 0; i < n && this.shouldVisitNextChild((RuleNode)ctx, result); ++i) {
            ParseTree c = ctx.getChild(i);
            if (c == ctx.expression()) {
                this.enterGroup();
            }
            try {
                Object childResult = c.accept((ParseTreeVisitor)this);
                result = this.aggregateResult(result, childResult);
                continue;
            }
            finally {
                if (c == ctx.expression()) {
                    this.exitGroup();
                }
            }
        }
        return result;
    }

    public Object visitBooleanLiteral(cqlParser.BooleanLiteralContext ctx) {
        return super.visitBooleanLiteral(ctx);
    }

    public Object visitNullLiteral(cqlParser.NullLiteralContext ctx) {
        return super.visitNullLiteral(ctx);
    }

    public Object visitStringLiteral(cqlParser.StringLiteralContext ctx) {
        return super.visitStringLiteral(ctx);
    }

    public Object visitNumberLiteral(cqlParser.NumberLiteralContext ctx) {
        return super.visitNumberLiteral(ctx);
    }

    public Object visitDateTimeLiteral(cqlParser.DateTimeLiteralContext ctx) {
        return super.visitDateTimeLiteral(ctx);
    }

    public Object visitTimeLiteral(cqlParser.TimeLiteralContext ctx) {
        return super.visitTimeLiteral(ctx);
    }

    public Object visitQuantityLiteral(cqlParser.QuantityLiteralContext ctx) {
        return super.visitQuantityLiteral(ctx);
    }

    public Object visitIntervalSelector(cqlParser.IntervalSelectorContext ctx) {
        return super.visitIntervalSelector(ctx);
    }

    public Object visitTupleSelector(cqlParser.TupleSelectorContext ctx) {
        this.isFirstTupleElement = true;
        return super.visitTupleSelector(ctx);
    }

    public Object visitTupleElementSelector(cqlParser.TupleElementSelectorContext ctx) {
        if (this.isFirstTupleElement) {
            this.increaseIndentLevel();
            this.isFirstTupleElement = false;
        }
        this.newLine();
        return super.visitTupleElementSelector(ctx);
    }

    public Object visitInstanceSelector(cqlParser.InstanceSelectorContext ctx) {
        return super.visitInstanceSelector(ctx);
    }

    public Object visitInstanceElementSelector(cqlParser.InstanceElementSelectorContext ctx) {
        return super.visitInstanceElementSelector(ctx);
    }

    public Object visitListSelector(cqlParser.ListSelectorContext ctx) {
        return super.visitListSelector(ctx);
    }

    public Object visitDisplayClause(cqlParser.DisplayClauseContext ctx) {
        return super.visitDisplayClause(ctx);
    }

    public Object visitCodeSelector(cqlParser.CodeSelectorContext ctx) {
        return super.visitCodeSelector(ctx);
    }

    public Object visitConceptSelector(cqlParser.ConceptSelectorContext ctx) {
        return super.visitConceptSelector(ctx);
    }

    public Object visitIdentifier(cqlParser.IdentifierContext ctx) {
        return super.visitIdentifier(ctx);
    }

    public Object visitExternalConstant(cqlParser.ExternalConstantContext ctx) {
        return super.visitExternalConstant(ctx);
    }

    public Object visitMemberInvocation(cqlParser.MemberInvocationContext ctx) {
        return super.visitMemberInvocation(ctx);
    }

    public Object visitFunctionInvocation(cqlParser.FunctionInvocationContext ctx) {
        this.enterFunctionInvocation();
        try {
            Object object = super.visitFunctionInvocation(ctx);
            return object;
        }
        finally {
            this.exitFunctionInvocation();
        }
    }

    public Object visitThisInvocation(cqlParser.ThisInvocationContext ctx) {
        return super.visitThisInvocation(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitFunction(cqlParser.FunctionContext ctx) {
        Object result = this.defaultResult();
        int n = ctx.getChildCount();
        for (int i = 0; i < n && this.shouldVisitNextChild((RuleNode)ctx, result); ++i) {
            ParseTree c = ctx.getChild(i);
            if (c == ctx.paramList()) {
                this.enterGroup();
            }
            try {
                Object childResult = c.accept((ParseTreeVisitor)this);
                result = this.aggregateResult(result, childResult);
                continue;
            }
            finally {
                if (c == ctx.paramList()) {
                    this.exitGroup();
                }
            }
        }
        return result;
    }

    public Object visitParamList(cqlParser.ParamListContext ctx) {
        return super.visitParamList(ctx);
    }

    public Object visitQuantity(cqlParser.QuantityContext ctx) {
        return super.visitQuantity(ctx);
    }

    public Object visitUnit(cqlParser.UnitContext ctx) {
        return super.visitUnit(ctx);
    }

    public Object visitTerminal(TerminalNode node) {
        this.checkForComment(node);
        if (node.getSymbol().getType() != -1) {
            this.appendTerminal(node.getText());
        }
        return super.visitTerminal(node);
    }

    private void checkForComment(TerminalNode node) {
        int numComments = 0;
        for (CommentToken token : comments) {
            if (token.token.getTokenIndex() >= node.getSymbol().getTokenIndex()) continue;
            this.appendComment(token);
            ++numComments;
        }
        while (numComments > 0) {
            comments.remove(--numComments);
        }
    }

    public static class FormatResult {
        List<Exception> errors;
        String output;

        public FormatResult(List<Exception> errors, String output) {
            this.errors = errors;
            this.output = output;
        }

        public List<Exception> getErrors() {
            return this.errors;
        }

        public String getOutput() {
            return this.output;
        }
    }

    private static class SyntaxErrorListener
    extends BaseErrorListener {
        private List<Exception> errors = new ArrayList<Exception>();

        private SyntaxErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            if (!((Token)offendingSymbol).getText().trim().isEmpty()) {
                this.errors.add(new Exception(String.format("[%d:%d]: %s", line, charPositionInLine, msg)));
            }
        }
    }

    private static class CommentToken {
        private Token token;
        private String whitespaceBefore;

        public CommentToken(Token token, String whitespaceBefore) {
            this.token = token;
            this.whitespaceBefore = whitespaceBefore;
        }
    }
}

