/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.cqframework.cql.cql2elm.CqlTranslatorException;
import org.cqframework.cql.cql2elm.CqlTranslatorIncludeException;
import org.cqframework.cql.cql2elm.DataTypes;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.ModelInfoLoader;
import org.cqframework.cql.cql2elm.ModelInfoProvider;
import org.cqframework.cql.cql2elm.SystemFunctionResolver;
import org.cqframework.cql.cql2elm.model.CallContext;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.ConversionMap;
import org.cqframework.cql.cql2elm.model.Invocation;
import org.cqframework.cql.cql2elm.model.LibraryRef;
import org.cqframework.cql.cql2elm.model.Model;
import org.cqframework.cql.cql2elm.model.OperatorResolution;
import org.cqframework.cql.cql2elm.model.QueryContext;
import org.cqframework.cql.cql2elm.model.SystemLibraryHelper;
import org.cqframework.cql.cql2elm.model.SystemModel;
import org.cqframework.cql.cql2elm.model.TimingOperatorContext;
import org.cqframework.cql.cql2elm.model.TranslatedLibrary;
import org.cqframework.cql.cql2elm.model.invocation.AggregateExpressionInvocation;
import org.cqframework.cql.cql2elm.model.invocation.BinaryExpressionInvocation;
import org.cqframework.cql.cql2elm.model.invocation.FunctionRefInvocation;
import org.cqframework.cql.cql2elm.model.invocation.InCodeSystemInvocation;
import org.cqframework.cql.cql2elm.model.invocation.InValueSetInvocation;
import org.cqframework.cql.cql2elm.model.invocation.UnaryExpressionInvocation;
import org.cqframework.cql.cql2elm.preprocessor.ExpressionDefinitionInfo;
import org.cqframework.cql.cql2elm.preprocessor.LibraryInfo;
import org.cqframework.cql.cql2elm.preprocessor.ParameterDefinitionInfo;
import org.cqframework.cql.elm.tracking.ClassType;
import org.cqframework.cql.elm.tracking.ClassTypeElement;
import org.cqframework.cql.elm.tracking.DataType;
import org.cqframework.cql.elm.tracking.IntervalType;
import org.cqframework.cql.elm.tracking.ListType;
import org.cqframework.cql.elm.tracking.NamedType;
import org.cqframework.cql.elm.tracking.TrackBack;
import org.cqframework.cql.elm.tracking.Trackable;
import org.cqframework.cql.elm.tracking.TupleType;
import org.cqframework.cql.elm.tracking.TupleTypeElement;
import org.cqframework.cql.gen.cqlBaseVisitor;
import org.cqframework.cql.gen.cqlParser;
import org.hl7.cql_annotations.r1.CqlToElmError;
import org.hl7.cql_annotations.r1.ErrorType;
import org.hl7.cql_annotations.r1.Narrative;
import org.hl7.cql_annotations.r1.ObjectFactory;
import org.hl7.elm.r1.AccessModifier;
import org.hl7.elm.r1.Add;
import org.hl7.elm.r1.After;
import org.hl7.elm.r1.AggregateExpression;
import org.hl7.elm.r1.AliasRef;
import org.hl7.elm.r1.AliasedQuerySource;
import org.hl7.elm.r1.And;
import org.hl7.elm.r1.As;
import org.hl7.elm.r1.Before;
import org.hl7.elm.r1.BinaryExpression;
import org.hl7.elm.r1.Case;
import org.hl7.elm.r1.CaseItem;
import org.hl7.elm.r1.Code;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.CodeSystemRef;
import org.hl7.elm.r1.Collapse;
import org.hl7.elm.r1.Concept;
import org.hl7.elm.r1.Contains;
import org.hl7.elm.r1.Convert;
import org.hl7.elm.r1.DateFrom;
import org.hl7.elm.r1.DateTime;
import org.hl7.elm.r1.DateTimePrecision;
import org.hl7.elm.r1.DefineClause;
import org.hl7.elm.r1.DifferenceBetween;
import org.hl7.elm.r1.Distinct;
import org.hl7.elm.r1.DurationBetween;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.End;
import org.hl7.elm.r1.Ends;
import org.hl7.elm.r1.Equal;
import org.hl7.elm.r1.Except;
import org.hl7.elm.r1.Exists;
import org.hl7.elm.r1.Expand;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.ExpressionRef;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.FunctionRef;
import org.hl7.elm.r1.GreaterOrEqual;
import org.hl7.elm.r1.IdentifierRef;
import org.hl7.elm.r1.If;
import org.hl7.elm.r1.In;
import org.hl7.elm.r1.InCodeSystem;
import org.hl7.elm.r1.InValueSet;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.IncludedIn;
import org.hl7.elm.r1.Includes;
import org.hl7.elm.r1.Indexer;
import org.hl7.elm.r1.Instance;
import org.hl7.elm.r1.InstanceElement;
import org.hl7.elm.r1.Intersect;
import org.hl7.elm.r1.Interval;
import org.hl7.elm.r1.IntervalTypeSpecifier;
import org.hl7.elm.r1.Is;
import org.hl7.elm.r1.IsNull;
import org.hl7.elm.r1.LessOrEqual;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.ListTypeSpecifier;
import org.hl7.elm.r1.Literal;
import org.hl7.elm.r1.Matches;
import org.hl7.elm.r1.MaxValue;
import org.hl7.elm.r1.Meets;
import org.hl7.elm.r1.MinValue;
import org.hl7.elm.r1.Multiply;
import org.hl7.elm.r1.NamedTypeSpecifier;
import org.hl7.elm.r1.Negate;
import org.hl7.elm.r1.Not;
import org.hl7.elm.r1.Null;
import org.hl7.elm.r1.OperandDef;
import org.hl7.elm.r1.OperandRef;
import org.hl7.elm.r1.Or;
import org.hl7.elm.r1.Overlaps;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.ParameterRef;
import org.hl7.elm.r1.Power;
import org.hl7.elm.r1.Predecessor;
import org.hl7.elm.r1.ProperContains;
import org.hl7.elm.r1.ProperIn;
import org.hl7.elm.r1.ProperIncludedIn;
import org.hl7.elm.r1.ProperIncludes;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Quantity;
import org.hl7.elm.r1.Query;
import org.hl7.elm.r1.QueryDefineRef;
import org.hl7.elm.r1.RelationshipClause;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.ReturnClause;
import org.hl7.elm.r1.SameAs;
import org.hl7.elm.r1.SingletonFrom;
import org.hl7.elm.r1.SortByItem;
import org.hl7.elm.r1.SortClause;
import org.hl7.elm.r1.SortDirection;
import org.hl7.elm.r1.Start;
import org.hl7.elm.r1.Starts;
import org.hl7.elm.r1.Successor;
import org.hl7.elm.r1.Time;
import org.hl7.elm.r1.Tuple;
import org.hl7.elm.r1.TupleElement;
import org.hl7.elm.r1.TupleElementDefinition;
import org.hl7.elm.r1.TupleTypeSpecifier;
import org.hl7.elm.r1.TypeSpecifier;
import org.hl7.elm.r1.UnaryExpression;
import org.hl7.elm.r1.Union;
import org.hl7.elm.r1.UsingDef;
import org.hl7.elm.r1.ValueSetDef;
import org.hl7.elm.r1.ValueSetRef;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.elm.r1.Width;
import org.hl7.elm.r1.With;
import org.hl7.elm.r1.Without;
import org.hl7.elm.r1.Xor;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class Cql2ElmVisitor
extends cqlBaseVisitor {
    private final org.hl7.elm.r1.ObjectFactory of = new org.hl7.elm.r1.ObjectFactory();
    private final ObjectFactory af = new ObjectFactory();
    private boolean annotate = false;
    private boolean dateRangeOptimization = false;
    private TokenStream tokenStream;
    private LibraryManager libraryManager = null;
    private LibraryInfo libraryInfo = null;
    private Library library = null;
    private TranslatedLibrary translatedLibrary = null;
    private String currentContext = "Patient";
    private final SystemFunctionResolver systemFunctionResolver = new SystemFunctionResolver(this);
    private final Map<String, TranslatedLibrary> libraries = new HashMap<String, TranslatedLibrary>();
    private final ConversionMap conversionMap = new ConversionMap();
    private final Stack<String> expressionDefinitions = new Stack();
    private final Stack<QueryContext> queries = new Stack();
    private final Stack<String> expressionContext = new Stack();
    private final Stack<TimingOperatorContext> timingOperators = new Stack();
    private final Stack<Narrative> narratives = new Stack();
    private FunctionDef currentFunctionDef = null;
    private int currentToken = -1;
    private int nextLocalId = 1;
    private final List<Retrieve> retrieves = new ArrayList<Retrieve>();
    private final List<Expression> expressions = new ArrayList<Expression>();
    private final List<CqlTranslatorException> errors = new ArrayList<CqlTranslatorException>();
    private final Map<String, Model> models = new HashMap<String, Model>();
    private boolean implicitPatientCreated = false;

    public Cql2ElmVisitor(LibraryManager libraryManager) {
        this.libraryManager = libraryManager;
    }

    public void recordParsingException(CqlTranslatorException e) {
        this.errors.add(e);
        CqlToElmError err = this.af.createCqlToElmError();
        err.setMessage(e.getMessage());
        err.setErrorType(ErrorType.SYNTAX);
        if (e.getLocator() != null) {
            err.setStartLine(Integer.valueOf(e.getLocator().getStartLine()));
            err.setEndLine(Integer.valueOf(e.getLocator().getEndLine()));
            err.setStartChar(Integer.valueOf(e.getLocator().getStartChar()));
            err.setEndChar(Integer.valueOf(e.getLocator().getEndChar()));
        }
        if (e.getCause() != null && e.getCause() instanceof CqlTranslatorIncludeException) {
            CqlTranslatorIncludeException incEx = (CqlTranslatorIncludeException)e.getCause();
            err.setTargetIncludeLibraryId(incEx.getLibraryId());
            err.setTargetIncludeLibraryVersionId(incEx.getVersionId());
            err.setErrorType(ErrorType.INCLUDE);
        }
        this.getOrInitializeLibrary().getAnnotation().add(err);
    }

    public void enableAnnotations() {
        this.annotate = true;
    }

    public void disableAnnotations() {
        this.annotate = false;
    }

    public void enableDateRangeOptimization() {
        this.dateRangeOptimization = true;
    }

    public void disableDateRangeOptimization() {
        this.dateRangeOptimization = false;
    }

    public TokenStream getTokenStream() {
        return this.tokenStream;
    }

    public void setTokenStream(TokenStream value) {
        this.tokenStream = value;
    }

    public LibraryInfo getLibraryInfo() {
        return this.libraryInfo;
    }

    public void setLibraryInfo(LibraryInfo value) {
        this.libraryInfo = value;
    }

    public Library getLibrary() {
        return this.library;
    }

    public TranslatedLibrary getTranslatedLibrary() {
        return this.translatedLibrary;
    }

    public List<Retrieve> getRetrieves() {
        return this.retrieves;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public List<CqlTranslatorException> getErrors() {
        return this.errors;
    }

    private int getNextLocalId() {
        return this.nextLocalId++;
    }

    private void pushNarrative(@NotNull ParseTree tree) {
        Narrative parentNarrative;
        org.antlr.v4.runtime.misc.Interval sourceInterval = tree.getSourceInterval();
        Narrative narrative = parentNarrative = this.narratives.isEmpty() ? null : this.narratives.peek();
        if (parentNarrative != null && sourceInterval.a - 1 - this.currentToken >= 0) {
            org.antlr.v4.runtime.misc.Interval tokenInterval = new org.antlr.v4.runtime.misc.Interval(this.currentToken, sourceInterval.a - 1);
            parentNarrative.getContent().add(this.tokenStream.getText(tokenInterval));
        }
        this.currentToken = sourceInterval.a;
        Narrative newNarrative = this.af.createNarrative();
        this.narratives.push(newNarrative);
    }

    private Narrative popNarrative(@NotNull ParseTree tree, Object o) {
        org.antlr.v4.runtime.misc.Interval sourceInterval = tree.getSourceInterval();
        Narrative currentNarrative = this.narratives.pop();
        if (sourceInterval.b - this.currentToken >= 0) {
            org.antlr.v4.runtime.misc.Interval tokenInterval = new org.antlr.v4.runtime.misc.Interval(this.currentToken, sourceInterval.b);
            currentNarrative.getContent().add(this.tokenStream.getText(tokenInterval));
        }
        this.currentToken = sourceInterval.b + 1;
        if (o instanceof Element) {
            Element element = (Element)o;
            if (element.getLocalId() == null) {
                element.setLocalId(Integer.toString(this.getNextLocalId()));
                currentNarrative.setR(element.getLocalId());
                if (!this.narratives.isEmpty()) {
                    Narrative parentNarrative = this.narratives.peek();
                    parentNarrative.getContent().add(new JAXBElement(new QName("urn:hl7-org:cql-annotations:r1", "s"), Narrative.class, (Object)currentNarrative));
                }
                if (o instanceof ExpressionDef) {
                    ExpressionDef expressionDef = (ExpressionDef)o;
                    expressionDef.getAnnotation().add(this.af.createAnnotation().withS(currentNarrative));
                }
            } else if (!this.narratives.isEmpty()) {
                Narrative parentNarrative = this.narratives.peek();
                parentNarrative.getContent().addAll(currentNarrative.getContent());
            }
        } else if (!this.narratives.isEmpty()) {
            Narrative parentNarrative = this.narratives.peek();
            parentNarrative.getContent().addAll(currentNarrative.getContent());
        }
        return currentNarrative;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(@NotNull ParseTree tree) {
        if (this.annotate) {
            this.pushNarrative(tree);
        }
        Object o = null;
        try {
            try {
                o = super.visit(tree);
            }
            catch (CqlTranslatorIncludeException e) {
                this.recordParsingException(new CqlTranslatorException(e.getMessage(), this.getTrackBack((ParserRuleContext)tree), e));
            }
            catch (CqlTranslatorException e) {
                this.recordParsingException(e);
            }
            catch (Exception e) {
                this.recordParsingException(new CqlTranslatorException(e.getMessage() == null ? "Internal translator error." : e.getMessage(), tree instanceof ParserRuleContext ? this.getTrackBack((ParserRuleContext)tree) : null, e));
                o = this.of.createNull();
            }
        }
        finally {
            if (this.annotate) {
                this.popNarrative(tree, o);
            }
        }
        if (o instanceof Trackable && tree instanceof ParserRuleContext && !(tree instanceof cqlParser.LogicContext)) {
            this.track((Trackable)o, (ParserRuleContext)tree);
        }
        if (o instanceof Expression) {
            this.addExpression((Expression)o);
        }
        return o;
    }

    private Library getOrInitializeLibrary() {
        if (this.library == null) {
            this.library = this.of.createLibrary().withSchemaIdentifier(this.of.createVersionedIdentifier().withId("urn:hl7-org:elm").withVersion("r1"));
        }
        return this.library;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitLogic(@NotNull cqlParser.LogicContext ctx) {
        this.getOrInitializeLibrary();
        this.translatedLibrary = new TranslatedLibrary();
        this.loadSystemLibrary();
        if (this.libraryInfo.getLibraryName() == null) {
            this.libraryInfo.setLibraryName("Anonymous");
        }
        Object lastResult = null;
        this.libraryManager.beginTranslation(this.libraryInfo.getLibraryName());
        try {
            for (int i = 0; i < ctx.getChildCount(); ++i) {
                lastResult = this.visit(ctx.getChild(i));
            }
            Object object = lastResult;
            return object;
        }
        finally {
            this.libraryManager.endTranslation(this.libraryInfo.getLibraryName());
        }
    }

    public VersionedIdentifier visitLibraryDefinition(@NotNull cqlParser.LibraryDefinitionContext ctx) {
        VersionedIdentifier vid = this.of.createVersionedIdentifier().withId(this.parseString((ParseTree)ctx.identifier())).withVersion(this.parseString((ParseTree)ctx.versionSpecifier()));
        this.setLibraryIdentifier(vid);
        return vid;
    }

    public UsingDef visitUsingDefinition(@NotNull cqlParser.UsingDefinitionContext ctx) {
        Model model = this.getModel(this.parseString((ParseTree)ctx.identifier()), this.parseString((ParseTree)ctx.versionSpecifier()));
        return this.translatedLibrary.resolveUsingRef(model.getModelInfo().getName());
    }

    public Object visitIncludeDefinition(@NotNull cqlParser.IncludeDefinitionContext ctx) {
        IncludeDef library = this.of.createIncludeDef().withLocalIdentifier(this.parseString((ParseTree)ctx.localIdentifier())).withPath(this.parseString((ParseTree)ctx.identifier())).withVersion(this.parseString((ParseTree)ctx.versionSpecifier()));
        this.addToLibrary(library);
        return library;
    }

    public ParameterDef visitParameterDefinition(@NotNull cqlParser.ParameterDefinitionContext ctx) {
        ParameterDef param = this.of.createParameterDef().withAccessLevel(this.parseAccessModifier((ParseTree)ctx.accessModifier())).withName(this.parseString((ParseTree)ctx.identifier())).withDefault(this.parseExpression((ParseTree)ctx.expression())).withParameterTypeSpecifier(this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier()));
        DataType paramType = null;
        if (param.getParameterTypeSpecifier() != null) {
            paramType = param.getParameterTypeSpecifier().getResultType();
        }
        if (param.getDefault() != null) {
            if (paramType != null) {
                this.verifyType(param.getDefault().getResultType(), paramType);
            } else {
                paramType = param.getDefault().getResultType();
            }
        }
        if (paramType == null) {
            throw new IllegalArgumentException(String.format("Could not determine parameter type for parameter %s.", param.getName()));
        }
        param.setResultType(paramType);
        if (param.getDefault() != null) {
            param.setDefault(this.ensureCompatible(param.getDefault(), paramType));
        }
        this.addToLibrary(param);
        return param;
    }

    public NamedTypeSpecifier visitNamedTypeSpecifier(@NotNull cqlParser.NamedTypeSpecifierContext ctx) {
        DataType resultType = this.resolveTypeName(this.parseString((ParseTree)ctx.modelIdentifier()), this.parseString((ParseTree)ctx.identifier()));
        NamedTypeSpecifier result = this.of.createNamedTypeSpecifier().withName(this.dataTypeToQName(resultType));
        result.setResultType(resultType);
        return result;
    }

    public TupleElementDefinition visitTupleElementDefinition(@NotNull cqlParser.TupleElementDefinitionContext ctx) {
        TupleElementDefinition result = this.of.createTupleElementDefinition().withName(this.parseString((ParseTree)ctx.identifier())).withType(this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier()));
        return result;
    }

    public Object visitTupleTypeSpecifier(@NotNull cqlParser.TupleTypeSpecifierContext ctx) {
        TupleType resultType = new TupleType();
        TupleTypeSpecifier typeSpecifier = this.of.createTupleTypeSpecifier();
        for (cqlParser.TupleElementDefinitionContext definitionContext : ctx.tupleElementDefinition()) {
            TupleElementDefinition element = (TupleElementDefinition)this.visit((ParseTree)definitionContext);
            resultType.addElement(new TupleTypeElement(element.getName(), element.getType().getResultType()));
            typeSpecifier.getElement().add(element);
        }
        typeSpecifier.setResultType((DataType)resultType);
        return typeSpecifier;
    }

    public IntervalTypeSpecifier visitIntervalTypeSpecifier(@NotNull cqlParser.IntervalTypeSpecifierContext ctx) {
        IntervalTypeSpecifier result = this.of.createIntervalTypeSpecifier().withPointType(this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier()));
        IntervalType intervalType = new IntervalType(result.getPointType().getResultType());
        result.setResultType((DataType)intervalType);
        return result;
    }

    public ListTypeSpecifier visitListTypeSpecifier(@NotNull cqlParser.ListTypeSpecifierContext ctx) {
        ListTypeSpecifier result = this.of.createListTypeSpecifier().withElementType(this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier()));
        ListType listType = new ListType(result.getElementType().getResultType());
        result.setResultType((DataType)listType);
        return result;
    }

    public AccessModifier visitAccessModifier(@NotNull cqlParser.AccessModifierContext ctx) {
        switch (ctx.getText().toLowerCase()) {
            case "public": {
                return AccessModifier.PUBLIC;
            }
            case "private": {
                return AccessModifier.PRIVATE;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown access modifier %s.", ctx.getText().toLowerCase()));
    }

    public CodeSystemDef visitCodesystemDefinition(@NotNull cqlParser.CodesystemDefinitionContext ctx) {
        CodeSystemDef cs = (CodeSystemDef)this.of.createCodeSystemDef().withAccessLevel(this.parseAccessModifier((ParseTree)ctx.accessModifier())).withName(this.parseString((ParseTree)ctx.identifier())).withId(this.parseString((ParseTree)ctx.codesystemId())).withVersion(this.parseString((ParseTree)ctx.versionSpecifier())).withResultType((DataType)new ListType(this.resolveTypeName("Code")));
        this.addToLibrary(cs);
        return cs;
    }

    public CodeSystemRef visitCodesystemIdentifier(@NotNull cqlParser.CodesystemIdentifierContext ctx) {
        CodeSystemDef def;
        String libraryName = this.parseString((ParseTree)ctx.libraryIdentifier());
        String name = this.parseString((ParseTree)ctx.identifier());
        if (libraryName != null) {
            def = this.resolveLibrary(libraryName).resolveCodeSystemRef(name);
            this.checkAccessLevel(libraryName, name, def.getAccessLevel());
        } else {
            def = this.translatedLibrary.resolveCodeSystemRef(name);
        }
        if (def == null) {
            throw new IllegalArgumentException(String.format("Could not resolve reference to code system %s.", name));
        }
        return (CodeSystemRef)this.of.createCodeSystemRef().withLibraryName(libraryName).withName(name).withResultType(def.getResultType());
    }

    public ValueSetDef visitValuesetDefinition(@NotNull cqlParser.ValuesetDefinitionContext ctx) {
        ValueSetDef vs = this.of.createValueSetDef().withAccessLevel(this.parseAccessModifier((ParseTree)ctx.accessModifier())).withName(this.parseString((ParseTree)ctx.identifier())).withId(this.parseString((ParseTree)ctx.valuesetId())).withVersion(this.parseString((ParseTree)ctx.versionSpecifier()));
        if (ctx.codesystems() != null) {
            for (cqlParser.CodesystemIdentifierContext codesystem : ctx.codesystems().codesystemIdentifier()) {
                vs.getCodeSystem().add((CodeSystemRef)this.visit((ParseTree)codesystem));
            }
        }
        vs.setResultType((DataType)new ListType(this.resolveTypeName("Code")));
        this.addToLibrary(vs);
        return vs;
    }

    public Object visitContextDefinition(@NotNull cqlParser.ContextDefinitionContext ctx) {
        this.currentContext = this.parseString((ParseTree)ctx.identifier());
        if (!this.currentContext.equals("Patient") && !this.currentContext.equals("Population")) {
            throw new IllegalArgumentException(String.format("Unknown context %s.", this.currentContext));
        }
        if (!this.implicitPatientCreated) {
            if (this.hasUsings()) {
                String patientTypeName = this.getModel().getModelInfo().getPatientClassName();
                if (patientTypeName == null || patientTypeName.equals("")) {
                    throw new IllegalArgumentException("Model definition does not contain enough information to construct a patient context.");
                }
                DataType patientType = this.resolveTypeName(patientTypeName);
                Retrieve patientRetrieve = this.of.createRetrieve().withDataType(this.dataTypeToQName(patientType));
                patientRetrieve.setResultType((DataType)new ListType(patientType));
                String patientClassIdentifier = this.getModel().getModelInfo().getPatientClassIdentifier();
                if (patientClassIdentifier != null) {
                    patientRetrieve.setTemplateId(patientClassIdentifier);
                }
                ExpressionDef patientExpressionDef = this.of.createExpressionDef().withName("Patient").withContext(this.currentContext).withExpression((Expression)this.of.createSingletonFrom().withOperand((Expression)patientRetrieve));
                patientExpressionDef.getExpression().setResultType(patientType);
                patientExpressionDef.setResultType(patientType);
                this.addToLibrary(patientExpressionDef);
            } else {
                ExpressionDef patientExpressionDef = this.of.createExpressionDef().withName("Patient").withContext(this.currentContext).withExpression((Expression)this.of.createNull());
                patientExpressionDef.getExpression().setResultType(this.resolveTypeName("System", "Any"));
                patientExpressionDef.setResultType(patientExpressionDef.getExpression().getResultType());
                this.addToLibrary(patientExpressionDef);
            }
            this.implicitPatientCreated = true;
            return this.currentContext;
        }
        return this.currentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionDef visitExpressionDefinition(@NotNull cqlParser.ExpressionDefinitionContext ctx) {
        String identifier = this.parseString((ParseTree)ctx.identifier());
        ExpressionDef def = this.translatedLibrary.resolveExpressionRef(identifier);
        if (def == null) {
            this.pushExpressionDefinition(identifier);
            this.pushExpressionContext(this.currentContext);
            try {
                def = this.of.createExpressionDef().withAccessLevel(this.parseAccessModifier((ParseTree)ctx.accessModifier())).withName(identifier).withContext(this.currentContext).withExpression((Expression)this.visit((ParseTree)ctx.expression()));
                def.setResultType(def.getExpression().getResultType());
                this.addToLibrary(def);
            }
            finally {
                this.popExpressionDefinition();
                this.popExpressionContext();
            }
        }
        return def;
    }

    public Literal visitStringLiteral(@NotNull cqlParser.StringLiteralContext ctx) {
        return this.createLiteral(this.parseString((ParseTree)ctx.STRING()));
    }

    public Literal visitBooleanLiteral(@NotNull cqlParser.BooleanLiteralContext ctx) {
        return this.createLiteral(Boolean.valueOf(ctx.getText()));
    }

    public Object visitIntervalSelector(@NotNull cqlParser.IntervalSelectorContext ctx) {
        Interval result = this.of.createInterval().withLow(this.parseExpression((ParseTree)ctx.expression(0))).withLowClosed(Boolean.valueOf(ctx.getChild(1).getText().equals("["))).withHigh(this.parseExpression((ParseTree)ctx.expression(1))).withHighClosed(Boolean.valueOf(ctx.getChild(5).getText().equals("]")));
        DataType pointType = this.ensureCompatibleTypes(result.getLow().getResultType(), result.getHigh().getResultType());
        result.setResultType((DataType)new IntervalType(pointType));
        result.setLow(this.ensureCompatible(result.getLow(), pointType));
        result.setHigh(this.ensureCompatible(result.getHigh(), pointType));
        return result;
    }

    public Object visitTupleElementSelector(@NotNull cqlParser.TupleElementSelectorContext ctx) {
        TupleElement result = this.of.createTupleElement().withName(this.parseString((ParseTree)ctx.identifier())).withValue(this.parseExpression((ParseTree)ctx.expression()));
        result.setResultType(result.getValue().getResultType());
        return result;
    }

    public Object visitTupleSelector(@NotNull cqlParser.TupleSelectorContext ctx) {
        Tuple tuple = this.of.createTuple();
        TupleType tupleType = new TupleType();
        for (cqlParser.TupleElementSelectorContext elementContext : ctx.tupleElementSelector()) {
            TupleElement element = (TupleElement)this.visit((ParseTree)elementContext);
            tupleType.addElement(new TupleTypeElement(element.getName(), element.getResultType()));
            tuple.getElement().add(element);
        }
        tuple.setResultType((DataType)tupleType);
        return tuple;
    }

    public Object visitInstanceElementSelector(@NotNull cqlParser.InstanceElementSelectorContext ctx) {
        InstanceElement result = this.of.createInstanceElement().withName(this.parseString((ParseTree)ctx.identifier())).withValue(this.parseExpression((ParseTree)ctx.expression()));
        result.setResultType(result.getValue().getResultType());
        return result;
    }

    public Object visitInstanceSelector(@NotNull cqlParser.InstanceSelectorContext ctx) {
        Instance instance = this.of.createInstance();
        NamedTypeSpecifier classTypeSpecifier = this.visitNamedTypeSpecifier(ctx.namedTypeSpecifier());
        instance.setClassType(classTypeSpecifier.getName());
        instance.setResultType(classTypeSpecifier.getResultType());
        for (cqlParser.InstanceElementSelectorContext elementContext : ctx.instanceElementSelector()) {
            InstanceElement element = (InstanceElement)this.visit((ParseTree)elementContext);
            DataType propertyType = this.resolveProperty(classTypeSpecifier.getResultType(), element.getName());
            element.setValue(this.ensureCompatible(element.getValue(), propertyType));
            instance.getElement().add(element);
        }
        return instance;
    }

    public Object visitCodeSelector(@NotNull cqlParser.CodeSelectorContext ctx) {
        Code code = this.of.createCode();
        code.setCode(this.parseString((ParseTree)ctx.stringLiteral().STRING()));
        code.setSystem((CodeSystemRef)this.visit((ParseTree)ctx.codesystemIdentifier()));
        if (ctx.displayClause() != null) {
            code.setDisplay(this.parseString((ParseTree)ctx.displayClause().stringLiteral().STRING()));
        }
        code.setResultType(this.resolveTypeName("Code"));
        return code;
    }

    public Object visitConceptSelector(@NotNull cqlParser.ConceptSelectorContext ctx) {
        Concept concept = this.of.createConcept();
        if (ctx.displayClause() != null) {
            concept.setDisplay(this.parseString((ParseTree)ctx.displayClause().stringLiteral().STRING()));
        }
        for (cqlParser.CodeSelectorContext codeContext : ctx.codeSelector()) {
            concept.getCode().add((Code)this.visit((ParseTree)codeContext));
        }
        concept.setResultType(this.resolveTypeName("Concept"));
        return concept;
    }

    public Object visitListSelector(@NotNull cqlParser.ListSelectorContext ctx) {
        TypeSpecifier elementTypeSpecifier = this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier());
        org.hl7.elm.r1.List list = this.of.createList();
        ListType listType = null;
        if (elementTypeSpecifier != null) {
            ListTypeSpecifier listTypeSpecifier = this.of.createListTypeSpecifier().withElementType(elementTypeSpecifier);
            listType = new ListType(elementTypeSpecifier.getResultType());
            listTypeSpecifier.setResultType((DataType)listType);
        }
        DataType elementType = elementTypeSpecifier != null ? elementTypeSpecifier.getResultType() : null;
        DataType inferredElementType = null;
        ArrayList<Expression> elements = new ArrayList<Expression>();
        for (cqlParser.ExpressionContext elementContext : ctx.expression()) {
            Expression element = this.parseExpression((ParseTree)elementContext);
            if (elementType != null) {
                this.verifyType(element.getResultType(), elementType);
            } else {
                inferredElementType = inferredElementType == null ? element.getResultType() : this.ensureCompatibleTypes(inferredElementType, element.getResultType());
            }
            elements.add(element);
        }
        if (elementType == null) {
            elementType = inferredElementType == null ? this.resolveTypeName("System", "Any") : inferredElementType;
        }
        for (Expression element : elements) {
            if (!elementType.isSuperTypeOf(element.getResultType())) {
                list.getElement().add(this.convertExpression(element, elementType));
                continue;
            }
            list.getElement().add(element);
        }
        if (listType == null) {
            listType = new ListType(elementType);
        }
        list.setResultType((DataType)listType);
        return list;
    }

    public Object visitTimeLiteral(@NotNull cqlParser.TimeLiteralContext ctx) {
        Pattern dateTimePattern;
        Matcher matcher;
        String input = ctx.getText();
        if (input.startsWith("@")) {
            input = input.substring(1);
        }
        if ((matcher = (dateTimePattern = Pattern.compile("T((\\d{2})(\\:(\\d{2})(\\:(\\d{2})(\\.(\\d+))?)?)?)?((Z)|(([+-])(\\d{2})(\\:?(\\d{2}))?))?")).matcher(input)).matches()) {
            try {
                Time result = this.of.createTime();
                int hour = Integer.parseInt(matcher.group(2));
                int minute = -1;
                int second = -1;
                int millisecond = -1;
                if (hour < 0 || hour > 24) {
                    throw new IllegalArgumentException(String.format("Invalid hour in time literal (%s).", input));
                }
                result.setHour((Expression)this.createLiteral(hour));
                if (matcher.group(4) != null) {
                    minute = Integer.parseInt(matcher.group(4));
                    if (minute < 0 || minute >= 60 || hour == 24 && minute > 0) {
                        throw new IllegalArgumentException(String.format("Invalid minute in time literal (%s).", input));
                    }
                    result.setMinute((Expression)this.createLiteral(minute));
                }
                if (matcher.group(6) != null) {
                    second = Integer.parseInt(matcher.group(6));
                    if (second < 0 || second >= 60 || hour == 24 && second > 0) {
                        throw new IllegalArgumentException(String.format("Invalid second in time literal (%s).", input));
                    }
                    result.setSecond((Expression)this.createLiteral(second));
                }
                if (matcher.group(8) != null) {
                    millisecond = Integer.parseInt(matcher.group(8));
                    if (millisecond < 0 || hour == 24 && millisecond > 0) {
                        throw new IllegalArgumentException(String.format("Invalid millisecond in time literal (%s).", input));
                    }
                    result.setMillisecond((Expression)this.createLiteral(millisecond));
                }
                if (matcher.group(10) != null && matcher.group(10).equals("Z")) {
                    result.setTimezoneOffset((Expression)this.createLiteral(0.0));
                }
                if (matcher.group(12) != null) {
                    int offsetPolarity;
                    int n = offsetPolarity = matcher.group(12).equals("+") ? 1 : 0;
                    if (matcher.group(15) != null) {
                        int hourOffset = Integer.parseInt(matcher.group(13));
                        if (hourOffset < 0 || hourOffset > 14) {
                            throw new IllegalArgumentException(String.format("Timezone hour offset out of range in time literal (%s).", input));
                        }
                        int minuteOffset = Integer.parseInt(matcher.group(15));
                        if (minuteOffset < 0 || minuteOffset >= 60 || hourOffset == 14 && minuteOffset > 0) {
                            throw new IllegalArgumentException(String.format("Timezone minute offset out of range in time literal (%s).", input));
                        }
                        result.setTimezoneOffset((Expression)this.createLiteral((double)(hourOffset + minuteOffset / 60) * (double)offsetPolarity));
                    } else if (matcher.group(13) != null) {
                        int hourOffset = Integer.parseInt(matcher.group(13));
                        if (hourOffset < 0 || hourOffset > 14) {
                            throw new IllegalArgumentException(String.format("Timezone hour offset out of range in time literal (%s).", input));
                        }
                        result.setTimezoneOffset((Expression)this.createLiteral(Double.valueOf(hourOffset * offsetPolarity)));
                    }
                }
                result.setResultType(this.resolveTypeName("Time"));
                return result;
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException(String.format("Invalid date-time input (%s). Use ISO 8601 date time representation (yyyy-MM-ddThh:mm:ss.mmmmZhh:mm).", input), e);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid date-time input (%s). Use ISO 8601 date time representation (yyyy-MM-ddThh:mm:ss.mmmmZhh:mm).", input));
    }

    public Object visitDateTimeLiteral(@NotNull cqlParser.DateTimeLiteralContext ctx) {
        Pattern dateTimePattern;
        Matcher matcher;
        String input = ctx.getText();
        if (input.startsWith("@")) {
            input = input.substring(1);
        }
        if ((matcher = (dateTimePattern = Pattern.compile("(\\d{4})(-(\\d{2}))?(-(\\d{2}))?((Z)|(T((\\d{2})(\\:(\\d{2})(\\:(\\d{2})(\\.(\\d+))?)?)?)?((Z)|(([+-])(\\d{2})(\\:?(\\d{2}))?))?))?")).matcher(input)).matches()) {
            try {
                GregorianCalendar calendar = (GregorianCalendar)GregorianCalendar.getInstance();
                DateTime result = this.of.createDateTime();
                int year = Integer.parseInt(matcher.group(1));
                int month = -1;
                int day = -1;
                int hour = -1;
                int minute = -1;
                int second = -1;
                int millisecond = -1;
                result.setYear((Expression)this.createLiteral(year));
                if (matcher.group(3) != null) {
                    month = Integer.parseInt(matcher.group(3));
                    if (month < 0 || month > 12) {
                        throw new IllegalArgumentException(String.format("Invalid month in date/time literal (%s).", input));
                    }
                    result.setMonth((Expression)this.createLiteral(month));
                }
                if (matcher.group(5) != null) {
                    day = Integer.parseInt(matcher.group(5));
                    int maxDay = 31;
                    switch (month) {
                        case 2: {
                            maxDay = calendar.isLeapYear(year) ? 29 : 28;
                            break;
                        }
                        case 4: 
                        case 6: 
                        case 9: 
                        case 11: {
                            maxDay = 30;
                            break;
                        }
                    }
                    if (day < 0 || day > maxDay) {
                        throw new IllegalArgumentException(String.format("Invalid day in date/time literal (%s).", input));
                    }
                    result.setDay((Expression)this.createLiteral(day));
                }
                if (matcher.group(10) != null) {
                    hour = Integer.parseInt(matcher.group(10));
                    if (hour < 0 || hour > 24) {
                        throw new IllegalArgumentException(String.format("Invalid hour in date/time literal (%s).", input));
                    }
                    result.setHour((Expression)this.createLiteral(hour));
                }
                if (matcher.group(12) != null) {
                    minute = Integer.parseInt(matcher.group(12));
                    if (minute < 0 || minute >= 60 || hour == 24 && minute > 0) {
                        throw new IllegalArgumentException(String.format("Invalid minute in date/time literal (%s).", input));
                    }
                    result.setMinute((Expression)this.createLiteral(minute));
                }
                if (matcher.group(14) != null) {
                    second = Integer.parseInt(matcher.group(14));
                    if (second < 0 || second >= 60 || hour == 24 && second > 0) {
                        throw new IllegalArgumentException(String.format("Invalid second in date/time literal (%s).", input));
                    }
                    result.setSecond((Expression)this.createLiteral(second));
                }
                if (matcher.group(16) != null) {
                    millisecond = Integer.parseInt(matcher.group(16));
                    if (millisecond < 0 || hour == 24 && millisecond > 0) {
                        throw new IllegalArgumentException(String.format("Invalid millisecond in date/time literal (%s).", input));
                    }
                    result.setMillisecond((Expression)this.createLiteral(millisecond));
                }
                if (matcher.group(7) != null && matcher.group(7).equals("Z") || matcher.group(18) != null && matcher.group(18).equals("Z")) {
                    result.setTimezoneOffset((Expression)this.createLiteral(0.0));
                }
                if (matcher.group(20) != null) {
                    int offsetPolarity;
                    int n = offsetPolarity = matcher.group(20).equals("+") ? 1 : 0;
                    if (matcher.group(23) != null) {
                        int hourOffset = Integer.parseInt(matcher.group(21));
                        if (hourOffset < 0 || hourOffset > 14) {
                            throw new IllegalArgumentException(String.format("Timezone hour offset is out of range in date/time literal (%s).", input));
                        }
                        int minuteOffset = Integer.parseInt(matcher.group(23));
                        if (minuteOffset < 0 || minuteOffset >= 60 || hourOffset == 14 && minuteOffset > 0) {
                            throw new IllegalArgumentException(String.format("Timezone minute offset is out of range in date/time literal (%s).", input));
                        }
                        result.setTimezoneOffset((Expression)this.createLiteral((double)(hourOffset + minuteOffset / 60) * (double)offsetPolarity));
                    } else if (matcher.group(21) != null) {
                        int hourOffset = Integer.parseInt(matcher.group(21));
                        if (hourOffset < 0 || hourOffset > 14) {
                            throw new IllegalArgumentException(String.format("Timezone hour offset is out of range in date/time literal (%s).", input));
                        }
                        result.setTimezoneOffset((Expression)this.createLiteral(Double.valueOf(hourOffset * offsetPolarity)));
                    }
                }
                result.setResultType(this.resolveTypeName("DateTime"));
                return result;
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException(String.format("Invalid date-time input (%s). Use ISO 8601 date time representation (yyyy-MM-ddThh:mm:ss.mmmmZhh:mm).", input), e);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid date-time input (%s). Use ISO 8601 date time representation (yyyy-MM-ddThh:mm:ss.mmmmZhh:mm).", input));
    }

    public Null visitNullLiteral(@NotNull cqlParser.NullLiteralContext ctx) {
        Null result = this.of.createNull();
        result.setResultType(this.resolveTypeName("System", "Any"));
        return result;
    }

    public Expression visitQuantityLiteral(@NotNull cqlParser.QuantityLiteralContext ctx) {
        if (ctx.unit() != null) {
            DecimalFormat df = new DecimalFormat("#.#");
            df.setParseBigDecimal(true);
            try {
                Quantity result = this.of.createQuantity().withValue((BigDecimal)df.parse(ctx.QUANTITY().getText())).withUnit(this.parseString((ParseTree)ctx.unit()));
                result.setResultType(this.resolveTypeName("Quantity"));
                return result;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Could not parse quantity literal: %s", ctx.getText()), e);
            }
        }
        String quantity = ctx.QUANTITY().getText();
        DataType resultType = this.resolveTypeName(quantity.contains(".") ? "Decimal" : "Integer");
        Literal result = this.of.createLiteral().withValue(quantity).withValueType(this.dataTypeToQName(resultType));
        result.setResultType(resultType);
        return result;
    }

    public Not visitNotExpression(@NotNull cqlParser.NotExpressionContext ctx) {
        Not result = this.of.createNot().withOperand(this.parseExpression((ParseTree)ctx.expression()));
        this.resolveUnaryCall("System", "Not", (UnaryExpression)result);
        return result;
    }

    public Exists visitExistenceExpression(@NotNull cqlParser.ExistenceExpressionContext ctx) {
        Exists result = this.of.createExists().withOperand(this.parseExpression((ParseTree)ctx.expression()));
        this.resolveUnaryCall("System", "Exists", (UnaryExpression)result);
        return result;
    }

    public BinaryExpression visitMultiplicationExpressionTerm(@NotNull cqlParser.MultiplicationExpressionTermContext ctx) {
        Multiply exp = null;
        String operatorName = null;
        switch (ctx.getChild(1).getText()) {
            case "*": {
                exp = this.of.createMultiply();
                operatorName = "Multiply";
                break;
            }
            case "/": {
                exp = this.of.createDivide();
                operatorName = "Divide";
                break;
            }
            case "div": {
                exp = this.of.createTruncatedDivide();
                operatorName = "TruncatedDivide";
                break;
            }
            case "mod": {
                exp = this.of.createModulo();
                operatorName = "Modulo";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported operator: %s.", ctx.getChild(1).getText()));
            }
        }
        exp.withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expressionTerm(0)), this.parseExpression((ParseTree)ctx.expressionTerm(1))});
        this.resolveBinaryCall("System", operatorName, (BinaryExpression)exp);
        return exp;
    }

    public Power visitPowerExpressionTerm(@NotNull cqlParser.PowerExpressionTermContext ctx) {
        Power power = this.of.createPower().withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expressionTerm(0)), this.parseExpression((ParseTree)ctx.expressionTerm(1))});
        this.resolveBinaryCall("System", "Power", (BinaryExpression)power);
        return power;
    }

    public Object visitPolarityExpressionTerm(@NotNull cqlParser.PolarityExpressionTermContext ctx) {
        if (ctx.getChild(0).getText().equals("+")) {
            return this.visit((ParseTree)ctx.expressionTerm());
        }
        Negate result = this.of.createNegate().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
        this.resolveUnaryCall("System", "Negate", (UnaryExpression)result);
        return result;
    }

    public BinaryExpression visitAdditionExpressionTerm(@NotNull cqlParser.AdditionExpressionTermContext ctx) {
        Add exp = null;
        String operatorName = null;
        switch (ctx.getChild(1).getText()) {
            case "+": {
                exp = this.of.createAdd();
                operatorName = "Add";
                break;
            }
            case "-": {
                exp = this.of.createSubtract();
                operatorName = "Subtract";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported operator: %s.", ctx.getChild(1).getText()));
            }
        }
        exp.withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expressionTerm(0)), this.parseExpression((ParseTree)ctx.expressionTerm(1))});
        this.resolveBinaryCall("System", operatorName, (BinaryExpression)exp);
        return exp;
    }

    public Object visitPredecessorExpressionTerm(@NotNull cqlParser.PredecessorExpressionTermContext ctx) {
        Predecessor result = this.of.createPredecessor().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
        this.resolveUnaryCall("System", "Predecessor", (UnaryExpression)result);
        return result;
    }

    public Object visitSuccessorExpressionTerm(@NotNull cqlParser.SuccessorExpressionTermContext ctx) {
        Successor result = this.of.createSuccessor().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
        this.resolveUnaryCall("System", "Successor", (UnaryExpression)result);
        return result;
    }

    public Object visitElementExtractorExpressionTerm(@NotNull cqlParser.ElementExtractorExpressionTermContext ctx) {
        SingletonFrom result = this.of.createSingletonFrom().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
        if (!(result.getOperand().getResultType() instanceof ListType)) {
            throw new IllegalArgumentException("List type expected.");
        }
        result.setResultType(((ListType)result.getOperand().getResultType()).getElementType());
        this.resolveUnaryCall("System", "SingletonFrom", (UnaryExpression)result);
        return result;
    }

    public Object visitTypeExtentExpressionTerm(@NotNull cqlParser.TypeExtentExpressionTermContext ctx) {
        String extent = this.parseString(ctx.getChild(0));
        TypeSpecifier targetType = this.parseTypeSpecifier((ParseTree)ctx.namedTypeSpecifier());
        switch (extent) {
            case "minimum": {
                MinValue minimum = this.of.createMinValue();
                minimum.setValueType(this.dataTypeToQName(targetType.getResultType()));
                minimum.setResultType(targetType.getResultType());
                return minimum;
            }
            case "maximum": {
                MaxValue maximum = this.of.createMaxValue();
                maximum.setValueType(this.dataTypeToQName(targetType.getResultType()));
                maximum.setResultType(targetType.getResultType());
                return maximum;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown extent: %s", extent));
    }

    public Object visitTimeBoundaryExpressionTerm(@NotNull cqlParser.TimeBoundaryExpressionTermContext ctx) {
        Start result = null;
        String operatorName = null;
        if (ctx.getChild(0).getText().equals("start")) {
            result = this.of.createStart().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
            operatorName = "Start";
        } else {
            result = this.of.createEnd().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
            operatorName = "End";
        }
        if (!(result.getOperand().getResultType() instanceof IntervalType)) {
            throw new IllegalArgumentException("Interval type expected.");
        }
        result.setResultType(((IntervalType)result.getOperand().getResultType()).getPointType());
        this.resolveUnaryCall("System", operatorName, (UnaryExpression)result);
        return result;
    }

    private DateTimePrecision parseDateTimePrecision(String dateTimePrecision) {
        if (dateTimePrecision == null) {
            throw new IllegalArgumentException("dateTimePrecision is null");
        }
        switch (dateTimePrecision) {
            case "a": 
            case "year": 
            case "years": {
                return DateTimePrecision.YEAR;
            }
            case "mo": 
            case "month": 
            case "months": {
                return DateTimePrecision.MONTH;
            }
            case "d": 
            case "day": 
            case "days": {
                return DateTimePrecision.DAY;
            }
            case "h": 
            case "hour": 
            case "hours": {
                return DateTimePrecision.HOUR;
            }
            case "min": 
            case "minute": 
            case "minutes": {
                return DateTimePrecision.MINUTE;
            }
            case "s": 
            case "second": 
            case "seconds": {
                return DateTimePrecision.SECOND;
            }
            case "ms": 
            case "millisecond": 
            case "milliseconds": {
                return DateTimePrecision.MILLISECOND;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown precision '%s'.", dateTimePrecision));
    }

    public Object visitTimeUnitExpressionTerm(@NotNull cqlParser.TimeUnitExpressionTermContext ctx) {
        String component = ctx.dateTimeComponent().getText();
        DateFrom result = null;
        String operatorName = null;
        switch (component) {
            case "date": {
                result = this.of.createDateFrom().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
                operatorName = "DateFrom";
                break;
            }
            case "time": {
                result = this.of.createTimeFrom().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
                operatorName = "TimeFrom";
                break;
            }
            case "timezone": {
                result = this.of.createTimezoneFrom().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
                operatorName = "TimezoneFrom";
                break;
            }
            case "year": 
            case "month": 
            case "day": 
            case "hour": 
            case "minute": 
            case "second": 
            case "millisecond": {
                result = this.of.createDateTimeComponentFrom().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm())).withPrecision(this.parseDateTimePrecision(component));
                operatorName = "DateTimeComponentFrom";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown precision '%s'.", component));
            }
        }
        this.resolveUnaryCall("System", operatorName, (UnaryExpression)result);
        return result;
    }

    public Object visitDurationExpressionTerm(@NotNull cqlParser.DurationExpressionTermContext ctx) {
        Expression operand = this.parseExpression((ParseTree)ctx.expressionTerm());
        Start start = this.of.createStart().withOperand(operand);
        this.resolveUnaryCall("System", "Start", (UnaryExpression)start);
        End end = this.of.createEnd().withOperand(operand);
        this.resolveUnaryCall("System", "End", (UnaryExpression)end);
        DurationBetween result = this.of.createDurationBetween().withPrecision(this.parseDateTimePrecision(ctx.pluralDateTimePrecision().getText())).withOperand(new Expression[]{start, end});
        this.resolveBinaryCall("System", "DurationBetween", (BinaryExpression)result);
        return result;
    }

    public Object visitBetweenExpression(@NotNull cqlParser.BetweenExpressionContext ctx) {
        Expression first = this.parseExpression((ParseTree)ctx.expression());
        Expression second = this.parseExpression((ParseTree)ctx.expressionTerm(0));
        Expression third = this.parseExpression((ParseTree)ctx.expressionTerm(1));
        boolean isProper = ctx.getChild(0).getText().equals("properly");
        And result = this.of.createAnd().withOperand(new Expression[]{(isProper ? this.of.createGreater() : this.of.createGreaterOrEqual()).withOperand(new Expression[]{first, second}), (isProper ? this.of.createLess() : this.of.createLessOrEqual()).withOperand(new Expression[]{first, third})});
        this.resolveBinaryCall("System", isProper ? "Greater" : "GreaterOrEqual", (BinaryExpression)result.getOperand().get(0));
        this.resolveBinaryCall("System", isProper ? "Less" : "LessOrEqual", (BinaryExpression)result.getOperand().get(1));
        this.resolveBinaryCall("System", "And", (BinaryExpression)result);
        return result;
    }

    public Object visitDurationBetweenExpression(@NotNull cqlParser.DurationBetweenExpressionContext ctx) {
        DurationBetween result = this.of.createDurationBetween().withPrecision(this.parseDateTimePrecision(ctx.pluralDateTimePrecision().getText())).withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expressionTerm(0)), this.parseExpression((ParseTree)ctx.expressionTerm(1))});
        this.resolveBinaryCall("System", "DurationBetween", (BinaryExpression)result);
        return result;
    }

    public Object visitDifferenceBetweenExpression(@NotNull cqlParser.DifferenceBetweenExpressionContext ctx) {
        DifferenceBetween result = this.of.createDifferenceBetween().withPrecision(this.parseDateTimePrecision(ctx.pluralDateTimePrecision().getText())).withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expressionTerm(0)), this.parseExpression((ParseTree)ctx.expressionTerm(1))});
        this.resolveBinaryCall("System", "DifferenceBetween", (BinaryExpression)result);
        return result;
    }

    public Object visitWidthExpressionTerm(@NotNull cqlParser.WidthExpressionTermContext ctx) {
        Width result = this.of.createWidth().withOperand(this.parseExpression((ParseTree)ctx.expressionTerm()));
        this.resolveUnaryCall("System", "Width", (UnaryExpression)result);
        return result;
    }

    public Expression visitParenthesizedTerm(@NotNull cqlParser.ParenthesizedTermContext ctx) {
        return this.parseExpression((ParseTree)ctx.expression());
    }

    public Object visitMembershipExpression(@NotNull cqlParser.MembershipExpressionContext ctx) {
        String operator;
        switch (operator = ctx.getChild(1).getText()) {
            case "in": {
                if (ctx.dateTimePrecisionSpecifier() != null) {
                    In in = this.of.createIn().withPrecision(this.parseDateTimePrecision(ctx.dateTimePrecisionSpecifier().dateTimePrecision().getText())).withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
                    this.resolveBinaryCall("System", "In", (BinaryExpression)in);
                    return in;
                }
                Expression left = this.parseExpression((ParseTree)ctx.expression(0));
                Expression right = this.parseExpression((ParseTree)ctx.expression(1));
                if (right instanceof ValueSetRef) {
                    InValueSet in = this.of.createInValueSet().withCode(left).withValueset((ValueSetRef)right);
                    this.resolveCall("System", "InValueSet", new InValueSetInvocation(in));
                    return in;
                }
                if (right instanceof CodeSystemRef) {
                    InCodeSystem in = this.of.createInCodeSystem().withCode(left).withCodesystem((CodeSystemRef)right);
                    this.resolveCall("System", "InCodeSystem", new InCodeSystemInvocation(in));
                    return in;
                }
                In in = this.of.createIn().withOperand(new Expression[]{left, right});
                this.resolveBinaryCall("System", "In", (BinaryExpression)in);
                return in;
            }
            case "contains": {
                if (ctx.dateTimePrecisionSpecifier() != null) {
                    Contains contains = this.of.createContains().withPrecision(this.parseDateTimePrecision(ctx.dateTimePrecisionSpecifier().dateTimePrecision().getText())).withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
                    this.resolveBinaryCall("System", "Contains", (BinaryExpression)contains);
                    return contains;
                }
                Expression left = this.parseExpression((ParseTree)ctx.expression(0));
                Expression right = this.parseExpression((ParseTree)ctx.expression(1));
                if (left instanceof ValueSetRef) {
                    InValueSet in = this.of.createInValueSet().withCode(right).withValueset((ValueSetRef)left);
                    this.resolveCall("System", "InValueSet", new InValueSetInvocation(in));
                    return in;
                }
                if (left instanceof CodeSystemRef) {
                    InCodeSystem in = this.of.createInCodeSystem().withCode(right).withCodesystem((CodeSystemRef)left);
                    this.resolveCall("System", "InCodeSystem", new InCodeSystemInvocation(in));
                    return in;
                }
                Contains contains = this.of.createContains().withOperand(new Expression[]{left, right});
                this.resolveBinaryCall("System", "Contains", (BinaryExpression)contains);
                return contains;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown operator: %s", operator));
    }

    public And visitAndExpression(@NotNull cqlParser.AndExpressionContext ctx) {
        And and = this.of.createAnd().withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
        this.resolveBinaryCall("System", "And", (BinaryExpression)and);
        return and;
    }

    public Expression visitOrExpression(@NotNull cqlParser.OrExpressionContext ctx) {
        if (ctx.getChild(1).getText().equals("xor")) {
            Xor xor = this.of.createXor().withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
            this.resolveBinaryCall("System", "Xor", (BinaryExpression)xor);
            return xor;
        }
        Or or = this.of.createOr().withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
        this.resolveBinaryCall("System", "Or", (BinaryExpression)or);
        return or;
    }

    public Object visitInFixSetExpression(@NotNull cqlParser.InFixSetExpressionContext ctx) {
        String operator;
        switch (operator = ctx.getChild(1).getText()) {
            case "union": {
                Union union = this.of.createUnion().withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
                this.resolveBinaryCall("System", "Union", (BinaryExpression)union);
                return union;
            }
            case "intersect": {
                Intersect intersect = this.of.createIntersect().withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
                this.resolveBinaryCall("System", "Intersect", (BinaryExpression)intersect);
                return intersect;
            }
            case "except": {
                Except except = this.of.createExcept().withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
                this.resolveBinaryCall("System", "Except", (BinaryExpression)except);
                return except;
            }
        }
        return this.of.createNull();
    }

    public Expression visitEqualityExpression(@NotNull cqlParser.EqualityExpressionContext ctx) {
        String operator = this.parseString(ctx.getChild(1));
        if (operator.equals("matches")) {
            Matches matches = this.of.createMatches().withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
            this.resolveBinaryCall("System", "Matches", (BinaryExpression)matches);
            return matches;
        }
        Equal equal = this.of.createEqual().withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
        this.resolveBinaryCall("System", "Equal", (BinaryExpression)equal);
        if (!"=".equals(this.parseString(ctx.getChild(1)))) {
            Not not = this.of.createNot().withOperand((Expression)equal);
            this.resolveUnaryCall("System", "Not", (UnaryExpression)not);
            return not;
        }
        return equal;
    }

    public BinaryExpression visitInequalityExpression(@NotNull cqlParser.InequalityExpressionContext ctx) {
        LessOrEqual exp;
        String operatorName;
        switch (this.parseString(ctx.getChild(1))) {
            case "<=": {
                operatorName = "LessOrEqual";
                exp = this.of.createLessOrEqual();
                break;
            }
            case "<": {
                operatorName = "Less";
                exp = this.of.createLess();
                break;
            }
            case ">": {
                operatorName = "Greater";
                exp = this.of.createGreater();
                break;
            }
            case ">=": {
                operatorName = "GreaterOrEqual";
                exp = this.of.createGreaterOrEqual();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown operator: %s", ctx.getChild(1).getText()));
            }
        }
        exp.withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression(0)), this.parseExpression((ParseTree)ctx.expression(1))});
        this.resolveBinaryCall("System", operatorName, (BinaryExpression)exp);
        return exp;
    }

    public List<String> visitQualifiedIdentifier(@NotNull cqlParser.QualifiedIdentifierContext ctx) {
        ArrayList<String> identifiers = new ArrayList<String>();
        for (cqlParser.QualifierContext qualifierContext : ctx.qualifier()) {
            String qualifier = this.parseString((ParseTree)qualifierContext);
            identifiers.add(qualifier);
        }
        String identifier = this.parseString((ParseTree)ctx.identifier());
        identifiers.add(identifier);
        return identifiers;
    }

    public Expression resolveAccessor(Expression left, String memberIdentifier) {
        if (left instanceof LibraryRef) {
            String libraryName = ((LibraryRef)left).getLibraryName();
            TranslatedLibrary referencedLibrary = this.resolveLibrary(libraryName);
            Element element = referencedLibrary.resolve(memberIdentifier);
            if (element instanceof ExpressionDef) {
                this.checkAccessLevel(libraryName, memberIdentifier, ((ExpressionDef)element).getAccessLevel());
                ExpressionRef result = this.of.createExpressionRef().withLibraryName(libraryName).withName(memberIdentifier);
                result.setResultType(this.getExpressionDefResultType((ExpressionDef)element));
                return result;
            }
            if (element instanceof ParameterDef) {
                this.checkAccessLevel(libraryName, memberIdentifier, ((ParameterDef)element).getAccessLevel());
                ParameterRef result = this.of.createParameterRef().withLibraryName(libraryName).withName(memberIdentifier);
                result.setResultType(element.getResultType());
                return result;
            }
            if (element instanceof ValueSetDef) {
                this.checkAccessLevel(libraryName, memberIdentifier, ((ValueSetDef)element).getAccessLevel());
                ValueSetRef result = this.of.createValueSetRef().withLibraryName(libraryName).withName(memberIdentifier);
                result.setResultType(element.getResultType());
                return result;
            }
            if (element instanceof CodeSystemDef) {
                this.checkAccessLevel(libraryName, memberIdentifier, ((CodeSystemDef)element).getAccessLevel());
                CodeSystemRef result = this.of.createCodeSystemRef().withLibraryName(libraryName).withName(memberIdentifier);
                result.setResultType(element.getResultType());
                return result;
            }
            IdentifierRef identifier = new IdentifierRef();
            identifier.setLibraryName(libraryName);
            identifier.setName(memberIdentifier);
            return identifier;
        }
        if (left instanceof AliasRef) {
            Property result = this.of.createProperty().withScope(((AliasRef)left).getName()).withPath(memberIdentifier);
            result.setResultType(this.resolveProperty(left.getResultType(), memberIdentifier));
            return result;
        }
        Property result = this.of.createProperty().withSource(left).withPath(memberIdentifier);
        result.setResultType(this.resolveProperty(left.getResultType(), memberIdentifier));
        return result;
    }

    public Expression visitAccessorExpressionTerm(@NotNull cqlParser.AccessorExpressionTermContext ctx) {
        Expression left = this.parseExpression((ParseTree)ctx.expressionTerm());
        String memberIdentifier = this.parseString((ParseTree)ctx.identifier());
        return this.resolveAccessor(left, memberIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression resolveIdentifier(String identifier) {
        AliasedQuerySource alias = this.resolveAlias(identifier);
        if (alias != null) {
            AliasRef result = this.of.createAliasRef().withName(identifier);
            if (alias.getResultType() instanceof ListType) {
                result.setResultType(((ListType)alias.getResultType()).getElementType());
            } else {
                result.setResultType(alias.getResultType());
            }
            return result;
        }
        DefineClause define = this.resolveQueryDefine(identifier);
        if (define != null) {
            QueryDefineRef result = this.of.createQueryDefineRef().withName(identifier);
            result.setResultType(define.getResultType());
            return result;
        }
        OperandRef operandRef = this.resolveOperandRef(identifier);
        if (operandRef != null) {
            return operandRef;
        }
        Element element = this.translatedLibrary.resolve(identifier);
        if (element == null) {
            ParameterDefinitionInfo parameterInfo;
            ExpressionDefinitionInfo expressionInfo = this.libraryInfo.resolveExpressionReference(identifier);
            if (expressionInfo != null) {
                String saveContext = this.currentContext;
                this.currentContext = expressionInfo.getContext();
                try {
                    ExpressionDef expressionDef = this.visitExpressionDefinition(expressionInfo.getDefinition());
                    element = expressionDef;
                }
                finally {
                    this.currentContext = saveContext;
                }
            }
            if ((parameterInfo = this.libraryInfo.resolveParameterReference(identifier)) != null) {
                ParameterDef parameterDef = this.visitParameterDefinition(parameterInfo.getDefinition());
                element = parameterDef;
            }
        }
        if (element instanceof ExpressionDef) {
            ExpressionRef expressionRef = this.of.createExpressionRef().withName(((ExpressionDef)element).getName());
            expressionRef.setResultType(this.getExpressionDefResultType((ExpressionDef)element));
            return expressionRef;
        }
        if (element instanceof ParameterDef) {
            ParameterRef parameterRef = this.of.createParameterRef().withName(((ParameterDef)element).getName());
            parameterRef.setResultType(element.getResultType());
            return parameterRef;
        }
        if (element instanceof ValueSetDef) {
            ValueSetRef valuesetRef = this.of.createValueSetRef().withName(((ValueSetDef)element).getName());
            valuesetRef.setResultType(element.getResultType());
            return valuesetRef;
        }
        if (element instanceof CodeSystemDef) {
            CodeSystemRef codesystemRef = this.of.createCodeSystemRef().withName(((CodeSystemDef)element).getName());
            codesystemRef.setResultType(element.getResultType());
            return codesystemRef;
        }
        if (element instanceof IncludeDef) {
            LibraryRef libraryRef = new LibraryRef();
            libraryRef.setLibraryName(((IncludeDef)element).getLocalIdentifier());
            return libraryRef;
        }
        IdentifierRef id = this.of.createIdentifierRef();
        id.setName(identifier);
        return id;
    }

    public Expression resolveQualifiedIdentifier(List<String> identifiers) {
        Expression current = null;
        for (String identifier : identifiers) {
            if (current == null) {
                current = this.resolveIdentifier(identifier);
                continue;
            }
            current = this.resolveAccessor(current, identifier);
        }
        return current;
    }

    public Expression visitIdentifierTerm(@NotNull cqlParser.IdentifierTermContext ctx) {
        String identifier = this.parseString((ParseTree)ctx.identifier());
        return this.resolveIdentifier(identifier);
    }

    public Object visitTerminal(@NotNull TerminalNode node) {
        String text = node.getText();
        int tokenType = node.getSymbol().getType();
        if (135 == tokenType || 134 == tokenType) {
            text = text.substring(1, text.length() - 1);
            text = 135 == tokenType ? text.replace("''", "'") : text.replace("\"\"", "\"");
        }
        return text;
    }

    public Object visitTermExpression(@NotNull cqlParser.TermExpressionContext ctx) {
        return this.visit((ParseTree)ctx.expressionTerm());
    }

    public Object visitConversionExpressionTerm(@NotNull cqlParser.ConversionExpressionTermContext ctx) {
        TypeSpecifier targetType = this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier());
        Expression operand = this.parseExpression((ParseTree)ctx.expression());
        Conversion conversion = this.conversionMap.findConversion(operand.getResultType(), targetType.getResultType(), false);
        if (conversion == null) {
            throw new IllegalArgumentException(String.format("Could not resolve conversion from type %s to type %s.", operand.getResultType(), targetType.getResultType()));
        }
        return this.convertExpression(operand, conversion);
    }

    public Object visitTypeExpression(@NotNull cqlParser.TypeExpressionContext ctx) {
        if (ctx.getChild(1).getText().equals("is")) {
            Is is = this.of.createIs().withOperand(this.parseExpression((ParseTree)ctx.expression())).withIsTypeSpecifier(this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier()));
            is.setResultType(this.resolveTypeName("Boolean"));
            return is;
        }
        As as = this.of.createAs().withOperand(this.parseExpression((ParseTree)ctx.expression())).withAsTypeSpecifier(this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier())).withStrict(Boolean.valueOf(false));
        DataType targetType = as.getAsTypeSpecifier().getResultType();
        DataTypes.verifyCast(targetType, as.getOperand().getResultType());
        as.setResultType(targetType);
        return as;
    }

    public Object visitCastExpression(@NotNull cqlParser.CastExpressionContext ctx) {
        As as = this.of.createAs().withOperand(this.parseExpression((ParseTree)ctx.expression())).withAsTypeSpecifier(this.parseTypeSpecifier((ParseTree)ctx.typeSpecifier())).withStrict(Boolean.valueOf(true));
        DataType targetType = as.getAsTypeSpecifier().getResultType();
        DataTypes.verifyCast(targetType, as.getOperand().getResultType());
        as.setResultType(targetType);
        return as;
    }

    public Expression visitBooleanExpression(@NotNull cqlParser.BooleanExpressionContext ctx) {
        IsNull exp = null;
        Expression left = (Expression)this.visit((ParseTree)ctx.expression());
        String lastChild = ctx.getChild(ctx.getChildCount() - 1).getText();
        String nextToLast = ctx.getChild(ctx.getChildCount() - 2).getText();
        switch (lastChild) {
            case "null": {
                exp = this.of.createIsNull().withOperand(left);
                this.resolveUnaryCall("System", "IsNull", (UnaryExpression)exp);
                break;
            }
            case "true": {
                exp = this.of.createIsTrue().withOperand(left);
                this.resolveUnaryCall("System", "IsTrue", (UnaryExpression)exp);
                break;
            }
            case "false": {
                exp = this.of.createIsFalse().withOperand(left);
                this.resolveUnaryCall("System", "IsFalse", (UnaryExpression)exp);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown boolean test predicate %s.", lastChild));
            }
        }
        if ("not".equals(nextToLast)) {
            exp = this.of.createNot().withOperand((Expression)exp);
            this.resolveUnaryCall("System", "Not", (UnaryExpression)exp);
        }
        return exp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitTimingExpression(@NotNull cqlParser.TimingExpressionContext ctx) {
        Expression left = this.parseExpression((ParseTree)ctx.expression(0));
        Expression right = this.parseExpression((ParseTree)ctx.expression(1));
        TimingOperatorContext timingOperatorContext = new TimingOperatorContext(left, right);
        this.timingOperators.push(timingOperatorContext);
        try {
            Object object = this.visit((ParseTree)ctx.intervalOperatorPhrase());
            return object;
        }
        finally {
            this.timingOperators.pop();
        }
    }

    public Object visitConcurrentWithIntervalOperatorPhrase(@NotNull cqlParser.ConcurrentWithIntervalOperatorPhraseContext ctx) {
        ParseTree lastChild;
        TimingOperatorContext timingOperator = this.timingOperators.peek();
        ParseTree firstChild = ctx.getChild(0);
        if ("starts".equals(firstChild.getText())) {
            Start start = this.of.createStart().withOperand(timingOperator.getLeft());
            this.resolveUnaryCall("System", "Start", (UnaryExpression)start);
            timingOperator.setLeft((Expression)start);
        }
        if ("ends".equals(firstChild.getText())) {
            End end = this.of.createEnd().withOperand(timingOperator.getLeft());
            this.resolveUnaryCall("System", "End", (UnaryExpression)end);
            timingOperator.setLeft((Expression)end);
        }
        if ("start".equals((lastChild = ctx.getChild(ctx.getChildCount() - 1)).getText())) {
            Start start = this.of.createStart().withOperand(timingOperator.getRight());
            this.resolveUnaryCall("System", "Start", (UnaryExpression)start);
            timingOperator.setRight((Expression)start);
        }
        if ("end".equals(lastChild.getText())) {
            End end = this.of.createEnd().withOperand(timingOperator.getRight());
            this.resolveUnaryCall("System", "End", (UnaryExpression)end);
            timingOperator.setRight((Expression)end);
        }
        String operatorName = null;
        SameAs operator = null;
        if (ctx.relativeQualifier() == null) {
            operator = ctx.dateTimePrecision() != null ? this.of.createSameAs().withPrecision(this.parseDateTimePrecision(ctx.dateTimePrecision().getText())) : this.of.createSameAs();
            operatorName = "SameAs";
        } else {
            switch (ctx.relativeQualifier().getText()) {
                case "or after": {
                    operator = ctx.dateTimePrecision() != null ? this.of.createSameOrAfter().withPrecision(this.parseDateTimePrecision(ctx.dateTimePrecision().getText())) : this.of.createSameOrAfter();
                    operatorName = "SameOrAfter";
                    break;
                }
                case "or before": {
                    operator = ctx.dateTimePrecision() != null ? this.of.createSameOrBefore().withPrecision(this.parseDateTimePrecision(ctx.dateTimePrecision().getText())) : this.of.createSameOrBefore();
                    operatorName = "SameOrBefore";
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown relative qualifier: '%s'.", ctx.relativeQualifier().getText()));
                }
            }
        }
        operator = operator.withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
        this.resolveBinaryCall("System", operatorName, (BinaryExpression)operator);
        return operator;
    }

    public Object visitIncludesIntervalOperatorPhrase(@NotNull cqlParser.IncludesIntervalOperatorPhraseContext ctx) {
        Includes includes;
        String dateTimePrecision;
        boolean isProper = false;
        boolean isRightPoint = false;
        TimingOperatorContext timingOperator = this.timingOperators.peek();
        for (ParseTree pt : ctx.children) {
            if ("properly".equals(pt.getText())) {
                isProper = true;
                continue;
            }
            if ("start".equals(pt.getText())) {
                Start start = this.of.createStart().withOperand(timingOperator.getRight());
                this.resolveUnaryCall("System", "Start", (UnaryExpression)start);
                timingOperator.setRight((Expression)start);
                isRightPoint = true;
                continue;
            }
            if (!"end".equals(pt.getText())) continue;
            End end = this.of.createEnd().withOperand(timingOperator.getRight());
            this.resolveUnaryCall("System", "End", (UnaryExpression)end);
            timingOperator.setRight((Expression)end);
            isRightPoint = true;
        }
        String string = dateTimePrecision = ctx.dateTimePrecisionSpecifier() != null ? ctx.dateTimePrecisionSpecifier().dateTimePrecision().getText() : null;
        if (!(isRightPoint || timingOperator.getRight().getResultType() instanceof IntervalType || timingOperator.getRight().getResultType() instanceof ListType)) {
            isRightPoint = true;
        }
        if (isRightPoint) {
            Contains contains;
            if (isProper) {
                ProperContains properContains;
                if (dateTimePrecision != null) {
                    properContains = this.of.createProperContains().withPrecision(this.parseDateTimePrecision(dateTimePrecision)).withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
                    this.resolveBinaryCall("System", "ProperContains", (BinaryExpression)properContains);
                    return properContains;
                }
                properContains = this.of.createProperContains().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
                this.resolveBinaryCall("System", "ProperContains", (BinaryExpression)properContains);
                return properContains;
            }
            if (dateTimePrecision != null) {
                contains = this.of.createContains().withPrecision(this.parseDateTimePrecision(dateTimePrecision)).withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
                this.resolveBinaryCall("System", "Contains", (BinaryExpression)contains);
                return contains;
            }
            contains = this.of.createContains().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
            this.resolveBinaryCall("System", "Contains", (BinaryExpression)contains);
            return contains;
        }
        if (isProper) {
            ProperIncludes properIncludes;
            if (dateTimePrecision != null) {
                properIncludes = this.of.createProperIncludes().withPrecision(this.parseDateTimePrecision(dateTimePrecision)).withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
                this.resolveBinaryCall("System", "ProperIncludes", (BinaryExpression)properIncludes);
                return properIncludes;
            }
            properIncludes = this.of.createProperIncludes().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
            this.resolveBinaryCall("System", "ProperIncludes", (BinaryExpression)properIncludes);
            return properIncludes;
        }
        if (dateTimePrecision != null) {
            includes = this.of.createIncludes().withPrecision(this.parseDateTimePrecision(dateTimePrecision)).withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
            this.resolveBinaryCall("System", "Includes", (BinaryExpression)includes);
            return includes;
        }
        includes = this.of.createIncludes().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
        this.resolveBinaryCall("System", "Includes", (BinaryExpression)includes);
        return includes;
    }

    public Object visitIncludedInIntervalOperatorPhrase(@NotNull cqlParser.IncludedInIntervalOperatorPhraseContext ctx) {
        IncludedIn includedIn;
        String dateTimePrecision;
        boolean isProper = false;
        boolean isLeftPoint = false;
        TimingOperatorContext timingOperator = this.timingOperators.peek();
        for (ParseTree pt : ctx.children) {
            if ("starts".equals(pt.getText())) {
                Start start = this.of.createStart().withOperand(timingOperator.getLeft());
                this.resolveUnaryCall("System", "Start", (UnaryExpression)start);
                timingOperator.setLeft((Expression)start);
                isLeftPoint = true;
                continue;
            }
            if ("ends".equals(pt.getText())) {
                End end = this.of.createEnd().withOperand(timingOperator.getLeft());
                this.resolveUnaryCall("System", "End", (UnaryExpression)end);
                timingOperator.setLeft((Expression)end);
                isLeftPoint = true;
                continue;
            }
            if (!"properly".equals(pt.getText())) continue;
            isProper = true;
        }
        String string = dateTimePrecision = ctx.dateTimePrecisionSpecifier() != null ? ctx.dateTimePrecisionSpecifier().dateTimePrecision().getText() : null;
        if (!(isLeftPoint || timingOperator.getLeft().getResultType() instanceof IntervalType || timingOperator.getLeft().getResultType() instanceof ListType)) {
            isLeftPoint = true;
        }
        if (isLeftPoint) {
            In in;
            if (isProper) {
                ProperIn properIn;
                if (dateTimePrecision != null) {
                    properIn = this.of.createProperIn().withPrecision(this.parseDateTimePrecision(dateTimePrecision)).withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
                    this.resolveBinaryCall("System", "ProperIn", (BinaryExpression)properIn);
                    return properIn;
                }
                properIn = this.of.createProperIn().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
                this.resolveBinaryCall("System", "ProperIn", (BinaryExpression)properIn);
                return properIn;
            }
            if (dateTimePrecision != null) {
                in = this.of.createIn().withPrecision(this.parseDateTimePrecision(dateTimePrecision)).withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
                this.resolveBinaryCall("System", "In", (BinaryExpression)in);
                return in;
            }
            in = this.of.createIn().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
            this.resolveBinaryCall("System", "In", (BinaryExpression)in);
            return in;
        }
        if (isProper) {
            ProperIncludedIn properIncludedIn;
            if (dateTimePrecision != null) {
                properIncludedIn = this.of.createProperIncludedIn().withPrecision(this.parseDateTimePrecision(dateTimePrecision)).withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
                this.resolveBinaryCall("System", "ProperIncludedIn", (BinaryExpression)properIncludedIn);
                return properIncludedIn;
            }
            properIncludedIn = this.of.createProperIncludedIn().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
            this.resolveBinaryCall("System", "ProperIncludedIn", (BinaryExpression)properIncludedIn);
            return properIncludedIn;
        }
        if (dateTimePrecision != null) {
            includedIn = this.of.createIncludedIn().withPrecision(this.parseDateTimePrecision(dateTimePrecision)).withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
            this.resolveBinaryCall("System", "IncludedIn", (BinaryExpression)includedIn);
            return includedIn;
        }
        includedIn = this.of.createIncludedIn().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
        this.resolveBinaryCall("System", "IncludedIn", (BinaryExpression)includedIn);
        return includedIn;
    }

    public Object visitBeforeOrAfterIntervalOperatorPhrase(@NotNull cqlParser.BeforeOrAfterIntervalOperatorPhraseContext ctx) {
        Start start;
        End end;
        String dateTimePrecision;
        TimingOperatorContext timingOperator = this.timingOperators.peek();
        Boolean isBefore = false;
        for (ParseTree child : ctx.children) {
            End end2;
            Start start2;
            if ("starts".equals(child.getText())) {
                start2 = this.of.createStart().withOperand(timingOperator.getLeft());
                this.resolveUnaryCall("System", "Start", (UnaryExpression)start2);
                timingOperator.setLeft((Expression)start2);
                continue;
            }
            if ("ends".equals(child.getText())) {
                end2 = this.of.createEnd().withOperand(timingOperator.getLeft());
                this.resolveUnaryCall("System", "End", (UnaryExpression)end2);
                timingOperator.setLeft((Expression)end2);
                continue;
            }
            if ("start".equals(child.getText())) {
                start2 = this.of.createStart().withOperand(timingOperator.getRight());
                this.resolveUnaryCall("System", "Start", (UnaryExpression)start2);
                timingOperator.setRight((Expression)start2);
                continue;
            }
            if ("end".equals(child.getText())) {
                end2 = this.of.createEnd().withOperand(timingOperator.getRight());
                this.resolveUnaryCall("System", "End", (UnaryExpression)end2);
                timingOperator.setRight((Expression)end2);
                continue;
            }
            if (!"before".equals(child.getText())) continue;
            isBefore = true;
        }
        String string = dateTimePrecision = ctx.dateTimePrecisionSpecifier() != null ? ctx.dateTimePrecisionSpecifier().dateTimePrecision().getText() : null;
        if (ctx.quantityOffset() == null) {
            After after;
            if (isBefore.booleanValue()) {
                Before before;
                if (dateTimePrecision != null) {
                    before = this.of.createBefore().withPrecision(this.parseDateTimePrecision(dateTimePrecision)).withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
                    this.resolveBinaryCall("System", "Before", (BinaryExpression)before);
                    return before;
                }
                before = this.of.createBefore().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
                this.resolveBinaryCall("System", "Before", (BinaryExpression)before);
                return before;
            }
            if (dateTimePrecision != null) {
                after = this.of.createAfter().withPrecision(this.parseDateTimePrecision(dateTimePrecision)).withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
                this.resolveBinaryCall("System", "After", (BinaryExpression)after);
                return after;
            }
            after = this.of.createAfter().withOperand(new Expression[]{timingOperator.getLeft(), timingOperator.getRight()});
            this.resolveBinaryCall("System", "After", (BinaryExpression)after);
            return after;
        }
        Quantity quantity = (Quantity)this.visit((ParseTree)ctx.quantityOffset().quantityLiteral());
        Literal quantityLiteral = this.createLiteral(quantity.getValue().intValueExact());
        Expression lowerBound = null;
        Expression upperBound = null;
        if (timingOperator.getLeft().getResultType() instanceof IntervalType) {
            if (isBefore.booleanValue()) {
                end = this.of.createEnd().withOperand(timingOperator.getLeft());
                this.resolveUnaryCall("System", "End", (UnaryExpression)end);
                lowerBound = end;
            } else {
                start = this.of.createStart().withOperand(timingOperator.getLeft());
                this.resolveUnaryCall("System", "Start", (UnaryExpression)start);
                lowerBound = start;
            }
        } else {
            lowerBound = timingOperator.getLeft();
        }
        if (timingOperator.getRight().getResultType() instanceof IntervalType) {
            if (isBefore.booleanValue()) {
                start = this.of.createStart().withOperand(timingOperator.getRight());
                this.resolveUnaryCall("System", "Start", (UnaryExpression)start);
                upperBound = start;
            } else {
                end = this.of.createEnd().withOperand(timingOperator.getRight());
                this.resolveUnaryCall("System", "End", (UnaryExpression)end);
                upperBound = end;
            }
        } else {
            upperBound = timingOperator.getRight();
        }
        BinaryExpression betweenOperator = this.resolveBetweenOperator(quantity.getUnit(), lowerBound, upperBound);
        if (betweenOperator != null) {
            if (ctx.quantityOffset().offsetRelativeQualifier() == null) {
                if (isBefore.booleanValue()) {
                    Equal equal = this.of.createEqual().withOperand(new Expression[]{betweenOperator, quantityLiteral});
                    this.resolveBinaryCall("System", "Equal", (BinaryExpression)equal);
                    return equal;
                }
                Negate negate = this.of.createNegate().withOperand((Expression)quantityLiteral);
                this.resolveUnaryCall("System", "Negate", (UnaryExpression)negate);
                Equal equal = this.of.createEqual().withOperand(new Expression[]{betweenOperator, negate});
                this.resolveBinaryCall("System", "Equal", (BinaryExpression)equal);
                return equal;
            }
            switch (ctx.quantityOffset().offsetRelativeQualifier().getText()) {
                case "or more": {
                    if (isBefore.booleanValue()) {
                        GreaterOrEqual greaterOrEqual = this.of.createGreaterOrEqual().withOperand(new Expression[]{betweenOperator, quantityLiteral});
                        this.resolveBinaryCall("System", "GreaterOrEqual", (BinaryExpression)greaterOrEqual);
                        return greaterOrEqual;
                    }
                    Negate negate = this.of.createNegate().withOperand((Expression)quantityLiteral);
                    this.resolveUnaryCall("System", "Negate", (UnaryExpression)negate);
                    LessOrEqual lessOrEqual = this.of.createLessOrEqual().withOperand(new Expression[]{betweenOperator, negate});
                    this.resolveBinaryCall("System", "LessOrEqual", (BinaryExpression)lessOrEqual);
                    return lessOrEqual;
                }
                case "or less": {
                    if (isBefore.booleanValue()) {
                        Interval quantityInterval = this.of.createInterval().withLow((Expression)this.createLiteral(0)).withLowClosed(Boolean.valueOf(false)).withHigh((Expression)quantityLiteral).withHighClosed(Boolean.valueOf(true));
                        quantityInterval.setResultType((DataType)new IntervalType(quantityInterval.getLow().getResultType()));
                        In in = this.of.createIn().withOperand(new Expression[]{betweenOperator, quantityInterval});
                        this.resolveBinaryCall("System", "In", (BinaryExpression)in);
                        return in;
                    }
                    Negate negate = this.of.createNegate().withOperand((Expression)quantityLiteral);
                    this.resolveUnaryCall("System", "Negate", (UnaryExpression)negate);
                    Interval quantityInterval = this.of.createInterval().withLow((Expression)negate).withLowClosed(Boolean.valueOf(true)).withHigh((Expression)this.createLiteral(0)).withHighClosed(Boolean.valueOf(false));
                    quantityInterval.setResultType((DataType)new IntervalType(quantityInterval.getLow().getResultType()));
                    In in = this.of.createIn().withOperand(new Expression[]{betweenOperator, quantityInterval});
                    this.resolveBinaryCall("System", "In", (BinaryExpression)in);
                    return in;
                }
            }
        }
        throw new IllegalArgumentException("Unable to resolve interval operator phrase.");
    }

    private BinaryExpression resolveBetweenOperator(String unit, Expression left, Expression right) {
        if (unit != null) {
            DurationBetween between = this.of.createDurationBetween().withPrecision(this.parseDateTimePrecision(unit)).withOperand(new Expression[]{left, right});
            this.resolveBinaryCall("System", "DurationBetween", (BinaryExpression)between);
            return between;
        }
        return null;
    }

    public Object visitWithinIntervalOperatorPhrase(@NotNull cqlParser.WithinIntervalOperatorPhraseContext ctx) {
        TimingOperatorContext timingOperator = this.timingOperators.peek();
        boolean isProper = false;
        for (ParseTree child : ctx.children) {
            End end;
            Start start;
            if ("starts".equals(child.getText())) {
                start = this.of.createStart().withOperand(timingOperator.getLeft());
                this.resolveUnaryCall("System", "Start", (UnaryExpression)start);
                timingOperator.setLeft((Expression)start);
                continue;
            }
            if ("ends".equals(child.getText())) {
                end = this.of.createEnd().withOperand(timingOperator.getLeft());
                this.resolveUnaryCall("System", "End", (UnaryExpression)end);
                timingOperator.setLeft((Expression)end);
                continue;
            }
            if ("start".equals(child.getText())) {
                start = this.of.createStart().withOperand(timingOperator.getRight());
                this.resolveUnaryCall("System", "Start", (UnaryExpression)start);
                timingOperator.setRight((Expression)start);
                continue;
            }
            if ("end".equals(child.getText())) {
                end = this.of.createEnd().withOperand(timingOperator.getRight());
                this.resolveUnaryCall("System", "End", (UnaryExpression)end);
                timingOperator.setRight((Expression)end);
                continue;
            }
            if (!"properly".equals(child.getText())) continue;
            isProper = true;
        }
        Quantity quantity = (Quantity)this.visit((ParseTree)ctx.quantityLiteral());
        Literal quantityLiteral = this.createLiteral(quantity.getValue().intValueExact());
        Negate negativeQuantityLiteral = this.of.createNegate().withOperand((Expression)this.createLiteral(quantity.getValue().intValueExact()));
        this.resolveUnaryCall("System", "Negate", (UnaryExpression)negativeQuantityLiteral);
        Expression lowerBound = null;
        Expression upperBound = null;
        if (timingOperator.getRight().getResultType() instanceof IntervalType) {
            lowerBound = this.of.createStart().withOperand(timingOperator.getRight());
            this.resolveUnaryCall("System", "Start", (UnaryExpression)((Start)lowerBound));
            upperBound = this.of.createEnd().withOperand(timingOperator.getRight());
            this.resolveUnaryCall("System", "End", (UnaryExpression)((End)upperBound));
        } else {
            lowerBound = timingOperator.getRight();
            upperBound = timingOperator.getRight();
        }
        BinaryExpression leftBetween = this.resolveBetweenOperator(quantity.getUnit(), timingOperator.getLeft(), lowerBound);
        BinaryExpression rightBetween = this.resolveBetweenOperator(quantity.getUnit(), timingOperator.getLeft(), upperBound);
        BinaryExpression leftCompare = (isProper ? this.of.createGreater() : this.of.createGreaterOrEqual()).withOperand(new Expression[]{leftBetween, negativeQuantityLiteral});
        this.resolveBinaryCall("System", isProper ? "Greater" : "GreaterOrEqual", leftCompare);
        BinaryExpression rightCompare = (isProper ? this.of.createLess() : this.of.createLessOrEqual()).withOperand(new Expression[]{rightBetween, quantityLiteral});
        this.resolveBinaryCall("System", isProper ? "Less" : "LessOrEqual", rightCompare);
        And result = this.of.createAnd().withOperand(new Expression[]{leftCompare, rightCompare});
        this.resolveBinaryCall("System", "And", (BinaryExpression)result);
        return result;
    }

    public Object visitMeetsIntervalOperatorPhrase(@NotNull cqlParser.MeetsIntervalOperatorPhraseContext ctx) {
        Meets operator;
        String operatorName = null;
        String dateTimePrecision = ctx.dateTimePrecisionSpecifier() != null ? ctx.dateTimePrecisionSpecifier().dateTimePrecision().getText() : null;
        if (ctx.getChildCount() == 1 + (dateTimePrecision == null ? 0 : 1)) {
            operator = dateTimePrecision != null ? this.of.createMeets().withPrecision(this.parseDateTimePrecision(dateTimePrecision)) : this.of.createMeets();
            operatorName = "Meets";
        } else if ("before".equals(ctx.getChild(1).getText())) {
            operator = dateTimePrecision != null ? this.of.createMeetsBefore().withPrecision(this.parseDateTimePrecision(dateTimePrecision)) : this.of.createMeetsBefore();
            operatorName = "MeetsBefore";
        } else {
            operator = dateTimePrecision != null ? this.of.createMeetsAfter().withPrecision(this.parseDateTimePrecision(dateTimePrecision)) : this.of.createMeetsAfter();
            operatorName = "MeetsAfter";
        }
        operator.withOperand(new Expression[]{this.timingOperators.peek().getLeft(), this.timingOperators.peek().getRight()});
        this.resolveBinaryCall("System", operatorName, (BinaryExpression)operator);
        return operator;
    }

    public Object visitOverlapsIntervalOperatorPhrase(@NotNull cqlParser.OverlapsIntervalOperatorPhraseContext ctx) {
        Overlaps operator;
        String operatorName = null;
        String dateTimePrecision = ctx.dateTimePrecisionSpecifier() != null ? ctx.dateTimePrecisionSpecifier().dateTimePrecision().getText() : null;
        if (ctx.getChildCount() == (1 + dateTimePrecision == null ? 0 : 1)) {
            operator = dateTimePrecision != null ? this.of.createOverlaps().withPrecision(this.parseDateTimePrecision(dateTimePrecision)) : this.of.createOverlaps();
            operatorName = "Overlaps";
        } else if ("before".equals(ctx.getChild(1).getText())) {
            operator = dateTimePrecision != null ? this.of.createOverlapsBefore().withPrecision(this.parseDateTimePrecision(dateTimePrecision)) : this.of.createOverlapsBefore();
            operatorName = "OverlapsBefore";
        } else {
            operator = dateTimePrecision != null ? this.of.createOverlapsAfter().withPrecision(this.parseDateTimePrecision(dateTimePrecision)) : this.of.createOverlapsAfter();
            operatorName = "OverlapsAfter";
        }
        operator.withOperand(new Expression[]{this.timingOperators.peek().getLeft(), this.timingOperators.peek().getRight()});
        this.resolveBinaryCall("System", operatorName, (BinaryExpression)operator);
        return operator;
    }

    public Object visitStartsIntervalOperatorPhrase(@NotNull cqlParser.StartsIntervalOperatorPhraseContext ctx) {
        String dateTimePrecision = ctx.dateTimePrecisionSpecifier() != null ? ctx.dateTimePrecisionSpecifier().dateTimePrecision().getText() : null;
        Starts starts = (dateTimePrecision != null ? this.of.createStarts().withPrecision(this.parseDateTimePrecision(dateTimePrecision)) : this.of.createStarts()).withOperand(new Expression[]{this.timingOperators.peek().getLeft(), this.timingOperators.peek().getRight()});
        this.resolveBinaryCall("System", "Starts", (BinaryExpression)starts);
        return starts;
    }

    public Object visitEndsIntervalOperatorPhrase(@NotNull cqlParser.EndsIntervalOperatorPhraseContext ctx) {
        String dateTimePrecision = ctx.dateTimePrecisionSpecifier() != null ? ctx.dateTimePrecisionSpecifier().dateTimePrecision().getText() : null;
        Ends ends = (dateTimePrecision != null ? this.of.createEnds().withPrecision(this.parseDateTimePrecision(dateTimePrecision)) : this.of.createEnds()).withOperand(new Expression[]{this.timingOperators.peek().getLeft(), this.timingOperators.peek().getRight()});
        this.resolveBinaryCall("System", "Ends", (BinaryExpression)ends);
        return ends;
    }

    public Object visitIfThenElseExpressionTerm(@NotNull cqlParser.IfThenElseExpressionTermContext ctx) {
        If ifObject = this.of.createIf().withCondition(this.parseExpression((ParseTree)ctx.expression(0))).withThen(this.parseExpression((ParseTree)ctx.expression(1))).withElse(this.parseExpression((ParseTree)ctx.expression(2)));
        DataTypes.verifyType(ifObject.getCondition().getResultType(), this.resolveTypeName("Boolean"));
        DataType resultType = this.ensureCompatibleTypes(ifObject.getThen().getResultType(), ifObject.getElse().getResultType());
        ifObject.setResultType(resultType);
        ifObject.setThen(this.ensureCompatible(ifObject.getThen(), resultType));
        ifObject.setElse(this.ensureCompatible(ifObject.getElse(), resultType));
        return ifObject;
    }

    public Object visitCaseExpressionTerm(@NotNull cqlParser.CaseExpressionTermContext ctx) {
        Case result = this.of.createCase();
        Boolean hitElse = false;
        DataType resultType = null;
        for (ParseTree pt : ctx.children) {
            if ("else".equals(pt.getText())) {
                hitElse = true;
                continue;
            }
            if (pt instanceof cqlParser.ExpressionContext) {
                if (hitElse.booleanValue()) {
                    result.setElse(this.parseExpression(pt));
                    resultType = this.ensureCompatibleTypes(resultType, result.getElse().getResultType());
                } else {
                    result.setComparand(this.parseExpression(pt));
                }
            }
            if (!(pt instanceof cqlParser.CaseExpressionItemContext)) continue;
            CaseItem caseItem = (CaseItem)this.visit(pt);
            if (result.getComparand() != null) {
                this.verifyType(caseItem.getWhen().getResultType(), result.getComparand().getResultType());
            } else {
                DataTypes.verifyType(caseItem.getWhen().getResultType(), this.resolveTypeName("Boolean"));
            }
            resultType = resultType == null ? caseItem.getThen().getResultType() : this.ensureCompatibleTypes(resultType, caseItem.getThen().getResultType());
            result.getCaseItem().add(caseItem);
        }
        for (CaseItem caseItem : result.getCaseItem()) {
            if (result.getComparand() != null) {
                caseItem.setWhen(this.ensureCompatible(caseItem.getWhen(), result.getComparand().getResultType()));
            }
            caseItem.setThen(this.ensureCompatible(caseItem.getThen(), resultType));
        }
        result.setElse(this.ensureCompatible(result.getElse(), resultType));
        result.setResultType(resultType);
        return result;
    }

    public Object visitCaseExpressionItem(@NotNull cqlParser.CaseExpressionItemContext ctx) {
        return this.of.createCaseItem().withWhen(this.parseExpression((ParseTree)ctx.expression(0))).withThen(this.parseExpression((ParseTree)ctx.expression(1)));
    }

    public Object visitAggregateExpressionTerm(@NotNull cqlParser.AggregateExpressionTermContext ctx) {
        switch (ctx.getChild(0).getText()) {
            case "distinct": {
                Distinct distinct = this.of.createDistinct().withOperand(this.parseExpression((ParseTree)ctx.expression()));
                this.resolveUnaryCall("System", "Distinct", (UnaryExpression)distinct);
                return distinct;
            }
            case "collapse": {
                Collapse collapse = this.of.createCollapse().withOperand(this.parseExpression((ParseTree)ctx.expression()));
                this.resolveUnaryCall("System", "Collapse", (UnaryExpression)collapse);
                return collapse;
            }
            case "expand": {
                Expand expand = this.of.createExpand().withOperand(this.parseExpression((ParseTree)ctx.expression()));
                this.resolveUnaryCall("System", "Expand", (UnaryExpression)expand);
                return expand;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown aggregate operator %s.", ctx.getChild(0).getText()));
    }

    public Retrieve visitRetrieve(@NotNull cqlParser.RetrieveContext ctx) {
        ClassType classType;
        String label;
        String model = this.parseString((ParseTree)ctx.namedTypeSpecifier().modelIdentifier());
        DataType dataType = this.resolveTypeName(model, label = this.parseString((ParseTree)ctx.namedTypeSpecifier().identifier()));
        if (dataType == null) {
            throw new IllegalArgumentException(String.format("Could not resolve type name %s.", label));
        }
        if (!(dataType instanceof ClassType) || !((ClassType)dataType).isRetrievable()) {
            throw new IllegalArgumentException(String.format("Specified data type %s does not support retrieval.", label));
        }
        ClassType namedType = classType = (ClassType)dataType;
        Retrieve retrieve = this.of.createRetrieve().withDataType(this.dataTypeToQName((DataType)namedType)).withTemplateId(classType.getIdentifier());
        if (ctx.valueset() != null) {
            if (ctx.valuesetPathIdentifier() != null) {
                retrieve.setCodeProperty(this.parseString((ParseTree)ctx.valuesetPathIdentifier()));
            } else if (classType.getPrimaryCodePath() != null) {
                retrieve.setCodeProperty(classType.getPrimaryCodePath());
            }
            List identifiers = (List)this.visit((ParseTree)ctx.valueset());
            retrieve.setCodes(this.resolveQualifiedIdentifier(identifiers));
        }
        this.retrieves.add(retrieve);
        retrieve.setResultType((DataType)new ListType((DataType)namedType));
        return retrieve;
    }

    public Object visitSingleSourceClause(@NotNull cqlParser.SingleSourceClauseContext ctx) {
        ArrayList<AliasedQuerySource> sources = new ArrayList<AliasedQuerySource>();
        sources.add((AliasedQuerySource)this.visit((ParseTree)ctx.aliasedQuerySource()));
        return sources;
    }

    public Object visitMultipleSourceClause(@NotNull cqlParser.MultipleSourceClauseContext ctx) {
        ArrayList<AliasedQuerySource> sources = new ArrayList<AliasedQuerySource>();
        for (cqlParser.AliasedQuerySourceContext source : ctx.aliasedQuerySource()) {
            sources.add((AliasedQuerySource)this.visit((ParseTree)source));
        }
        return sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitQuery(@NotNull cqlParser.QueryContext ctx) {
        QueryContext queryContext = new QueryContext();
        this.queries.push(queryContext);
        try {
            List sources;
            queryContext.enterSourceClause();
            try {
                sources = (List)this.visit((ParseTree)ctx.sourceClause());
            }
            finally {
                queryContext.exitSourceClause();
            }
            queryContext.addQuerySources(sources);
            boolean expressionContextPushed = false;
            if (this.inPopulationContext() && queryContext.referencesPatientContext()) {
                this.pushExpressionContext("Patient");
                expressionContextPushed = true;
            }
            try {
                ReturnClause ret;
                Expression where;
                List dfcx;
                List list = dfcx = ctx.defineClause() != null ? (List)this.visit((ParseTree)ctx.defineClause()) : null;
                if (dfcx != null) {
                    queryContext.addDefineClauses(dfcx);
                }
                ArrayList<RelationshipClause> qicx = new ArrayList<RelationshipClause>();
                if (ctx.queryInclusionClause() != null) {
                    for (Object queryInclusionClauseContext : ctx.queryInclusionClause()) {
                        qicx.add((RelationshipClause)this.visit((ParseTree)queryInclusionClauseContext));
                    }
                }
                Expression expression = where = ctx.whereClause() != null ? (Expression)this.visit((ParseTree)ctx.whereClause()) : null;
                if (this.dateRangeOptimization && where != null) {
                    for (AliasedQuerySource aqs : sources) {
                        where = this.optimizeDateRangeInQuery(where, aqs);
                    }
                }
                ReturnClause returnClause = ret = ctx.returnClause() != null ? (ReturnClause)this.visit((ParseTree)ctx.returnClause()) : null;
                if (ret == null && sources.size() > 1) {
                    ret = this.of.createReturnClause().withDistinct(Boolean.valueOf(true));
                    Tuple returnExpression = this.of.createTuple();
                    TupleType returnType = new TupleType();
                    for (AliasedQuerySource aqs : sources) {
                        TupleElement element = this.of.createTupleElement().withName(aqs.getAlias()).withValue((Expression)this.of.createAliasRef().withName(aqs.getAlias()));
                        element.getValue().setResultType(aqs.getResultType());
                        element.setResultType(element.getValue().getResultType());
                        returnType.addElement(new TupleTypeElement(element.getName(), element.getResultType()));
                        returnExpression.getElement().add(element);
                    }
                    returnExpression.setResultType((DataType)(queryContext.isSingular() ? returnType : new ListType((DataType)returnType)));
                    ret.setExpression((Expression)returnExpression);
                    ret.setResultType(returnExpression.getResultType());
                }
                SortClause sort = ctx.sortClause() != null ? (SortClause)this.visit((ParseTree)ctx.sortClause()) : null;
                Query query = this.of.createQuery().withSource((Collection)sources).withDefine((Collection)dfcx).withRelationship(qicx).withWhere(where).withReturn(ret).withSort(sort);
                if (ret == null) {
                    query.setResultType(((AliasedQuerySource)sources.get(0)).getResultType());
                } else {
                    query.setResultType(ret.getResultType());
                }
                Query query2 = query;
                if (expressionContextPushed) {
                    this.popExpressionContext();
                }
                return query2;
            }
            catch (Throwable throwable) {
                if (expressionContextPushed) {
                    this.popExpressionContext();
                }
                throw throwable;
            }
        }
        finally {
            this.queries.pop();
        }
    }

    private Expression optimizeDateRangeInQuery(Expression where, AliasedQuerySource aqs) {
        if (aqs.getExpression() instanceof Retrieve) {
            Retrieve retrieve = (Retrieve)aqs.getExpression();
            String alias = aqs.getAlias();
            if (where instanceof IncludedIn && this.attemptDateRangeOptimization((IncludedIn)where, retrieve, alias)) {
                where = null;
            } else if (where instanceof And && this.attemptDateRangeOptimization((And)where, retrieve, alias)) {
                where = this.consolidateAnd((And)where);
            }
        }
        return where;
    }

    private boolean attemptDateRangeOptimization(IncludedIn during, Retrieve retrieve, String alias) {
        Property property;
        if (retrieve.getDateProperty() != null || retrieve.getDateRange() != null) {
            return false;
        }
        Expression left = (Expression)during.getOperand().get(0);
        Expression right = (Expression)during.getOperand().get(1);
        if (left instanceof Property && alias.equals((property = (Property)left).getScope()) && this.isRHSEligibleForDateRangeOptimization(right)) {
            retrieve.setDateProperty(property.getPath());
            retrieve.setDateRange(right);
            return true;
        }
        return false;
    }

    private boolean attemptDateRangeOptimization(And and, Retrieve retrieve, String alias) {
        if (retrieve.getDateProperty() != null || retrieve.getDateRange() != null) {
            return false;
        }
        for (int i = 0; i < and.getOperand().size(); ++i) {
            Expression operand = (Expression)and.getOperand().get(i);
            if (operand instanceof IncludedIn && this.attemptDateRangeOptimization((IncludedIn)operand, retrieve, alias)) {
                and.getOperand().set(i, this.createLiteral(true));
                return true;
            }
            if (!(operand instanceof And) || !this.attemptDateRangeOptimization((And)operand, retrieve, alias)) continue;
            return true;
        }
        return false;
    }

    private Expression consolidateAnd(And and) {
        And result = and;
        Expression lhs = (Expression)and.getOperand().get(0);
        Expression rhs = (Expression)and.getOperand().get(1);
        if (this.isBooleanLiteral(lhs, true)) {
            result = rhs;
        } else if (this.isBooleanLiteral(rhs, true)) {
            result = lhs;
        } else if (lhs instanceof And) {
            and.getOperand().set(0, this.consolidateAnd((And)lhs));
        } else if (rhs instanceof And) {
            and.getOperand().set(1, this.consolidateAnd((And)rhs));
        }
        return result;
    }

    private boolean isRHSEligibleForDateRangeOptimization(Expression rhs) {
        Expression targetElement = rhs;
        if (rhs instanceof ParameterRef) {
            String paramName = ((ParameterRef)rhs).getName();
            for (ParameterDef def : this.getLibrary().getParameters().getDef()) {
                if (!paramName.equals(def.getName())) continue;
                targetElement = def.getParameterTypeSpecifier();
                if (targetElement != null) break;
                targetElement = def.getDefault();
                break;
            }
        } else if (rhs instanceof ExpressionRef && !(rhs instanceof FunctionRef)) {
            String expName = ((ExpressionRef)rhs).getName();
            for (ExpressionDef def : this.getLibrary().getStatements().getDef()) {
                if (!expName.equals(def.getName())) continue;
                targetElement = def.getExpression();
            }
        }
        boolean isEligible = false;
        if (targetElement instanceof DateTime) {
            isEligible = true;
        } else if (targetElement instanceof Interval) {
            Interval ivl = (Interval)targetElement;
            isEligible = ivl.getLow() != null && ivl.getLow() instanceof DateTime || ivl.getHigh() != null && ivl.getHigh() instanceof DateTime;
        } else if (targetElement instanceof IntervalTypeSpecifier) {
            IntervalTypeSpecifier spec = (IntervalTypeSpecifier)targetElement;
            isEligible = this.isDateTimeTypeSpecifier((Element)spec.getPointType());
        } else if (targetElement instanceof NamedTypeSpecifier) {
            isEligible = this.isDateTimeTypeSpecifier((Element)targetElement);
        }
        return isEligible;
    }

    private boolean isDateTimeTypeSpecifier(Element e) {
        return e.getResultType().equals(this.resolveTypeName("System", "DateTime"));
    }

    public Object visitDefineClause(@NotNull cqlParser.DefineClauseContext ctx) {
        ArrayList<DefineClause> defineClauseItems = new ArrayList<DefineClause>();
        for (cqlParser.DefineClauseItemContext defineClauseItem : ctx.defineClauseItem()) {
            defineClauseItems.add((DefineClause)this.visit((ParseTree)defineClauseItem));
        }
        return defineClauseItems;
    }

    public Object visitDefineClauseItem(@NotNull cqlParser.DefineClauseItemContext ctx) {
        DefineClause defineClause = this.of.createDefineClause().withExpression(this.parseExpression((ParseTree)ctx.expression())).withIdentifier(this.parseString((ParseTree)ctx.identifier()));
        defineClause.setResultType(defineClause.getExpression().getResultType());
        return defineClause;
    }

    public Object visitAliasedQuerySource(@NotNull cqlParser.AliasedQuerySourceContext ctx) {
        AliasedQuerySource source = this.of.createAliasedQuerySource().withExpression(this.parseExpression((ParseTree)ctx.querySource())).withAlias(this.parseString((ParseTree)ctx.alias()));
        source.setResultType(source.getExpression().getResultType());
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitWithClause(@NotNull cqlParser.WithClauseContext ctx) {
        AliasedQuerySource aqs = (AliasedQuerySource)this.visit((ParseTree)ctx.aliasedQuerySource());
        this.queries.peek().addQuerySource(aqs);
        try {
            Expression expression = (Expression)this.visit((ParseTree)ctx.expression());
            DataTypes.verifyType(expression.getResultType(), this.resolveTypeName("Boolean"));
            With result = this.of.createWith();
            result.withExpression(aqs.getExpression()).withAlias(aqs.getAlias()).withSuchThat(expression);
            result.setResultType(aqs.getResultType());
            With with = result;
            return with;
        }
        finally {
            this.queries.peek().removeQuerySource(aqs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitWithoutClause(@NotNull cqlParser.WithoutClauseContext ctx) {
        AliasedQuerySource aqs = (AliasedQuerySource)this.visit((ParseTree)ctx.aliasedQuerySource());
        this.queries.peek().addQuerySource(aqs);
        try {
            Expression expression = (Expression)this.visit((ParseTree)ctx.expression());
            DataTypes.verifyType(expression.getResultType(), this.resolveTypeName("Boolean"));
            Without result = this.of.createWithout();
            result.withExpression(aqs.getExpression()).withAlias(aqs.getAlias()).withSuchThat(expression);
            result.setResultType(aqs.getResultType());
            Without without = result;
            return without;
        }
        finally {
            this.queries.peek().removeQuerySource(aqs);
        }
    }

    public Object visitWhereClause(@NotNull cqlParser.WhereClauseContext ctx) {
        Expression result = (Expression)this.visit((ParseTree)ctx.expression());
        DataTypes.verifyType(result.getResultType(), this.resolveTypeName("Boolean"));
        return result;
    }

    public Object visitReturnClause(@NotNull cqlParser.ReturnClauseContext ctx) {
        ReturnClause returnClause = this.of.createReturnClause();
        if (ctx.getChild(1) instanceof TerminalNode) {
            switch (ctx.getChild(1).getText()) {
                case "all": {
                    returnClause.setDistinct(Boolean.valueOf(false));
                    break;
                }
                case "distinct": {
                    returnClause.setDistinct(Boolean.valueOf(true));
                    break;
                }
            }
        }
        returnClause.setExpression(this.parseExpression((ParseTree)ctx.expression()));
        returnClause.setResultType((DataType)(this.queries.peek().isSingular() ? returnClause.getExpression().getResultType() : new ListType(returnClause.getExpression().getResultType())));
        return returnClause;
    }

    public SortDirection visitSortDirection(@NotNull cqlParser.SortDirectionContext ctx) {
        if (ctx.getText().equals("desc")) {
            return SortDirection.DESC;
        }
        return SortDirection.ASC;
    }

    private SortDirection parseSortDirection(cqlParser.SortDirectionContext ctx) {
        if (ctx != null) {
            return this.visitSortDirection(ctx);
        }
        return SortDirection.ASC;
    }

    public SortByItem visitSortByItem(@NotNull cqlParser.SortByItemContext ctx) {
        return this.of.createByExpression().withExpression(this.parseExpression((ParseTree)ctx.expressionTerm())).withDirection(this.parseSortDirection(ctx.sortDirection()));
    }

    public Object visitSortClause(@NotNull cqlParser.SortClauseContext ctx) {
        if (ctx.sortDirection() != null) {
            return this.of.createSortClause().withBy(new SortByItem[]{this.of.createByDirection().withDirection(this.parseSortDirection(ctx.sortDirection()))});
        }
        ArrayList<SortByItem> sortItems = new ArrayList<SortByItem>();
        if (ctx.sortByItem() != null) {
            for (cqlParser.SortByItemContext sortByItemContext : ctx.sortByItem()) {
                sortItems.add((SortByItem)this.visit((ParseTree)sortByItemContext));
            }
        }
        return this.of.createSortClause().withBy(sortItems);
    }

    public Object visitQuerySource(@NotNull cqlParser.QuerySourceContext ctx) {
        if (ctx.expression() != null) {
            return this.visit((ParseTree)ctx.expression());
        }
        if (ctx.retrieve() != null) {
            return this.visit((ParseTree)ctx.retrieve());
        }
        List identifiers = (List)this.visit((ParseTree)ctx.qualifiedIdentifier());
        return this.resolveQualifiedIdentifier(identifiers);
    }

    public Object visitIndexedExpressionTerm(@NotNull cqlParser.IndexedExpressionTermContext ctx) {
        Indexer indexer = this.of.createIndexer().withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expressionTerm())}).withOperand(new Expression[]{this.parseExpression((ParseTree)ctx.expression())});
        this.resolveBinaryCall("System", "Indexer", (BinaryExpression)indexer);
        return indexer;
    }

    public Object visitInvocationExpressionTerm(@NotNull cqlParser.InvocationExpressionTermContext ctx) {
        Expression systemFunction;
        FunctionRef fun = this.of.createFunctionRef().withLibraryName(this.parseString((ParseTree)ctx.qualifier())).withName(this.parseString((ParseTree)ctx.identifier()));
        if (ctx.expression() != null) {
            for (cqlParser.ExpressionContext expressionContext : ctx.expression()) {
                fun.getOperand().add((Expression)this.visit((ParseTree)expressionContext));
            }
        }
        if ((systemFunction = this.systemFunctionResolver.resolveSystemFunction(fun)) != null) {
            return systemFunction;
        }
        this.resolveCall(fun.getLibraryName(), fun.getName(), new FunctionRefInvocation(fun));
        return fun;
    }

    public Object visitFunctionBody(@NotNull cqlParser.FunctionBodyContext ctx) {
        return this.visit((ParseTree)ctx.expression());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitFunctionDefinition(@NotNull cqlParser.FunctionDefinitionContext ctx) {
        FunctionDef fun = this.of.createFunctionDef().withAccessLevel(this.parseAccessModifier((ParseTree)ctx.accessModifier())).withName(this.parseString((ParseTree)ctx.identifier()));
        if (ctx.operandDefinition() != null) {
            for (cqlParser.OperandDefinitionContext opdef : ctx.operandDefinition()) {
                TypeSpecifier typeSpecifier = this.parseTypeSpecifier((ParseTree)opdef.typeSpecifier());
                fun.getOperand().add((OperandDef)this.of.createOperandDef().withName(this.parseString((ParseTree)opdef.identifier())).withOperandTypeSpecifier(typeSpecifier).withResultType(typeSpecifier.getResultType()));
            }
        }
        this.currentFunctionDef = fun;
        this.pushExpressionContext(this.currentContext);
        try {
            fun.setExpression(this.parseExpression((ParseTree)ctx.functionBody()));
        }
        finally {
            this.currentFunctionDef = null;
            this.popExpressionContext();
        }
        fun.setContext(this.currentContext);
        fun.setResultType(fun.getExpression().getResultType());
        this.addToLibrary((ExpressionDef)fun);
        return fun;
    }

    private UsingDef buildUsingDef(VersionedIdentifier modelIdentifier, Model model) {
        UsingDef usingDef = this.of.createUsingDef().withLocalIdentifier(modelIdentifier.getId()).withVersion(modelIdentifier.getVersion()).withUri(model.getModelInfo().getUrl());
        this.addToLibrary(usingDef);
        return usingDef;
    }

    private Model buildModel(VersionedIdentifier identifier) {
        Model model = null;
        try {
            ModelInfoProvider provider = ModelInfoLoader.getModelInfoProvider(identifier);
            model = identifier.getId().equals("System") ? new SystemModel(provider.load()) : new Model(provider.load(), this.getModel("System"));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Could not load model information for model %s, version %s.", identifier.getId(), identifier.getVersion()));
        }
        return model;
    }

    private boolean hasUsings() {
        for (Model model : this.models.values()) {
            if (model.getModelInfo().getName().equals("System")) continue;
            return true;
        }
        return false;
    }

    private String getDefaultModelName() {
        String modelName = null;
        for (Model model : this.models.values()) {
            if (model.getModelInfo().getName().equals("System")) continue;
            if (modelName != null) {
                throw new IllegalArgumentException(String.format("Could not resolve a default model between %s and %s.", modelName, model.getModelInfo().getName()));
            }
            modelName = model.getModelInfo().getName();
        }
        if (modelName == null) {
            throw new IllegalArgumentException("Could not determine a default model because no usings have been defined.");
        }
        return modelName;
    }

    protected Model getModel() {
        return this.getModel((String)null);
    }

    private Model getModel(String modelName) {
        return this.getModel(modelName, null);
    }

    private Model getModel(String modelName, String version) {
        if (modelName == null) {
            modelName = this.getDefaultModelName();
        }
        VersionedIdentifier modelIdentifier = new VersionedIdentifier().withId(modelName).withVersion(version);
        return this.getModel(modelIdentifier);
    }

    private Model getModel(VersionedIdentifier modelIdentifier) {
        Model model = this.models.get(modelIdentifier.getId());
        if (model == null) {
            model = this.buildModel(modelIdentifier);
            this.models.put(modelIdentifier.getId(), model);
            this.buildUsingDef(modelIdentifier, model);
        }
        if (modelIdentifier.getVersion() != null && !modelIdentifier.getVersion().equals(model.getModelInfo().getVersion())) {
            throw new IllegalArgumentException(String.format("Could not load model information for model %s, version %s because version %s is already loaded.", modelIdentifier.getId(), modelIdentifier.getVersion(), model.getModelInfo().getVersion()));
        }
        return model;
    }

    private AccessModifier parseAccessModifier(ParseTree pt) {
        return pt == null ? AccessModifier.PUBLIC : (AccessModifier)this.visit(pt);
    }

    private String parseString(ParseTree pt) {
        return pt == null ? null : (String)this.visit(pt);
    }

    private Expression parseExpression(ParseTree pt) {
        return pt == null ? null : (Expression)this.visit(pt);
    }

    private TypeSpecifier parseTypeSpecifier(ParseTree pt) {
        return pt == null ? null : (TypeSpecifier)this.visit(pt);
    }

    protected QName dataTypeToQName(DataType type) {
        if (type instanceof NamedType) {
            NamedType namedType = (NamedType)type;
            ModelInfo modelInfo = this.getModel(namedType.getNamespace()).getModelInfo();
            return new QName(modelInfo.getUrl(), namedType.getSimpleName());
        }
        throw new IllegalArgumentException("A named type is required in this context.");
    }

    private TypeSpecifier dataTypeToTypeSpecifier(DataType type) {
        if (type instanceof NamedType) {
            return (TypeSpecifier)this.of.createNamedTypeSpecifier().withName(this.dataTypeToQName(type)).withResultType(type);
        }
        if (type instanceof ListType) {
            return this.listTypeToTypeSpecifier((ListType)type);
        }
        if (type instanceof IntervalType) {
            return this.intervalTypeToTypeSpecifier((IntervalType)type);
        }
        if (type instanceof TupleType) {
            return this.tupleTypeToTypeSpecifier((TupleType)type);
        }
        throw new IllegalArgumentException(String.format("Could not convert type %s to a type specifier.", type));
    }

    private TypeSpecifier listTypeToTypeSpecifier(ListType type) {
        return (TypeSpecifier)this.of.createListTypeSpecifier().withElementType(this.dataTypeToTypeSpecifier(type.getElementType())).withResultType((DataType)type);
    }

    private TypeSpecifier intervalTypeToTypeSpecifier(IntervalType type) {
        return (TypeSpecifier)this.of.createIntervalTypeSpecifier().withPointType(this.dataTypeToTypeSpecifier(type.getPointType())).withResultType((DataType)type);
    }

    private TypeSpecifier tupleTypeToTypeSpecifier(TupleType type) {
        return (TypeSpecifier)this.of.createTupleTypeSpecifier().withElement(this.tupleTypeElementsToTupleElementDefinitions(type.getElements())).withResultType((DataType)type);
    }

    private TupleElementDefinition[] tupleTypeElementsToTupleElementDefinitions(Iterable<TupleTypeElement> elements) {
        ArrayList<TupleElementDefinition> definitions = new ArrayList<TupleElementDefinition>();
        for (TupleTypeElement element : elements) {
            definitions.add(this.of.createTupleElementDefinition().withName(element.getName()).withType(this.dataTypeToTypeSpecifier(element.getType())));
        }
        return definitions.toArray(new TupleElementDefinition[definitions.size()]);
    }

    private ClassType resolveLabel(String modelName, String label) {
        ClassType result = null;
        if (modelName == null || modelName.equals("")) {
            for (Model model : this.models.values()) {
                ClassType modelResult = model.resolveLabel(label);
                if (modelResult == null) continue;
                if (result != null) {
                    throw new IllegalArgumentException(String.format("Label %s is ambiguous between %s and %s.", label, result.getName(), modelResult.getName()));
                }
                result = modelResult;
            }
        } else {
            result = this.getModel(modelName).resolveLabel(label);
        }
        return result;
    }

    private DataType resolveTypeName(String typeName) {
        return this.resolveTypeName(null, typeName);
    }

    private DataType resolveTypeName(String modelName, String typeName) {
        ClassType result = this.resolveLabel(modelName, typeName);
        if (result == null) {
            if (modelName == null || modelName.equals("")) {
                for (Model model : this.models.values()) {
                    DataType modelResult = model.resolveTypeName(typeName);
                    if (modelResult == null) continue;
                    if (result != null) {
                        throw new IllegalArgumentException(String.format("Type name %s is ambiguous between %s and %s.", typeName, ((NamedType)result).getName(), ((NamedType)modelResult).getName()));
                    }
                    result = modelResult;
                }
            } else {
                result = this.getModel(modelName).resolveTypeName(typeName);
            }
        }
        return result;
    }

    protected DataType resolveProperty(DataType sourceType, String identifier) {
        for (DataType currentType = sourceType; currentType != null; currentType = currentType.getBaseType()) {
            if (currentType instanceof ClassType) {
                ClassType classType = (ClassType)currentType;
                for (ClassTypeElement e : classType.getElements()) {
                    if (!e.getName().equals(identifier)) continue;
                    if (e.isProhibited()) {
                        throw new IllegalArgumentException(String.format("Element %s cannot be referenced because it is marked prohibited in type %s.", e.getName(), ((ClassType)currentType).getName()));
                    }
                    return e.getType();
                }
            } else if (currentType instanceof TupleType) {
                TupleType tupleType = (TupleType)currentType;
                for (ClassTypeElement e : tupleType.getElements()) {
                    if (!e.getName().equals(identifier)) continue;
                    return e.getType();
                }
            } else if (currentType instanceof IntervalType) {
                IntervalType intervalType = (IntervalType)currentType;
                switch (identifier) {
                    case "low": 
                    case "high": {
                        return intervalType.getPointType();
                    }
                    case "lowClosed": 
                    case "highClosed": {
                        return this.resolveTypeName("Boolean");
                    }
                }
                throw new IllegalArgumentException(String.format("Invalid interval property name %s.", identifier));
            }
            if (currentType.getBaseType() == null) break;
        }
        throw new IllegalArgumentException(String.format("Member %s not found for type %s.", identifier, sourceType));
    }

    protected Expression resolveCall(String libraryName, String operatorName, Invocation invocation) {
        Iterable<Expression> operands = invocation.getOperands();
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        for (Expression operand : operands) {
            if (operand.getResultType() == null) {
                throw new IllegalArgumentException(String.format("Could not determine signature for invocation of operator %s%s.", libraryName == null ? "" : libraryName + ".", operatorName));
            }
            dataTypes.add(operand.getResultType());
        }
        CallContext callContext = new CallContext(libraryName, operatorName, dataTypes.toArray(new DataType[dataTypes.size()]));
        OperatorResolution resolution = this.resolveCall(callContext);
        this.checkOperator(callContext, resolution);
        if (resolution.hasConversions()) {
            ArrayList<Expression> convertedOperands = new ArrayList<Expression>();
            Iterator<Expression> operandIterator = operands.iterator();
            Iterator<Conversion> conversionIterator = resolution.getConversions().iterator();
            while (operandIterator.hasNext()) {
                Expression operand = operandIterator.next();
                Conversion conversion = conversionIterator.next();
                if (conversion != null) {
                    convertedOperands.add(this.convertExpression(operand, conversion));
                    continue;
                }
                convertedOperands.add(operand);
            }
            invocation.setOperands(convertedOperands);
        }
        invocation.setResultType(resolution.getOperator().getResultType());
        return invocation.getExpression();
    }

    private Expression ensureCompatible(Expression expression, DataType targetType) {
        if (!targetType.isSuperTypeOf(expression.getResultType())) {
            return this.convertExpression(expression, targetType);
        }
        return expression;
    }

    private Expression convertExpression(Expression expression, DataType targetType) {
        Conversion conversion = this.conversionMap.findConversion(expression.getResultType(), targetType, true);
        if (conversion != null) {
            return this.convertExpression(expression, conversion);
        }
        DataTypes.verifyType(expression.getResultType(), targetType);
        return expression;
    }

    private Expression convertListExpression(Expression expression, Conversion conversion) {
        ListType fromType = (ListType)conversion.getFromType();
        ListType toType = (ListType)conversion.getToType();
        Query query = (Query)this.of.createQuery().withSource(new AliasedQuerySource[]{(AliasedQuerySource)this.of.createAliasedQuerySource().withAlias("X").withExpression(expression).withResultType((DataType)fromType)}).withReturn((ReturnClause)this.of.createReturnClause().withDistinct(Boolean.valueOf(false)).withExpression(this.convertExpression((Expression)((AliasRef)this.of.createAliasRef().withName("X").withResultType(fromType.getElementType())), conversion.getConversion())).withResultType((DataType)toType)).withResultType((DataType)toType);
        return query;
    }

    private Expression convertIntervalExpression(Expression expression, Conversion conversion) {
        IntervalType fromType = (IntervalType)conversion.getFromType();
        IntervalType toType = (IntervalType)conversion.getToType();
        Interval interval = (Interval)this.of.createInterval().withLow(this.convertExpression((Expression)((Property)this.of.createProperty().withSource(expression).withPath("low").withResultType(fromType.getPointType())), conversion.getConversion())).withLowClosedExpression((Expression)((Property)this.of.createProperty().withSource(expression).withPath("lowClosed").withResultType(this.resolveTypeName("Boolean")))).withHigh(this.convertExpression((Expression)((Property)this.of.createProperty().withSource(expression).withPath("high").withResultType(fromType.getPointType())), conversion.getConversion())).withHighClosedExpression((Expression)((Property)this.of.createProperty().withSource(expression).withPath("highClosed").withResultType(this.resolveTypeName("Boolean")))).withResultType((DataType)toType);
        return interval;
    }

    private Expression convertExpression(Expression expression, Conversion conversion) {
        if (conversion.isCast() && conversion.getFromType().isSuperTypeOf(conversion.getToType())) {
            As castedOperand = (As)this.of.createAs().withOperand(expression).withResultType(conversion.getToType());
            castedOperand.setAsTypeSpecifier(this.dataTypeToTypeSpecifier(castedOperand.getResultType()));
            if (castedOperand.getResultType() instanceof NamedType) {
                castedOperand.setAsType(this.dataTypeToQName(castedOperand.getResultType()));
            }
            return castedOperand;
        }
        if (conversion.isListConversion()) {
            return this.convertListExpression(expression, conversion);
        }
        if (conversion.isIntervalConversion()) {
            return this.convertIntervalExpression(expression, conversion);
        }
        Convert convertedOperand = (Convert)this.of.createConvert().withOperand(expression).withResultType(conversion.getToType());
        convertedOperand.setToTypeSpecifier(this.dataTypeToTypeSpecifier(convertedOperand.getResultType()));
        if (convertedOperand.getResultType() instanceof NamedType) {
            convertedOperand.setToType(this.dataTypeToQName(convertedOperand.getResultType()));
        }
        return convertedOperand;
    }

    private void verifyType(DataType actualType, DataType expectedType) {
        if (expectedType.isSuperTypeOf(actualType) || actualType.isCompatibleWith(expectedType)) {
            return;
        }
        Conversion conversion = this.conversionMap.findConversion(actualType, expectedType, true);
        if (conversion != null) {
            return;
        }
        DataTypes.verifyType(actualType, expectedType);
    }

    private DataType ensureCompatibleTypes(DataType first, DataType second) {
        if (first.equals(DataType.ANY)) {
            return second;
        }
        if (second.equals(DataType.ANY)) {
            return first;
        }
        if (first.isSuperTypeOf(second) || second.isCompatibleWith(first)) {
            return first;
        }
        if (second.isSuperTypeOf(first) || first.isCompatibleWith(second)) {
            return second;
        }
        Conversion conversion = this.conversionMap.findConversion(second, first, true);
        if (conversion != null) {
            return first;
        }
        conversion = this.conversionMap.findConversion(first, second, true);
        if (conversion != null) {
            return second;
        }
        DataTypes.verifyType(second, first);
        return first;
    }

    protected Expression resolveUnaryCall(String libraryName, String operatorName, UnaryExpression expression) {
        return this.resolveCall(libraryName, operatorName, new UnaryExpressionInvocation(expression));
    }

    protected Expression resolveBinaryCall(String libraryName, String operatorName, BinaryExpression expression) {
        return this.resolveCall(libraryName, operatorName, new BinaryExpressionInvocation(expression));
    }

    protected Expression resolveAggregateCall(String libraryName, String operatorName, AggregateExpression expression) {
        return this.resolveCall(libraryName, operatorName, new AggregateExpressionInvocation(expression));
    }

    private OperatorResolution resolveCall(CallContext callContext) {
        OperatorResolution result = null;
        if (callContext.getLibraryName() == null || callContext.getLibraryName().equals("")) {
            result = this.translatedLibrary.resolveCall(callContext, this.conversionMap);
            if (result == null && (result = this.getSystemLibrary().resolveCall(callContext, this.conversionMap)) != null) {
                this.checkAccessLevel(result.getOperator().getLibraryName(), result.getOperator().getName(), result.getOperator().getAccessLevel());
            }
        } else {
            result = this.resolveLibrary(callContext.getLibraryName()).resolveCall(callContext, this.conversionMap);
        }
        return result;
    }

    private void checkOperator(CallContext callContext, OperatorResolution resolution) {
        if (resolution == null) {
            throw new IllegalArgumentException(String.format("Could not resolve call to operator %s with signature %s.", callContext.getOperatorName(), callContext.getSignature()));
        }
    }

    private void checkAccessLevel(String libraryName, String objectName, AccessModifier accessModifier) {
        if (accessModifier == AccessModifier.PRIVATE) {
            throw new IllegalArgumentException(String.format("Object %s in library %s is marked private and cannot be referenced from another library.", objectName, libraryName));
        }
    }

    private Literal createLiteral(String val, String type) {
        DataType resultType = this.resolveTypeName(type);
        Literal result = this.of.createLiteral().withValue(val).withValueType(this.dataTypeToQName(resultType));
        result.setResultType(resultType);
        return result;
    }

    private Literal createLiteral(String string) {
        return this.createLiteral(String.valueOf(string), "String");
    }

    private Literal createLiteral(Boolean bool) {
        return this.createLiteral(String.valueOf(bool), "Boolean");
    }

    private Literal createLiteral(Integer integer) {
        return this.createLiteral(String.valueOf(integer), "Integer");
    }

    private Literal createLiteral(Double value) {
        return this.createLiteral(String.valueOf(value), "Decimal");
    }

    private boolean isBooleanLiteral(Expression expression, Boolean bool) {
        Literal lit;
        boolean ret = false;
        if (expression instanceof Literal && (ret = (lit = (Literal)expression).getValueType().equals(this.dataTypeToQName(this.resolveTypeName("Boolean")))) && bool != null) {
            ret = bool.equals(Boolean.valueOf(lit.getValue()));
        }
        return ret;
    }

    private AliasedQuerySource resolveAlias(String identifier) {
        for (QueryContext query : this.queries) {
            AliasedQuerySource source = query.resolveAlias(identifier);
            if (source == null) continue;
            return source;
        }
        return null;
    }

    private DefineClause resolveQueryDefine(String identifier) {
        for (QueryContext query : this.queries) {
            DefineClause define = query.resolveDefine(identifier);
            if (define == null) continue;
            return define;
        }
        return null;
    }

    private OperandRef resolveOperandRef(String identifier) {
        if (this.currentFunctionDef != null) {
            for (OperandDef operand : this.currentFunctionDef.getOperand()) {
                if (!operand.getName().equals(identifier)) continue;
                return (OperandRef)this.of.createOperandRef().withName(identifier).withResultType(operand.getResultType());
            }
        }
        return null;
    }

    private void setLibraryIdentifier(VersionedIdentifier vid) {
        this.library.setIdentifier(vid);
        this.translatedLibrary.setIdentifier(vid);
    }

    private void addToLibrary(UsingDef usingDef) {
        if (this.library.getUsings() == null) {
            this.library.setUsings(this.of.createLibraryUsings());
        }
        this.library.getUsings().getDef().add(usingDef);
        this.translatedLibrary.add(usingDef);
    }

    private void addToLibrary(CodeSystemDef cs) {
        if (this.library.getCodeSystems() == null) {
            this.library.setCodeSystems(this.of.createLibraryCodeSystems());
        }
        this.library.getCodeSystems().getDef().add(cs);
        this.translatedLibrary.add(cs);
    }

    private void addToLibrary(ValueSetDef vs) {
        if (this.library.getValueSets() == null) {
            this.library.setValueSets(this.of.createLibraryValueSets());
        }
        this.library.getValueSets().getDef().add(vs);
        this.translatedLibrary.add(vs);
    }

    private void addToLibrary(ParameterDef paramDef) {
        if (this.library.getParameters() == null) {
            this.library.setParameters(this.of.createLibraryParameters());
        }
        this.library.getParameters().getDef().add(paramDef);
        this.translatedLibrary.add(paramDef);
    }

    private void addToLibrary(ExpressionDef expDef) {
        if (this.library.getStatements() == null) {
            this.library.setStatements(this.of.createLibraryStatements());
        }
        this.library.getStatements().getDef().add(expDef);
        this.translatedLibrary.add(expDef);
    }

    private void pushExpressionDefinition(String identifier) {
        if (this.expressionDefinitions.contains(identifier)) {
            throw new IllegalArgumentException(String.format("Cannot resolve reference to expression %s because it results in a circular reference.", identifier));
        }
        this.expressionDefinitions.push(identifier);
    }

    private void popExpressionDefinition() {
        this.expressionDefinitions.pop();
    }

    private DataType getExpressionDefResultType(ExpressionDef expressionDef) {
        if (this.currentExpressionContext().equals(expressionDef.getContext())) {
            return expressionDef.getResultType();
        }
        if (this.inPatientContext()) {
            return expressionDef.getResultType();
        }
        if (this.inPopulationContext()) {
            DataType resultType;
            if (!this.queries.empty() && this.queries.peek().inSourceClause()) {
                this.queries.peek().referencePatientContext();
            }
            if (!((resultType = expressionDef.getResultType()) instanceof ListType)) {
                return new ListType(resultType);
            }
            return resultType;
        }
        throw new IllegalArgumentException(String.format("Invalid context reference from %s context to %s context.", this.currentExpressionContext(), expressionDef.getContext()));
    }

    private void pushExpressionContext(String context) {
        this.expressionContext.push(context);
    }

    private void popExpressionContext() {
        if (this.expressionContext.empty()) {
            throw new IllegalStateException("Expression context stack is empty.");
        }
        this.expressionContext.pop();
    }

    private String currentExpressionContext() {
        if (this.expressionContext.empty()) {
            throw new IllegalStateException("Expression context stack is empty.");
        }
        return this.expressionContext.peek();
    }

    private boolean inPatientContext() {
        return this.currentExpressionContext().equals("Patient");
    }

    private boolean inPopulationContext() {
        return this.currentExpressionContext().equals("Population");
    }

    private void addToLibrary(IncludeDef includeDef) {
        if (this.library.getIdentifier() == null || this.library.getIdentifier().getId() == null) {
            throw new IllegalArgumentException("Unnamed libraries cannot reference other libraries.");
        }
        if (this.library.getIncludes() == null) {
            this.library.setIncludes(this.of.createLibraryIncludes());
        }
        this.library.getIncludes().getDef().add(includeDef);
        this.translatedLibrary.add(includeDef);
        VersionedIdentifier libraryIdentifier = new VersionedIdentifier().withId(includeDef.getPath()).withVersion(includeDef.getVersion());
        TranslatedLibrary referencedLibrary = this.libraryManager.resolveLibrary(libraryIdentifier, this.errors);
        this.libraries.put(includeDef.getLocalIdentifier(), referencedLibrary);
        this.loadConversionMap(referencedLibrary);
    }

    protected SystemModel getSystemModel() {
        return (SystemModel)this.getModel("System");
    }

    private void loadSystemLibrary() {
        TranslatedLibrary systemLibrary = SystemLibraryHelper.load(this.getSystemModel());
        this.libraries.put(systemLibrary.getIdentifier().getId(), systemLibrary);
        this.loadConversionMap(systemLibrary);
    }

    private void loadConversionMap(TranslatedLibrary library) {
        for (Conversion conversion : library.getConversions()) {
            this.conversionMap.add(conversion);
        }
    }

    private TranslatedLibrary getSystemLibrary() {
        return this.resolveLibrary("System");
    }

    private TranslatedLibrary resolveLibrary(String identifier) {
        return this.libraries.get(identifier);
    }

    private void addExpression(Expression expression) {
        this.expressions.add(expression);
    }

    private TrackBack getTrackBack(ParserRuleContext ctx) {
        TrackBack tb = new TrackBack(this.library.getIdentifier(), ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine() + 1, ctx.getStop().getLine(), ctx.getStop().getCharPositionInLine() + ctx.getStop().getText().length());
        return tb;
    }

    private TrackBack track(Trackable trackable, ParserRuleContext ctx) {
        TrackBack tb = this.getTrackBack(ctx);
        trackable.getTrackbacks().add(tb);
        return tb;
    }
}

