/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Nullable;
import org.antlr.v4.runtime.tree.ParseTree;
import org.cqframework.cql.cql2elm.Cql2ElmVisitor;
import org.cqframework.cql.cql2elm.CqlTranslatorException;
import org.cqframework.cql.cql2elm.DefaultLibrarySourceProvider;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.ModelInfoLoader;
import org.cqframework.cql.cql2elm.ModelInfoProvider;
import org.cqframework.cql.cql2elm.model.TranslatedLibrary;
import org.cqframework.cql.cql2elm.preprocessor.CqlPreprocessorVisitor;
import org.cqframework.cql.elm.tracking.TrackBack;
import org.cqframework.cql.gen.cqlLexer;
import org.cqframework.cql.gen.cqlParser;
import org.hl7.cql_annotations.r1.Annotation;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.ObjectFactory;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class CqlTranslator {
    private Library library = null;
    private TranslatedLibrary translatedLibrary = null;
    private Object visitResult = null;
    private List<Retrieve> retrieves = null;
    private List<CqlTranslatorException> errors = null;
    private LibraryManager libraryManager = null;

    public static CqlTranslator fromText(String cqlText, LibraryManager libraryManager, Options ... options) {
        return new CqlTranslator(new ANTLRInputStream(cqlText), libraryManager, options);
    }

    public static CqlTranslator fromStream(InputStream cqlStream, LibraryManager libraryManager, Options ... options) throws IOException {
        return new CqlTranslator(new ANTLRInputStream(cqlStream), libraryManager, options);
    }

    public static CqlTranslator fromFile(String cqlFileName, LibraryManager libraryManager, Options ... options) throws IOException {
        return new CqlTranslator(new ANTLRInputStream((InputStream)new FileInputStream(cqlFileName)), libraryManager, options);
    }

    public static CqlTranslator fromFile(File cqlFile, LibraryManager libraryManager, Options ... options) throws IOException {
        return new CqlTranslator(new ANTLRInputStream((InputStream)new FileInputStream(cqlFile)), libraryManager, options);
    }

    private CqlTranslator(ANTLRInputStream is, LibraryManager libraryManager, Options ... options) {
        this.libraryManager = libraryManager;
        this.translateToELM(is, options);
    }

    public String toXml() {
        try {
            return this.convertToXML(this.library);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Could not convert library to XML.", e);
        }
    }

    public String toJson() {
        try {
            return this.convertToJSON(this.library);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Could not convert library to JSON.", e);
        }
    }

    public Library toELM() {
        return this.library;
    }

    public TranslatedLibrary getTranslatedLibrary() {
        return this.translatedLibrary;
    }

    public Object toObject() {
        return this.visitResult;
    }

    public List<Retrieve> toRetrieves() {
        return this.retrieves;
    }

    public List<CqlTranslatorException> getErrors() {
        return this.errors;
    }

    private void translateToELM(ANTLRInputStream is, Options ... options) {
        cqlLexer lexer = new cqlLexer((CharStream)is);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        cqlParser parser = new cqlParser((TokenStream)tokens);
        parser.setBuildParseTree(true);
        this.errors = new ArrayList<CqlTranslatorException>();
        Cql2ElmVisitor visitor = new Cql2ElmVisitor(this.libraryManager);
        parser.addErrorListener((ANTLRErrorListener)new CqlErrorListener(visitor));
        cqlParser.LogicContext tree = parser.logic();
        CqlPreprocessorVisitor preprocessor = new CqlPreprocessorVisitor();
        preprocessor.visit((ParseTree)tree);
        visitor.setLibraryInfo(preprocessor.getLibraryInfo());
        visitor.setTokenStream((TokenStream)tokens);
        List<Options> optionList = Arrays.asList(options);
        if (optionList.contains((Object)Options.EnableDateRangeOptimization)) {
            visitor.enableDateRangeOptimization();
        }
        if (optionList.contains((Object)Options.EnableAnnotations)) {
            visitor.enableAnnotations();
        }
        this.visitResult = visitor.visit((ParseTree)tree);
        this.library = visitor.getLibrary();
        this.translatedLibrary = visitor.getTranslatedLibrary();
        this.retrieves = visitor.getRetrieves();
        this.errors.addAll(visitor.getErrors());
    }

    private String convertToXML(Library library) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Library.class, Annotation.class});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)new ObjectFactory().createLibrary(library), (Writer)writer);
        return writer.getBuffer().toString();
    }

    private String convertToJSON(Library library) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Library.class, Annotation.class});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)new ObjectFactory().createLibrary(library), (Writer)writer);
        return writer.getBuffer().toString();
    }

    private static void loadModelInfo(File modelInfoXML) {
        ModelInfo modelInfo = (ModelInfo)JAXB.unmarshal((File)modelInfoXML, ModelInfo.class);
        VersionedIdentifier modelId = new VersionedIdentifier().withId(modelInfo.getName()).withVersion(modelInfo.getVersion());
        ModelInfoProvider modelProvider = () -> modelInfo;
        ModelInfoLoader.registerModelInfoProvider(modelId, modelProvider);
    }

    private static void writeELM(Path inPath, Path outPath, Format format, boolean dateRangeOptimizations, boolean annotations, boolean verifyOnly) throws IOException {
        ArrayList<Options> options = new ArrayList<Options>();
        if (dateRangeOptimizations) {
            options.add(Options.EnableDateRangeOptimization);
        }
        if (annotations) {
            options.add(Options.EnableAnnotations);
        }
        System.err.println("================================================================================");
        System.err.printf("TRANSLATE %s%n", inPath);
        LibraryManager libraryManager = new LibraryManager();
        libraryManager.getLibrarySourceLoader().registerProvider(new DefaultLibrarySourceProvider(inPath.getParent()));
        CqlTranslator translator = CqlTranslator.fromFile(inPath.toFile(), libraryManager, options.toArray(new Options[options.size()]));
        libraryManager.getLibrarySourceLoader().clearProviders();
        if (translator.getErrors().size() > 0) {
            System.err.println("Translation failed due to errors:");
            for (CqlTranslatorException error : translator.getErrors()) {
                TrackBack tb = error.getLocator();
                String lines = tb == null ? "[n/a]" : String.format("[%d:%d, %d:%d]", tb.getStartLine(), tb.getStartChar(), tb.getEndLine(), tb.getEndChar());
                System.err.printf("%s %s%n", lines, error.getMessage());
            }
        } else if (!verifyOnly) {
            try (PrintWriter pw = new PrintWriter(outPath.toFile(), "UTF-8");){
                switch (format) {
                    case COFFEE: {
                        pw.print("module.exports = ");
                        pw.println(translator.toJson());
                        break;
                    }
                    case JSON: {
                        pw.println(translator.toJson());
                        break;
                    }
                    default: {
                        pw.println(translator.toXml());
                    }
                }
                pw.println();
            }
        }
        System.err.println();
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec input = parser.accepts("input").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec model = parser.accepts("model").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec output = parser.accepts("output").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec format = parser.accepts("format").withRequiredArg().ofType(Format.class).defaultsTo((Object)Format.XML, (Object[])new Format[0]);
        OptionSpecBuilder verify = parser.accepts("verify");
        OptionSpecBuilder optimization = parser.accepts("date-range-optimization");
        OptionSpecBuilder annotations = parser.accepts("annotations");
        OptionSet options = parser.parse(args);
        final Path source = ((File)input.value(options)).toPath();
        final Path destination = output.value(options) != null ? ((File)output.value(options)).toPath() : (source.toFile().isDirectory() ? source : source.getParent());
        Format outputFormat = (Format)((Object)format.value(options));
        final HashMap<Path, Path> inOutMap = new HashMap<Path, Path>();
        if (source.toFile().isDirectory()) {
            if (destination.toFile().exists() && !destination.toFile().isDirectory()) {
                throw new IllegalArgumentException("Output must be a valid folder if input is a folder!");
            }
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toFile().getName().endsWith(".cql") || file.toFile().getName().endsWith(".CQL")) {
                        Path destinationFolder = destination.resolve(source.relativize(file.getParent()));
                        if (!destinationFolder.toFile().exists() && !destinationFolder.toFile().mkdirs()) {
                            System.err.printf("Problem creating %s%n", destinationFolder);
                        }
                        inOutMap.put(file, destinationFolder);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            inOutMap.put(source, destination);
        }
        for (Map.Entry inOut : inOutMap.entrySet()) {
            Path in = (Path)inOut.getKey();
            Path out = (Path)inOut.getValue();
            if (out.toFile().isDirectory()) {
                String name = in.toFile().getName();
                if (name.lastIndexOf(46) != -1) {
                    name = name.substring(0, name.lastIndexOf(46));
                }
                switch (outputFormat) {
                    case JSON: {
                        name = name + ".json";
                        break;
                    }
                    case COFFEE: {
                        name = name + ".coffee";
                        break;
                    }
                    default: {
                        name = name + ".xml";
                    }
                }
                out = out.resolve(name);
            }
            if (out.equals(in)) {
                throw new IllegalArgumentException("input and output file must be different!");
            }
            if (options.has((OptionSpec)model)) {
                File modelFile = (File)options.valueOf((OptionSpec)model);
                if (!modelFile.exists() || modelFile.isDirectory()) {
                    throw new IllegalArgumentException("model must be a valid file!");
                }
                CqlTranslator.loadModelInfo(modelFile);
            }
            CqlTranslator.writeELM(in, out, outputFormat, options.has((OptionSpec)optimization), options.has((OptionSpec)annotations), options.has((OptionSpec)verify));
        }
    }

    private class CqlErrorListener
    extends BaseErrorListener {
        Cql2ElmVisitor visitor;

        public CqlErrorListener(Cql2ElmVisitor visitor) {
            this.visitor = visitor;
        }

        public void syntaxError(@NotNull Recognizer<?, ?> recognizer, @Nullable Object offendingSymbol, int line, int charPositionInLine, @NotNull String msg, @Nullable RecognitionException e) {
            TrackBack trackback = new TrackBack(new VersionedIdentifier().withId("unknown"), line, charPositionInLine, line, charPositionInLine);
            this.visitor.recordParsingException(new CqlTranslatorException(msg, trackback, (Throwable)e));
        }
    }

    public static enum Format {
        XML,
        JSON,
        COFFEE;

    }

    public static enum Options {
        EnableDateRangeOptimization,
        EnableAnnotations;

    }
}

