/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.util.HashMap;
import java.util.Map;
import org.cqframework.cql.cql2elm.ModelInfoProvider;
import org.cqframework.cql.cql2elm.QdmModelInfoProvider;
import org.cqframework.cql.cql2elm.QuickModelInfoProvider;
import org.cqframework.cql.cql2elm.SystemModelInfoProvider;
import org.hl7.elm.r1.VersionedIdentifier;

public class ModelInfoLoader {
    private static final Map<VersionedIdentifier, ModelInfoProvider> PROVIDERS = new HashMap<VersionedIdentifier, ModelInfoProvider>();

    public static ModelInfoProvider getModelInfoProvider(VersionedIdentifier modelIdentifier) {
        ModelInfoLoader.checkModelIdentifier(modelIdentifier);
        ModelInfoProvider provider = PROVIDERS.get(modelIdentifier);
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Could not resolve model info provider for model %s, version %s.", modelIdentifier.getId(), modelIdentifier.getVersion()));
        }
        return provider;
    }

    public static void registerModelInfoProvider(VersionedIdentifier modelIdentifier, ModelInfoProvider provider) {
        ModelInfoLoader.checkModelIdentifier(modelIdentifier);
        if (provider == null) {
            throw new IllegalArgumentException("Provider is null");
        }
        PROVIDERS.put(modelIdentifier, provider);
        if (modelIdentifier.getVersion() != null) {
            VersionedIdentifier versionlessIdentifier = new VersionedIdentifier().withId(modelIdentifier.getId());
            PROVIDERS.put(versionlessIdentifier, provider);
        }
    }

    public static void unregisterModelInfoProvider(VersionedIdentifier modelIdentifier) {
        ModelInfoLoader.checkModelIdentifier(modelIdentifier);
        PROVIDERS.remove(modelIdentifier);
    }

    private static void checkModelIdentifier(VersionedIdentifier modelIdentifier) {
        if (modelIdentifier == null) {
            throw new IllegalArgumentException("modelIdentifier is null.");
        }
        if (modelIdentifier.getId() == null || modelIdentifier.getId().equals("")) {
            throw new IllegalArgumentException("modelIdentifier Id is null.");
        }
    }

    static {
        ModelInfoLoader.registerModelInfoProvider(new VersionedIdentifier().withId("System").withVersion("1"), new SystemModelInfoProvider());
        ModelInfoLoader.registerModelInfoProvider(new VersionedIdentifier().withId("QUICK").withVersion("1"), new QuickModelInfoProvider());
        ModelInfoLoader.registerModelInfoProvider(new VersionedIdentifier().withId("QDM").withVersion("4.1.2"), new QdmModelInfoProvider());
    }
}

