/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.util.ArrayList;
import java.util.List;
import org.cqframework.cql.cql2elm.Cql2ElmVisitor;
import org.cqframework.cql.cql2elm.model.SystemModel;
import org.cqframework.cql.cql2elm.model.invocation.CombineInvocation;
import org.cqframework.cql.cql2elm.model.invocation.ConvertInvocation;
import org.cqframework.cql.cql2elm.model.invocation.DateTimeInvocation;
import org.cqframework.cql.cql2elm.model.invocation.FirstInvocation;
import org.cqframework.cql.cql2elm.model.invocation.IndexOfInvocation;
import org.cqframework.cql.cql2elm.model.invocation.LastInvocation;
import org.cqframework.cql.cql2elm.model.invocation.NaryExpressionInvocation;
import org.cqframework.cql.cql2elm.model.invocation.PositionOfInvocation;
import org.cqframework.cql.cql2elm.model.invocation.RoundInvocation;
import org.cqframework.cql.cql2elm.model.invocation.SplitInvocation;
import org.cqframework.cql.cql2elm.model.invocation.SubstringInvocation;
import org.cqframework.cql.cql2elm.model.invocation.ZeroOperandExpressionInvocation;
import org.hl7.elm.r1.AggregateExpression;
import org.hl7.elm.r1.BinaryExpression;
import org.hl7.elm.r1.CalculateAge;
import org.hl7.elm.r1.CalculateAgeAt;
import org.hl7.elm.r1.Combine;
import org.hl7.elm.r1.Convert;
import org.hl7.elm.r1.DateTime;
import org.hl7.elm.r1.DateTimePrecision;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.First;
import org.hl7.elm.r1.FunctionRef;
import org.hl7.elm.r1.IndexOf;
import org.hl7.elm.r1.Last;
import org.hl7.elm.r1.NaryExpression;
import org.hl7.elm.r1.Now;
import org.hl7.elm.r1.ObjectFactory;
import org.hl7.elm.r1.PositionOf;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Round;
import org.hl7.elm.r1.Split;
import org.hl7.elm.r1.Substring;
import org.hl7.elm.r1.Today;
import org.hl7.elm.r1.UnaryExpression;

public class SystemFunctionResolver {
    private final ObjectFactory of = new ObjectFactory();
    private final Cql2ElmVisitor visitor;

    public SystemFunctionResolver(Cql2ElmVisitor visitor) {
        this.visitor = visitor;
    }

    public Expression resolveSystemFunction(FunctionRef fun) {
        if (fun.getLibraryName() == null) {
            switch (fun.getName()) {
                case "AllTrue": 
                case "AnyTrue": 
                case "Avg": 
                case "Count": 
                case "Max": 
                case "Median": 
                case "Min": 
                case "Mode": 
                case "PopulationStdDev": 
                case "PopulationVariance": 
                case "StdDev": 
                case "Sum": 
                case "Variance": {
                    return this.resolveAggregate(fun);
                }
                case "Abs": 
                case "Ceiling": 
                case "Floor": 
                case "Ln": 
                case "Truncate": {
                    return this.resolveUnary(fun);
                }
                case "Log": {
                    return this.resolveBinary(fun);
                }
                case "Round": {
                    return this.resolveRound(fun);
                }
                case "AgeInYears": 
                case "AgeInMonths": 
                case "AgeInDays": 
                case "AgeInHours": 
                case "AgeInMinutes": 
                case "AgeInSeconds": 
                case "AgeInMilliseconds": {
                    this.checkNumberOfOperands(fun, 0);
                    return this.resolveCalculateAge((Expression)this.getPatientBirthDateProperty(), SystemFunctionResolver.resolveAgeRelatedFunctionPrecision(fun));
                }
                case "AgeInYearsAt": 
                case "AgeInMonthsAt": 
                case "AgeInDaysAt": 
                case "AgeInHoursAt": 
                case "AgeInMinutesAt": 
                case "AgeInSecondsAt": 
                case "AgeInMillisecondsAt": {
                    ArrayList<Expression> ops = new ArrayList<Expression>();
                    ops.add((Expression)this.getPatientBirthDateProperty());
                    ops.addAll(fun.getOperand());
                    return this.resolveCalculateAgeAt(ops, SystemFunctionResolver.resolveAgeRelatedFunctionPrecision(fun));
                }
                case "CalculateAgeInMonths": 
                case "CalculateAgeInDays": 
                case "CalculateAgeInHours": 
                case "CalculateAgeInMinutes": 
                case "CalculateAgeInSeconds": 
                case "CalculateAgeInMilliseconds": {
                    this.checkNumberOfOperands(fun, 1);
                    return this.resolveCalculateAge((Expression)fun.getOperand().get(0), SystemFunctionResolver.resolveAgeRelatedFunctionPrecision(fun));
                }
                case "CalculateAgeInYearsAt": 
                case "CalculateAgeInMonthsAt": 
                case "CalculateAgeInDaysAt": 
                case "CalculateAgeInHoursAt": 
                case "CalculateAgeInMinutesAt": 
                case "CalculateAgeInSecondsAt": 
                case "CalculateAgeInMillisecondsAt": {
                    return this.resolveCalculateAgeAt(fun.getOperand(), SystemFunctionResolver.resolveAgeRelatedFunctionPrecision(fun));
                }
                case "DateTime": {
                    return this.resolveDateTime(fun);
                }
                case "Now": {
                    return this.resolveNow(fun);
                }
                case "Today": {
                    return this.resolveToday(fun);
                }
                case "IndexOf": {
                    return this.resolveIndexOf(fun);
                }
                case "First": {
                    return this.resolveFirst(fun);
                }
                case "Last": {
                    return this.resolveLast(fun);
                }
                case "Coalesce": {
                    return this.resolveNary(fun);
                }
                case "Length": {
                    return this.resolveUnary(fun);
                }
                case "Combine": {
                    return this.resolveCombine(fun);
                }
                case "Split": {
                    return this.resolveSplit(fun);
                }
                case "Upper": 
                case "Lower": {
                    return this.resolveUnary(fun);
                }
                case "PositionOf": {
                    return this.resolvePositionOf(fun);
                }
                case "Substring": {
                    return this.resolveSubstring(fun);
                }
                case "ToString": 
                case "ToBoolean": 
                case "ToInteger": 
                case "ToDecimal": 
                case "ToDateTime": 
                case "ToTime": 
                case "ToConcept": {
                    return this.resolveConvert(fun);
                }
            }
        }
        return null;
    }

    private CalculateAge resolveCalculateAge(Expression e, DateTimePrecision p) {
        CalculateAge operator = this.of.createCalculateAge().withPrecision(p).withOperand(e);
        this.visitor.resolveUnaryCall("System", "CalculateAge", (UnaryExpression)operator);
        return operator;
    }

    private CalculateAgeAt resolveCalculateAgeAt(List<Expression> e, DateTimePrecision p) {
        CalculateAgeAt operator = this.of.createCalculateAgeAt().withPrecision(p).withOperand(e);
        this.visitor.resolveBinaryCall("System", "CalculateAgeAt", (BinaryExpression)operator);
        return operator;
    }

    private static DateTimePrecision resolveAgeRelatedFunctionPrecision(FunctionRef fun) {
        String name = fun.getName();
        if (name.contains("Years")) {
            return DateTimePrecision.YEAR;
        }
        if (name.contains("Months")) {
            return DateTimePrecision.MONTH;
        }
        if (name.contains("Days")) {
            return DateTimePrecision.DAY;
        }
        if (name.contains("Hours")) {
            return DateTimePrecision.HOUR;
        }
        if (name.contains("Minutes")) {
            return DateTimePrecision.MINUTE;
        }
        if (name.contains("Second")) {
            return DateTimePrecision.SECOND;
        }
        if (name.contains("Milliseconds")) {
            return DateTimePrecision.MILLISECOND;
        }
        throw new IllegalArgumentException(String.format("Unknown precision '%s'.", name));
    }

    private Property getPatientBirthDateProperty() {
        Expression source = this.visitor.resolveIdentifier("Patient");
        Property property = this.of.createProperty().withSource(source).withPath(this.visitor.getModel().getModelInfo().getPatientBirthDatePropertyName());
        property.setResultType(this.visitor.resolveProperty(source.getResultType(), property.getPath()));
        return property;
    }

    private Round resolveRound(FunctionRef fun) {
        if (fun.getOperand().isEmpty() || fun.getOperand().size() > 2) {
            throw new IllegalArgumentException("Could not resolve call to system operator Round.  Expected 1 or 2 arguments.");
        }
        Round round = this.of.createRound().withOperand((Expression)fun.getOperand().get(0));
        if (fun.getOperand().size() == 2) {
            round.setPrecision((Expression)fun.getOperand().get(1));
        }
        this.visitor.resolveCall("System", "Round", new RoundInvocation(round));
        return round;
    }

    private DateTime resolveDateTime(FunctionRef fun) {
        DateTime dt = this.of.createDateTime();
        DateTimeInvocation.setDateTimeFieldsFromOperands(dt, fun.getOperand());
        this.visitor.resolveCall("System", "DateTime", new DateTimeInvocation(dt));
        return dt;
    }

    private Now resolveNow(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 0);
        Now now = this.of.createNow();
        this.visitor.resolveCall("System", "Now", new ZeroOperandExpressionInvocation((Expression)now));
        return now;
    }

    private Today resolveToday(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 0);
        Today today = this.of.createToday();
        this.visitor.resolveCall("System", "Today", new ZeroOperandExpressionInvocation((Expression)today));
        return today;
    }

    private IndexOf resolveIndexOf(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 2);
        IndexOf indexOf = this.of.createIndexOf();
        indexOf.setSource((Expression)fun.getOperand().get(0));
        indexOf.setElement((Expression)fun.getOperand().get(1));
        this.visitor.resolveCall("System", "IndexOf", new IndexOfInvocation(indexOf));
        return indexOf;
    }

    private First resolveFirst(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 1);
        First first = this.of.createFirst();
        first.setSource((Expression)fun.getOperand().get(0));
        this.visitor.resolveCall("System", "First", new FirstInvocation(first));
        return first;
    }

    private Last resolveLast(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 1);
        Last last = this.of.createLast();
        last.setSource((Expression)fun.getOperand().get(0));
        this.visitor.resolveCall("System", "Last", new LastInvocation(last));
        return last;
    }

    private Combine resolveCombine(FunctionRef fun) {
        if (fun.getOperand().isEmpty() || fun.getOperand().size() > 2) {
            throw new IllegalArgumentException("Could not resolve call to system operator Combine.  Expected 1 or 2 arguments.");
        }
        Combine combine = this.of.createCombine().withSource((Expression)fun.getOperand().get(0));
        if (fun.getOperand().size() == 2) {
            combine.setSeparator((Expression)fun.getOperand().get(1));
        }
        this.visitor.resolveCall("System", "Combine", new CombineInvocation(combine));
        return combine;
    }

    private Split resolveSplit(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 2);
        Split split = this.of.createSplit().withStringToSplit((Expression)fun.getOperand().get(0)).withSeparator((Expression)fun.getOperand().get(1));
        this.visitor.resolveCall("System", "Split", new SplitInvocation(split));
        return split;
    }

    private PositionOf resolvePositionOf(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 2);
        PositionOf pos = this.of.createPositionOf().withPattern((Expression)fun.getOperand().get(0)).withString((Expression)fun.getOperand().get(1));
        this.visitor.resolveCall("System", "PositionOf", new PositionOfInvocation(pos));
        return pos;
    }

    private Substring resolveSubstring(FunctionRef fun) {
        if (fun.getOperand().size() < 2 || fun.getOperand().size() > 3) {
            throw new IllegalArgumentException("Could not resolve call to system operator Substring.  Expected 2 or 3 arguments.");
        }
        Substring substring = this.of.createSubstring().withStringToSub(fun.getOperand().get(0)).withStartIndex(fun.getOperand().get(1));
        if (fun.getOperand().size() == 3) {
            substring.setLength(fun.getOperand().get(2));
        }
        this.visitor.resolveCall("System", "Substring", new SubstringInvocation(substring));
        return substring;
    }

    private Convert resolveConvert(FunctionRef fun) {
        this.checkNumberOfOperands(fun, 1);
        Convert convert = this.of.createConvert().withOperand((Expression)fun.getOperand().get(0));
        SystemModel sm = this.visitor.getSystemModel();
        switch (fun.getName()) {
            case "ToString": {
                convert.setToType(this.visitor.dataTypeToQName(sm.getString()));
                break;
            }
            case "ToBoolean": {
                convert.setToType(this.visitor.dataTypeToQName(sm.getBoolean()));
                break;
            }
            case "ToInteger": {
                convert.setToType(this.visitor.dataTypeToQName(sm.getInteger()));
                break;
            }
            case "ToDecimal": {
                convert.setToType(this.visitor.dataTypeToQName(sm.getDecimal()));
                break;
            }
            case "ToDateTime": {
                convert.setToType(this.visitor.dataTypeToQName(sm.getDateTime()));
                break;
            }
            case "ToTime": {
                convert.setToType(this.visitor.dataTypeToQName(sm.getTime()));
                break;
            }
            case "ToConcept": {
                convert.setToType(this.visitor.dataTypeToQName(sm.getConcept()));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Could not resolve call to system operator %s. Unknown conversion type.", fun.getName()));
            }
        }
        this.visitor.resolveCall("System", fun.getName(), new ConvertInvocation(convert));
        return convert;
    }

    private UnaryExpression resolveUnary(FunctionRef fun) {
        UnaryExpression operator = null;
        try {
            Class<?> clazz = Class.forName("org.hl7.elm.r1." + fun.getName());
            if (UnaryExpression.class.isAssignableFrom(clazz)) {
                operator = (UnaryExpression)clazz.newInstance();
                this.checkNumberOfOperands(fun, 1);
                operator.setOperand((Expression)fun.getOperand().get(0));
                this.visitor.resolveUnaryCall("System", fun.getName(), operator);
                return operator;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return operator;
    }

    private BinaryExpression resolveBinary(FunctionRef fun) {
        BinaryExpression operator = null;
        try {
            Class<?> clazz = Class.forName("org.hl7.elm.r1." + fun.getName());
            if (BinaryExpression.class.isAssignableFrom(clazz)) {
                operator = (BinaryExpression)clazz.newInstance();
                this.checkNumberOfOperands(fun, 2);
                operator.getOperand().addAll(fun.getOperand());
                this.visitor.resolveBinaryCall("System", fun.getName(), operator);
                return operator;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return operator;
    }

    private NaryExpression resolveNary(FunctionRef fun) {
        NaryExpression operator = null;
        try {
            Class<?> clazz = Class.forName("org.hl7.elm.r1." + fun.getName());
            if (NaryExpression.class.isAssignableFrom(clazz)) {
                operator = (NaryExpression)clazz.newInstance();
                operator.getOperand().addAll(fun.getOperand());
                this.visitor.resolveCall("System", fun.getName(), new NaryExpressionInvocation(operator));
                return operator;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return operator;
    }

    private AggregateExpression resolveAggregate(FunctionRef fun) {
        AggregateExpression operator = null;
        try {
            Class<?> clazz = Class.forName("org.hl7.elm.r1." + fun.getName());
            if (AggregateExpression.class.isAssignableFrom(clazz)) {
                operator = (AggregateExpression)clazz.newInstance();
                this.checkNumberOfOperands(fun, 1);
                operator.setSource((Expression)fun.getOperand().get(0));
                this.visitor.resolveAggregateCall("System", fun.getName(), operator);
                return operator;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return operator;
    }

    private void checkNumberOfOperands(FunctionRef fun, int expectedOperands) {
        if (fun.getOperand().size() != expectedOperands) {
            throw new IllegalArgumentException(String.format("Could not resolve call to system operator %s.  Expected %d arguments.", fun.getName(), expectedOperands));
        }
    }
}

