/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.elm.tracking.DataType;
import org.cqframework.cql.elm.tracking.IntervalType;
import org.cqframework.cql.elm.tracking.ListType;

public class ConversionMap {
    private Map<DataType, List<Conversion>> map = new HashMap<DataType, List<Conversion>>();

    public void add(Conversion conversion) {
        if (conversion == null) {
            throw new IllegalArgumentException("conversion is null.");
        }
        List<Conversion> conversions = this.getConversions(conversion.getFromType());
        if (conversions.contains(conversion)) {
            throw new IllegalArgumentException(String.format("Conversion from %s to %s is already defined.", conversion.getFromType().toString(), conversion.getToType().toString()));
        }
        conversions.add(conversion);
    }

    private List<Conversion> getConversions(DataType fromType) {
        List<Conversion> conversions = this.map.get(fromType);
        if (conversions == null) {
            conversions = new ArrayList<Conversion>();
            this.map.put(fromType, conversions);
        }
        return conversions;
    }

    public Conversion findCompatibleConversion(DataType fromType, DataType toType) {
        if (fromType.isCompatibleWith(toType)) {
            return new Conversion(fromType, toType);
        }
        return null;
    }

    public Conversion findListConversion(ListType fromType, ListType toType) {
        Conversion elementConversion = this.findConversion(fromType.getElementType(), toType.getElementType(), true);
        if (elementConversion != null) {
            return new Conversion(fromType, toType, elementConversion);
        }
        return null;
    }

    public Conversion findIntervalConversion(IntervalType fromType, IntervalType toType) {
        Conversion pointConversion = this.findConversion(fromType.getPointType(), toType.getPointType(), true);
        if (pointConversion != null) {
            return new Conversion(fromType, toType, pointConversion);
        }
        return null;
    }

    public Conversion findConversion(DataType fromType, DataType toType, boolean isImplicit) {
        Conversion result = this.findCompatibleConversion(fromType, toType);
        if (result == null) {
            int score = Integer.MAX_VALUE;
            for (Conversion conversion : this.getConversions(fromType)) {
                int newScore;
                if (isImplicit && !conversion.isImplicit() || !conversion.getToType().isSuperTypeOf(toType) && !conversion.getToType().isGeneric()) continue;
                int n = conversion.getToType().equals(toType) ? 0 : (newScore = conversion.getToType().isGeneric() ? 1 : 2);
                if (newScore < score) {
                    result = conversion;
                    score = newScore;
                    continue;
                }
                if (newScore != score) continue;
                throw new IllegalArgumentException(String.format("Ambiguous implicit conversion from %s to %s or %s.", fromType.toString(), result.getToType().toString(), conversion.getToType().toString()));
            }
        }
        if (result == null) {
            if (fromType instanceof ListType && toType instanceof ListType) {
                result = this.findListConversion((ListType)fromType, (ListType)toType);
            }
            if (fromType instanceof IntervalType && toType instanceof IntervalType) {
                result = this.findIntervalConversion((IntervalType)fromType, (IntervalType)toType);
            }
        }
        return result;
    }
}

