/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.Map;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.ConversionMap;
import org.cqframework.cql.elm.tracking.DataType;
import org.cqframework.cql.elm.tracking.InstantiationContext;
import org.cqframework.cql.elm.tracking.TypeParameter;

public class InstantiationContextImpl
implements InstantiationContext {
    private Map<TypeParameter, DataType> typeMap;
    private ConversionMap conversionMap;

    public InstantiationContextImpl(Map<TypeParameter, DataType> typeMap, ConversionMap conversionMap) {
        if (typeMap == null) {
            throw new IllegalArgumentException("typeMap is null");
        }
        if (conversionMap == null) {
            throw new IllegalArgumentException("conversionMap is null");
        }
        this.typeMap = typeMap;
        this.conversionMap = conversionMap;
    }

    public boolean isInstantiable(TypeParameter parameter, DataType callType) {
        DataType boundType = this.typeMap.get(parameter);
        if (boundType == null) {
            this.typeMap.put(parameter, callType);
            return true;
        }
        if (boundType.isSuperTypeOf(callType) || callType.isCompatibleWith(boundType)) {
            return true;
        }
        if (callType.isSuperTypeOf(boundType) || boundType.isCompatibleWith(callType)) {
            this.typeMap.put(parameter, callType);
            return true;
        }
        Conversion conversion = this.conversionMap.findConversion(callType, boundType, true);
        if (conversion != null) {
            return true;
        }
        conversion = this.conversionMap.findConversion(boundType, callType, true);
        if (conversion != null) {
            this.typeMap.put(parameter, callType);
            return true;
        }
        return false;
    }

    public DataType instantiate(TypeParameter parameter) {
        DataType result = this.typeMap.get(parameter);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Could not resolve type parameter %s.", parameter.getIdentifier()));
        }
        return result;
    }
}

