/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.misc.NotNull;
import org.cqframework.cql.cql2elm.model.ModelImporter;
import org.cqframework.cql.elm.tracking.ClassType;
import org.cqframework.cql.elm.tracking.DataType;
import org.cqframework.cql.elm.tracking.NamedType;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class Model {
    private ModelInfo info;
    private Map<String, DataType> index;
    private Map<String, ClassType> classIndex;
    private Map<String, DataType> nameIndex;

    public Model(@NotNull ModelInfo modelInfo, Model systemModel) throws ClassNotFoundException {
        this.info = modelInfo;
        this.index = new HashMap<String, DataType>();
        this.nameIndex = new HashMap<String, DataType>();
        this.classIndex = new HashMap<String, ClassType>();
        ModelImporter importer = new ModelImporter(this.info, systemModel != null ? systemModel.nameIndex.values() : null);
        this.index = importer.getTypes();
        for (DataType t : this.index.values()) {
            if (t instanceof ClassType) {
                this.classIndex.put(((ClassType)t).getLabel(), (ClassType)t);
            }
            if (!(t instanceof NamedType)) continue;
            this.nameIndex.put(((NamedType)t).getSimpleName(), t);
        }
    }

    public ModelInfo getModelInfo() {
        return this.info;
    }

    public DataType resolveTypeName(@NotNull String typeName) {
        DataType result = this.index.get(typeName);
        if (result == null) {
            result = this.nameIndex.get(typeName);
        }
        return result;
    }

    public ClassType resolveLabel(@NotNull String label) {
        return this.classIndex.get(label);
    }
}

