/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cqframework.cql.elm.tracking.ClassType;
import org.cqframework.cql.elm.tracking.ClassTypeElement;
import org.cqframework.cql.elm.tracking.DataType;
import org.cqframework.cql.elm.tracking.IntervalType;
import org.cqframework.cql.elm.tracking.ListType;
import org.cqframework.cql.elm.tracking.NamedType;
import org.cqframework.cql.elm.tracking.SimpleType;
import org.cqframework.cql.elm.tracking.TupleType;
import org.cqframework.cql.elm.tracking.TupleTypeElement;
import org.hl7.elm_modelinfo.r1.ClassInfo;
import org.hl7.elm_modelinfo.r1.ClassInfoElement;
import org.hl7.elm_modelinfo.r1.IntervalTypeInfo;
import org.hl7.elm_modelinfo.r1.ListTypeInfo;
import org.hl7.elm_modelinfo.r1.ModelInfo;
import org.hl7.elm_modelinfo.r1.SimpleTypeInfo;
import org.hl7.elm_modelinfo.r1.TupleTypeInfo;
import org.hl7.elm_modelinfo.r1.TupleTypeInfoElement;
import org.hl7.elm_modelinfo.r1.TypeInfo;

public class ModelImporter {
    private ModelInfo modelInfo;
    private Map<String, TypeInfo> typeInfoIndex;
    private Map<String, DataType> resolvedTypes;
    private List<DataType> dataTypes;

    public ModelImporter(ModelInfo modelInfo, Iterable<DataType> systemTypes) {
        NamedType namedSystemType;
        if (modelInfo == null) {
            throw new IllegalArgumentException("modelInfo is null");
        }
        this.modelInfo = modelInfo;
        this.typeInfoIndex = new HashMap<String, TypeInfo>();
        this.resolvedTypes = new HashMap<String, DataType>();
        this.dataTypes = new ArrayList<DataType>();
        if (systemTypes != null) {
            for (DataType systemType : systemTypes) {
                if (!(systemType instanceof NamedType)) continue;
                namedSystemType = (NamedType)systemType;
                this.resolvedTypes.put(namedSystemType.getName(), systemType);
            }
        }
        for (TypeInfo t : this.modelInfo.getTypeInfo()) {
            ClassInfo classInfo;
            if (t instanceof SimpleTypeInfo) {
                this.typeInfoIndex.put(((SimpleTypeInfo)t).getName(), t);
                continue;
            }
            if (!(t instanceof ClassInfo) || (classInfo = (ClassInfo)t).getName() == null) continue;
            this.typeInfoIndex.put(classInfo.getName(), (TypeInfo)classInfo);
        }
        for (TypeInfo t : this.modelInfo.getTypeInfo()) {
            this.dataTypes.add(this.resolveTypeInfo(t));
        }
        if (systemTypes != null) {
            for (DataType systemType : systemTypes) {
                if (!(systemType instanceof NamedType)) continue;
                namedSystemType = (NamedType)systemType;
                this.resolvedTypes.remove(namedSystemType.getName());
            }
        }
    }

    public Map<String, DataType> getTypes() {
        return this.resolvedTypes;
    }

    private DataType resolveTypeInfo(TypeInfo t) {
        if (t instanceof SimpleTypeInfo) {
            return this.resolveSimpleType((SimpleTypeInfo)t);
        }
        if (t instanceof ClassInfo) {
            return this.resolveClassType((ClassInfo)t);
        }
        if (t instanceof TupleTypeInfo) {
            return this.resolveTupleType((TupleTypeInfo)t);
        }
        if (t instanceof IntervalTypeInfo) {
            return this.resolveIntervalType((IntervalTypeInfo)t);
        }
        if (t instanceof ListTypeInfo) {
            return this.resolveListType((ListTypeInfo)t);
        }
        return null;
    }

    private DataType resolveTypeSpecifier(String typeSpecifier) {
        if (typeSpecifier == null || typeSpecifier.equals("")) {
            return null;
        }
        if (typeSpecifier.startsWith("interval")) {
            DataType pointType = this.resolveTypeSpecifier(typeSpecifier.substring(typeSpecifier.indexOf(60) + 1, typeSpecifier.lastIndexOf(62)));
            return new IntervalType(pointType);
        }
        if (typeSpecifier.startsWith("list")) {
            DataType elementType = this.resolveTypeSpecifier(typeSpecifier.substring(typeSpecifier.indexOf(60) + 1, typeSpecifier.lastIndexOf(62)));
            return new ListType(elementType);
        }
        return this.resolveTypeName(typeSpecifier);
    }

    private DataType resolveTypeName(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName is null");
        }
        DataType result = this.lookupType(typeName);
        if (result == null) {
            TypeInfo typeInfo = this.lookupTypeInfo(typeName);
            if (typeInfo == null) {
                throw new IllegalArgumentException(String.format("Could not resolve type info for type name %s.", typeName));
            }
            result = this.resolveTypeInfo(typeInfo);
        }
        return result;
    }

    private DataType lookupType(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName is null");
        }
        return this.resolvedTypes.get(typeName);
    }

    private TypeInfo lookupTypeInfo(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName is null");
        }
        return this.typeInfoIndex.get(typeName);
    }

    private SimpleType resolveSimpleType(SimpleTypeInfo t) {
        SimpleType result = (SimpleType)this.lookupType(t.getName());
        if (result == null) {
            result = t.getName().equals(DataType.ANY.getName()) ? DataType.ANY : new SimpleType(t.getName(), this.resolveTypeSpecifier(t.getBaseType()));
            this.resolvedTypes.put(result.getName(), (DataType)result);
        }
        return result;
    }

    private Collection<TupleTypeElement> resolveTupleTypeElements(Collection<TupleTypeInfoElement> infoElements) {
        ArrayList<TupleTypeElement> elements = new ArrayList<TupleTypeElement>();
        for (TupleTypeInfoElement e : infoElements) {
            elements.add(new TupleTypeElement(e.getName(), this.resolveTypeSpecifier(e.getType())));
        }
        return elements;
    }

    private TupleType resolveTupleType(TupleTypeInfo t) {
        TupleType result = new TupleType(this.resolveTupleTypeElements(t.getElement()));
        return result;
    }

    private Collection<ClassTypeElement> resolveClassTypeElements(Collection<ClassInfoElement> infoElements) {
        ArrayList<ClassTypeElement> elements = new ArrayList<ClassTypeElement>();
        for (ClassInfoElement e : infoElements) {
            elements.add(new ClassTypeElement(e.getName(), this.resolveTypeSpecifier(e.getType())));
        }
        return elements;
    }

    private ClassType resolveClassType(ClassInfo t) {
        if (t.getName() == null) {
            throw new IllegalArgumentException("Class definition must have a name.");
        }
        ClassType result = (ClassType)this.lookupType(t.getName());
        if (result == null) {
            result = new ClassType(t.getName(), this.resolveTypeSpecifier(t.getBaseType()));
            this.resolvedTypes.put(result.getName(), (DataType)result);
            result.addElements(this.resolveClassTypeElements(t.getElement()));
            result.setIdentifier(t.getIdentifier());
            result.setLabel(t.getLabel());
            result.setRetrievable(t.isRetrievable());
            result.setPrimaryCodePath(t.getPrimaryCodePath());
        }
        return result;
    }

    private IntervalType resolveIntervalType(IntervalTypeInfo t) {
        IntervalType result = new IntervalType(this.resolveTypeSpecifier(t.getPointType()));
        return result;
    }

    private ListType resolveListType(ListTypeInfo t) {
        ListType result = new ListType(this.resolveTypeSpecifier(t.getElementType()));
        return result;
    }
}

