/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cqframework.cql.cql2elm.model.CallContext;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.ConversionMap;
import org.cqframework.cql.cql2elm.model.GenericOperator;
import org.cqframework.cql.cql2elm.model.Operator;
import org.cqframework.cql.cql2elm.model.OperatorResolution;
import org.cqframework.cql.cql2elm.model.Signature;

public class OperatorEntry {
    private String name;
    private SignatureNodes signatures = new SignatureNodes();
    private Map<Signature, GenericOperator> genericOperators = new HashMap<Signature, GenericOperator>();

    public OperatorEntry(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("name is null or empty");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addOperator(Operator operator) {
        if (operator instanceof GenericOperator) {
            this.addGenericOperator((GenericOperator)operator);
        } else {
            this.signatures.add(new SignatureNode(operator));
        }
    }

    private void addGenericOperator(GenericOperator operator) {
        if (this.genericOperators.containsKey(operator.getSignature())) {
            throw new IllegalArgumentException(String.format("Operator %s already has a generic registration for signature: %s.", this.name, operator.getSignature().toString()));
        }
        this.genericOperators.put(operator.getSignature(), operator);
    }

    private boolean allResultsUseConversion(List<OperatorResolution> results) {
        for (OperatorResolution resolution : results) {
            if (resolution.hasConversions()) continue;
            return false;
        }
        return true;
    }

    public List<OperatorResolution> resolve(CallContext callContext, ConversionMap conversionMap) {
        if (callContext == null) {
            throw new IllegalArgumentException("callContext is null");
        }
        List<OperatorResolution> results = this.signatures.resolve(callContext, conversionMap);
        if (results == null || this.allResultsUseConversion(results)) {
            Operator result = this.instantiate(callContext.getSignature(), conversionMap);
            if (result != null && !this.signatures.contains(result)) {
                this.signatures.add(new SignatureNode(result));
            }
            results = this.signatures.resolve(callContext, conversionMap);
        }
        return results;
    }

    private Operator instantiate(Signature signature, ConversionMap conversionMap) {
        ArrayList<Operator> instantiations = new ArrayList<Operator>();
        for (GenericOperator genericOperator : this.genericOperators.values()) {
            Operator instantiation = genericOperator.instantiate(signature, conversionMap);
            if (instantiation == null) continue;
            instantiations.add(instantiation);
        }
        switch (instantiations.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Operator)instantiations.get(0);
            }
        }
        throw new IllegalArgumentException(String.format("Ambiguous generic instantiation of operator %s with signature %s.", this.name, signature.toString()));
    }

    private static class SignatureNodes {
        private Map<Signature, SignatureNode> signatures = new HashMap<Signature, SignatureNode>();

        private SignatureNodes() {
        }

        public boolean contains(Operator operator) {
            return this.signatures.containsKey(operator.getSignature());
        }

        public void add(SignatureNode node) {
            if (node == null) {
                throw new IllegalArgumentException("node is null.");
            }
            if (this.signatures.containsKey(node.getSignature())) {
                throw new IllegalArgumentException(String.format("Operator %s already has a registration for signature: %s.", node.operator.getName(), node.getSignature().toString()));
            }
            boolean added = false;
            for (SignatureNode n : this.signatures.values()) {
                if (!n.getSignature().isSuperTypeOf(node.getSignature())) continue;
                n.subSignatures.add(node);
                added = true;
                break;
            }
            if (!added) {
                for (SignatureNode n : this.signatures.values().toArray(new SignatureNode[this.signatures.size()])) {
                    if (!node.getSignature().isSuperTypeOf(n.getSignature())) continue;
                    this.signatures.remove(n.getSignature());
                    node.subSignatures.add(n);
                }
                this.signatures.put(node.getSignature(), node);
            }
        }

        public List<OperatorResolution> resolve(CallContext callContext, ConversionMap conversionMap) {
            ArrayList<OperatorResolution> results = null;
            for (SignatureNode n : this.signatures.values()) {
                List<OperatorResolution> nodeResults = n.resolve(callContext, conversionMap);
                if (nodeResults == null) continue;
                if (results == null) {
                    results = new ArrayList<OperatorResolution>();
                }
                results.addAll(nodeResults);
            }
            return results;
        }
    }

    private static class SignatureNode {
        private Operator operator;
        private SignatureNodes subSignatures = new SignatureNodes();

        public SignatureNode(Operator operator) {
            if (operator == null) {
                throw new IllegalArgumentException("operator is null.");
            }
            this.operator = operator;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public Signature getSignature() {
            return this.operator.getSignature();
        }

        public List<OperatorResolution> resolve(CallContext callContext, ConversionMap conversionMap) {
            List<Object> results = null;
            if (this.operator.getSignature().equals(callContext.getSignature())) {
                results = new ArrayList<OperatorResolution>();
                results.add(new OperatorResolution(this.operator));
                return results;
            }
            results = this.subSignatures.resolve(callContext, conversionMap);
            if (results == null && this.operator.getSignature().isSuperTypeOf(callContext.getSignature())) {
                results = new ArrayList();
                results.add(new OperatorResolution(this.operator));
            }
            if (results == null && conversionMap != null) {
                Conversion[] conversions = new Conversion[this.operator.getSignature().getSize()];
                boolean isConvertible = callContext.getSignature().isConvertibleTo(this.operator.getSignature(), conversionMap, conversions);
                if (isConvertible) {
                    OperatorResolution resolution = new OperatorResolution(this.operator);
                    resolution.setConversions(conversions);
                    results = new ArrayList();
                    results.add(resolution);
                }
            }
            return results;
        }

        public int hashCode() {
            return this.operator.getSignature().hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof SignatureNode) {
                SignatureNode that = (SignatureNode)o;
                return this.operator.getName().equals(that.operator.getName()) && this.getSignature().equals(that.getSignature());
            }
            return false;
        }

        public String toString() {
            return this.operator.toString();
        }
    }
}

